/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.backup;

import com.parablu.epa.common.constants.BackupLifeCycle;
import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.dao.BackUpImageDAOImpl;
import com.parablu.epa.common.dao.BackupActivityHistoryDAOImpl;
import com.parablu.epa.common.dao.BackupCrawlDAOImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.dao.BackupStatisticsDAOImpl;
import com.parablu.epa.common.dao.FullBackupInfoTableDAOImpl;
import com.parablu.epa.common.dao.NewBackUpCrawlDAOImpl;
import com.parablu.epa.common.dao.NewBackupImageDAOImpl;
import com.parablu.epa.common.service.backup.FilesBeSkippedAsPerPolicy;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.BluVaultIPHelper;
import com.parablu.epa.common.service.settings.HashChecker;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.adapter.tcp.ListnerAdapter;
import com.parablu.epa.core.constant.CrawlLifecycle;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.BackupElement;
import com.parablu.epa.core.element.BackupListResponseElement;
import com.parablu.epa.core.element.BackupStatusElement;
import com.parablu.epa.core.element.BackupValidationElement;
import com.parablu.epa.core.element.FileElement;
import com.parablu.epa.core.element.FileListElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.core.helper.enumeration.BackupFoldersToBeSkipped;
import com.parablu.epa.core.service.sync.BaseJob;
import com.parablu.epa.core.service.transformer.CreateXmlObject;
import com.parablu.epa.core.service.transformer.Xmlparser;
import com.parablu.epa.core.to.BackUpCrawlFileTO;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.core.to.BackupOrRestoreStatusTo;
import com.parablu.epa.core.to.BackupResultTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.BluVaultTO;
import com.parablu.epa.core.to.DedupTO;
import com.parablu.epa.core.to.FullBackupInfoTO;
import com.parablu.epa.core.to.GzipTO;
import com.parablu.epa.helper.exceptions.BaseException;
import com.parablu.epa.helper.utils.PBCountDownTimer;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import com.parablu.epa.helper.utils.RegistryUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NewBackUpJob
extends BaseJob {
    private Logger logger = LoggerFactory.getLogger(NewBackUpJob.class);
    private BackUpFolderDAOImpl backUpFolderDAOImpl = null;
    private BackUpImageDAOImpl backUpImageDAOImpl = null;
    private BackupAdapter backupAdapter = null;
    boolean isFirstTimeCrawl = true;
    protected String currentIP = SettingHelper.getCurrentCloudIpAddress();
    boolean manual = false;
    protected Integer currentPort = null;
    boolean doDataBaseChanges = true;
    Set<File> crawledFileList = new HashSet<File>();
    private Set<File> backupImageList = new HashSet<File>();
    private final int crawlFileLimit = this.getCrawlLimit();
    private static final int CRAWL_LIMIT_FOR_DB_INSERT = 5000;
    private int noOfDBWritesForCrawlFileLimit = 0;
    Set<DedupTO> dedupToSet = new HashSet<DedupTO>();
    private String backupType = "INCREMENTAL";
    BackupCrawlDAOImpl backupCrawlDAOImpl = new BackupCrawlDAOImpl(SettingHelper.getBackUpCrawlDbUrl());
    BackupStatisticsDAOImpl backupStatisticsDAOImpl = new BackupStatisticsDAOImpl(SettingHelper.getBackUpDbUrl());
    NewBackUpCrawlDAOImpl newBackUpCrawlDAOImpl = new NewBackUpCrawlDAOImpl(SettingHelper.getBackUpCrawlDbUrl());
    NewBackupImageDAOImpl newBackupImageDAOImpl = new NewBackupImageDAOImpl(SettingHelper.getBackUpDbUrl());
    BackupStatusElement backupStatusElement = null;
    protected String crawlTimeStamp;
    boolean restart = false;
    long restartId = 0L;
    public long backupSizeOnDisk = 0L;
    private static List<BackupFolderTO> bkpFolderList = new ArrayList<BackupFolderTO>();
    String serverBackupStatusId = null;
    private static final String RUNNING = "RUNNING";
    private static final String POSTBACKUPF = "postBackupF";
    private static final String BEFORE_CALLING_DELETE = "Before calling delete";
    private static final String COMPLETED = "COMPLETED";
    private static final String STARTED_COMPLETED = "STARTED/COMPLETED";
    private static final String BACKUP = "BACKUP";
    private static final String FAILED = "FAILED";
    public boolean isFullBackup;
    private ListnerAdapter listnerAdapter = null;
    private String batchId;
    private static FullBackupInfoTableDAOImpl fullBackupInfoTableDAOImpl = new FullBackupInfoTableDAOImpl(SettingHelper.getBackUpDbUrl());
    private List<String> macBackupFoldersToBeSkippedList;
    private boolean isCasesensitiveFolderCheckEnabled = this.getValueForcaseCheck();

    public NewBackUpJob(boolean manualVal) {
        this.backUpFolderDAOImpl = new BackUpFolderDAOImpl(SettingHelper.getBackUpDbUrl());
        this.backUpImageDAOImpl = new BackUpImageDAOImpl(SettingHelper.getBackUpDbUrl());
        this.backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        this.manual = manualVal;
    }

    public abstract void updateSystrayImageAccordingToStage(String var1);

    protected abstract void scanFileSystemByType(BackupFolderTO var1);

    public void run() {
        block54: {
            BackupActivityTO backupActivityTO = new BackupActivityTO();
            BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
            try {
                String totalSize;
                int crawlFileCount;
                this.logger.debug("backUpStarted and thread priority:" + Thread.currentThread().getPriority());
                if (NotificationHelper.backUpStarted) {
                    this.logger.debug("backUpStarted:" + NotificationHelper.backUpStarted);
                    this.logger.debug("Thiss means that backup thread died but falg is not reset so set to false");
                    NotificationHelper.policyRefreshStarted = false;
                }
                NotificationHelper.setBackupStatus(1);
                NotificationHelper.backUpStarted = true;
                NotificationHelper.setTotalBackupCount(0);
                NotificationHelper.setNoOfFilesToBeBackedUp(0);
                NotificationHelper.setTotalUploadSize(0L);
                NotificationHelper.setBackupRestartId(0L);
                NotificationHelper.setTotalBackupFilesSkippedCount(0);
                NotificationHelper.setBackupChunkFileDetails("");
                this.startBackupPolicyRefresh();
                List<BackupFolderTO> listOfFolderFromPolicy = HashChecker.getAllFolderToBackUpFiles();
                ArrayList<BackupFolderTO> listOfFolder = new ArrayList<BackupFolderTO>();
                boolean noFolderExists = false;
                if (listOfFolderFromPolicy.isEmpty()) {
                    noFolderExists = true;
                }
                if (noFolderExists) {
                    BackupFolderTO backupFolderTO = new BackupFolderTO();
                    backupFolderTO.setFolderPath("parablu");
                    backupFolderTO.setCreateBy("IA");
                    backupFolderTO.setPolicyName("");
                    listOfFolderFromPolicy.add(backupFolderTO);
                }
                this.listnerAdapter = new ListnerAdapter();
                if (!this.listnerAdapter.checkForService()) {
                    this.logger.debug("service is not running so open the named pipe...");
                    this.openNamedPipeNClose();
                }
                this.createTablesIfNotExist();
                this.validatePreviousBackupCrawlStatus();
                this.validatePreviousBackupStatus();
                for (BackupFolderTO backupFolderTO : listOfFolderFromPolicy) {
                    if (this.isCasesensitiveFolderCheckEnabled) {
                        this.logger.debug("case check enabled............");
                        backupFolderTO.setFolderPath(PolicyManagementServerHelper.getrealPath(backupFolderTO.getFolderPath()));
                    }
                    listOfFolder.add(backupFolderTO);
                }
                List<FullBackupInfoTO> fullBackupInfos = fullBackupInfoTableDAOImpl.getBackupInfoDetails();
                FullBackupInfoTO fullBackupInfo = null;
                if (fullBackupInfos != null && !fullBackupInfos.isEmpty()) {
                    this.logger.debug("Inside getting full backup info details...");
                    fullBackupInfo = fullBackupInfos.get(0);
                }
                if (fullBackupInfo != null && fullBackupInfo.isFullBackup()) {
                    this.clearTablesForFullBackupOnDemand();
                    this.isFullBackup = true;
                    this.restart = false;
                    fullBackupInfo.setFullBackup(false);
                    fullBackupInfoTableDAOImpl.clearEntireTable();
                    fullBackupInfoTableDAOImpl.insertIntoBackupInfoTable(fullBackupInfo);
                }
                this.logger.debug("Device Blocked: " + SettingHelper.isDeviceBlocked());
                this.logger.debug("After validating previous backup.");
                long lastSuccessfullCrawlTime = this.backupStatusElement.getLastSuccessfulCrawlTimeStamp();
                this.batchId = this.backupStatusElement.getBatchId();
                if (lastSuccessfullCrawlTime == 0L) {
                    this.backupType = "FULL";
                }
                if ("true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed()) && "F".equalsIgnoreCase(NotificationHelper.getServerBackupType())) {
                    this.restart = false;
                }
                if (!this.restart) {
                    ParabluFileSystemUtils.setSnapshotValid((boolean)false);
                    this.batchId = "";
                    this.logger.debug("Inside restart False.");
                    bkpFolderList = listOfFolder;
                    this.logger.debug("os " + SettingHelper.getOsName().toLowerCase());
                    this.logger.debug("VSS ENABLED " + SettingHelper.getIsVssEnabled());
                    if (SettingHelper.getOsName().toLowerCase().contains("win") && SettingHelper.getIsVssEnabled() != null && "true".equalsIgnoreCase(SettingHelper.getIsVssEnabled())) {
                        this.listnerAdapter = new ListnerAdapter();
                        if (this.listnerAdapter.checkForService()) {
                            this.delAndCreateSnapshot(listOfFolder);
                        }
                    }
                    HashSet<BackupTO> backUpSet = new HashSet<BackupTO>();
                    HashSet<BackupTO> deletedSet = new HashSet<BackupTO>();
                    backupActivityTO.setBackupActivityStatus(CrawlLifecycle.SCANNING.toString());
                    backupActivityTO.setBackupActivityTimeStamp(String.valueOf(System.currentTimeMillis()));
                    backupActivityTO.setBatchId("-1");
                    backupActivityTO.setFullBackup(Boolean.toString(this.isFullBackup));
                    backupActivityTO.setBackupActivityID(backupActivityHistoryDAOImpl.addEventToBackupActivityHistoryTable(backupActivityTO));
                    NotificationHelper.setBackupStatus(2);
                    this.scanFileSystem(listOfFolder, lastSuccessfullCrawlTime);
                    this.renameBackupCrawlAndBackupImageTable();
                    if (Thread.currentThread().isInterrupted()) {
                        this.logger.debug("Current thread is interrupted so retruning");
                        return;
                    }
                    if ("true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) {
                        PolicyManagementServerHelper.sendServerBackupStatus(this.backupAdapter, RUNNING, "pid", String.valueOf(this.backupSizeOnDisk), 2, true, SettingHelper.readTokenFromFile(), this.serverBackupStatusId, "0");
                        this.logger.debug("==================================2-==========================bkpze " + this.backupSizeOnDisk);
                    }
                    this.updateCrawlTableAndGetDeletedFiles(deletedSet);
                    crawlFileCount = this.newBackUpCrawlDAOImpl.getCountOfTable(false);
                    this.logger.debug("count from crawl table is:" + crawlFileCount);
                    if (lastSuccessfullCrawlTime != 0L) {
                        List<BackupTO> backUpList = this.newBackUpCrawlDAOImpl.readAllEntriesFromBackupImageTable();
                        if (!deletedSet.isEmpty() || !backUpList.isEmpty()) {
                            backUpSet.addAll(backUpList);
                            this.chunkBackupFilesAndCallForUpload(backUpSet, deletedSet);
                        }
                    }
                    totalSize = String.valueOf(crawlFileCount);
                    if (crawlFileCount == 0) {
                        this.logger.debug("Backup List is zero");
                        backupActivityTO.setBackupActivityStatus(CrawlLifecycle.FINISHED.toString());
                        backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                        BackupActivityTO backupActivityTO1 = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
                        backupActivityTO1.setFailCode(0);
                        this.backupBatchInitiated(STARTED_COMPLETED, this.batchId, 0, backupActivityTO1.getFailCode(), backupActivityTO1.getTotalUploadSize(), backupActivityTO1.getBackupUploadCount(), crawlFileCount, backupActivityTO1.getBackupActivityTimeStamp());
                        if ("true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) {
                            PolicyManagementServerHelper.sendServerBackupStatus(this.backupAdapter, COMPLETED, "pid", String.valueOf(this.backupSizeOnDisk), 4, true, SettingHelper.readTokenFromFile(), this.serverBackupStatusId, Long.toString(System.currentTimeMillis()));
                            this.runScripts(POSTBACKUPF, this.manual);
                            NotificationHelper.setCurrentContainerJobId("0");
                        }
                        if (SettingHelper.getOsName().toLowerCase().contains("win") && SettingHelper.getIsVssEnabled() != null && "true".equalsIgnoreCase(SettingHelper.getIsVssEnabled())) {
                            this.listnerAdapter = new ListnerAdapter();
                            if (this.listnerAdapter.checkForService()) {
                                this.logger.debug(BEFORE_CALLING_DELETE);
                                this.deleteVsnapshot(bkpFolderList);
                            }
                        }
                        NotificationHelper.backUpStarted = false;
                        this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_IMAGE);
                        return;
                    }
                    NotificationHelper.setNoOfFilesToBeBackedUp(crawlFileCount);
                    this.logger.debug("BACKUPLIST SIZE :" + totalSize);
                } else {
                    ParabluFileSystemUtils.setSnapshotValid((boolean)true);
                    this.validatePreviousRestartId();
                    crawlFileCount = this.newBackUpCrawlDAOImpl.getCountOfTableForGivenId((int)this.restartId);
                    this.logger.debug("CRAWL COUNT : " + crawlFileCount);
                    NotificationHelper.setNoOfFilesToBeBackedUp(crawlFileCount);
                    totalSize = String.valueOf(crawlFileCount);
                    List<DedupTO> dedupTOs = this.newBackupImageDAOImpl.getListOfDedupsFromTable();
                    if (dedupTOs != null) {
                        this.dedupToSet.addAll(dedupTOs);
                    }
                    if (crawlFileCount == 0) {
                        this.logger.debug("BACKUP LIST IS ZERO");
                        backupActivityTO.setBackupActivityStatus(CrawlLifecycle.FINISHED.toString());
                        backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                        BackupActivityTO backupActivityTO1 = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
                        backupActivityTO1.setFailCode(0);
                        this.backupBatchInitiated(COMPLETED, this.backupStatusElement.getBatchId(), 0, backupActivityTO1.getFailCode(), backupActivityTO1.getTotalUploadSize(), backupActivityTO1.getBackupUploadCount(), crawlFileCount, backupActivityTO1.getBackupActivityTimeStamp());
                        if (SettingHelper.getOsName().toLowerCase().contains("win") && SettingHelper.getIsVssEnabled() != null && "true".equalsIgnoreCase(SettingHelper.getIsVssEnabled())) {
                            this.listnerAdapter = new ListnerAdapter();
                            if (this.listnerAdapter.checkForService()) {
                                this.logger.debug(BEFORE_CALLING_DELETE);
                                this.deleteVsnapshot(bkpFolderList);
                            }
                        }
                        NotificationHelper.backUpStarted = false;
                        this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_IMAGE);
                        return;
                    }
                    backupActivityTO.setBackupActivityStatus(CrawlLifecycle.INPROGRESS.toString());
                    backupActivityTO.setBackupActivityTimeStamp(String.valueOf(System.currentTimeMillis()));
                    backupActivityTO.setBatchId("-1");
                    backupActivityTO.setFullBackup(Boolean.toString(this.isFullBackup));
                    backupActivityTO.setBackupActivityID(backupActivityHistoryDAOImpl.addEventToBackupActivityHistoryTable(backupActivityTO));
                    backupActivityTO.setRestartID(this.restartId);
                    backupActivityHistoryDAOImpl.updateRestartIdINBackupActivityHistoryTable(backupActivityTO);
                }
                NotificationHelper.setBackupStatus(3);
                String status = BackupLifeCycle.STARTED.toString();
                backupActivityTO.setBatchStatus(status);
                this.batchId = this.backupBatchInitiated(status, this.batchId, 0, backupActivityTO.getFailCode(), 0L, "0/" + totalSize, crawlFileCount, this.crawlTimeStamp);
                if ("".equals(this.batchId) || "-1".equals(this.batchId)) {
                    backupActivityTO.setBackupActivityStatus(CrawlLifecycle.ABORTED.toString());
                    backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                    this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_NOINTERNET_ICON);
                    NotificationHelper.setBackupStatus(0);
                    if ("true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) {
                        PolicyManagementServerHelper.sendServerBackupStatus(this.backupAdapter, "ABORTED", "pid", String.valueOf(this.backupSizeOnDisk), 4, true, SettingHelper.readTokenFromFile(), this.serverBackupStatusId, Long.toString(System.currentTimeMillis()));
                        this.runScripts(POSTBACKUPF, this.manual);
                    }
                    NotificationHelper.setCurrentContainerJobId("0");
                    NotificationHelper.backUpStarted = false;
                    return;
                }
                this.logger.debug("batch id for this backup is:" + this.batchId + "status:" + status);
                backupActivityTO.setBatchId(this.batchId);
                this.validatePreviousBackupActivity(backupActivityHistoryDAOImpl);
                backupActivityTO.setBackupActivityStatus(CrawlLifecycle.INPROGRESS.toString());
                backupActivityTO.setBackupActivityTimeStamp(this.crawlTimeStamp);
                backupActivityTO.setBackupUploadCount("0/" + totalSize);
                backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                this.logger.debug("BEFORE STARTING BACKUP THREAD");
                this.backupType = this.backupType + "|" + this.manual;
                NotificationHelper.setBackupRestartId(this.restartId);
                this.startBackUpThread(this.dedupToSet, this.restart, this.restartId, this.backupType);
                Thread.sleep(1000L);
                this.dedupToSet = null;
                this.logger.debug("BACKUP FINISHED");
                SettingHelper.setLastSuccessfulBackup(System.currentTimeMillis());
                if (NotificationHelper.getTotalBackupCount() == (crawlFileCount -= NotificationHelper.getTotalBackupFilesSkippedCount())) {
                    backupActivityTO.setBackupActivityStatus(CrawlLifecycle.FINISHED.toString());
                } else {
                    backupActivityTO.setBackupActivityStatus(CrawlLifecycle.STOPPED.toString());
                }
                backupActivityTO.setBackupUploadCount(NotificationHelper.getTotalBackupCount() + "/" + crawlFileCount);
                backupActivityTO.setTotalUploadSize(NotificationHelper.getTotalUploadSize());
                backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                int totalFilesUploaded = NotificationHelper.getTotalBackupCount();
                this.logger.debug("TOTAL FILES UPLOADED " + totalFilesUploaded);
                this.logger.debug("TOTAL COUNT " + crawlFileCount);
                int lastRecordId = this.newBackUpCrawlDAOImpl.getLastRecordIdFromTable();
                long backupRestartId = NotificationHelper.getBackupRestartId();
                this.logger.debug("last record id>>>" + lastRecordId + ">>backup restart id" + backupRestartId);
                if ((long)lastRecordId == backupRestartId) {
                    status = BackupLifeCycle.COMPLETED.toString();
                    backupActivityTO.setBatchStatus(status);
                    backupActivityTO.setFailCode(0);
                    long totalUploadSize = backupActivityTO.getTotalUploadSize();
                    String uploadedList = backupActivityTO.getBackupUploadCount();
                    int errorCode = backupActivityTO.getFailCode();
                    this.batchId = this.backupBatchInitiated(status, this.batchId, NotificationHelper.getTotalBackupCount(), errorCode, totalUploadSize, uploadedList, crawlFileCount, backupActivityTO.getBackupActivityTimeStamp());
                    if (!"-1".equals(this.batchId)) {
                        this.logger.debug("BATCH ID FOR THIS BACKUP IS : " + this.batchId + "STATUS : " + status);
                        backupActivityTO.setBatchId(this.batchId);
                        backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                        if ("true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) {
                            this.logger.debug("is full backup ::: " + NotificationHelper.getServerBackupType());
                            PolicyManagementServerHelper.sendServerBackupStatus(this.backupAdapter, COMPLETED, "pid", String.valueOf(this.backupSizeOnDisk), 4, true, SettingHelper.readTokenFromFile(), this.serverBackupStatusId, Long.toString(System.currentTimeMillis()));
                            this.logger.debug("============================4=============================");
                            NotificationHelper.setCurrentContainerJobId("0");
                            if (NotificationHelper.getServerBackupType().contains("F")) {
                                new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl()).updateFullBackupTimestamp(backupActivityTO.getBackupActivityTimeStamp(), NotificationHelper.getCurrentContainerName());
                            }
                        }
                        if (SettingHelper.getOsName().toLowerCase().contains("win") && SettingHelper.getIsVssEnabled() != null && "true".equalsIgnoreCase(SettingHelper.getIsVssEnabled())) {
                            this.listnerAdapter = new ListnerAdapter();
                            if (this.listnerAdapter.checkForService()) {
                                this.logger.debug(BEFORE_CALLING_DELETE);
                                this.deleteVsnapshot(bkpFolderList);
                            }
                        }
                    }
                } else {
                    this.jobSucceded = false;
                    BackupActivityTO backupActivityTO1 = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
                    if (backupActivityTO1.getFailCode() != 912 && backupActivityTO1.getFailCode() != 1992 && backupActivityTO1.getFailCode() != 1981 && backupActivityTO1.getFailCode() != 1996 && backupActivityTO1.getFailCode() != 911) {
                        int response = this.backupAdapter.pingParacloud(this.currentIP);
                        this.jobStatusCode = backupActivityTO1.getFailCode();
                        if (response == 400) {
                            this.logger.debug("Backup Fail code>>>>>$$$$" + backupActivityTO1.getFailCode());
                            if (backupActivityTO1.getFailCode() == 2304) {
                                PolicyManagementServerHelper.updateFailCodeToActivityHistory(2304);
                                PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit(BackupLifeCycle.INTERRUPTED.toString(), true);
                            } else if (backupActivityTO1.getFailCode() == 909) {
                                PolicyManagementServerHelper.updateFailCodeToActivityHistory(909);
                                PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit(BackupLifeCycle.INTERRUPTED.toString(), true);
                            } else {
                                this.jobStatusCode = 913;
                                PolicyManagementServerHelper.updateFailCodeToActivityHistory(909);
                                PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit(BackupLifeCycle.INTERRUPTED.toString(), true);
                            }
                        }
                    } else if (backupActivityTO1.getFailCode() == 1992 || backupActivityTO1.getFailCode() == 1981 || backupActivityTO1.getFailCode() == 1996) {
                        this.jobStatusCode = backupActivityTO1.getFailCode();
                        PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit(BackupLifeCycle.STOPPED.toString(), true);
                    }
                }
                NotificationHelper.backUpStarted = false;
                this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_IMAGE);
                this.pauseBackup(false);
                return;
            }
            catch (BaseException baseException) {
                this.logger.error("baseException ", (Throwable)baseException);
                backupActivityTO.setBackupActivityStatus(CrawlLifecycle.ABORTED.toString());
                backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_NOINTERNET_ICON);
                NotificationHelper.setBackupStatus(0);
                if ("true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) {
                    try {
                        PolicyManagementServerHelper.sendServerBackupStatus(this.backupAdapter, "ABORTED", "pid", String.valueOf(this.backupSizeOnDisk), 4, true, SettingHelper.readTokenFromFile(), this.serverBackupStatusId, Long.toString(System.currentTimeMillis()));
                        NotificationHelper.setCurrentContainerJobId("0");
                    }
                    catch (Exception e) {
                        this.logger.debug("Could not update Status " + e);
                    }
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                this.logger.trace("" + e);
                this.logger.error("Exception :", (Object)e.getMessage());
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("Unkown Exception :", (Object)e.getMessage());
                backupActivityTO.setBackupActivityStatus(CrawlLifecycle.ABORTED.toString());
                backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_NOINTERNET_ICON);
                NotificationHelper.setBackupStatus(0);
                if (!"true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) break block54;
                try {
                    PolicyManagementServerHelper.sendServerBackupStatus(this.backupAdapter, FAILED, "pid", String.valueOf(this.backupSizeOnDisk), 4, true, SettingHelper.readTokenFromFile(), this.serverBackupStatusId, Long.toString(System.currentTimeMillis()));
                    NotificationHelper.setCurrentContainerJobId("0");
                }
                catch (Exception e1) {
                    this.logger.trace("" + e1);
                    this.logger.debug("Could not update Status " + e1.getMessage());
                }
            }
        }
        this.jobSucceded = false;
        NotificationHelper.backUpStarted = false;
    }

    private void delAndCreateSnapshot(List<BackupFolderTO> listOfFolder) {
        boolean retry;
        int retryCount = 0;
        List<BackupFolderTO> validPaths = this.getValidPaths(listOfFolder, false);
        do {
            retry = false;
            this.logger.debug(BEFORE_CALLING_DELETE);
            this.deleteVsnapshot(validPaths);
            this.logger.debug("Before calling create after delete");
            this.createVsnapshot(validPaths);
            this.logger.debug("After creating snapshot");
            List<BackupFolderTO> validSnapPaths = this.getValidPaths(validPaths, true);
            int failPathCount = validSnapPaths.size();
            if (failPathCount != 0) {
                retry = true;
                this.logger.debug("snap shot creation failed so retry pathCount: " + failPathCount + "snap path:" + validSnapPaths.get(0).getFolderPath());
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    this.logger.error("thread interrupted while sleep in create snapshot");
                }
                continue;
            }
            ParabluFileSystemUtils.setSnapshotValid((boolean)true);
        } while (retry && ++retryCount < 3);
    }

    private List<BackupFolderTO> getValidPaths(List<BackupFolderTO> listOfFolder, boolean checkForSnapshot) {
        ArrayList<BackupFolderTO> validPaths = new ArrayList<BackupFolderTO>();
        if (checkForSnapshot) {
            this.logger.debug("Before checking for snapshot paths exists");
            this.checkSnapShotExists(listOfFolder, validPaths);
            this.logger.debug("After checking for snapshot paths exists");
        } else {
            this.logger.debug("Before checking for configured paths exists");
            for (BackupFolderTO backupFolderTO : listOfFolder) {
                if (!StringUtils.isNotEmpty((String)backupFolderTO.getFolderPath()) || !new File(backupFolderTO.getFolderPath()).exists()) continue;
                validPaths.add(backupFolderTO);
            }
            this.logger.debug("After checking for configured paths exists");
        }
        return validPaths;
    }

    private void checkSnapShotExists(List<BackupFolderTO> listOfFolder, List<BackupFolderTO> validPaths) {
        for (BackupFolderTO backupFolderTO : listOfFolder) {
            this.logger.debug("folder name to check snapshot path:" + backupFolderTO.getFolderPath());
            String snapPath = ObjectUtils.getSnapShotPath((String)backupFolderTO.getFolderPath());
            this.logger.debug("snapshot path:" + backupFolderTO.getFolderPath());
            File snapFile = new File(snapPath);
            if (snapPath.isEmpty() || snapFile.exists()) continue;
            this.logger.debug("snap shot path doesn't exist" + snapFile.getAbsolutePath());
            validPaths.add(backupFolderTO);
            break;
        }
    }

    private void clearTablesForFullBackupOnDemand() {
        this.logger.debug("cleared tables for full backup again");
        this.newBackUpCrawlDAOImpl.deleteEntireTable();
        this.newBackUpCrawlDAOImpl.deleteEntirePrevCrawlTable();
        this.newBackUpCrawlDAOImpl.deleteEntireOldBackpCrawlTable();
        this.newBackupImageDAOImpl.clearEntireTable();
        this.newBackupImageDAOImpl.clearEntirePrevBackupImageTable();
        this.newBackupImageDAOImpl.clearEntireOldBackupImageTable();
    }

    private void validatePreviousBackupCrawlStatus() {
        this.logger.debug("Validating previous backup crawl status.");
        BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        BackupActivityTO activityTO = backupActivityHistoryDAOImpl.getScanStatusFromBackupActivityHistoryTable();
        if (activityTO != null && activityTO.getBackupActivityStatus().contentEquals(CrawlLifecycle.SCANNING.toString())) {
            this.logger.debug("INSIDE ROLL BACK PREVIOUS CRAWL");
            this.doDataBaseChanges = false;
            this.logger.debug("cleaning up old tables");
            this.newBackUpCrawlDAOImpl.dropTable("NewBkupCrawl");
            this.newBackupImageDAOImpl.dropTable("NEWBKITABLE");
            activityTO.setBackupActivityStatus(CrawlLifecycle.ABORTED.toString());
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(activityTO);
        }
    }

    private void validatePreviousBackupStatus() {
        this.backupStatusElement = this.getStatusOfBackup();
        this.logger.debug("After validate previous backup status");
        if (this.backupStatusElement != null && this.backupStatusElement.getResponseCode() == 200) {
            if (!"".equals(this.backupStatusElement.getBatchId()) && this.backupStatusElement.getLastSuccessfulCrawlTimeStamp() != 0L) {
                if (!this.backupStatusElement.getStatus().equalsIgnoreCase(BackupLifeCycle.COMPLETED.toString())) {
                    this.crawlTimeStamp = String.valueOf(this.backupStatusElement.getLastSuccessfulCrawlTimeStamp());
                    boolean success = this.getBackupCrawlTableStatus();
                    if (success) {
                        this.restart = true;
                        this.isFullBackup = this.backupStatusElement.isFullBackup();
                    } else {
                        this.backupStatusElement.setLastSuccessfulCrawlTimeStamp(0L);
                    }
                }
            } else if (!"".equals(this.backupStatusElement.getBatchId()) && this.backupStatusElement.getLastSuccessfulCrawlTimeStamp() == 0L) {
                this.logger.debug("inside crawl time stamp 0 so take it from local activity");
                BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
                BackupActivityTO backupActivityTO = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
                if (backupActivityTO != null) {
                    this.backupStatusElement.setLastSuccessfulCrawlTimeStamp(Long.valueOf(backupActivityTO.getBackupActivityTimeStamp()).longValue());
                    this.logger.debug("local activity activity timestamp..." + this.backupStatusElement.getLastSuccessfulCrawlTimeStamp());
                    this.createPrevBKITFromOldBkpImage();
                    this.logger.debug("After creating the prev bkit with old table");
                    this.restart = false;
                }
            } else {
                this.backupStatusElement.setLastSuccessfulCrawlTimeStamp(0L);
                this.isCasesensitiveFolderCheckEnabled = true;
                if (SettingHelper.getOsName().toLowerCase().contains("win")) {
                    RegistryUtils.setRegistryValue((String)"HKCU", (String)"Software\\ParaBlu\\BluSync", (String)"casecheck", (String)"true");
                }
                if (SettingHelper.getOsName().toLowerCase().contains("mac")) {
                    this.logger.debug("NEW DEVICE to set case check");
                    String basePath = SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + ".ParaBlu" + StringLiterals.FILE_SEPARATOR + "ParaBlu" + StringLiterals.FILE_SEPARATOR + "Blusync";
                    File pathForCasecheck = new File(basePath + StringLiterals.FILE_SEPARATOR + "settings" + StringLiterals.FILE_SEPARATOR + "casecheck");
                    try {
                        pathForCasecheck.createNewFile();
                    }
                    catch (IOException e) {
                        this.logger.debug("Unable to ceate casecheck ");
                    }
                }
                this.restart = false;
            }
        } else {
            throw new CrawlAdapterException("Get backup status failed");
        }
    }

    private void renameBackupCrawlAndBackupImageTable() {
        this.logger.debug("Before renaming the backup temp table..");
        boolean success = this.newBackUpCrawlDAOImpl.renameTable("NewBkupCrawl_Temp", "NewBkupCrawl");
        this.logger.debug("Before renaming the backup crawl temp table.. success :" + success);
        success = this.newBackupImageDAOImpl.renameTable("NEWBKITABLE_TEMP", "NEWBKITABLE");
        this.logger.debug("Before renaming the backup temp table.. success :" + success);
    }

    private void createPrevBKITFromOldBkpImage() {
        List<BackupTO> backUpFileTOs = this.backUpImageDAOImpl.readAllEntriesFromBackupImageTable();
        if (backUpFileTOs != null) {
            this.newBackupImageDAOImpl.insertListOfBackupTOsIntoTable(backUpFileTOs);
        }
    }

    private boolean getBackupCrawlTableStatus() {
        int count = this.newBackUpCrawlDAOImpl.getCountOfRemainingFilesForBackup(true);
        return count != 0;
    }

    private void updateCrawlTableAndGetDeletedFiles(Set<BackupTO> deletedSet) {
        if (this.backupStatusElement.getLastSuccessfulCrawlTimeStamp() == 0L) {
            return;
        }
        this.logger.debug("Before getting added files from bkit");
        List<BackUpCrawlFileTO> backupCrawlTOs = this.newBackupImageDAOImpl.getAddedORDeletedFilesByComparing("ADDED");
        List backupTOs = null;
        this.logger.debug("After getting ADDED files from bkit");
        this.logger.debug("Before getting backupCrawlTOs for added files from objectutils");
        if (backupCrawlTOs != null) {
            backupTOs = ObjectUtils.createBackupElementForFileNames(backupCrawlTOs);
        }
        this.logger.debug("After getting backupCrawlTOs for added files from objectutils");
        if (backupTOs != null) {
            this.logger.debug("backup crawl file to list size:" + backupTOs.size());
            this.newBackUpCrawlDAOImpl.checkFileExistsAndInsertFiles(backupTOs);
        }
        this.logger.debug("Before getting deleted files from bkit");
        List<BackUpCrawlFileTO> deletedFiles = this.newBackupImageDAOImpl.getAddedORDeletedFilesByComparing("DELETED");
        this.logger.debug("After getting deleted files from bkit");
        if (deletedFiles != null) {
            this.logger.debug("Before getting deletedList set from objectutils");
            List deletedList = ObjectUtils.createBackupElementForDeletedFiles(deletedFiles);
            this.logger.debug("After getting deletedList set from objectutils");
            deletedSet.addAll(deletedList);
            this.logger.debug("DELETED SET SIZE:" + deletedSet.size());
        }
        ArrayList<BackupTO> failedFromPrevBkupFiles = new ArrayList<BackupTO>();
        List failedFilesFromPrevBkup = new ArrayList();
        if (this.backupStatusElement.getBackupLogElement() != null && this.backupStatusElement.getBackupLogElement().getFailedFiles() != null) {
            failedFilesFromPrevBkup = this.backupStatusElement.getBackupLogElement().getFailedFiles();
        }
        for (FileElement backupElement : failedFilesFromPrevBkup) {
            BackupTO backupTO = new BackupTO();
            ObjectUtils.copyFileElemenToBackupTO((FileElement)backupElement, (BackupTO)backupTO);
            failedFromPrevBkupFiles.add(backupTO);
        }
        if (!failedFromPrevBkupFiles.isEmpty()) {
            this.newBackUpCrawlDAOImpl.checkFileExistsAndInsertFiles(failedFromPrevBkupFiles);
        }
    }

    private BackupStatusElement getStatusOfBackup() {
        BackupStatusElement statusElement = null;
        try {
            statusElement = this.backupAdapter.getBackupStatus(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.readTokenFromFile(), BACKUP, SettingHelper.getDeviceName(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName());
            if (this.isBadRequest(statusElement) || this.isServerDown(statusElement)) {
                statusElement = this.retryBackupStatusUsingUpdatedIp();
            } else {
                if (statusElement.getResponseCode() == 421) {
                    this.sessionExpired = true;
                    throw new CrawlAdapterException("Session Expired");
                }
                if (statusElement.getResponseCode() == 420) {
                    this.deviceBlocked = true;
                    throw new CrawlAdapterException(" User Device Blocked");
                }
            }
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Error in get backup status.", (Object)e.getMessage());
            statusElement = this.retryBackupStatusUsingUpdatedIp();
        }
        return statusElement;
    }

    private boolean isBadRequest(BackupStatusElement statusElement) {
        return statusElement == null || statusElement.getResponseCode() == 404;
    }

    private boolean isServerDown(BackupStatusElement statusElement) {
        return statusElement.getResponseCode() == 400 || statusElement.getResponseCode() == 503 || statusElement.getResponseCode() == 500;
    }

    private BackupStatusElement retryBackupStatusUsingUpdatedIp() {
        boolean retry;
        BackupStatusElement statusElement = null;
        int retryCount = 0;
        int sleepMultiplier = 1;
        long sleepTime = 60000L * (long)sleepMultiplier;
        String currentIp = SettingHelper.getCurrentCloudIpAddress();
        BluVaultIPHelper bluVaultIPHelper = new BluVaultIPHelper();
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        List<BluVaultTO> ebmsList = bluVaultIPHelper.getEbmsList(backupPolicyDAOImpl);
        do {
            retry = false;
            try {
                ebmsList = this.removeCurrentIp(ebmsList, currentIp);
                this.logger.debug("ebms list size after removing the current ip:" + ebmsList.size());
                if (ebmsList.isEmpty()) {
                    this.logger.debug("inside ebms list empty cycle finished so sleep and reset");
                    ++retryCount;
                    sleepTime = this.sleepForGivenTime(statusElement, sleepTime, retry);
                    ebmsList = bluVaultIPHelper.getEbmsList(backupPolicyDAOImpl);
                }
                if (!ebmsList.isEmpty()) {
                    currentIp = ebmsList.get(0).getBluVaultName();
                }
                NotificationHelper.setBackupStatus(1);
                statusElement = this.backupAdapter.getBackupStatus(currentIp, SettingHelper.readTokenFromFile(), BACKUP, SettingHelper.getDeviceName(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName());
                if (this.isBadRequest(statusElement) || this.isServerDown(statusElement)) {
                    retry = true;
                } else if (statusElement.getResponseCode() == 200) {
                    if (!StringUtils.isEmpty((String)currentIp)) {
                        SettingHelper.setGaeLocalIpAddress(currentIp);
                        SettingHelper.setPublicIpAddress(currentIp);
                        SettingHelper.setCurrentCloudIpAddress(currentIp);
                        SettingHelper.applyChangesToSharedPreferences(false);
                    }
                    return statusElement;
                }
            }
            catch (CrawlAdapterException e) {
                this.logger.trace("" + (Object)((Object)e));
                this.logger.error("Crawl Exception  getting backup status so retry.." + e.getMessage());
                retry = true;
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("Error while getting backup status" + e.getMessage());
            }
            if (retryCount < 4) continue;
            retry = true;
            sleepTime = 1800000L;
        } while (retry);
        return statusElement;
    }

    private long sleepForGivenTime(BackupStatusElement statusElement, long sleepTime, boolean retry) {
        long sleepTimeTemp = sleepTime;
        try {
            this.logger.debug("SleepTime is" + sleepTimeTemp);
            PBCountDownTimer countDownTimer = new PBCountDownTimer();
            if (statusElement != null) {
                this.logger.debug("response code:" + statusElement.getResponseCode());
            }
            countDownTimer.startCountDownTimer((int)sleepTimeTemp / 60000);
            this.logger.debug("after starting timer/....");
            NotificationHelper.setBackupStatus(6);
            Thread.sleep(sleepTimeTemp);
            int sleepMultiplier = 2;
            sleepTimeTemp *= (long)sleepMultiplier;
        }
        catch (InterruptedException e1) {
            this.logger.error("Sleeper Thread interupted error");
        }
        return sleepTimeTemp;
    }

    public void checkIfPathExists(List<BackupFolderTO> listOfFolder) {
        ArrayList<String> listOfNotExistingFolders = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (BackupFolderTO backupFolder : listOfFolder) {
            String actualPath = SettingHelper.getOsName().toLowerCase().contains("mac") ? this.checkForMacBasePath(backupFolder.getFolderPath()) : backupFolder.getFolderPath();
            File file = new File(actualPath);
            if (file.exists()) continue;
            listOfNotExistingFolders.add(backupFolder.getFolderPath());
            buffer.append(backupFolder.getFolderPath());
            buffer.append("\n");
        }
        if (!listOfNotExistingFolders.isEmpty()) {
            String toolTipMessage = "Following folder or drive does not exist";
            String toolTipmessage1 = buffer.toString();
            this.updateSystrayToolTipNotification(toolTipMessage, toolTipmessage1);
        }
    }

    private void validatePreviousBackupActivity(BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl) {
        BackupActivityTO backupActivityTO = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
        if (backupActivityTO != null && backupActivityTO.getBatchStatus().equals(BackupLifeCycle.STARTED.toString())) {
            backupActivityTO.setBatchStatus(BackupLifeCycle.INTERRUPTED.toString());
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
        }
        if (backupActivityTO != null && backupActivityTO.getBackupActivityStatus().equals(CrawlLifecycle.INPROGRESS.toString())) {
            backupActivityTO.setBackupActivityStatus(CrawlLifecycle.ABORTED.toString());
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
        }
    }

    private void validatePreviousRestartId() {
        if (this.backupStatusElement.getBackupLogElement() != null) {
            this.restartId = this.backupStatusElement.getBackupLogElement().getRestartId();
            this.logger.debug("Restart Id is: " + this.restartId);
        }
    }

    public abstract void startBackUpThread(Set<DedupTO> var1, boolean var2, long var3, String var5) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException;

    public abstract void pauseBackup(boolean var1);

    private void chunkBackupFilesAndCallForUpload(Set<BackupTO> backUpList, Set<BackupTO> deletedSet) throws CrawlAdapterException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        HashSet<BackupTO> chunkBackupFilesTOSet = new HashSet<BackupTO>();
        HashSet<BackupTO> chunkDeletedFilesTOSet = new HashSet<BackupTO>();
        ArrayList<BackupTO> removeList = new ArrayList<BackupTO>();
        Iterator<BackupTO> iterator = backUpList.iterator();
        while (iterator.hasNext()) {
            chunkBackupFilesTOSet.add(iterator.next());
            if (chunkBackupFilesTOSet.size() != this.crawlFileLimit) continue;
            this.createAndSendRequestAndUpdatedatabase(chunkBackupFilesTOSet, new HashSet<BackupTO>(), removeList);
            chunkBackupFilesTOSet.clear();
        }
        iterator = deletedSet.iterator();
        while (iterator.hasNext()) {
            chunkDeletedFilesTOSet.add(iterator.next());
            if (chunkBackupFilesTOSet.size() != this.crawlFileLimit) continue;
            this.createAndSendRequestAndUpdatedatabase(new HashSet<BackupTO>(), chunkDeletedFilesTOSet, removeList);
            chunkDeletedFilesTOSet.clear();
        }
        this.createAndSendRequestAndUpdatedatabase(chunkBackupFilesTOSet, chunkDeletedFilesTOSet, removeList);
        chunkBackupFilesTOSet.clear();
        this.logger.debug("Final remove list size:" + removeList.size() + "Backuplist size before:" + backUpList.size());
        backUpList.removeAll(removeList);
    }

    private void createAndSendRequestAndUpdatedatabase(Set<BackupTO> backUpList, Set<BackupTO> deletedSet, List<BackupTO> removeList) throws CrawlAdapterException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        byte[] bs = this.createWebRequest(backUpList, deletedSet);
        if (bs == null) {
            throw new BaseException("gzip byte array is null,serialization failed");
        }
        List<BackupTO> filesNotToUpload = this.sendWebRequest(bs);
        removeList.addAll(filesNotToUpload);
    }

    private byte[] createWebRequest(Set<BackupTO> backUpList, Set<BackupTO> deletedSet) {
        ArrayList<FileElement> newBackupFileElements = new ArrayList<FileElement>();
        ArrayList<FileElement> deletedBackupFileElements = new ArrayList<FileElement>();
        this.convertBackupTOListToBackupElementList(backUpList, newBackupFileElements);
        this.convertBackupTOListToBackupElementList(deletedSet, deletedBackupFileElements);
        FileListElement newBackupFileListElement = new FileListElement();
        FileListElement deletedBackupFileListElement = new FileListElement();
        newBackupFileListElement.setFileElementList(newBackupFileElements);
        deletedBackupFileListElement.setFileElementList(deletedBackupFileElements);
        BackupValidationElement backupValidationElement = new BackupValidationElement();
        backupValidationElement.setFilesToAddList(newBackupFileListElement);
        backupValidationElement.setFilesToDeleteList(deletedBackupFileListElement);
        byte[] bs = CreateXmlObject.createGzipByteArrayForValidateBackUpRequest((BackupValidationElement)backupValidationElement);
        return bs;
    }

    private List<BackupTO> sendWebRequest(byte[] bs) throws CrawlAdapterException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        GzipTO gzipResponse;
        this.currentIP = SettingHelper.getCurrentCloudIpAddress();
        if (SettingHelper.getCurrentHttpsPort() != null) {
            this.currentPort = Integer.valueOf(SettingHelper.getCurrentHttpsPort());
        }
        if ((gzipResponse = this.backupAdapter.validateDeltaForBackUp(bs, this.currentIP, null, false, SettingHelper.readTokenFromFile())) == null || gzipResponse.getResponseCode() == 404 || gzipResponse.getResponseCode() == 400 || gzipResponse.getResponseCode() == 503) {
            gzipResponse = this.retryUsingUpdatedIp(bs, gzipResponse);
        }
        if (gzipResponse == null) {
            throw new CrawlAdapterException(" null gzipResponse (connection error)");
        }
        int responseCode = gzipResponse.getResponseCode();
        if (responseCode == 400 || responseCode == 404) {
            throw new CrawlAdapterException(" HTTP_DEVICE_SESSION_EXPIRED or HTTP_BAD_REQUEST or HTTP_NOT_FOUND:" + responseCode);
        }
        if (responseCode == 416) {
            this.licenseExpired = true;
            throw new CrawlAdapterException(" License Expired");
        }
        if (responseCode == 420) {
            this.deviceBlocked = true;
            throw new CrawlAdapterException(" User Device Blocked");
        }
        if (responseCode == 417) {
            throw new CrawlAdapterException("User Limit Reached");
        }
        if (responseCode == 421) {
            this.sessionExpired = true;
            throw new CrawlAdapterException("Session Expired");
        }
        if (responseCode == 401) {
            throw new CrawlAdapterException("Unauthorized");
        }
        if (responseCode != 200) {
            throw new CrawlAdapterException(" Server Error: " + responseCode);
        }
        byte[] responseByte = gzipResponse.getResponse();
        BackupListResponseElement backupListResponseElement = Xmlparser.parseBackupListResponse((byte[])responseByte);
        if (backupListResponseElement == null) {
            throw new CrawlAdapterException(" backupListResponseElement; parsed response null");
        }
        List<DedupTO> dedupTOs = this.getDedupListFromResponse(backupListResponseElement);
        this.logger.debug("Dedup list is: " + dedupTOs.size());
        this.insertDedupIntoTable(dedupTOs);
        this.dedupToSet.addAll(dedupTOs);
        return ObjectUtils.convertFileElementToBackupTO((List)backupListResponseElement.getFilesNotToAddList().getFileElementList(), (String)"0");
    }

    private void insertDedupIntoTable(List<DedupTO> dedupTOs) {
        if (dedupTOs != null && !dedupTOs.isEmpty()) {
            try {
                this.newBackupImageDAOImpl.insertListOfDedupsIntoTable(dedupTOs);
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("Error in insert dedup entries" + e.getMessage());
            }
        }
    }

    private List<DedupTO> getDedupListFromResponse(BackupListResponseElement backupListResponseElement) {
        List dedupTOs = ObjectUtils.convertKeyValueElementToDedupTO((List)backupListResponseElement.getFilesNotToAddList().getMd5AndDedupedIdList());
        return dedupTOs;
    }

    private GzipTO retryUsingUpdatedIp(byte[] bs, GzipTO gzipRes) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        SettingHelper.checkAndUpdateIpAddress();
        GzipTO gzipResponse = gzipRes;
        if (gzipResponse == null || gzipResponse.getResponseCode() == 404 || gzipResponse.getResponseCode() == 400) {
            this.currentIP = SettingHelper.getGaeLocalIpAddress();
            this.currentPort = null;
            gzipResponse = this.backupAdapter.validateDeltaForBackUp(bs, this.currentIP, this.currentPort, this.isFirstTimeCrawl, SettingHelper.readTokenFromFile());
        }
        if (gzipResponse == null || gzipResponse.getResponseCode() == 404 || gzipResponse.getResponseCode() == 400) {
            this.currentIP = SettingHelper.getPublicIpAddress();
            this.currentPort = null;
            gzipResponse = this.backupAdapter.validateDeltaForBackUp(bs, this.currentIP, this.currentPort, this.isFirstTimeCrawl, SettingHelper.readTokenFromFile());
        }
        if (gzipResponse == null || gzipResponse.getResponseCode() == 404 || gzipResponse.getResponseCode() == 400 && SettingHelper.getHttpsPort() != null) {
            this.currentIP = SettingHelper.getPublicIpAddress();
            this.currentPort = Integer.valueOf(SettingHelper.getHttpsPort());
            gzipResponse = this.backupAdapter.validateDeltaForBackUp(bs, this.currentIP, this.currentPort, this.isFirstTimeCrawl, SettingHelper.readTokenFromFile());
        }
        if (gzipResponse != null && gzipResponse.getResponseCode() != 404 && gzipResponse.getResponseCode() != 400) {
            SettingHelper.setCurrentHttpsPort(this.currentPort == null ? null : String.valueOf(this.currentPort));
            SettingHelper.setCurrentCloudIpAddress(this.currentIP);
            SettingHelper.applyChangesToSharedPreferences(false);
        }
        return gzipResponse;
    }

    private void convertBackupTOListToBackupElementList(Set<BackupTO> fileTOList, List<FileElement> fileElementList) {
        for (BackupTO fileTO : fileTOList) {
            BackupElement fileElement = new BackupElement();
            ObjectUtils.copyBackupTOtoFileElement((BackupTO)fileTO, (FileElement)fileElement);
            fileElementList.add((FileElement)fileElement);
        }
    }

    private void createTablesIfNotExist() {
        this.logger.debug("inside create table  if not exists..");
        this.backUpFolderDAOImpl.createBackUpTable();
        this.backUpImageDAOImpl.createTable();
        this.newBackUpCrawlDAOImpl.createTable();
        this.newBackupImageDAOImpl.createNewBackUpImageTable();
        this.newBackupImageDAOImpl.createNewPrevBackUpImageTable();
        this.newBackUpCrawlDAOImpl.createNewPrevBackupCrawlTable();
        this.newBackupImageDAOImpl.createDedupTable();
        this.newBackupImageDAOImpl.createOldPrevBackUpImageTable();
        this.newBackUpCrawlDAOImpl.createOldBackupCrawlTable();
    }

    private void scanFileSystem(List<BackupFolderTO> files, long lastSuccessfullCrawlTime) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        boolean success = this.doDataBaseChanges();
        this.logger.debug("Database changes done" + success);
        if (!files.isEmpty()) {
            List<String> excludedFoldersFromPolicy = null;
            this.logger.debug("START CRAWL " + System.currentTimeMillis());
            if (SettingHelper.getBackupLicenced().contentEquals("true")) {
                FilesBeSkippedAsPerPolicy.setLegalHoldDetails();
                FilesBeSkippedAsPerPolicy.allowedSize = FilesBeSkippedAsPerPolicy.getCurrentPolicyMaxSize();
                this.setFilterDetails();
                excludedFoldersFromPolicy = FilesBeSkippedAsPerPolicy.excludedFoldersFromPolicy = HashChecker.getExcludedFoldersList();
                excludedFoldersFromPolicy.forEach(System.out::println);
            }
            this.crawlTimeStamp = Long.toString(System.currentTimeMillis());
            for (BackupFolderTO file : files) {
                if (Thread.currentThread().isInterrupted()) break;
                try {
                    ArrayList<File> fileList;
                    if (excludedFoldersFromPolicy != null && !excludedFoldersFromPolicy.isEmpty() && FilesBeSkippedAsPerPolicy.skipExcludedFolders(excludedFoldersFromPolicy, file.getFolderPath())) continue;
                    this.scanFileSystemByType(file.getFolderPath(), lastSuccessfullCrawlTime);
                    if (!this.backupImageList.isEmpty()) {
                        this.logger.debug(" Files to be inserted in backupimage table" + this.backupImageList.size());
                        ++this.noOfDBWritesForCrawlFileLimit;
                        fileList = new ArrayList<File>();
                        fileList.addAll(this.backupImageList);
                        this.newBackupImageDAOImpl.insertListOfFileNamesIntoTable(fileList);
                        this.backupImageList.clear();
                        fileList.clear();
                    }
                    if (this.crawledFileList.isEmpty()) continue;
                    this.logger.debug("#1 Files to be inserted in crawl table " + this.crawledFileList.size());
                    ++this.noOfDBWritesForCrawlFileLimit;
                    fileList = new ArrayList();
                    fileList.addAll(this.crawledFileList);
                    List backupTOs = ObjectUtils.createBackupElementForFiles(fileList);
                    this.newBackUpCrawlDAOImpl.insertListIntoTable(backupTOs);
                    this.crawledFileList.clear();
                    fileList.clear();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.trace("" + e);
                    this.logger.error("exception while crawl", (Throwable)e);
                }
            }
            this.logger.debug("END CRAWL" + System.currentTimeMillis());
            this.logger.debug("noOfDBWritesForCrawlFileLimit:## " + this.noOfDBWritesForCrawlFileLimit);
        }
    }

    private void setFilterDetails() {
        Map<String, String> exclusionMap = this.backUpFolderDAOImpl.getInclusionExtensions();
        if (exclusionMap != null && !exclusionMap.isEmpty()) {
            FilesBeSkippedAsPerPolicy.extensions = exclusionMap.get("extensionName");
            String filterType = exclusionMap.get("filterType");
            FilesBeSkippedAsPerPolicy.filterType = StringUtils.isEmpty((String)filterType) ? "inclusion" : filterType;
        }
    }

    private boolean doDataBaseChanges() {
        this.newBackUpCrawlDAOImpl.clearEntireTempTable();
        this.newBackupImageDAOImpl.clearEntireTempTable();
        if (!this.doDataBaseChanges) {
            this.logger.debug("database changes not needed so return");
            return true;
        }
        boolean success = false;
        this.newBackUpCrawlDAOImpl.createTempTable();
        this.newBackupImageDAOImpl.createNewBackUpImageTempTable();
        this.newBackUpCrawlDAOImpl.deleteEntireOldBackpCrawlTable();
        boolean delSuccess = this.newBackUpCrawlDAOImpl.dropTable("NewPrev_BkupCrawl");
        boolean copySuccess = false;
        if (delSuccess) {
            copySuccess = this.newBackUpCrawlDAOImpl.renameTable("NewBkupCrawl", "NewPrev_BkupCrawl");
        }
        if (copySuccess) {
            this.newBackUpCrawlDAOImpl.dropTable("NewBkupCrawl");
        }
        copySuccess = false;
        delSuccess = this.newBackupImageDAOImpl.dropTable("NEWPREV_BKITABLE");
        if (delSuccess) {
            copySuccess = this.newBackupImageDAOImpl.renameTable("NEWBKITABLE", "NEWPREV_BKITABLE");
        }
        if (copySuccess) {
            this.newBackupImageDAOImpl.dropTable("NEWBKITABLE");
        }
        if (delSuccess && copySuccess) {
            success = true;
        }
        return success;
    }

    public String backupBatchInitiated(String batchStatus, String batchId, int totalCount, int errorCode, long totalUploadSize, String totalUploadedCount, int crawlCount, String crawlTimeStamp) {
        String recivedBatchId;
        boolean retry;
        String jobType = BACKUP;
        String originalBatchId = batchId;
        int retryCount = 0;
        int sleepMultiplier = 1;
        long sleepTime = 60000L * (long)sleepMultiplier;
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        String currentIPToUse = SettingHelper.getCurrentCloudIpAddress();
        BluVaultIPHelper bluVaultIPHelper = new BluVaultIPHelper();
        List<BluVaultTO> ebmsList = bluVaultIPHelper.getEbmsList(backupPolicyDAOImpl);
        do {
            retry = false;
            this.logger.debug("Retrying to update backup status.");
            try {
                this.logger.debug("the STATUS:" + batchStatus);
                BackupOrRestoreStatusTo backupOrRestoreStatusTo = new BackupOrRestoreStatusTo();
                backupOrRestoreStatusTo.setStatus(batchStatus);
                backupOrRestoreStatusTo.setIp(currentIPToUse);
                backupOrRestoreStatusTo.setToken(SettingHelper.readTokenFromFile());
                backupOrRestoreStatusTo.setBatchId(originalBatchId);
                backupOrRestoreStatusTo.setJobType(jobType);
                backupOrRestoreStatusTo.setDeviceName(SettingHelper.getDeviceName());
                backupOrRestoreStatusTo.setTotalCount(totalCount);
                backupOrRestoreStatusTo.setErrorCode(errorCode);
                backupOrRestoreStatusTo.setDeviceUUID(SettingHelper.getDeviceUUId());
                backupOrRestoreStatusTo.setTotalUploadSize(totalUploadSize);
                backupOrRestoreStatusTo.setTotalUploadedCount(totalUploadedCount);
                backupOrRestoreStatusTo.setCrawlCount(crawlCount);
                backupOrRestoreStatusTo.setCrawlTimeStamp(crawlTimeStamp);
                backupOrRestoreStatusTo.setFullBackup(this.isFullBackup);
                backupOrRestoreStatusTo.setDiskSpaceDetails(new ParabluFileSystemUtils().getSystemSpace());
                backupOrRestoreStatusTo.setPolicyConfiguredFolders(this.getConfiguredBackupFolders());
                recivedBatchId = this.backupAdapter.sendEmailNotification(backupOrRestoreStatusTo);
            }
            catch (Exception e) {
                recivedBatchId = "-1";
                this.logger.trace("" + e);
                this.logger.error(" Exception inside  put batch " + e.getMessage());
            }
            if (!"-1".equalsIgnoreCase(recivedBatchId)) continue;
            retry = true;
            ebmsList = this.removeCurrentIp(ebmsList, currentIPToUse);
            this.logger.debug("ebms list size after removing the current ip:" + ebmsList.size());
            if (ebmsList.isEmpty()) {
                this.logger.debug("inside ebms list empty cycle finished so sleep and reset");
                sleepTime = ParabluFileSystemUtils.sleepForGivenTime((long)sleepTime);
                ++retryCount;
                ebmsList = bluVaultIPHelper.getEbmsList(backupPolicyDAOImpl);
            }
            if (ebmsList.isEmpty()) continue;
            currentIPToUse = ebmsList.get(0).getBluVaultName();
        } while (retry && retryCount < 4);
        return recivedBatchId;
    }

    private List<BluVaultTO> removeCurrentIp(List<BluVaultTO> ebmsList, String currentIP) {
        List<Object> ebmsList1 = new ArrayList<BluVaultTO>();
        if (ebmsList == null) {
            ArrayList<BluVaultTO> ebsList = new ArrayList<BluVaultTO>();
            return ebsList;
        }
        if (StringUtils.isEmpty((String)currentIP)) {
            return ebmsList;
        }
        try {
            ebmsList1 = ebmsList.stream().filter(p -> !p.getBluVaultName().equalsIgnoreCase(currentIP)).collect(Collectors.toList());
            this.logger.debug("After removing the ip size:" + ebmsList1.size() + "  current Ip:" + currentIP);
        }
        catch (Exception e) {
            this.logger.error("error happened while removing current ip..", (Throwable)e);
        }
        return ebmsList1;
    }

    private BackupResultTO scanFileSystemByType(String completeParentPath, long lastSuccessfullCrawlTime) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        File currentFolder;
        File[] childFileAndFolderNames;
        ArrayList<File> fileList;
        String recivedCompleteParentPath = completeParentPath;
        if (this.backupImageList.size() > 5000) {
            this.logger.debug("Files to be inserted in backupimage table" + this.backupImageList.size());
            ++this.noOfDBWritesForCrawlFileLimit;
            fileList = new ArrayList<File>();
            fileList.addAll(this.backupImageList);
            this.newBackupImageDAOImpl.insertListOfFileNamesIntoTable(fileList);
            this.backupImageList.clear();
            fileList.clear();
        }
        if (this.crawledFileList.size() > 5000) {
            this.logger.debug("Files to be inserted in crawl table " + this.crawledFileList.size());
            ++this.noOfDBWritesForCrawlFileLimit;
            fileList = new ArrayList();
            fileList.addAll(this.crawledFileList);
            List backupTOs = ObjectUtils.createBackupElementForFiles(fileList);
            this.newBackUpCrawlDAOImpl.insertListIntoTable(backupTOs);
            this.crawledFileList.clear();
            fileList.clear();
        }
        if ((childFileAndFolderNames = (currentFolder = new File(recivedCompleteParentPath = this.checkForMacBasePath(recivedCompleteParentPath))).listFiles()) == null) {
            return null;
        }
        int noOfChildFilesAndFolders = childFileAndFolderNames.length;
        for (int i = 0; i < noOfChildFilesAndFolders; ++i) {
            String snapshotPath;
            File snapShotFile;
            if (Thread.currentThread().isInterrupted()) {
                this.logger.debug("Current thread is interrupted so return .....");
                return null;
            }
            File currentProcessingFile = childFileAndFolderNames[i];
            if (SettingHelper.getOsName().toLowerCase().startsWith("win") && ParabluFileSystemUtils.isSnapshotValid() && !(snapShotFile = new File(snapshotPath = ObjectUtils.getSnapShotPath((String)currentProcessingFile.getAbsolutePath()))).exists()) {
                this.logger.debug("file does not exist in snapshot so continue..." + snapShotFile);
                continue;
            }
            if (currentProcessingFile.getName().startsWith(".pbsdn")) {
                currentProcessingFile.delete();
                continue;
            }
            if (currentProcessingFile.getName().startsWith("pbchnkz") || currentProcessingFile.getName().startsWith(".pbchnkz") || currentProcessingFile.getName().startsWith("CHUNK")) {
                if (currentProcessingFile.isDirectory()) {
                    String[] children = currentProcessingFile.list();
                    for (int j = 0; j < children.length; ++j) {
                        new File(currentProcessingFile, children[j]).delete();
                    }
                }
                currentProcessingFile.delete();
                continue;
            }
            if (currentProcessingFile.getName().startsWith("rpbchnkz") || currentProcessingFile.getName().startsWith(".rpbchnkz")) continue;
            boolean isParabluAppDir = false;
            if (this.isParaBluAppDirectory(currentProcessingFile)) {
                isParabluAppDir = true;
            }
            boolean fileToBeSkipped = this.isFileToBeSkipped(currentProcessingFile.getAbsolutePath());
            boolean isFileToBeSkippedAsperPolicy = !currentProcessingFile.isDirectory() && SettingHelper.getBackupLicenced().contentEquals("true") ? FilesBeSkippedAsPerPolicy.checkVariousPolicies(currentProcessingFile) : FilesBeSkippedAsPerPolicy.checkExcludeFolders(currentProcessingFile);
            if (fileToBeSkipped || isFileToBeSkippedAsperPolicy || isParabluAppDir) continue;
            boolean isFileADirectory = currentProcessingFile.isDirectory();
            this.backupImageList.add(currentProcessingFile);
            if (currentProcessingFile.lastModified() > lastSuccessfullCrawlTime) {
                this.crawledFileList.add(currentProcessingFile);
                this.backupSizeOnDisk += currentProcessingFile.length();
            }
            if (!isFileADirectory) continue;
            BackupResultTO backupResult = this.scanFileSystemByType(currentProcessingFile.getAbsolutePath(), lastSuccessfullCrawlTime);
            if (backupResult != null && backupResult.getCrawledFileList() != null) {
                this.crawledFileList.addAll(backupResult.getCrawledFileList());
            }
            if (backupResult == null || backupResult.getBackupImageList() == null) continue;
            this.backupImageList.addAll(backupResult.getBackupImageList());
        }
        if (this.backupImageList.size() > 5000) {
            ++this.noOfDBWritesForCrawlFileLimit;
            ArrayList<File> fileList2 = new ArrayList<File>();
            fileList2.addAll(this.backupImageList);
            this.logger.debug("Files to be inserted " + this.backupImageList.size());
            this.newBackupImageDAOImpl.insertListOfFileNamesIntoTable(fileList2);
            this.backupImageList.clear();
        }
        if (this.crawledFileList.size() > 5000) {
            this.logger.debug("Files to be inserted " + this.crawledFileList.size());
            ++this.noOfDBWritesForCrawlFileLimit;
            ArrayList<File> fileList3 = new ArrayList<File>();
            fileList3.addAll(this.crawledFileList);
            List backupTOs = ObjectUtils.createBackupElementForFiles(fileList3);
            this.newBackUpCrawlDAOImpl.insertListIntoTable(backupTOs);
            this.crawledFileList.clear();
            fileList3.clear();
        }
        BackupResultTO backupResult = new BackupResultTO();
        backupResult.setBackupImageList(this.backupImageList);
        backupResult.setCrawledFileList(this.crawledFileList);
        return backupResult;
    }

    public boolean isPotentialValidLink(File file) {
        int minimumLength = 100;
        boolean isPotentiallyValid = false;
        try (FileInputStream fis = new FileInputStream(file);){
            isPotentiallyValid = file.isFile() && file.getName().toLowerCase().endsWith(".lnk") && ((InputStream)fis).available() >= 100;
        }
        catch (IOException e) {
            this.logger.trace("" + e);
            this.logger.error("exception while reading file" + e.getMessage());
        }
        return isPotentiallyValid;
    }

    private boolean isParaBluAppDirectory(File currentProcessingFile) {
        boolean isAppDir = false;
        if (SettingHelper.getOsName().toLowerCase().contains("win")) {
            String paraBluDir = SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + "AppData" + StringLiterals.FILE_SEPARATOR + "Roaming" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "ParaBlu";
            String paraBluDirNew = SettingHelper.getInstallationDir();
            if (currentProcessingFile.getAbsolutePath().toLowerCase().contains(paraBluDir.toLowerCase())) {
                isAppDir = true;
            }
            if (currentProcessingFile.getAbsolutePath().toLowerCase().contains(paraBluDirNew.toLowerCase())) {
                isAppDir = true;
            }
        }
        return isAppDir;
    }

    public static String rootDirectory() {
        return File.listRoots()[0].getAbsolutePath();
    }

    private boolean isFileToBeSkipped(String fileName) {
        if (FilesBeSkippedAsPerPolicy.isBackupSystemFilesEnabled()) {
            return false;
        }
        String rootDirectory = NewBackUpJob.rootDirectory().toLowerCase();
        if (SettingHelper.getOsName().toLowerCase().contains("win")) {
            for (BackupFoldersToBeSkipped.WindowsBackupFoldersToBeSkipped beSkipped : BackupFoldersToBeSkipped.WindowsBackupFoldersToBeSkipped.values()) {
                String folderBeSkipped = (rootDirectory + beSkipped.value()).toLowerCase();
                String currentFolder = fileName.toLowerCase();
                if (!currentFolder.contains(folderBeSkipped) && !currentFolder.contains(rootDirectory + BackupFoldersToBeSkipped.WindowsBackupFoldersToBeSkipped.PROGRAM_FILES.value().toLowerCase())) continue;
                return true;
            }
        } else {
            this.getMacFolderPathsToBeSkipped(rootDirectory);
            for (String beSkipped : this.macBackupFoldersToBeSkippedList) {
                String currentFolder = fileName.toLowerCase();
                if (!currentFolder.equalsIgnoreCase(beSkipped.toLowerCase()) && !currentFolder.toLowerCase().startsWith(beSkipped.toLowerCase() + StringLiterals.FILE_SEPARATOR)) continue;
                return true;
            }
        }
        return false;
    }

    private String checkForMacBasePath(String completeParentPath) {
        String mac = "Macintosh";
        if (completeParentPath.startsWith("Macintosh" + StringLiterals.FILE_SEPARATOR)) {
            return completeParentPath.substring(9);
        }
        return completeParentPath;
    }

    private int getCrawlLimit() {
        if (!StringUtils.isEmpty((String)SettingHelper.getBackupCrawlLimit())) {
            this.logger.debug("returning crawl limit" + SettingHelper.getBackupCrawlLimit());
            return Integer.valueOf(SettingHelper.getBackupCrawlLimit());
        }
        return 500;
    }

    private String getConfiguredBackupFolders() {
        StringBuilder backupFolders = new StringBuilder("");
        if (!bkpFolderList.isEmpty()) {
            for (BackupFolderTO backupFolderTO : bkpFolderList) {
                backupFolders.append(backupFolderTO.getFolderPath()).append("; ");
            }
        }
        return backupFolders.toString();
    }

    private void getMacFolderPathsToBeSkipped(String rootDirectory) {
        if (this.macBackupFoldersToBeSkippedList == null || this.macBackupFoldersToBeSkippedList.isEmpty()) {
            this.macBackupFoldersToBeSkippedList = new ArrayList<String>();
            File[] usersFolders = new File(new File(SettingHelper.getUserHome()).getParent()).listFiles();
            String macBackupFoldersToBeSkipped = PropertyHelper.EXCLUSION_FOLDERS;
            List<Object> macBackupFoldersToBeSkippedListFromProperty = new ArrayList();
            String macBackupFoldersToBeSkippedRoot = PropertyHelper.EXCLUSION_FOLDERS_ROOT;
            List<Object> macBackupFoldersToBeSkippedRootListFromProperty = new ArrayList();
            if (StringUtils.isNotEmpty((String)macBackupFoldersToBeSkipped)) {
                macBackupFoldersToBeSkippedListFromProperty = Arrays.asList(macBackupFoldersToBeSkipped.split("\\s*;\\s*"));
            }
            if (StringUtils.isNotEmpty((String)macBackupFoldersToBeSkipped)) {
                macBackupFoldersToBeSkippedRootListFromProperty = Arrays.asList(macBackupFoldersToBeSkippedRoot.split("\\s*;\\s*"));
            }
            for (String string : macBackupFoldersToBeSkippedListFromProperty) {
                for (File userFolder : usersFolders) {
                    String userfolderBeSkipped = (userFolder.getAbsolutePath() + StringLiterals.FILE_SEPARATOR + string).toLowerCase();
                    this.macBackupFoldersToBeSkippedList.add(userfolderBeSkipped);
                }
            }
            for (String string : macBackupFoldersToBeSkippedRootListFromProperty) {
                String folderBeSkipped = (rootDirectory + string).toLowerCase();
                this.macBackupFoldersToBeSkippedList.add(folderBeSkipped);
            }
        }
    }

    private void openNamedPipeNClose() {
        try {
            this.logger.debug("opening the named pipe...");
            RandomAccessFile pipe = new RandomAccessFile("\\\\.\\pipe\\ParabluSvcNAmedPipe", "rw");
            this.logger.debug("wait for one sec and close...");
            Thread.sleep(1000L);
            pipe.close();
        }
        catch (Exception e) {
            this.logger.error("Exception in open named pipe.." + e.getMessage());
        }
    }

    private boolean getValueForcaseCheck() {
        try {
            String basePath;
            File pathForCaesen;
            String caseCheckEnabled;
            if (SettingHelper.getOsName().toLowerCase().contains("win") && StringUtils.isNotEmpty((String)(caseCheckEnabled = RegistryUtils.getRegistryValue((String)"HKCU", (String)"Software\\ParaBlu\\BluSync", (String)"casecheck")))) {
                this.logger.debug("case check value form registry...:" + caseCheckEnabled);
                return Boolean.valueOf(caseCheckEnabled);
            }
            if (SettingHelper.getOsName().toLowerCase().contains("mac") && (pathForCaesen = new File((basePath = SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + ".ParaBlu" + StringLiterals.FILE_SEPARATOR + "ParaBlu" + StringLiterals.FILE_SEPARATOR + "Blusync") + StringLiterals.FILE_SEPARATOR + "settings" + StringLiterals.FILE_SEPARATOR + "casecheck")).exists()) {
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("error getting the value from registry:" + e);
        }
        return false;
    }

    public abstract void deleteVsnapshot(List<BackupFolderTO> var1);

    public abstract void createVsnapshot(List<BackupFolderTO> var1);

    public abstract boolean runScripts(String var1, boolean var2);

    public abstract void startBackupPolicyRefresh();

    public abstract void updateSystrayToolTipNotification();
}

