/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.backup;

import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.dao.BackUpImageDAOImpl;
import com.parablu.epa.common.dao.BackupActivityHistoryDAOImpl;
import com.parablu.epa.common.dao.BackupCrawlDAOImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.dao.BackupStatisticsDAOImpl;
import com.parablu.epa.common.service.backup.FilesBeSkippedAsPerPolicy;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.constant.CrawlLifecycle;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.BackupElement;
import com.parablu.epa.core.element.BackupFilesStatElement;
import com.parablu.epa.core.element.BackupListResponseElement;
import com.parablu.epa.core.element.BackupStatElement;
import com.parablu.epa.core.element.BackupStatElementList;
import com.parablu.epa.core.element.BackupValidationElement;
import com.parablu.epa.core.element.FileElement;
import com.parablu.epa.core.element.FileListElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.exception.DatabaseException;
import com.parablu.epa.core.exception.EndpointGeneralException;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.helper.enumeration.BackupFoldersToBeSkipped;
import com.parablu.epa.core.service.sync.BaseJob;
import com.parablu.epa.core.service.transformer.CreateXmlObject;
import com.parablu.epa.core.service.transformer.Xmlparser;
import com.parablu.epa.core.to.BackUpCrawlFileTO;
import com.parablu.epa.core.to.BackUpStatFileTO;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.core.to.BackupOrRestoreStatusTo;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.DedupTO;
import com.parablu.epa.core.to.GzipTO;
import com.parablu.epa.helper.exceptions.BaseException;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BackUpJob
extends BaseJob {
    private Logger logger = LoggerFactory.getLogger(BackUpJob.class);
    private BackUpFolderDAOImpl backUpFolderDAOImpl = null;
    private BackUpImageDAOImpl backUpImageDAOImpl = null;
    private BackupAdapter backupAdapter = null;
    boolean isFirstTimeCrawl = true;
    protected String currentIP = null;
    boolean manual = false;
    protected Integer currentPort = null;
    Set<File> crawledFileList = new HashSet<File>();
    private final int crawlFileLimit = this.getCrawlLimit();
    private static final int CRAWL_LIMIT_FOR_DB_INSERT = 5000;
    private int noOfDBWritesForCrawlFileLimit = 0;
    Set<DedupTO> dedupToSet = new HashSet<DedupTO>();
    BackupCrawlDAOImpl backupCrawlDAOImpl = new BackupCrawlDAOImpl(SettingHelper.getBackUpCrawlDbUrl());
    BackupStatisticsDAOImpl backupStatisticsDAOImpl = new BackupStatisticsDAOImpl(SettingHelper.getBackUpDbUrl());

    public BackUpJob(boolean manualVal) {
        this.backUpFolderDAOImpl = new BackUpFolderDAOImpl(SettingHelper.getBackUpDbUrl());
        this.backUpImageDAOImpl = new BackUpImageDAOImpl(SettingHelper.getBackUpDbUrl());
        this.backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        this.manual = manualVal;
    }

    public abstract void updateSystrayImageAccordingToStage(String var1);

    protected abstract void scanFileSystemByType(BackupFolderTO var1);

    public void run() {
        BackupActivityTO backupActivityTO = new BackupActivityTO();
        BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        try {
            if (NotificationHelper.backUpStarted) {
                this.logger.debug("Backup Started:" + NotificationHelper.backUpStarted);
                return;
            }
            NotificationHelper.backUpStarted = true;
            NotificationHelper.setTotalBackupCount(0);
            NotificationHelper.setNoOfFilesToBeBackedUp(0);
            List<BackupFolderTO> listOfFolder = this.backUpFolderDAOImpl.getAllFolderToBackUpFiles();
            HashSet<BackupTO> backUpSet = new HashSet<BackupTO>();
            HashSet<BackupTO> deletedSet = new HashSet<BackupTO>();
            this.createTablesIfNotExist();
            this.scanFileSystem(listOfFolder);
            this.checkIfPathExists(listOfFolder);
            int crawlFileCount = this.backupCrawlDAOImpl.getCountOfTable();
            this.logger.debug("Current count from crawl table is:" + crawlFileCount);
            List<BackUpCrawlFileTO> crawlFileTOs = this.backupCrawlDAOImpl.getCrawlBackUpFiles();
            this.getFilesFromCrawlTable(backUpSet, deletedSet, crawlFileTOs);
            if (backUpSet.isEmpty() && deletedSet.isEmpty()) {
                this.logger.debug("No files to be backed up");
                this.backupCrawlDAOImpl.clearTable(crawlFileTOs);
                NotificationHelper.backUpStarted = false;
                this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_IMAGE);
                return;
            }
            this.chunkBackupFilesAndCallForUpload(backUpSet, deletedSet);
            ArrayList<BackupTO> backUpList = new ArrayList<BackupTO>(backUpSet);
            int totalFilesExcludeFolder = 0;
            long totalSizeToBeUploaded = 0L;
            for (BackupTO backupTO : backUpList) {
                if (backupTO.isFolder()) continue;
                ++totalFilesExcludeFolder;
                totalSizeToBeUploaded += backupTO.getFileSize();
            }
            String totalSize = String.valueOf(totalFilesExcludeFolder);
            if (totalFilesExcludeFolder == 0) {
                this.logger.debug("Backup List is zero");
                this.backupCrawlDAOImpl.clearTable(crawlFileTOs);
                NotificationHelper.backUpStarted = false;
                this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_IMAGE);
                return;
            }
            NotificationHelper.setNoOfFilesToBeBackedUp(totalFilesExcludeFolder);
            NotificationHelper.setTotalSizeToBeUploaded(totalSizeToBeUploaded);
            String status = "STARTED";
            backupActivityTO.setBatchStatus(status);
            String batchId = this.backupBatchInitiated(status, "", 0, backupActivityTO.getFailCode(), 0L, "0/" + totalSize, crawlFileCount);
            if ("".equals(batchId) || "-1".equals(batchId)) {
                backupActivityTO.setBackupActivityStatus(CrawlLifecycle.ABORTED.toString());
                backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_NOINTERNET_ICON);
                NotificationHelper.setBackupStatus(0);
                NotificationHelper.backUpStarted = false;
                return;
            }
            backupActivityTO.setBatchId(batchId);
            this.validatePreviousBackupActivity(backupActivityHistoryDAOImpl);
            backupActivityTO.setBackupActivityStatus(CrawlLifecycle.INPROGRESS.toString());
            backupActivityTO.setBackupActivityTimeStamp(String.valueOf(System.currentTimeMillis()));
            backupActivityTO.setBackupActivityID(backupActivityHistoryDAOImpl.addEventToBackupActivityHistoryTable(backupActivityTO));
            backupActivityTO.setBackupUploadCount("0/" + totalSize);
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
            this.backupStatisticsDAOImpl.insertListOfFileNamesIntoTable(backUpList);
            this.startBackUpThread(backUpList, this.dedupToSet);
            this.backupCrawlDAOImpl.clearTable(crawlFileTOs);
            this.dedupToSet = null;
            this.logger.debug("Backup Finished. CrawlTable Deleted");
            for (BackupFolderTO backupFolderTO : listOfFolder) {
                backupFolderTO.setLastSyncTime(System.currentTimeMillis());
            }
            this.backUpFolderDAOImpl.updateAll(listOfFolder);
            SettingHelper.setLastSuccessfulBackup(System.currentTimeMillis());
            if (String.valueOf(NotificationHelper.getTotalBackupCount()).equals(totalSize)) {
                backupActivityTO.setBackupActivityStatus(CrawlLifecycle.FINISHED.toString());
            } else {
                backupActivityTO.setBackupActivityStatus(CrawlLifecycle.STOPPED.toString());
            }
            backupActivityTO.setBackupUploadCount(NotificationHelper.getTotalBackupCount() + "/" + totalSize);
            backupActivityTO.setTotalUploadSize(NotificationHelper.getTotalUploadSize());
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
            int totalFilesUploaded = NotificationHelper.getTotalBackupCount();
            if (String.valueOf(totalFilesUploaded).equals(totalSize)) {
                status = "COMPLETED";
                backupActivityTO.setBatchStatus(status);
                backupActivityTO.setFailCode(0);
                long totalUploadSize = backupActivityTO.getTotalUploadSize();
                String uploadedList = backupActivityTO.getBackupUploadCount();
                int errorCode = backupActivityTO.getFailCode();
                batchId = this.backupBatchInitiated(status, batchId, NotificationHelper.getTotalBackupCount(), errorCode, totalUploadSize, uploadedList, crawlFileCount);
                if (!"-1".equals(batchId)) {
                    this.sendBackupStatisticsToServer(batchId);
                    backupActivityTO.setBatchId(batchId);
                    backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
                }
            } else {
                BackupActivityTO backupActivityTO1 = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
                if (backupActivityTO1.getFailCode() != 912 && backupActivityTO1.getFailCode() != 1992 && backupActivityTO1.getFailCode() != 1981) {
                    int response = this.backupAdapter.pingParacloud(this.currentIP);
                    if (response == 400) {
                        PolicyManagementServerHelper.updateFailCodeToActivityHistory(2304);
                        PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit("COMPLETED", true);
                    }
                } else if (backupActivityTO1.getFailCode() == 1992 || backupActivityTO1.getFailCode() == 1981) {
                    PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit("FAILED", true);
                }
            }
            NotificationHelper.backUpStarted = false;
            this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_IMAGE);
            return;
        }
        catch (BaseException baseException) {
            this.logger.error("baseException ", (Throwable)baseException);
            backupActivityTO.setBackupActivityStatus(CrawlLifecycle.ABORTED.toString());
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
            this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_NOINTERNET_ICON);
            NotificationHelper.setBackupStatus(0);
        }
        catch (RuntimeException e) {
            this.logger.trace("" + e);
            this.logger.error("Exception :", (Object)e.getMessage());
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Unkown Exception :", (Object)e.getMessage());
            backupActivityTO.setBackupActivityStatus(CrawlLifecycle.ABORTED.toString());
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
            this.updateSystrayImageAccordingToStage(SyncConstants.PARABLU_NOINTERNET_ICON);
            NotificationHelper.setBackupStatus(0);
        }
        this.jobSucceded = false;
        NotificationHelper.backUpStarted = false;
    }

    private void checkIfPathExists(List<BackupFolderTO> listOfFolder) {
        ArrayList<String> listOfNotExistingFolders = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (BackupFolderTO backupFolder : listOfFolder) {
            File file = new File(backupFolder.getFolderPath());
            if (file.exists()) continue;
            listOfNotExistingFolders.add(backupFolder.getFolderPath());
            buffer.append(backupFolder.getFolderPath());
            buffer.append("\n");
        }
        if (!listOfNotExistingFolders.isEmpty()) {
            String toolTipMessage = "Following folder or drive does not exist";
            String toolTipmessage1 = buffer.toString();
            this.updateSystrayToolTipNotification(toolTipMessage, toolTipmessage1);
        }
    }

    private void validatePreviousBackupActivity(BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl) {
        BackupActivityTO backupActivityTO = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
        if (backupActivityTO != null && "STARTED".equals(backupActivityTO.getBatchStatus())) {
            backupActivityTO.setBatchStatus("FAILED");
            String batchId = backupActivityTO.getBatchId();
            int errorCode = backupActivityTO.getFailCode();
            this.logger.debug("the fail code is:" + errorCode);
            long totalUploadSize = backupActivityTO.getTotalUploadSize();
            String uploadedList = backupActivityTO.getBackupUploadCount();
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
            batchId = this.backupBatchInitiated(backupActivityTO.getBatchStatus(), batchId, 0, errorCode, totalUploadSize, uploadedList, 0);
            if (batchId != null && batchId != "-1") {
                this.sendBackupStatisticsToServer(batchId);
            }
        }
        if (backupActivityTO != null && backupActivityTO.getBackupActivityStatus().equals(CrawlLifecycle.INPROGRESS.toString())) {
            backupActivityTO.setBackupActivityStatus(CrawlLifecycle.ABORTED.toString());
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
        }
    }

    public abstract void startBackUpThread(List<BackupTO> var1, Set<DedupTO> var2) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException;

    public abstract void pauseBackup(boolean var1);

    private void chunkBackupFilesAndCallForUpload(Set<BackupTO> backUpList, Set<BackupTO> deletedSet) throws CrawlAdapterException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        HashSet<BackupTO> chunkBackupFilesTOSet = new HashSet<BackupTO>();
        HashSet<BackupTO> chunkDeletedFilesTOSet = new HashSet<BackupTO>();
        ArrayList<BackupTO> removeList = new ArrayList<BackupTO>();
        Iterator<BackupTO> iterator = backUpList.iterator();
        while (iterator.hasNext()) {
            chunkBackupFilesTOSet.add(iterator.next());
            if (chunkBackupFilesTOSet.size() != this.crawlFileLimit) continue;
            this.createAndSendRequestAndUpdatedatabase(chunkBackupFilesTOSet, new HashSet<BackupTO>(), removeList);
            chunkBackupFilesTOSet.clear();
        }
        iterator = deletedSet.iterator();
        while (iterator.hasNext()) {
            chunkDeletedFilesTOSet.add(iterator.next());
            if (chunkBackupFilesTOSet.size() != this.crawlFileLimit) continue;
            this.createAndSendRequestAndUpdatedatabase(new HashSet<BackupTO>(), chunkDeletedFilesTOSet, removeList);
            chunkDeletedFilesTOSet.clear();
        }
        this.createAndSendRequestAndUpdatedatabase(chunkBackupFilesTOSet, chunkDeletedFilesTOSet, removeList);
        chunkBackupFilesTOSet.clear();
        this.logger.debug("Final remove list size:" + removeList.size() + "Backuplist size before:" + backUpList.size());
        backUpList.removeAll(removeList);
    }

    private void createAndSendRequestAndUpdatedatabase(Set<BackupTO> backUpList, Set<BackupTO> deletedSet, List<BackupTO> removeList) throws CrawlAdapterException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        byte[] bs = this.createWebRequest(backUpList, deletedSet);
        if (bs == null) {
            throw new BaseException("gzip byte array is null,serialization failed");
        }
        List<BackupTO> filesNotToUpload = this.sendWebRequest(bs);
        removeList.addAll(filesNotToUpload);
        if (!filesNotToUpload.isEmpty() && !this.backUpImageDAOImpl.insertListIntoTable(filesNotToUpload)) {
            throw new DatabaseException("insert list into table failed");
        }
        if (!deletedSet.isEmpty() && !this.backUpImageDAOImpl.removeListFromTable(new ArrayList<BackupTO>(deletedSet))) {
            throw new DatabaseException("remove list from table failed");
        }
    }

    private byte[] createWebRequest(Set<BackupTO> backUpList, Set<BackupTO> deletedSet) {
        ArrayList<FileElement> newBackupFileElements = new ArrayList<FileElement>();
        ArrayList<FileElement> deletedBackupFileElements = new ArrayList<FileElement>();
        this.convertBackupTOListToBackupElementList(backUpList, newBackupFileElements);
        this.convertBackupTOListToBackupElementList(deletedSet, deletedBackupFileElements);
        FileListElement newBackupFileListElement = new FileListElement();
        FileListElement deletedBackupFileListElement = new FileListElement();
        newBackupFileListElement.setFileElementList(newBackupFileElements);
        deletedBackupFileListElement.setFileElementList(deletedBackupFileElements);
        BackupValidationElement backupValidationElement = new BackupValidationElement();
        backupValidationElement.setFilesToAddList(newBackupFileListElement);
        backupValidationElement.setFilesToDeleteList(deletedBackupFileListElement);
        byte[] bs = CreateXmlObject.createGzipByteArrayForValidateBackUpRequest((BackupValidationElement)backupValidationElement);
        return bs;
    }

    private List<BackupTO> sendWebRequest(byte[] bs) throws CrawlAdapterException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        GzipTO gzipResponse;
        this.currentIP = SettingHelper.getCurrentCloudIpAddress();
        if (SettingHelper.getCurrentHttpsPort() != null) {
            this.currentPort = Integer.valueOf(SettingHelper.getCurrentHttpsPort());
        }
        if ((gzipResponse = this.backupAdapter.validateDeltaForBackUp(bs, this.currentIP, null, this.isFirstTimeCrawl, SettingHelper.readTokenFromFile())) == null || gzipResponse.getResponseCode() == 404 || gzipResponse.getResponseCode() == 400 || gzipResponse.getResponseCode() == 503) {
            gzipResponse = this.retryUsingUpdatedIp(bs, gzipResponse);
        }
        if (gzipResponse == null) {
            throw new CrawlAdapterException(" null gzipResponse (connection error)");
        }
        int responseCode = gzipResponse.getResponseCode();
        if (responseCode == 400 || responseCode == 404) {
            throw new CrawlAdapterException(" HTTP_DEVICE_SESSION_EXPIRED or HTTP_BAD_REQUEST or HTTP_NOT_FOUND:" + responseCode);
        }
        if (responseCode == 416) {
            this.licenseExpired = true;
            SettingHelper.setLicenseActive(false);
            throw new CrawlAdapterException(" License Expired");
        }
        if (responseCode == 420) {
            this.deviceBlocked = true;
            SettingHelper.setDeviceBlocked(true);
            throw new CrawlAdapterException(" User Device Blocked");
        }
        if (responseCode == 417) {
            throw new CrawlAdapterException("User Limit Reached");
        }
        if (responseCode == 421) {
            this.sessionExpired = true;
            throw new CrawlAdapterException("Session Expired");
        }
        if (responseCode == 401) {
            throw new CrawlAdapterException("Unauthorized");
        }
        if (responseCode != 200) {
            throw new CrawlAdapterException(" Server Error: " + responseCode);
        }
        byte[] responseByte = gzipResponse.getResponse();
        BackupListResponseElement backupListResponseElement = Xmlparser.parseBackupListResponse((byte[])responseByte);
        if (backupListResponseElement == null) {
            throw new CrawlAdapterException(" backupListResponseElement; parsed response null");
        }
        List<DedupTO> dedupTOs = this.getDedupListFromResponse(backupListResponseElement);
        this.dedupToSet.addAll(dedupTOs);
        return ObjectUtils.convertFileElementToBackupTO((List)backupListResponseElement.getFilesNotToAddList().getFileElementList(), (String)"0");
    }

    private List<DedupTO> getDedupListFromResponse(BackupListResponseElement backupListResponseElement) {
        List dedupTOs = ObjectUtils.convertKeyValueElementToDedupTO((List)backupListResponseElement.getFilesNotToAddList().getMd5AndDedupedIdList());
        return dedupTOs;
    }

    private GzipTO retryUsingUpdatedIp(byte[] bs, GzipTO gzipResponse) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        SettingHelper.checkAndUpdateIpAddress();
        GzipTO gzipRes = null;
        if (gzipResponse == null || gzipResponse.getResponseCode() == 404 || gzipResponse.getResponseCode() == 400) {
            this.currentIP = SettingHelper.getGaeLocalIpAddress();
            this.currentPort = null;
            gzipRes = this.backupAdapter.validateDeltaForBackUp(bs, this.currentIP, this.currentPort, this.isFirstTimeCrawl, SettingHelper.readTokenFromFile());
        }
        if (gzipRes == null || gzipRes.getResponseCode() == 404 || gzipRes.getResponseCode() == 400) {
            this.currentIP = SettingHelper.getPublicIpAddress();
            this.currentPort = null;
            gzipRes = this.backupAdapter.validateDeltaForBackUp(bs, this.currentIP, this.currentPort, this.isFirstTimeCrawl, SettingHelper.readTokenFromFile());
        }
        if ((gzipRes == null || gzipRes.getResponseCode() == 404 || gzipRes.getResponseCode() == 400) && SettingHelper.getHttpsPort() != null) {
            this.currentIP = SettingHelper.getPublicIpAddress();
            this.currentPort = Integer.valueOf(SettingHelper.getHttpsPort());
            gzipRes = this.backupAdapter.validateDeltaForBackUp(bs, this.currentIP, this.currentPort, this.isFirstTimeCrawl, SettingHelper.readTokenFromFile());
        }
        if (gzipRes != null && gzipRes.getResponseCode() != 404 && gzipRes.getResponseCode() != 400) {
            SettingHelper.setCurrentHttpsPort(this.currentPort == null ? null : String.valueOf(this.currentPort));
            SettingHelper.setCurrentCloudIpAddress(this.currentIP);
            SettingHelper.applyChangesToSharedPreferences(false);
        }
        return gzipRes;
    }

    private void convertBackupTOListToBackupElementList(Set<BackupTO> fileTOList, List<FileElement> fileElementList) {
        for (BackupTO fileTO : fileTOList) {
            BackupElement fileElement = new BackupElement();
            ObjectUtils.copyBackupTOtoFileElement((BackupTO)fileTO, (FileElement)fileElement);
            fileElementList.add((FileElement)fileElement);
        }
    }

    private void createTablesIfNotExist() {
        this.backUpFolderDAOImpl.createBackUpTable();
        this.backUpImageDAOImpl.createTable();
    }

    private void scanFileSystem(List<BackupFolderTO> files) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        this.backupCrawlDAOImpl.clearEntireTable();
        if (!files.isEmpty()) {
            List<String> excludedFoldersFromPolicy = null;
            this.logger.debug("START CRAWL " + System.currentTimeMillis());
            if (SettingHelper.getBackupLicenced().contentEquals("true")) {
                this.backUpFolderDAOImpl = new BackUpFolderDAOImpl(SettingHelper.getBackUpDbUrl());
                BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
                FilesBeSkippedAsPerPolicy.allowedSize = FilesBeSkippedAsPerPolicy.getCurrentPolicyMaxSize();
                this.setFilterDetails();
                excludedFoldersFromPolicy = backupPolicyDAOImpl.getExcludedFoldersList();
            }
            for (BackupFolderTO file : files) {
                try {
                    if (excludedFoldersFromPolicy != null && !excludedFoldersFromPolicy.isEmpty() && FilesBeSkippedAsPerPolicy.skipExcludedFolders(excludedFoldersFromPolicy, file.getFolderPath())) continue;
                    this.scanFileSystemByTypeAndStartUpload(file.getFolderPath(), null);
                    if (this.crawledFileList.isEmpty()) continue;
                    ++this.noOfDBWritesForCrawlFileLimit;
                    this.logger.debug("Files to be inserted " + this.crawledFileList.size());
                    ArrayList<File> fileList = new ArrayList<File>();
                    fileList.addAll(this.crawledFileList);
                    this.backupCrawlDAOImpl.insertListOfFileNamesIntoTable(fileList);
                    this.crawledFileList.clear();
                    fileList.clear();
                }
                catch (RuntimeException e) {
                    this.logger.trace("" + e);
                    this.logger.error("exception while crawl in runtime exception" + e.getMessage());
                }
                catch (Exception e) {
                    this.logger.trace("" + e);
                    this.logger.error("exception while crawl" + e.getMessage());
                }
            }
            this.logger.debug("END CRAWL :" + System.currentTimeMillis());
        }
    }

    private void getFilesFromCrawlTable(Set<BackupTO> backupSet, Set<BackupTO> deletedSet, List<BackUpCrawlFileTO> crawlFileTOs) {
        List list;
        List<BackupTO> backUpFileTOs = this.backUpImageDAOImpl.readAllEntriesFromBackupImageTable();
        if (backUpFileTOs == null) {
            throw new DatabaseException("Sql Exception occurred while readAllEntriesFromTable");
        }
        deletedSet.addAll(backUpFileTOs);
        if (!backUpFileTOs.isEmpty()) {
            this.isFirstTimeCrawl = false;
        }
        if ((list = ObjectUtils.createBackupElementForFileNames(crawlFileTOs)) != null) {
            backupSet.addAll(list);
        }
        ArrayList<BackupTO> removeList = new ArrayList<BackupTO>();
        for (BackupTO backTo : backupSet) {
            for (BackupTO backupTO : deletedSet) {
                if (!backTo.getFileName().equals(backupTO.getFileName())) continue;
                removeList.add(backupTO);
            }
        }
        deletedSet.removeAll(removeList);
        backupSet.removeAll(backUpFileTOs);
    }

    public String backupBatchInitiated(String batchStatus, String batchId, int totalCount, int errorCode, long totalUploadSize, String totalUploadedCount, int crawlCount) {
        String batchIdentity;
        String jobType = "BACKUP";
        try {
            this.logger.debug("the STATUS:" + batchStatus);
            BackupOrRestoreStatusTo backupOrRestoreStatusTo = new BackupOrRestoreStatusTo();
            backupOrRestoreStatusTo.setStatus(batchStatus);
            backupOrRestoreStatusTo.setIp(SettingHelper.getCurrentCloudIpAddress());
            backupOrRestoreStatusTo.setToken(SettingHelper.readTokenFromFile());
            backupOrRestoreStatusTo.setBatchId(batchId);
            backupOrRestoreStatusTo.setJobType(jobType);
            backupOrRestoreStatusTo.setDeviceName(SettingHelper.getDeviceName());
            backupOrRestoreStatusTo.setTotalCount(totalCount);
            backupOrRestoreStatusTo.setErrorCode(errorCode);
            backupOrRestoreStatusTo.setDeviceUUID(SettingHelper.getDeviceUUId());
            backupOrRestoreStatusTo.setTotalUploadSize(totalUploadSize);
            backupOrRestoreStatusTo.setTotalUploadedCount(totalUploadedCount);
            backupOrRestoreStatusTo.setCrawlCount(crawlCount);
            backupOrRestoreStatusTo.setCrawlTimeStamp("0");
            backupOrRestoreStatusTo.setFullBackup(false);
            backupOrRestoreStatusTo.setDiskSpaceDetails(new ParabluFileSystemUtils().getSystemSpace());
            backupOrRestoreStatusTo.setPolicyConfiguredFolders(this.getConfiguredBackupFolders());
            batchIdentity = this.backupAdapter.sendEmailNotification(backupOrRestoreStatusTo);
        }
        catch (Exception e) {
            batchIdentity = "-1";
            this.logger.trace("" + e);
            this.logger.error(" Exception inside  put batch " + e.getMessage());
        }
        return batchIdentity;
    }

    private List<File> scanFileSystemByTypeAndStartUpload(String completeParentPath, Map<String, Long> fileHashMap) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        List<File> file = null;
        if (this.crawledFileList.size() > 5000) {
            this.logger.debug("Files to be inserted " + this.crawledFileList.size());
            ++this.noOfDBWritesForCrawlFileLimit;
            ArrayList<File> fileList = new ArrayList<File>();
            fileList.addAll(this.crawledFileList);
            this.backupCrawlDAOImpl.insertListOfFileNamesIntoTable(fileList);
            this.crawledFileList.clear();
            fileList.clear();
        }
        Boolean checkList = true;
        String fullParentPath = this.checkForMacBasePath(completeParentPath);
        File currentFolder = new File(fullParentPath);
        File[] childFileAndFolderNames = currentFolder.listFiles();
        if (childFileAndFolderNames == null) {
            return file;
        }
        int noOfChildFilesAndFolders = childFileAndFolderNames.length;
        if (fileHashMap == null || fileHashMap.isEmpty()) {
            checkList = false;
        }
        for (int i = 0; i < noOfChildFilesAndFolders; ++i) {
            List<File> currentFolderCrawlFileTOList;
            Long prevModifiedValue;
            File currentProcessingFile = childFileAndFolderNames[i];
            if (currentProcessingFile.getName().startsWith(".pbsdn")) {
                currentProcessingFile.delete();
                continue;
            }
            boolean isfileHidden = currentProcessingFile.getName().equals("CHUNK") || currentProcessingFile.isHidden();
            boolean fileToBeSkipped = this.isFileToBeSkipped(currentProcessingFile.getName());
            boolean isFileToBeSkippedAsperPolicy = false;
            if (!currentProcessingFile.isDirectory() && SettingHelper.getBackupLicenced().contentEquals("true")) {
                isFileToBeSkippedAsperPolicy = FilesBeSkippedAsPerPolicy.checkVariousPolicies(currentProcessingFile);
            }
            if (isfileHidden || fileToBeSkipped || isFileToBeSkippedAsperPolicy) continue;
            boolean isFileADirectory = currentProcessingFile.isDirectory();
            String absPath = currentProcessingFile.getAbsolutePath();
            if (checkList.booleanValue() && !isFileADirectory && (prevModifiedValue = fileHashMap.get(absPath)) != null && prevModifiedValue.equals(currentProcessingFile.lastModified())) continue;
            this.crawledFileList.add(currentProcessingFile);
            if (!isFileADirectory || (currentFolderCrawlFileTOList = this.scanFileSystemByTypeAndStartUpload(currentProcessingFile.getAbsolutePath(), fileHashMap)) == null) continue;
            this.crawledFileList.addAll(currentFolderCrawlFileTOList);
        }
        if (this.crawledFileList.size() > 5000) {
            ++this.noOfDBWritesForCrawlFileLimit;
            ArrayList<File> fileList = new ArrayList<File>();
            fileList.addAll(this.crawledFileList);
            this.logger.debug(" Files to be inserted " + this.crawledFileList.size());
            this.backupCrawlDAOImpl.insertListOfFileNamesIntoTable(fileList);
            this.crawledFileList.clear();
        }
        ArrayList<File> fileList = new ArrayList<File>();
        fileList.addAll(this.crawledFileList);
        return fileList;
    }

    private void sendBackupStatisticsToServer(String batchId) {
        try {
            List<BackUpStatFileTO> backUpStatFileTOs = this.backupStatisticsDAOImpl.getBackUpFiles();
            ArrayList<BackupFilesStatElement> backupFilesStatElements = new ArrayList<BackupFilesStatElement>();
            if (backUpStatFileTOs != null && !backUpStatFileTOs.isEmpty()) {
                this.convertBackUpStatFileToBackupFilesStatElementList(backUpStatFileTOs, backupFilesStatElements);
            }
            BackupStatElementList backupStatElementList = new BackupStatElementList();
            backupStatElementList.setFileElementList(backupFilesStatElements);
            BackupStatElement backupStatElement = new BackupStatElement();
            backupStatElement.setBatchId(batchId);
            backupStatElement.setFileElementList(backupStatElementList);
            this.createXmlAndSendBackuStatistics(backupStatElement);
            this.backupStatisticsDAOImpl.clearEntireTable();
        }
        catch (EndpointGeneralException e) {
            this.logger.error("Error in get backup file statistics from db for send backup file statistics", (Throwable)e);
        }
    }

    private void convertBackUpStatFileToBackupFilesStatElementList(List<BackUpStatFileTO> backUpStatFileTOs, List<BackupFilesStatElement> backupFilesStatElements) {
        for (BackUpStatFileTO fileTO : backUpStatFileTOs) {
            BackupFilesStatElement fileElement = new BackupFilesStatElement();
            ObjectUtils.copyBackupStatTOtoBackupStatElement((BackUpStatFileTO)fileTO, (BackupFilesStatElement)fileElement);
            backupFilesStatElements.add(fileElement);
        }
    }

    private boolean isFileToBeSkipped(String fileName) {
        for (BackupFoldersToBeSkipped.WindowsBackupFoldersToBeSkipped beSkipped : BackupFoldersToBeSkipped.WindowsBackupFoldersToBeSkipped.values()) {
            if (!beSkipped.name().equalsIgnoreCase(fileName) && !fileName.toLowerCase().startsWith("program files")) continue;
            return true;
        }
        return false;
    }

    private String checkForMacBasePath(String completeParentPath) {
        String mac = "Macintosh";
        if (completeParentPath.startsWith("Macintosh" + StringLiterals.FILE_SEPARATOR)) {
            return completeParentPath.substring(9);
        }
        return completeParentPath;
    }

    private int getCrawlLimit() {
        if (!StringUtils.isEmpty((String)SettingHelper.getBackupCrawlLimit())) {
            this.logger.debug("returning crawl limit" + SettingHelper.getBackupCrawlLimit());
            return Integer.valueOf(SettingHelper.getBackupCrawlLimit());
        }
        return 500;
    }

    private void createXmlAndSendBackuStatistics(BackupStatElement backupStatElement) {
        try {
            String xmlRequest = CreateXmlObject.createXmlForBackupStatElement((BackupStatElement)backupStatElement);
            if (xmlRequest != null) {
                this.backupAdapter.sendBackupFileStatistics(xmlRequest, SettingHelper.getCurrentCloudIpAddress(), null, SettingHelper.getUserName(), SettingHelper.readTokenFromFile());
            }
        }
        catch (CrawlAdapterException | IOException | GeneralSecurityException e) {
            this.logger.error("Error in create xml Element for send backup file statistics", e);
        }
    }

    private void setFilterDetails() {
        Map<String, String> exclusionMap = this.backUpFolderDAOImpl.getInclusionExtensions();
        if (exclusionMap != null && !exclusionMap.isEmpty()) {
            FilesBeSkippedAsPerPolicy.extensions = exclusionMap.get("extensionName");
            FilesBeSkippedAsPerPolicy.filterType = exclusionMap.get("filterType");
        }
    }

    private String getConfiguredBackupFolders() {
        List<BackupFolderTO> listOfFolder = this.backUpFolderDAOImpl.getAllFolderToBackUpFiles();
        StringBuilder backupFolders = new StringBuilder("");
        if (!listOfFolder.isEmpty()) {
            for (BackupFolderTO backupFolderTO : listOfFolder) {
                backupFolders.append(backupFolderTO.getFolderPath()).append("; ");
            }
        }
        return backupFolders.toString();
    }
}

