/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.dao.NewBackupImageDAO;
import com.parablu.epa.core.to.BackUpCrawlFileTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.DedupTO;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewBackupImageDAOImpl
extends BaseDAO
implements NewBackupImageDAO {
    private Logger logger = LoggerFactory.getLogger(NewBackupImageDAOImpl.class);
    private static final String DELETEFROM = "delete from ";
    private static final String SQLEXCEPTION_CREATING_BACKUPCRAWL_TABLE = "SQLException while creating backupCrawl table";
    private static final String SQLEXCEPTION_WHILE_SELECTING_FROM_BACKUP = "SQLException while selcting from backup";
    private static final String SQLEXCEPTION_INSERTING_LISTOF_PARENTFOLDERS = "SQLException while inserting list of parent folders";
    private static final String SQLEXCEPTION_WHILE_DELETING = "SQLException while deleting";
    private static final String ALTER_TABLE = "ALTER TABLE ";
    private static final String RENAME_TO = " RENAME TO ";
    private static final String DROP_TABLE = "DROP TABLE IF EXISTS ";

    public NewBackupImageDAOImpl(String uRL) {
        super(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createNewBackUpImageTable() {
        String query = BluSyncSQLConstants.CREATE_NEW_BKP_IMAGE_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_CREATING_BACKUPCRAWL_TABLE, (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createNewBackUpImageTempTable() {
        String query = BluSyncSQLConstants.CREATE_NEW_BKP_IMAGE_TABLE_TEMP_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_CREATING_BACKUPCRAWL_TABLE, (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertFileNameIntoTable(File file) {
        String query = "insert into NEWBKITABLE(FileName,filepath) values(?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into NEWBKITABLE(FileName,filepath) values(?,?);");
                this.statement.setString(1, file.getName());
                this.statement.setString(2, file.getAbsolutePath());
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while inserting parent folder", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackUpCrawlFileTO> getCrawlBackUpFiles() {
        String query = " select * from NEWBKITABLE";
        ArrayList<BackUpCrawlFileTO> files = null;
        this.statement = null;
        ResultSet resultSet = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(" select * from NEWBKITABLE");
                resultSet = this.statement.executeQuery();
                files = new ArrayList<BackUpCrawlFileTO>();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        BackUpCrawlFileTO backUpCrawlFileTO = new BackUpCrawlFileTO();
                        backUpCrawlFileTO.setCompletePath(resultSet.getString("filepath"));
                        backUpCrawlFileTO.setId(resultSet.getInt("Id"));
                        files.add(backUpCrawlFileTO);
                    }
                }
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_SELECTING_FROM_BACKUP, (Throwable)exception);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set while selecting from backup" + e);
                    }
                }
                this.closeConnection();
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountOfTable() {
        String query = "SELECT COUNT(*) FROM NEWPREV_BKITABLE where IsFolder = 'false';";
        this.statement = null;
        ResultSet resultSet = null;
        int count = 0;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("SELECT COUNT(*) FROM NEWPREV_BKITABLE where IsFolder = 'false';");
                resultSet = this.statement.executeQuery();
                while (resultSet.next()) {
                    count = resultSet.getInt(1);
                }
                resultSet.close();
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_SELECTING_FROM_BACKUP, (Throwable)exception);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing resultset for selcting from backup", (Throwable)e);
                    }
                }
                this.closeConnection();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearEntireTable() {
        String query = "delete from NEWBKITABLE";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("delete from NEWBKITABLE");
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while deleting from new backup image table:", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertListOfFileNamesIntoTable(List<File> files) {
        String query = "insert into NEWBKITABLE_TEMP(FileName,filepath,IsFolder,size) values(?,?,?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into NEWBKITABLE_TEMP(FileName,filepath,IsFolder,size) values(?,?,?,?);");
                int listsize = files.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    this.statement.setString(1, files.get(recordCount).getName());
                    this.statement.setString(2, files.get(recordCount).getAbsolutePath());
                    this.statement.setString(3, String.valueOf(files.get(recordCount).isDirectory()));
                    this.statement.setString(4, String.valueOf(files.get(recordCount).length()));
                    this.statement.addBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_INSERTING_LISTOF_PARENTFOLDERS, (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean alterTable() {
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnectionForCreatingDatabase();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement("ALTER table NEWBKITABLE ADD COLUMN IsFolder TEXT;");
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.info("sqlExeception in creating activity delay" + e);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createNewPrevBackUpImageTable() {
        String query = BluSyncSQLConstants.CREATE_NEW_PREV_BKP_IMAGE_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_CREATING_BACKUPCRAWL_TABLE, (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyNewToPrevOrPrevToNewBackUpImageTable(String constraint) {
        String query = null;
        if (constraint.contentEquals("NewBackupToNewPrevBackupImageTable")) {
            query = "insert into NEWPREV_BKITABLE select * from NEWBKITABLE";
        } else if (constraint.contentEquals("NewPrevBackupToNewBackupImageTable")) {
            query = "insert into NEWBKITABLE select * from NEWPREV_BKITABLE";
        }
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while copying backupCrawl table", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearEntirePrevBackupImageTable() {
        String query = "delete from NEWPREV_BKITABLE";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("delete from NEWPREV_BKITABLE");
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_DELETING, (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackUpCrawlFileTO> getAddedORDeletedFilesByComparing(String constraint) {
        String query = null;
        if (constraint.contentEquals("DELETED")) {
            this.logger.debug("Before getting the deleted files");
            query = "select FileName , FilePath , isFolder from NEWPREV_BKITABLE EXCEPT select FileName , FilePath , isFolder from NEWBKITABLE";
        } else if (constraint.contentEquals("ADDED")) {
            this.logger.debug("Before getting the added files");
            query = "select FileName , FilePath ,isFolder from NEWBKITABLE EXCEPT select FileName , FilePath , isFolder from NEWPREV_BKITABLE";
        }
        ArrayList<BackUpCrawlFileTO> files = null;
        this.statement = null;
        ResultSet resultSet = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                resultSet = this.statement.executeQuery();
                files = new ArrayList<BackUpCrawlFileTO>();
                this.logger.debug("Before getting the " + constraint + " files..");
                if (resultSet != null) {
                    while (resultSet.next()) {
                        BackUpCrawlFileTO backUpCrawlFileTO = new BackUpCrawlFileTO();
                        backUpCrawlFileTO.setCompletePath(resultSet.getString("filepath"));
                        backUpCrawlFileTO.setFileName(resultSet.getString("FileName"));
                        backUpCrawlFileTO.setFolder(Boolean.parseBoolean(resultSet.getString("IsFolder")));
                        files.add(backUpCrawlFileTO);
                    }
                }
                this.logger.debug("After getting the " + constraint + " files..");
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_SELECTING_FROM_BACKUP, (Throwable)exception);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set while selecting from backup" + e);
                    }
                }
                this.closeConnection();
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertListOfBackupTOsIntoTable(List<BackupTO> files) {
        String query = "insert into NEWBKITABLE(FileName,filepath,IsFolder) values(?,?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into NEWBKITABLE(FileName,filepath,IsFolder) values(?,?,?);");
                int listsize = files.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    this.statement.setString(1, files.get(recordCount).getFileName());
                    this.statement.setString(2, files.get(recordCount).getAbstractFilePath() + File.separator + files.get(recordCount).getFileName());
                    this.statement.setString(3, String.valueOf(files.get(recordCount).isFolder()));
                    this.statement.addBatch();
                    if (recordCount % 1000 != 0) continue;
                    this.statement.executeBatch();
                    this.statement.clearBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_INSERTING_LISTOF_PARENTFOLDERS, (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFailedFilesFromBackupImageTable(List<BackupTO> files) {
        String query = "delete from NEWBKITABLE where FileName=? AND filepath =? ;";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("delete from NEWBKITABLE where FileName=? AND filepath =? ;");
                int listsize = files.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    this.statement.setString(1, files.get(recordCount).getFileName());
                    this.statement.setString(2, files.get(recordCount).getAbstractFilePath() + File.separator + files.get(recordCount).getFileName());
                    this.statement.addBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_INSERTING_LISTOF_PARENTFOLDERS, (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createDedupTable() {
        String query = BluSyncSQLConstants.CREATE_DEDUP_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_CREATING_BACKUPCRAWL_TABLE, (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertListOfDedupsIntoTable(List<DedupTO> files) {
        String query = "insert into Dedup_Table(checksum,backupId) values(?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into Dedup_Table(checksum,backupId) values(?,?);");
                int listsize = files.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    this.statement.setString(1, files.get(recordCount).getMd5Value());
                    this.statement.setString(2, files.get(recordCount).getBackupId());
                    this.statement.addBatch();
                    if (recordCount % 1000 != 0) continue;
                    this.statement.executeBatch();
                    this.statement.clearBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_INSERTING_LISTOF_PARENTFOLDERS, (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DedupTO> getListOfDedupsFromTable() {
        String query = " select * from Dedup_Table";
        ArrayList<DedupTO> dedupTOs = null;
        this.statement = null;
        ResultSet resultSet = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(" select * from Dedup_Table");
                resultSet = this.statement.executeQuery();
                dedupTOs = new ArrayList<DedupTO>();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        DedupTO dedupTO = new DedupTO();
                        dedupTO.setMd5Value(resultSet.getString("checksum"));
                        dedupTO.setBackupId(resultSet.getString("backupId"));
                        dedupTOs.add(dedupTO);
                    }
                }
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_SELECTING_FROM_BACKUP, (Throwable)exception);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set for geting Oldest Image Table Name" + e);
                    }
                }
                this.closeConnection();
            }
        }
        return dedupTOs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearDedupTable() {
        String query = "delete from Dedup_Table";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("delete from Dedup_Table");
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_DELETING, (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackUpCrawlFileTO> getDeletedList(List<BackUpCrawlFileTO> fileTOs) {
        this.logger.debug("INSIDE GET DELETED FILES " + fileTOs.size());
        ArrayList<BackUpCrawlFileTO> files = new ArrayList<BackUpCrawlFileTO>();
        for (int i = 0; i < fileTOs.size(); ++i) {
            String query = " select * from NEWPREV_BKITABLE where FileName=? And filepath=?;";
            this.statement = null;
            ResultSet resultSet = null;
            if (!this.getConnection()) continue;
            try {
                this.statement = this.conn.prepareStatement(" select * from NEWPREV_BKITABLE where FileName=? And filepath=?;");
                this.statement.setString(1, fileTOs.get(i).getFileName());
                this.statement.setString(2, fileTOs.get(i).getCompletePath());
                resultSet = this.statement.executeQuery();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        BackUpCrawlFileTO backUpCrawlFileTO = new BackUpCrawlFileTO();
                        backUpCrawlFileTO.setCompletePath(resultSet.getString("filepath"));
                        backUpCrawlFileTO.setId(resultSet.getInt("Id"));
                        backUpCrawlFileTO.setFileName(resultSet.getString("FileName"));
                        backUpCrawlFileTO.setFolder(Boolean.parseBoolean(resultSet.getString("IsFolder")));
                        String fileSize = resultSet.getString("size");
                        long size = 0L;
                        if (fileSize != null && fileSize != "") {
                            size = Long.valueOf(fileSize);
                        }
                        backUpCrawlFileTO.setFileSize(size);
                        files.add(backUpCrawlFileTO);
                    }
                    resultSet.close();
                    this.logger.debug("END OF GET DELETED FILES " + files.size());
                    continue;
                }
                this.logger.debug("Size of Result set is null for getting deleted file:");
                continue;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_SELECTING_FROM_BACKUP, (Throwable)exception);
                continue;
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing resultset for selcting from backup media table", (Throwable)e);
                    }
                }
                this.closeConnection();
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createOldPrevBackUpImageTable() {
        String query = BluSyncSQLConstants.CREATE_OLD_PREV_BKP_IMAGE_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while creaing backupCrawl table", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyOldToPrevOrPrevToOldBkUpImgTable(String constraint) {
        String query = null;
        if (constraint.contentEquals("OldPrevBKITtoNewPrevBKIT")) {
            query = "insert into NEWPREV_BKITABLE select * from OldPrevBKIT";
        } else if (constraint.contentEquals("NewPrevBKITtoOldPrevBKIT")) {
            query = "insert into OldPrevBKIT select * from NEWPREV_BKITABLE";
        }
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while copying backupCrawl table", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearEntireOldBackupImageTable() {
        String query = "delete from OldPrevBKIT";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("delete from OldPrevBKIT");
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_DELETING, (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameTable(String oldName, String newName) {
        String query = ALTER_TABLE + oldName + RENAME_TO + newName;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_DELETING, (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearEntireTempTable() {
        String query = "delete from NEWBKITABLE_TEMP";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("delete from NEWBKITABLE_TEMP");
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while deleting from new backup image table:", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropTable(String tableName) {
        String query = DROP_TABLE + tableName;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while renaming", (Throwable)exception);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }
}

