/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.dao.ImageTableDAO;
import com.parablu.epa.core.to.FileTO;
import com.parablu.epa.core.to.RenamedTO;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageTableImpl
extends BaseDAO
implements ImageTableDAO {
    private Logger logger = LoggerFactory.getLogger(ImageTableImpl.class);
    private final String baseFolderURL;
    private static final String AND_A = " and A.";
    private static final String WHERE = " where ";
    private static final String EQUAL_TO_B = " = B.";
    private static final String FROM = " from ";
    private static final String SELECT_A_ALL_FROM = "Select A.* from ";
    private static final String AS_A_INNER_JOIN = " as A inner join ";
    private static final String SELECT = "(select ";
    private static final String AS_B_ON_A = "as B on A.";
    private static final String AND_QUES = "=? and ";

    public ImageTableImpl(String dbURL, String folderURLOfDB) {
        super(dbURL);
        this.baseFolderURL = folderURLOfDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attachImageTableDataInCurrentTable(String currentImageTableName, String previousImageTableName) {
        boolean success = false;
        StringBuilder sb = new StringBuilder().append(this.baseFolderURL).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(previousImageTableName);
        StringBuilder sbURL = new StringBuilder().append(this.baseFolderURL).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(currentImageTableName);
        String sqlQuery = "attach database \"" + sb.toString() + "\" as " + previousImageTableName + ";";
        this.statement = null;
        boolean gotConnection = this.getConnection(sbURL.toString());
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.error("SQLException while attaching Image Table" + e);
            }
            finally {
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException e) {
                    this.closeConnection();
                    this.logger.error("SQLException while closing statement object during attaching Image Table operation" + e);
                }
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean detachImageTableDataInCurrentTable(String previousImageTableName) {
        boolean success = false;
        String sqlQuery = "DETACH DATABASE " + previousImageTableName + ";";
        this.statement = null;
        try {
            this.statement = this.conn.prepareStatement(sqlQuery);
            this.statement.execute();
            this.statement.close();
            success = true;
        }
        catch (SQLException e) {
            this.logger.error("SQLException while Detaching Image Table" + e);
        }
        finally {
            this.closeConnection();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeImageInformation(List<FileTO> fileTOList, String imageTableName) {
        String sqlQuery = "INSERT INTO " + imageTableName + " Values(?,?,?,?,?,?,?,?);";
        this.statement = null;
        StringBuilder sb = new StringBuilder().append(this.baseFolderURL).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(imageTableName);
        boolean isSuccessful = false;
        boolean gotConnection = this.getConnection(sb.toString());
        if (!gotConnection) {
            this.closeConnection();
            return isSuccessful;
        }
        try {
            this.statement = this.conn.prepareStatement(sqlQuery);
            int listsize = fileTOList.size();
            this.conn.setAutoCommit(false);
            for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                FileTO currentFileTO = fileTOList.get(recordCount);
                int tempValueFolder = currentFileTO.isFolder() ? 1 : 0;
                int tempValueExist = currentFileTO.isExists() ? 1 : 0;
                this.statement.setString(1, currentFileTO.getFileName());
                this.statement.setString(2, currentFileTO.getAbstractFilePath());
                this.statement.setString(3, currentFileTO.getMiniCloudId());
                this.statement.setString(4, currentFileTO.getMd5checksum());
                this.statement.setString(5, currentFileTO.getMetaData());
                this.statement.setString(6, String.valueOf(currentFileTO.getLastModifiedTimestamp()));
                this.statement.setInt(7, tempValueFolder);
                this.statement.setInt(8, tempValueExist);
                this.statement.addBatch();
                if (recordCount % 1000 != 0) continue;
                this.statement.executeBatch();
                this.statement.clearBatch();
            }
            this.statement.executeBatch();
            this.statement.close();
            this.conn.commit();
            isSuccessful = true;
        }
        catch (SQLException e) {
            this.logger.error("SQLException while storing Image Information" + e, (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return isSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeImageInformation(FileTO fileTO, String imageTableName) {
        String sqlQuery = "INSERT INTO " + imageTableName + " Values(?,?,?,?,?,?,?,?);";
        this.statement = null;
        StringBuilder sb = new StringBuilder().append(this.baseFolderURL).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(imageTableName);
        boolean isSuccessful = false;
        boolean gotConnection = this.getConnection(sb.toString());
        if (!gotConnection) {
            this.closeConnection();
            return isSuccessful;
        }
        try {
            this.statement = this.conn.prepareStatement(sqlQuery);
            int tempValueFolder = fileTO.isFolder() ? 1 : 0;
            int tempValueExist = fileTO.isExists() ? 1 : 0;
            this.statement.setString(1, fileTO.getFileName());
            this.statement.setString(2, fileTO.getAbstractFilePath());
            this.statement.setString(3, fileTO.getMiniCloudId());
            this.statement.setString(4, fileTO.getMd5checksum());
            this.statement.setString(5, fileTO.getMetaData());
            this.statement.setString(6, String.valueOf(fileTO.getLastModifiedTimestamp()));
            this.statement.setInt(7, tempValueFolder);
            this.statement.setInt(8, tempValueExist);
            this.statement.execute();
            this.statement.close();
            isSuccessful = true;
        }
        catch (SQLException e) {
            this.logger.error("SQLException while storing Image Information" + e);
        }
        finally {
            this.closeConnection();
        }
        return isSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileTO> getImageInformation(String imageTableName) {
        String sqlQuery = "select * from " + imageTableName;
        this.statement = null;
        ResultSet selectImageTableResult = null;
        ArrayList<FileTO> fileTOList = null;
        StringBuilder sb = new StringBuilder().append(this.baseFolderURL).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(imageTableName);
        boolean gotConnection = this.getConnection(sb.toString());
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                selectImageTableResult = this.statement.executeQuery();
                fileTOList = new ArrayList<FileTO>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    FileTO tempFile = new FileTO();
                    tempFile.setFileName(selectImageTableResult.getString("filename"));
                    tempFile.setAbstractFilePath(selectImageTableResult.getString("filepath"));
                    tempFile.setMiniCloudId(selectImageTableResult.getString("miniCloudId"));
                    tempFile.setMd5checksum(selectImageTableResult.getString("checksum"));
                    tempFile.setMetaData(selectImageTableResult.getString("metadata"));
                    String tempTimeStamp = selectImageTableResult.getString("modifiedtimestamp");
                    tempFile.setFolder(selectImageTableResult.getInt("folder") == 1);
                    tempFile.setExists(selectImageTableResult.getInt("exist") == 1);
                    long tempLongTimeStamp = Long.parseLong(tempTimeStamp);
                    tempFile.setLastModifiedTimestamp(tempLongTimeStamp);
                    fileTOList.add(tempFile);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while geting Image Information" + e);
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set for getImageInformation" + e);
                    }
                }
                this.closeConnection();
            }
        }
        return fileTOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileTO> getDeletedFilesBetweenImageTables(String currentImageTableName, String cloudId) {
        String sqlQuery = new StringBuffer().append("Select * from ").append(currentImageTableName).append(WHERE).append("exist").append(" = ? and ").append("miniCloudId").append(" =?").toString();
        this.statement = null;
        ResultSet selectImageTableResult = null;
        ArrayList<FileTO> fileTOList = null;
        StringBuilder sb = new StringBuilder().append(this.baseFolderURL).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(currentImageTableName);
        boolean gotConnection = this.getConnection(sb.toString());
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                this.statement.setInt(1, 0);
                this.statement.setString(2, cloudId);
                selectImageTableResult = this.statement.executeQuery();
                fileTOList = new ArrayList<FileTO>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    FileTO tempFile = new FileTO();
                    tempFile.setFileName(selectImageTableResult.getString("filename"));
                    tempFile.setAbstractFilePath(selectImageTableResult.getString("filepath"));
                    tempFile.setMiniCloudId(selectImageTableResult.getString("miniCloudId"));
                    tempFile.setMd5checksum(selectImageTableResult.getString("checksum"));
                    tempFile.setMetaData(selectImageTableResult.getString("metadata"));
                    String tempTimeStamp = selectImageTableResult.getString("modifiedtimestamp");
                    tempFile.setFolder(selectImageTableResult.getInt("folder") == 1);
                    tempFile.setExists(selectImageTableResult.getInt("exist") == 1);
                    tempFile.setLastModifiedTimestamp(Long.valueOf(tempTimeStamp).longValue());
                    fileTOList.add(tempFile);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while getting deleted records from Image Table" + e);
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set getDeletedFilesBetweenImageTables" + e);
                    }
                }
                this.closeConnection();
            }
        }
        return fileTOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileTO> getNewlyCreatedFilesBetweenImageTables(String previousImageTableName, String currentImageTableName, String cloudId) {
        String sqlQuery = new StringBuffer().append(SELECT_A_ALL_FROM).append(currentImageTableName).append(AS_A_INNER_JOIN).append(SELECT).append("filename").append(", ").append("filepath").append(FROM).append(currentImageTableName).append(" EXCEPT select ").append("filename").append(", ").append("filepath").append(FROM).append(previousImageTableName).append(WHERE).append("exist").append(" =?) ").append(AS_B_ON_A).append("filename").append(EQUAL_TO_B).append("filename").append(AND_A).append("filepath").append(EQUAL_TO_B).append("filepath").append(AND_A).append("miniCloudId").append(" =?;").toString();
        this.statement = null;
        ResultSet selectImageTableResult = null;
        ArrayList<FileTO> fileTOList = null;
        if (this.attachImageTableDataInCurrentTable(currentImageTableName, previousImageTableName)) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                this.statement.setInt(1, 1);
                this.statement.setString(2, cloudId);
                selectImageTableResult = this.statement.executeQuery();
                fileTOList = new ArrayList<FileTO>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    FileTO tempFile = new FileTO();
                    tempFile.setFileName(selectImageTableResult.getString("filename"));
                    tempFile.setAbstractFilePath(selectImageTableResult.getString("filepath"));
                    tempFile.setMiniCloudId(selectImageTableResult.getString("miniCloudId"));
                    tempFile.setMd5checksum(selectImageTableResult.getString("checksum"));
                    tempFile.setMetaData(selectImageTableResult.getString("metadata"));
                    String tempTimeStamp = selectImageTableResult.getString("modifiedtimestamp");
                    tempFile.setFolder(selectImageTableResult.getInt("folder") == 1);
                    tempFile.setExists(selectImageTableResult.getInt("exist") == 1);
                    tempFile.setLastModifiedTimestamp(Long.valueOf(tempTimeStamp).longValue());
                    fileTOList.add(tempFile);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.trace("" + e);
                this.logger.error("SQLException while getting newly added records from Image Table getNewlyCreatedFilesBetweenImageTables" + e.getMessage());
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set getNewlyCreatedFilesBetweenImageTables" + e);
                    }
                }
            }
            this.detachImageTableDataInCurrentTable(previousImageTableName);
        }
        return fileTOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileTO> getFilesModifilesBetweenImageTables(String previousImageTableName, String currentImageTableName, String miniCloudId) {
        String sqlQuery = new StringBuffer().append(SELECT_A_ALL_FROM).append(currentImageTableName).append(AS_A_INNER_JOIN).append(SELECT).append("filename").append(", ").append("filepath").append(", ").append("checksum").append(FROM).append(previousImageTableName).append(" ) ").append(AS_B_ON_A).append("filename").append(EQUAL_TO_B).append("filename").append(AND_A).append("filepath").append(EQUAL_TO_B).append("filepath").append(AND_A).append("checksum").append(" <> B.").append("checksum").append(AND_A).append("miniCloudId").append(" =?").toString();
        this.statement = null;
        ResultSet selectImageTableResult = null;
        ArrayList<FileTO> fileTOList = null;
        if (this.attachImageTableDataInCurrentTable(currentImageTableName, previousImageTableName)) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                this.statement.setString(1, miniCloudId);
                selectImageTableResult = this.statement.executeQuery();
                fileTOList = new ArrayList<FileTO>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    FileTO tempFile = new FileTO();
                    tempFile.setFileName(selectImageTableResult.getString("filename"));
                    tempFile.setAbstractFilePath(selectImageTableResult.getString("filepath"));
                    tempFile.setMiniCloudId(selectImageTableResult.getString("miniCloudId"));
                    tempFile.setMd5checksum(selectImageTableResult.getString("checksum"));
                    tempFile.setMetaData(selectImageTableResult.getString("metadata"));
                    String tempTimeStamp = selectImageTableResult.getString("modifiedtimestamp");
                    tempFile.setFolder(selectImageTableResult.getInt("folder") == 1);
                    tempFile.setExists(selectImageTableResult.getInt("exist") == 1);
                    tempFile.setLastModifiedTimestamp(Long.valueOf(tempTimeStamp).longValue());
                    fileTOList.add(tempFile);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.trace("" + e);
                this.logger.error("SQLException while getting modified records from Image Table getFilesModifilesBetweenImageTables" + e.getMessage());
            }
            finally {
                if (this.statement != null) {
                    try {
                        this.statement.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("Trying to closing statement getFilesModifilesBetweenImageTables" + e);
                    }
                }
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set getFilesModifilesBetweenImageTables" + e);
                    }
                }
            }
            this.detachImageTableDataInCurrentTable(previousImageTableName);
        }
        return fileTOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPreviousFilesFromPreviousImageTable(String previousImageTableName, String currentImageTableName, String deviceUserPath, String cloudId) {
        boolean sucess = false;
        String sqlQuery = new StringBuffer().append(SELECT_A_ALL_FROM).append(previousImageTableName).append(".").append(previousImageTableName).append(AS_A_INNER_JOIN).append(SELECT).append("filename").append(", ").append("filepath").append(FROM).append(previousImageTableName).append(".").append(previousImageTableName).append(" EXCEPT select ").append("filename").append(", ").append("filepath").append(FROM).append(currentImageTableName).append(") ").append(AS_B_ON_A).append("filename").append(EQUAL_TO_B).append("filename").append(AND_A).append("filepath").append(EQUAL_TO_B).append("filepath").append(AND_A).append("exist").append("=? and A.").append("miniCloudId").append(" =?;").toString();
        this.statement = null;
        ResultSet selectImageTableResult = null;
        ArrayList<FileTO> fileTOList = null;
        if (this.attachImageTableDataInCurrentTable(currentImageTableName, previousImageTableName)) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                this.statement.setInt(1, 1);
                this.statement.setString(2, cloudId);
                selectImageTableResult = this.statement.executeQuery();
                fileTOList = new ArrayList<FileTO>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    FileTO tempFile = new FileTO();
                    String curFileAbsPath = null;
                    curFileAbsPath = selectImageTableResult.getString("filepath");
                    String fileName = selectImageTableResult.getString("filename");
                    tempFile.setFileName(fileName);
                    tempFile.setAbstractFilePath(curFileAbsPath);
                    tempFile.setMiniCloudId(selectImageTableResult.getString("miniCloudId"));
                    tempFile.setMd5checksum(selectImageTableResult.getString("checksum"));
                    tempFile.setMetaData(selectImageTableResult.getString("metadata"));
                    String tempTimeStamp = selectImageTableResult.getString("modifiedtimestamp");
                    tempFile.setFolder(selectImageTableResult.getInt("folder") == 1);
                    tempFile.setLastModifiedTimestamp(Long.valueOf(tempTimeStamp).longValue());
                    boolean setExist = this.checkIfFileExists(deviceUserPath, fileName, curFileAbsPath);
                    tempFile.setExists(setExist);
                    fileTOList.add(tempFile);
                }
                this.statement.close();
                sucess = true;
            }
            catch (SQLException e) {
                this.logger.error("SQLException whiling adding data from previous Image Table" + e);
            }
            finally {
                if (this.statement != null) {
                    try {
                        this.statement.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("Trying to close statement " + e);
                    }
                }
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set" + e);
                    }
                }
            }
            this.detachImageTableDataInCurrentTable(previousImageTableName);
        }
        if (fileTOList != null) {
            sucess = this.storeImageInformation(fileTOList, currentImageTableName);
        }
        return sucess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFromTable(List<RenamedTO> renTOList, String imageTableName) {
        StringBuilder sqlQuery = new StringBuilder().append("delete from ").append(imageTableName).append(WHERE).append("filepath").append(AND_QUES).append("filename").append("=?;");
        this.statement = null;
        StringBuilder sb = new StringBuilder().append(this.baseFolderURL).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(imageTableName);
        boolean success = false;
        boolean gotConnection = this.getConnection(sb.toString());
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery.toString());
                for (RenamedTO renTo : renTOList) {
                    String path = renTo.getAbstractFilePath();
                    String name = renTo.getOldFileName();
                    this.statement.setString(1, path);
                    this.statement.setString(2, name);
                    this.statement.addBatch();
                }
                this.conn.setAutoCommit(false);
                this.statement.executeBatch();
                this.statement.close();
                this.conn.commit();
                success = true;
            }
            catch (SQLException e) {
                this.logger.error("SQLException while removing From Table" + e);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateTable(List<RenamedTO> renTOList, String imageTableName) {
        String sqlQueryStart = new StringBuffer().append("UPDATE ").append(imageTableName).append(" SET ").append("filename").append("=?").toString();
        String sqlQueryMid = " where filename=?";
        String sqlQueryEnd = " And filepath=?";
        this.statement = null;
        StringBuilder sb = new StringBuilder().append(this.baseFolderURL).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(imageTableName);
        boolean success = false;
        boolean gotConnection = this.getConnection(sb.toString());
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(new StringBuffer().append(sqlQueryStart).append(sqlQueryMid).append(sqlQueryEnd).toString());
                for (RenamedTO renTo : renTOList) {
                    String tempPath = renTo.getAbstractFilePath();
                    String tempName = renTo.getOldFileName();
                    String tempNewName = renTo.getNewfileName();
                    this.statement.setString(1, tempNewName);
                    this.statement.setString(2, tempName);
                    this.statement.setString(3, tempPath);
                    this.statement.addBatch();
                }
                this.statement.executeBatch();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.trace("" + e);
                this.logger.error("SQLException while updating Table" + e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFilTOListFromTable(List<FileTO> fileTOList, String imageTableName) {
        String sqlQuery = new StringBuffer().append("delete from ").append(imageTableName).append(WHERE).append("filepath").append(AND_QUES).append("filename").append("=?;").toString();
        this.statement = null;
        StringBuilder sb = new StringBuilder().append(this.baseFolderURL).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(imageTableName);
        boolean success = false;
        boolean gotConnection = this.getConnection(sb.toString());
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                for (FileTO fileTo : fileTOList) {
                    String path = fileTo.getAbstractFilePath();
                    String name = fileTo.getFileName();
                    this.statement.setString(1, path);
                    this.statement.setString(2, name);
                    this.statement.addBatch();
                }
                this.conn.setAutoCommit(false);
                this.statement.executeBatch();
                this.statement.close();
                this.conn.commit();
                success = true;
            }
            catch (SQLException e) {
                this.logger.error("SQLException while removing Fil TO List From Table" + e);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    private boolean checkIfFileExists(String deviceUserPath, String fileName, String absPath) {
        StringBuilder sbuffer = new StringBuilder().append(deviceUserPath).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(absPath).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(fileName);
        File file = new File(sbuffer.toString());
        return file.exists();
    }

    public boolean updateMD5(String currentImageTable, FileTO file) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileTO> getImageInformationWithMiniCloudId(String imageTableName, String miniCloudId) {
        String sqlQuery = "select * from " + imageTableName + WHERE + "miniCloudId" + " =?;";
        this.statement = null;
        ResultSet selectImageTableResult = null;
        ArrayList<FileTO> fileTOList = null;
        StringBuilder sb = new StringBuilder().append(this.baseFolderURL).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(imageTableName);
        boolean gotConnection = this.getConnection(sb.toString());
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                this.statement.setString(1, miniCloudId);
                selectImageTableResult = this.statement.executeQuery();
                fileTOList = new ArrayList<FileTO>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    FileTO tempFile = new FileTO();
                    tempFile.setFileName(selectImageTableResult.getString("filename"));
                    tempFile.setAbstractFilePath(selectImageTableResult.getString("filepath"));
                    tempFile.setMiniCloudId(selectImageTableResult.getString("miniCloudId"));
                    tempFile.setMd5checksum(selectImageTableResult.getString("checksum"));
                    tempFile.setMetaData(selectImageTableResult.getString("metadata"));
                    String tempTimeStamp = selectImageTableResult.getString("modifiedtimestamp");
                    tempFile.setFolder(selectImageTableResult.getInt("folder") == 1);
                    tempFile.setExists(selectImageTableResult.getInt("exist") == 1);
                    long tempLongTimeStamp = Long.parseLong(tempTimeStamp);
                    tempFile.setLastModifiedTimestamp(tempLongTimeStamp);
                    fileTOList.add(tempFile);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while geting Image Information With Mini Cloud Id" + e);
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set for geting Image Information With Mini Cloud Id" + e);
                    }
                }
                this.closeConnection();
            }
        }
        return fileTOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFilTOFromTable(FileTO fileTo, String imageTableName) {
        String sqlQuery = new StringBuffer().append("delete from ").append(imageTableName).append(WHERE).append("filepath").append(AND_QUES).append("filename").append("=?;").toString();
        this.statement = null;
        StringBuilder sb = new StringBuilder().append(this.baseFolderURL).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(imageTableName);
        boolean success = false;
        boolean gotConnection = this.getConnection(sb.toString());
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                String path = fileTo.getAbstractFilePath();
                String name = fileTo.getFileName();
                this.statement.setString(1, path);
                this.statement.setString(2, name);
                this.statement.addBatch();
                this.conn.setAutoCommit(false);
                this.statement.executeBatch();
                this.statement.close();
                this.conn.commit();
                success = true;
            }
            catch (SQLException e) {
                this.logger.error("SQLException while removing Fil TO List From Table" + e);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }
}

