/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.constant.CrawlLifecycle;
import com.parablu.epa.core.dao.BackupActivityDAO;
import com.parablu.epa.core.to.BackupActivityTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupActivityHistoryDAOImpl
extends BaseDAO
implements BackupActivityDAO {
    private Logger logger = LoggerFactory.getLogger(BackupActivityHistoryDAOImpl.class);
    private static final String SELECTFROM = "select * from ";
    private static final String SQLEXCEPTION_WHILE_CLOSING_RESULTSET = "SQLException while closing result set";
    private static final String SQLEXCEPTION_WHILE_UPDATING_ACTIVITYTABLE = "SQLException while updating activity Table:";
    private static final String DESC_LIMIT = " DESC LIMIT ";

    public BackupActivityHistoryDAOImpl(String uRL) {
        super(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createBackupActivityHistoryDB() {
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnectionForCreatingDatabase();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(BluSyncSQLConstants.CREATE_BACKUP_ACTIVITY_TABLE_QUERY);
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.error("sqlExeception during creation of Activity History DB:" + e);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addEventToBackupActivityHistoryTable(BackupActivityTO activity) {
        long columnId = 0L;
        String tempActivityName = activity.getBackupActivityStatus();
        String tempActivityTimeStamp = activity.getBackupActivityTimeStamp();
        String tempActivityUpload = activity.getBackupUploadCount();
        String tempActivityBatchStatus = activity.getBatchStatus();
        String tempActivityBatchId = activity.getBatchId();
        int tempActivityFailCode = activity.getFailCode();
        long tempActivityUploadSize = activity.getTotalUploadSize();
        String fullBackup = activity.getFullBackup();
        String sqlQuery = new StringBuffer().append("INSERT INTO ").append("BackupActivityHistory").append(" (").append("timestamp").append(",").append("status").append(",").append("batchStatus").append(",").append("batchID").append(",").append("failCode").append(",").append("totalUploadSize").append(",").append("uploadcount").append(",").append("fullbackup").append(")").append(" Values(?,?,?,?,?,?,?,?);").toString();
        ResultSet result = null;
        this.statement = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery, 1);
                this.statement.setString(1, tempActivityTimeStamp);
                this.statement.setString(2, tempActivityName);
                this.statement.setString(3, tempActivityBatchStatus);
                this.statement.setString(4, tempActivityBatchId);
                this.statement.setInt(5, tempActivityFailCode);
                this.statement.setLong(6, tempActivityUploadSize);
                this.statement.setString(7, tempActivityUpload);
                this.statement.setString(8, fullBackup);
                this.statement.execute();
                result = this.statement.getGeneratedKeys();
                if (result != null && result.next()) {
                    columnId = result.getLong(1);
                    result.close();
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while inserting into Activity history Table" + e);
            }
            finally {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (SQLException e) {
                        this.logger.error(SQLEXCEPTION_WHILE_CLOSING_RESULTSET + e);
                    }
                }
                this.closeConnection();
            }
        }
        return columnId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateEventToBackupActivityHistoryTable(BackupActivityTO activity) {
        long activityId = activity.getBackupActivityID();
        String tempActivityUpload = activity.getBackupUploadCount();
        String activityName = activity.getBackupActivityStatus();
        String batchStatus = activity.getBatchStatus();
        String batchId = activity.getBatchId();
        long totalUploadSize = activity.getTotalUploadSize();
        String sqlQuery = "Update BackupActivityHistory set uploadcount=?,status=?,batchStatus=?,batchID=?,totalUploadSize=? where id=?;";
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement("Update BackupActivityHistory set uploadcount=?,status=?,batchStatus=?,batchID=?,totalUploadSize=? where id=?;");
                this.statement.setString(1, tempActivityUpload);
                this.statement.setString(2, activityName);
                this.statement.setString(3, batchStatus);
                this.statement.setString(4, batchId);
                this.statement.setLong(5, totalUploadSize);
                this.statement.setLong(6, activityId);
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.trace("" + e);
                this.logger.error(SQLEXCEPTION_WHILE_UPDATING_ACTIVITYTABLE + e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupActivityTO getCurrentStatusFromBackupActivityHistoryTable() {
        String sqlQuery = new StringBuffer().append(SELECTFROM).append("BackupActivityHistory").append(" where status is not 'SCANNING' ").append(" ORDER BY ").append("id").append(" DESC LIMIT 1").toString();
        this.statement = null;
        ResultSet getcurNameRes = null;
        BackupActivityTO currentActivity = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                getcurNameRes = this.statement.executeQuery();
                if (getcurNameRes != null && getcurNameRes.next()) {
                    currentActivity = new BackupActivityTO();
                    currentActivity.setBackupActivityID(getcurNameRes.getLong("id"));
                    currentActivity.setBackupActivityTimeStamp(getcurNameRes.getString("timestamp"));
                    currentActivity.setBackupUploadCount(getcurNameRes.getString("uploadcount"));
                    currentActivity.setBackupActivityStatus(getcurNameRes.getString("status"));
                    currentActivity.setBatchStatus(getcurNameRes.getString("batchStatus"));
                    currentActivity.setBatchId(getcurNameRes.getString("batchID"));
                    currentActivity.setFailCode(getcurNameRes.getInt("failCode"));
                    currentActivity.setTotalUploadSize(getcurNameRes.getLong("totalUploadSize"));
                    currentActivity.setRestartID((long)getcurNameRes.getInt("restartid"));
                    currentActivity.setFullBackup(getcurNameRes.getString("fullbackup"));
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.trace("" + e);
                this.logger.error("SQLException while beting status from activity Table" + e.getMessage());
            }
            finally {
                if (getcurNameRes != null) {
                    try {
                        getcurNameRes.close();
                    }
                    catch (SQLException e) {
                        this.logger.trace("" + e);
                        this.logger.error("SQLException while closing result set getcurNameRes" + e);
                    }
                }
                this.closeConnection();
            }
            getcurNameRes = null;
        }
        return currentActivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackupActivityTO> getAllHistoryBackupActivityHistoryTable() {
        String sqlQuery = "select * from BackupActivityHistory";
        this.statement = null;
        ResultSet selectImageTableResult = null;
        ArrayList<BackupActivityTO> listOfActivities = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                selectImageTableResult = this.statement.executeQuery();
                listOfActivities = new ArrayList<BackupActivityTO>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    BackupActivityTO tempActivity = new BackupActivityTO();
                    String tempActivityUploadCount = null;
                    String tempActivityName = selectImageTableResult.getString("status");
                    String tempTimeStamp = selectImageTableResult.getString("timestamp");
                    tempActivityUploadCount = selectImageTableResult.getString("uploadcount");
                    tempActivity.setBackupActivityID((long)selectImageTableResult.getInt("id"));
                    tempActivity.setBackupActivityStatus(tempActivityName);
                    tempActivity.setBackupActivityTimeStamp(tempTimeStamp);
                    tempActivity.setBackupUploadCount(tempActivityUploadCount);
                    listOfActivities.add(tempActivity);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while get All History Activity History Table" + e);
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set ImageTable" + e);
                    }
                }
                this.closeConnection();
            }
        }
        return listOfActivities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanBackupActivityHistoryTable() {
        this.statement = null;
        BackupActivityTO activity = this.getlastSuccessfullEntryFromBackupActivityHistoryTable();
        String sqlStatement = "select count(*) AS recordCount from BackupActivityHistory";
        String lastSuccessfulCrawl = null;
        if (activity != null && activity.getBackupActivityTimeStamp() != null) {
            lastSuccessfulCrawl = activity.getBackupActivityTimeStamp();
        }
        String sqlDeleteStatement = "delete from BackupActivityHistory where timestamp not in (select timestamp from BackupActivityHistory ORDER BY timestamp DESC LIMIT 10000) and timestamp !=" + lastSuccessfulCrawl + ";";
        ResultSet rs = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlStatement);
                rs = this.statement.executeQuery();
                long rowCount = 0L;
                if (rs != null && rs.next()) {
                    rowCount = Long.valueOf(rs.getString("recordCount"));
                    rs.close();
                }
                this.logger.debug("Current number of records is :" + rowCount);
                if (rowCount > 10000L) {
                    this.statement.execute(sqlDeleteStatement);
                    this.logger.debug("Cleaning Table");
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while select from activity table", (Throwable)e);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        this.logger.error(SQLEXCEPTION_WHILE_CLOSING_RESULTSET + e);
                    }
                }
                this.closeConnection();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropBackupActivityHistoryTable() {
        String sqlQuery = "drop table BackupActivityHistory";
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement("drop table BackupActivityHistory");
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.trace("" + e);
                this.logger.error("SQLException while dropping activity Table:" + e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupActivityTO getlastSuccessfullEntryFromBackupActivityHistoryTable() {
        String sqlQuery = new StringBuffer().append(SELECTFROM).append("BackupActivityHistory").append(" where ").append("status").append(" =\"").append(CrawlLifecycle.FINISHED.name()).append("\" ORDER BY ").append("id").append(" DESC LIMIT 1").toString();
        this.statement = null;
        ResultSet getcurNameRes = null;
        BackupActivityTO currentActivity = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                getcurNameRes = this.statement.executeQuery();
                if (getcurNameRes != null && getcurNameRes.next()) {
                    String tempTimseStamp = getcurNameRes.getString("timestamp");
                    currentActivity = new BackupActivityTO();
                    currentActivity.setBackupActivityStatus(getcurNameRes.getString("status"));
                    currentActivity.setBackupActivityTimeStamp(tempTimseStamp);
                    currentActivity.setBackupUploadCount(getcurNameRes.getString("uploadcount"));
                    currentActivity.setBackupActivityID((long)getcurNameRes.getInt("id"));
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.trace("" + e);
                this.logger.error("SQLException while getting last entry from activity table:" + e.getMessage());
            }
            finally {
                if (getcurNameRes != null) {
                    try {
                        getcurNameRes.close();
                    }
                    catch (SQLException e) {
                        this.logger.error(SQLEXCEPTION_WHILE_CLOSING_RESULTSET + e);
                    }
                }
                this.closeConnection();
            }
            getcurNameRes = null;
        }
        return currentActivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackupActivityTO> getSelectRecordsFromBackupHistoryActivityHistoryTable(boolean order, long firstIndex, long lastIndex) {
        String sqlQuery = null;
        sqlQuery = order ? new StringBuffer().append(SELECTFROM).append("BackupActivityHistory").append(" ORDER BY ").append("id").append(DESC_LIMIT).append(firstIndex).append(",").append(lastIndex).toString() : new StringBuffer().append(SELECTFROM).append("BackupActivityHistory").append(" ORDER BY ").append("id").append(" ASC LIMIT ").append(firstIndex).append(",").append(lastIndex).toString();
        this.statement = null;
        ResultSet selectImageTableResult = null;
        ArrayList<BackupActivityTO> listOfActivities = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                selectImageTableResult = this.statement.executeQuery();
                listOfActivities = new ArrayList<BackupActivityTO>();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    BackupActivityTO tempActivity = new BackupActivityTO();
                    String tempActivityUploadCount = null;
                    String tempActivityName = selectImageTableResult.getString("status");
                    String tempTimeStamp = selectImageTableResult.getString("timestamp");
                    tempActivityUploadCount = selectImageTableResult.getString("uploadcount");
                    tempActivity.setBackupActivityID((long)selectImageTableResult.getInt("id"));
                    tempActivity.setBackupActivityStatus(tempActivityName);
                    tempActivity.setBackupActivityTimeStamp(tempTimeStamp);
                    tempActivity.setBackupUploadCount(tempActivityUploadCount);
                    listOfActivities.add(tempActivity);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while getSelectRecordsFromHistoryActivityHistoryTable" + e);
                this.logger.error(sqlQuery);
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set ImageTable" + e);
                    }
                }
                this.closeConnection();
            }
        }
        return listOfActivities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateFailCodeToBackupActivityHistoryTable(BackupActivityTO activity) {
        long activityId = activity.getBackupActivityID();
        int failCode = activity.getFailCode();
        String sqlQuery = "Update BackupActivityHistory set failCode=?  where id=?;";
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement("Update BackupActivityHistory set failCode=?  where id=?;");
                this.statement.setInt(1, failCode);
                this.statement.setLong(2, activityId);
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.trace("" + e);
                this.logger.error(SQLEXCEPTION_WHILE_UPDATING_ACTIVITYTABLE + e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean alterTable() {
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnectionForCreatingDatabase();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement("ALTER table BackupActivityHistory ADD COLUMN fullbackup TEXT;");
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.trace("" + e);
                this.logger.info("SQL Exeception in CREATE_ACTIVITY_TABLE" + e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupActivityTO getScanStatusFromBackupActivityHistoryTable() {
        String sqlQuery = new StringBuffer().append(SELECTFROM).append("BackupActivityHistory").append(" ORDER BY ").append("id").append(" DESC LIMIT 1").toString();
        this.statement = null;
        ResultSet getcurNameRes = null;
        BackupActivityTO currentActivity = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                getcurNameRes = this.statement.executeQuery();
                if (getcurNameRes != null && getcurNameRes.next()) {
                    currentActivity = new BackupActivityTO();
                    currentActivity.setBackupActivityID(getcurNameRes.getLong("id"));
                    currentActivity.setBackupActivityTimeStamp(getcurNameRes.getString("timestamp"));
                    currentActivity.setBackupUploadCount(getcurNameRes.getString("uploadcount"));
                    currentActivity.setBackupActivityStatus(getcurNameRes.getString("status"));
                    currentActivity.setBatchStatus(getcurNameRes.getString("batchStatus"));
                    currentActivity.setBatchId(getcurNameRes.getString("batchID"));
                    currentActivity.setFailCode(getcurNameRes.getInt("failCode"));
                    currentActivity.setTotalUploadSize(getcurNameRes.getLong("totalUploadSize"));
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while selecting from activity Table" + e);
            }
            finally {
                if (getcurNameRes != null) {
                    try {
                        getcurNameRes.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result setgetcurNameRes" + e);
                    }
                }
                this.closeConnection();
            }
            getcurNameRes = null;
        }
        return currentActivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRestartIdINBackupActivityHistoryTable(BackupActivityTO activity) {
        long activityId = activity.getBackupActivityID();
        long restartId = activity.getRestartID();
        String sqlQuery = "Update BackupActivityHistory set restartid=? where id=?;";
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement("Update BackupActivityHistory set restartid=? where id=?;");
                this.statement.setLong(1, restartId);
                this.statement.setLong(2, activityId);
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.trace("" + e);
                this.logger.error(SQLEXCEPTION_WHILE_UPDATING_ACTIVITYTABLE + e.getMessage());
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }
}

