/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.service.support.SupportHelper;
import com.parablu.epa.view.FontsManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportDialog
extends Dialog {
    private Logger logger = LoggerFactory.getLogger(SupportDialog.class);
    private FontsManager fontsManager;

    public SupportDialog(Shell shell) {
        super(shell, 0);
    }

    public SupportDialog(Shell parent, int style) {
        super(parent, style);
    }

    public boolean open() {
        boolean result = false;
        Shell parent = this.getParent();
        Shell shell = new Shell(parent, 67680);
        Display display = parent.getDisplay();
        this.fontsManager = new FontsManager(display);
        shell.setText(this.getText());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 10;
        gridLayout.marginTop = 10;
        shell.setLayout((Layout)gridLayout);
        shell.setLocation(parent.getLocation());
        Composite composite = new Composite((Composite)shell, 0x1000000);
        GridLayout compositeGridLayout = new GridLayout();
        compositeGridLayout.marginHeight = 0;
        compositeGridLayout.marginBottom = 0;
        compositeGridLayout.marginTop = 0;
        compositeGridLayout.numColumns = 2;
        compositeGridLayout.verticalSpacing = 5;
        compositeGridLayout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)compositeGridLayout);
        composite.setLayoutData((Object)new GridData(768));
        Group contactGroup = new Group(composite, 0x1000000);
        GridLayout groupGridLayout = new GridLayout();
        groupGridLayout.numColumns = 2;
        groupGridLayout.makeColumnsEqualWidth = false;
        contactGroup.setLayout((Layout)groupGridLayout);
        GridData contactGroupGridData = new GridData(768);
        contactGroupGridData.horizontalSpan = 2;
        contactGroup.setLayoutData((Object)contactGroupGridData);
        contactGroup.setText("How should we contact you?");
        contactGroup.setFont(this.fontsManager.getSmallNormalFont());
        Label label = new Label((Composite)contactGroup, 320);
        label.setText("Email Address");
        label.setFont(this.fontsManager.getMediumNormalFont());
        Text text = new Text((Composite)contactGroup, 2052);
        GridData gridData = new GridData(768);
        gridData.widthHint = 140;
        text.setLayoutData((Object)gridData);
        text.setFont(this.fontsManager.getMediumNormalFont());
        Group queryGroup = new Group(composite, 0x1000000);
        GridLayout queryGroupGridLayout = new GridLayout();
        queryGroupGridLayout.numColumns = 2;
        queryGroupGridLayout.makeColumnsEqualWidth = false;
        queryGroup.setLayout((Layout)queryGroupGridLayout);
        GridData queryGroupGridData = new GridData(768);
        queryGroupGridData.horizontalSpan = 2;
        queryGroup.setLayoutData((Object)queryGroupGridData);
        queryGroup.setText("What is your query?");
        queryGroup.setFont(this.fontsManager.getSmallNormalFont());
        Label sublabel = new Label((Composite)queryGroup, 320);
        sublabel.setText("Topic");
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 1;
        sublabel.setLayoutData((Object)gridData2);
        sublabel.setFont(this.fontsManager.getMediumNormalFont());
        Text subtext = new Text((Composite)queryGroup, 2052);
        GridData subGridData = new GridData(768);
        subGridData.widthHint = 70;
        subtext.setLayoutData((Object)subGridData);
        subtext.setFont(this.fontsManager.getMediumNormalFont());
        Label messageBoxlabel = new Label((Composite)queryGroup, 320);
        messageBoxlabel.setText("Description");
        GridData messageBoxlabelGridData = new GridData();
        messageBoxlabelGridData.horizontalSpan = 2;
        messageBoxlabel.setLayoutData((Object)messageBoxlabelGridData);
        messageBoxlabel.setFont(this.fontsManager.getMediumNormalFont());
        Text messageBox = new Text((Composite)queryGroup, 2050);
        GridData messageGridData = new GridData(768);
        messageGridData.heightHint = 60;
        messageGridData.horizontalSpan = 2;
        messageBox.setLayoutData((Object)messageGridData);
        messageBox.setFont(this.fontsManager.getMediumNormalFont());
        Button checkBoxbutton = new Button(composite, 32);
        GridData checkBoxbuttonGridData = new GridData(768);
        checkBoxbuttonGridData.horizontalSpan = 1;
        checkBoxbutton.setLayoutData((Object)checkBoxbuttonGridData);
        checkBoxbutton.setText("Attach Logs");
        checkBoxbutton.setSelection(true);
        Button button = new Button(composite, 8);
        GridData buttonGridData = new GridData();
        button.setLayoutData((Object)buttonGridData);
        button.setText("Send");
        button.setFont(this.fontsManager.getMediumNormalFont());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
            }
        });
        Listener listener = arg0 -> this.disposeWidgets();
        shell.addListener(12, listener);
        shell.pack();
        shell.open();
        return result;
    }

    public void disposeWidgets() {
        this.fontsManager.disposeFonts();
    }

    public void sendLogsAndShowAppropriateDialog() {
        MessageBox messageBox;
        if (SupportHelper.isSupportRequestInitiated()) {
            this.logger.debug("isSupportRequestInitiated: " + SupportHelper.isSupportRequestInitiated());
            return;
        }
        SupportHelper.setSupportRequestInitiated((boolean)true);
        int logsSent = SupportHelper.sendNewSupportLogs((String)SettingHelper.getCloudName(), (String)SettingHelper.getUserName(), (String)SettingHelper.getDeviceName(), (boolean)true);
        if (logsSent == 2) {
            messageBox = new MessageBox(this.getParent().getShell(), 34);
            messageBox.setText("Support Request Raised Successfully");
            messageBox.setMessage("Logs have been sent Successfully to our server.\nLog id will be attached in your request mail.");
        } else if (logsSent == 1) {
            messageBox = new MessageBox(this.getParent().getShell(), 40);
            messageBox.setMessage("Failed to send logs.\n\nLog id will be attached in your request mail.");
            messageBox.setText("Request Failed");
        } else {
            messageBox = new MessageBox(this.getParent().getShell(), 40);
            messageBox.setMessage("Please fill in the required fields.");
            messageBox.setText("Error");
        }
        messageBox.open();
    }
}

