/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.constants.BackupLifeCycle;
import com.parablu.epa.common.dao.RestoreActivityHistoryDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.FileElement;
import com.parablu.epa.core.element.FileListElement;
import com.parablu.epa.core.element.RestoreElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.helper.RestoreHelper;
import com.parablu.epa.core.service.transformer.CreateXmlObject;
import com.parablu.epa.core.to.BackupOrRestoreStatusTo;
import com.parablu.epa.core.to.DeviceTo;
import com.parablu.epa.core.to.DisplayTo;
import com.parablu.epa.core.to.GatewayTO;
import com.parablu.epa.core.to.RestoreActivityTO;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import com.parablu.epa.service.settings.MacSettingsHelper;
import com.parablu.epa.view.FontsManager;
import com.parablu.epa.view.RestoreUI;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreBackup
extends Shell {
    private Logger logger = LoggerFactory.getLogger(RestoreBackup.class);
    private BackupAdapter backupAdapter = null;
    private DeviceTo selectedItem;
    private TimerTask restoreTimerTask = null;
    private Timer restoreTimer = null;
    private int lengthForFileName = 25;
    private List<DisplayTo> listDevices = null;
    Button restoreButton;
    private boolean restoreLoadingStatus = true;
    Label restoreStatus;
    Label currentFileBeingRestoredLabel;
    private FontsManager fontsManager;
    private Integer port;
    private Button closeButton;
    private DeviceTo selectedFolder;
    private DeviceTo previousSelectedFolder;
    private String folderPath;
    public String deviceuid;
    int restoreFolderorDevice = 0;
    private List<DisplayTo> listFolders = null;
    String fullPath = null;
    String previousFolderPath = null;
    public int count = 1;
    public int restoredCount = 0;
    public int totalnoOfFilesToBeRestored = 0;
    Label currentRestoreStatusLabel;
    Group restoreFolderGroup = null;
    Group restoreGroup = null;
    Group queryGroup = null;
    private Image imageBack = null;
    Label showPathLabel;
    Button backLabel = null;
    String uploadIpForGateway = null;
    Group restorePathGroup = null;
    private static String backImageLocation = MacSettingsHelper.baseResourceFolder + "resource" + File.separator + "img" + File.separator + "glyphicons_221_unshare.png";
    String batchId = "";
    private Image imageFolder = null;
    private Image imageFile = null;
    private Image imageWindows = null;
    private Image imageMac = null;
    private static String folderImageLocation = MacSettingsHelper.baseResourceFolder + "resource" + File.separator + "img" + File.separator + "folder_img.png";
    private static String fileImageLocation = MacSettingsHelper.baseResourceFolder + "resource" + File.separator + "img" + File.separator + "file_img.png";
    private static String winImageLocation = MacSettingsHelper.baseResourceFolder + "resource" + File.separator + "img" + File.separator + "win_img.png";
    private static String macImageLocation = MacSettingsHelper.baseResourceFolder + "resource" + File.separator + "img" + File.separator + "mac_img.png";
    private static final String RESTORE_DEFAULT_STR = "Restore default Closing shell cause of error";
    private static final String SELECTED_FOLDER_LOG = "selected folder: ";
    private static final String STARTED = "STARTED";
    private SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
    Button checkBox;
    Button checkBoxbtn;
    private boolean restoreAllVersionSelected = false;
    RestoreElement restoreElement = new RestoreElement();
    private Thread restoreThread = null;

    public RestoreBackup(Shell shell) throws Exception {
        super(shell, 65760);
        this.setLocation(shell.getLocation());
        this.disableEscapeKey();
    }

    public RestoreBackup(Shell parent, int style) {
        super(parent, style);
        this.setLocation(parent.getLocation());
        this.disableEscapeKey();
    }

    private void disableEscapeKey() {
        Listener listener = e -> {
            if (e.detail == 2) {
                e.doit = false;
            }
        };
        this.getShell().addListener(31, listener);
    }

    public boolean openShell() throws InvalidKeyException, GeneralSecurityException, IOException {
        this.backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        NotificationHelper.successfulRestore = 3;
        boolean result = false;
        Shell parent = this.getShell();
        final Shell shell = this.getShell();
        shell.setText(this.getText());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 10;
        gridLayout.marginTop = 10;
        shell.setLayout((Layout)gridLayout);
        shell.setLocation(parent.getLocation());
        this.imageBack = new Image((Device)shell.getDisplay(), new ImageData(backImageLocation).scaledTo(16, 12));
        this.imageFolder = new Image((Device)shell.getDisplay(), new ImageData(folderImageLocation).scaledTo(10, 10));
        this.imageFile = new Image((Device)shell.getDisplay(), new ImageData(fileImageLocation).scaledTo(10, 10));
        this.imageWindows = new Image((Device)shell.getDisplay(), new ImageData(winImageLocation).scaledTo(15, 15));
        this.imageMac = new Image((Device)shell.getDisplay(), new ImageData(macImageLocation).scaledTo(15, 15));
        this.fontsManager = new FontsManager(this.getParent().getDisplay());
        Composite composite = new Composite((Composite)shell, 0x1000000);
        GridLayout compositeGridLayout = new GridLayout();
        compositeGridLayout.marginHeight = 0;
        compositeGridLayout.marginBottom = 0;
        compositeGridLayout.marginTop = 0;
        compositeGridLayout.numColumns = 2;
        compositeGridLayout.verticalSpacing = 3;
        compositeGridLayout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)compositeGridLayout);
        composite.setLayoutData((Object)new GridData(768));
        this.restoreGroup = new Group(composite, 0x1000000);
        GridLayout groupGridLayout = new GridLayout();
        groupGridLayout.numColumns = 2;
        groupGridLayout.makeColumnsEqualWidth = false;
        this.restoreGroup.setLayout((Layout)groupGridLayout);
        GridData contactGroupGridData = new GridData(768);
        contactGroupGridData.horizontalSpan = 2;
        this.restoreGroup.setLayoutData((Object)contactGroupGridData);
        this.restoreGroup.setText("Select the device to restore");
        this.restoreGroup.setFont(this.fontsManager.getSmallNormalFont());
        final Table table = new Table((Composite)this.restoreGroup, 68356);
        table.setHeaderVisible(true);
        TableColumn deviceColumn = new TableColumn(table, 16);
        deviceColumn.setText("Device");
        deviceColumn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumn column = (TableColumn)e.widget;
                table.removeAll();
                int sortDirection = table.getSortDirection();
                RestoreBackup.this.logger.debug("SORT Direction : " + sortDirection);
                if (1024 == sortDirection || 0 == sortDirection) {
                    RestoreBackup.this.sortListForRestore(RestoreBackup.this.listDevices, "Device", true);
                    table.setSortDirection(128);
                    RestoreBackup.this.logger.debug("UP SORT");
                } else {
                    RestoreBackup.this.sortListForRestore(RestoreBackup.this.listDevices, "Device", false);
                    table.setSortDirection(1024);
                    RestoreBackup.this.logger.debug("DOWN SORT");
                }
                RestoreBackup.this.addDevicesToTable(RestoreBackup.this.listDevices, table);
                table.setSortColumn(column);
            }
        });
        TableColumn deviceUserColumn = new TableColumn(table, 16);
        deviceUserColumn.setText("Username");
        deviceUserColumn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumn column = (TableColumn)e.widget;
                table.removeAll();
                if (1024 == table.getSortDirection() || 0 == table.getSortDirection()) {
                    RestoreBackup.this.sortListForRestore(RestoreBackup.this.listDevices, "Username", true);
                    table.setSortDirection(128);
                } else {
                    RestoreBackup.this.sortListForRestore(RestoreBackup.this.listDevices, "Username", false);
                    table.setSortDirection(1024);
                }
                RestoreBackup.this.addDevicesToTable(RestoreBackup.this.listDevices, table);
                table.setSortColumn(column);
            }
        });
        Label showHelpLabel = new Label((Composite)this.restoreGroup, 0);
        showHelpLabel.setLayoutData((Object)contactGroupGridData);
        showHelpLabel.setText("Click a device to select all data on the device for restoration");
        showHelpLabel.setFont(this.fontsManager.getSmallNormalFont());
        Label showHelpLabel1 = new Label((Composite)this.restoreGroup, 0);
        showHelpLabel1.setLayoutData((Object)contactGroupGridData);
        showHelpLabel1.setText("Double click a device to drill down and select a specific folder or a file in it.");
        showHelpLabel1.setFont(this.fontsManager.getSmallNormalFont());
        this.restorePathGroup = new Group(composite, 0x1000000);
        this.restorePathGroup.setVisible(false);
        GridLayout groupPathGridLayout = new GridLayout();
        groupPathGridLayout.numColumns = 2;
        groupPathGridLayout.makeColumnsEqualWidth = false;
        groupPathGridLayout.horizontalSpacing = 10;
        this.restorePathGroup.setLayout((Layout)groupPathGridLayout);
        this.restoreFolderGroup = new Group(composite, 0x1000000);
        this.restoreFolderGroup.setVisible(false);
        GridLayout groupFolderGridLayout = new GridLayout();
        groupFolderGridLayout.numColumns = 1;
        groupFolderGridLayout.makeColumnsEqualWidth = false;
        this.restoreFolderGroup.setLayout((Layout)groupFolderGridLayout);
        GridData contactGroupFolderGridData = new GridData(768);
        contactGroupFolderGridData.horizontalSpan = 2;
        GridData gdBtnNewButton3 = new GridData(4, 4, false, false, 1, 1);
        gdBtnNewButton3.heightHint = 27;
        gdBtnNewButton3.widthHint = 40;
        this.backLabel = new Button((Composite)this.restorePathGroup, 16384);
        this.backLabel.setLayoutData((Object)gdBtnNewButton3);
        this.backLabel.setText("");
        this.backLabel.setImage(this.imageBack);
        GridData gdBtnNewButton4 = new GridData(4, 4, true, false, 1, 1);
        gdBtnNewButton4.heightHint = 10;
        gdBtnNewButton4.widthHint = 500;
        this.showPathLabel = new Label((Composite)this.restorePathGroup, 0);
        this.showPathLabel.setLayoutData((Object)gdBtnNewButton4);
        this.showPathLabel.setText("");
        this.restoreFolderGroup.setLayoutData((Object)contactGroupFolderGridData);
        this.restoreFolderGroup.setText("Select a folder or a file to restore");
        this.restoreFolderGroup.setFont(this.fontsManager.getSmallNormalFont());
        final Table foldertable = new Table((Composite)this.restoreFolderGroup, 68356);
        TableColumn fileColumn = new TableColumn(foldertable, 16);
        foldertable.setHeaderVisible(true);
        fileColumn.setText("Folders/Files");
        fileColumn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumn column = (TableColumn)e.widget;
                foldertable.removeAll();
                if (1024 == foldertable.getSortDirection() || 0 == foldertable.getSortDirection()) {
                    RestoreBackup.this.sortListForRestore(RestoreBackup.this.listFolders, "Folders/Files", true);
                    foldertable.setSortDirection(128);
                } else {
                    RestoreBackup.this.sortListForRestore(RestoreBackup.this.listFolders, "Folders/Files", false);
                    foldertable.setSortDirection(1024);
                }
                RestoreBackup.this.setDataToFolderTable(foldertable, 1);
                foldertable.setSortColumn(column);
            }
        });
        TableColumn timestampColumn = new TableColumn(foldertable, 16);
        timestampColumn.setText("ModifiedTime");
        timestampColumn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumn column = (TableColumn)e.widget;
                foldertable.removeAll();
                if (1024 == foldertable.getSortDirection() || 0 == foldertable.getSortDirection()) {
                    RestoreBackup.this.sortListForRestore(RestoreBackup.this.listFolders, "ModifiedTime", true);
                    foldertable.setSortDirection(128);
                } else {
                    RestoreBackup.this.sortListForRestore(RestoreBackup.this.listFolders, "ModifiedTime", false);
                    foldertable.setSortDirection(1024);
                }
                RestoreBackup.this.setDataToFolderTable(foldertable, 1);
                foldertable.setSortColumn(column);
            }
        });
        TableColumn sizeColumn = new TableColumn(foldertable, 16);
        sizeColumn.setText("Size(KB)");
        sizeColumn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumn column = (TableColumn)e.widget;
                foldertable.removeAll();
                if (1024 == foldertable.getSortDirection() || 0 == foldertable.getSortDirection()) {
                    RestoreBackup.this.sortListForRestore(RestoreBackup.this.listFolders, "Size(KB)", true);
                    foldertable.setSortDirection(128);
                } else {
                    RestoreBackup.this.sortListForRestore(RestoreBackup.this.listFolders, "Size(KB)", false);
                    foldertable.setSortDirection(1024);
                }
                RestoreBackup.this.setDataToFolderTable(foldertable, 1);
                foldertable.setSortColumn(column);
            }
        });
        Label showFolderHelpLabel = new Label((Composite)this.restoreFolderGroup, 0);
        showFolderHelpLabel.setLayoutData((Object)contactGroupFolderGridData);
        showFolderHelpLabel.setText("Selecting a folder will result in restoring all sub-folders and files under it.");
        showFolderHelpLabel.setFont(this.fontsManager.getSmallNormalFont());
        this.backLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    if (RestoreBackup.this.fullPath == null) {
                        return;
                    }
                    if (RestoreBackup.this.fullPath.contains("/")) {
                        String tmpPath;
                        RestoreBackup.this.fullPath = tmpPath = this.getPreviousPathforBackButton();
                        RestoreBackup.this.logger.debug("tempPath in back function is:" + tmpPath);
                        RestoreBackup.this.showPathLabel.setText(RestoreBackup.this.fullPath);
                        RestoreBackup.this.getBasePathFromServer(foldertable, RestoreBackup.this.fullPath);
                        RestoreBackup.this.backLabel.setEnabled(false);
                    } else {
                        RestoreBackup.this.fullPath = null;
                        RestoreBackup.this.getBasePathFromServer(foldertable, RestoreBackup.this.fullPath);
                        RestoreBackup.this.backLabel.setEnabled(false);
                        RestoreBackup.this.showPathLabel.setText("");
                    }
                }
                catch (Exception e1) {
                    RestoreBackup.this.logger.trace("" + e1);
                    RestoreBackup.this.logger.error("Exception occured" + e1.getMessage());
                }
            }

            String getPreviousPathforBackButton() {
                String delimiter = "\\/";
                String[] tmpArray = RestoreBackup.this.fullPath.split(delimiter);
                StringBuilder tmpPath = null;
                for (int i = 0; i < tmpArray.length - 1; ++i) {
                    tmpPath = tmpPath == null ? new StringBuilder(tmpArray[i]) : tmpPath.append("/").append(tmpArray[i]);
                }
                if (tmpPath != null) {
                    return tmpPath.toString();
                }
                return null;
            }
        });
        foldertable.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseDoubleClick(MouseEvent event) {
                if (foldertable.getSelectionIndex() != -1) {
                    TableItem item = foldertable.getItem(foldertable.getSelectionIndex());
                    RestoreBackup.this.selectedFolder = (DeviceTo)item.getData();
                    if (RestoreBackup.this.selectedFolder == null) {
                        RestoreBackup.this.fullPath = RestoreBackup.this.previousFolderPath;
                        return;
                    }
                    RestoreBackup.this.logger.debug(RestoreBackup.SELECTED_FOLDER_LOG + RestoreBackup.this.selectedFolder.getFilePath());
                    RestoreBackup.this.folderPath = RestoreBackup.this.selectedFolder.getFilePath();
                    RestoreBackup.this.previousSelectedFolder = RestoreBackup.this.selectedFolder;
                    if (RestoreBackup.this.fullPath == null) {
                        RestoreBackup.this.fullPath = RestoreBackup.this.folderPath;
                        RestoreBackup.this.previousFolderPath = RestoreBackup.this.folderPath;
                    } else {
                        RestoreBackup.this.previousFolderPath = RestoreBackup.this.fullPath;
                        RestoreBackup.this.fullPath = RestoreBackup.this.fullPath + "/" + RestoreBackup.this.folderPath;
                        RestoreBackup.this.logger.debug("fullPath is:#####$$$$$$$ " + RestoreBackup.this.fullPath);
                        RestoreBackup.this.logger.debug("previousPath:#####$$$$$$$ " + RestoreBackup.this.previousFolderPath);
                    }
                    try {
                        if (!RestoreBackup.this.selectedFolder.getFolder().equals("true")) {
                            RestoreBackup.this.logger.debug("Current selected file is a folde:" + RestoreBackup.this.selectedFolder.getFolder());
                            RestoreBackup.this.showupRevisions(foldertable, RestoreBackup.this.selectedFolder.getFilePath(), RestoreBackup.this.selectedFolder.getFileName());
                        } else {
                            RestoreBackup.this.getBasePathFromServer(foldertable, RestoreBackup.this.fullPath);
                        }
                        RestoreBackup.this.showPathLabel.setText(RestoreBackup.this.fullPath);
                    }
                    catch (Exception e1) {
                        RestoreBackup.this.logger.trace("" + e1);
                        RestoreBackup.this.logger.error("Exception in getting basepath from server" + e1.getMessage());
                    }
                }
            }
        });
        foldertable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ++RestoreBackup.this.count;
                RestoreBackup.this.logger.debug("count inside click:" + RestoreBackup.this.count);
                RestoreBackup.this.restoreFolderorDevice = 0;
                if (foldertable.getSelectionIndex() != -1) {
                    TableItem item = foldertable.getItem(foldertable.getSelectionIndex());
                    RestoreBackup.this.selectedFolder = (DeviceTo)item.getData();
                    if (item.getText().startsWith(" Version") && RestoreBackup.this.checkBoxbtn != null) {
                        RestoreBackup.this.checkBox.setSelection(false);
                        RestoreBackup.this.restoreAllVersionSelected = RestoreBackup.this.checkBoxbtn.getSelection();
                    }
                    if (RestoreBackup.this.selectedFolder == null) {
                        RestoreBackup.this.selectedFolder = RestoreBackup.this.previousSelectedFolder;
                        RestoreBackup.this.folderPath = RestoreBackup.this.selectedFolder.getFilePath();
                        RestoreBackup.this.logger.debug(" selected folder: " + RestoreBackup.this.fullPath + File.separator + RestoreBackup.this.selectedFolder.getFilePath());
                        return;
                    }
                    if (RestoreBackup.this.fullPath == null) {
                        RestoreBackup.this.logger.debug(RestoreBackup.SELECTED_FOLDER_LOG + RestoreBackup.this.selectedFolder.getFilePath());
                    } else {
                        RestoreBackup.this.logger.debug(RestoreBackup.SELECTED_FOLDER_LOG + RestoreBackup.this.fullPath + File.separator + RestoreBackup.this.selectedFolder.getFilePath());
                    }
                }
            }
        });
        this.pullRestoreDeviceListFromServer(table);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestoreBackup.this.restoreFolderorDevice = 1;
                RestoreBackup.this.selectedFolder = null;
                RestoreBackup.this.fullPath = null;
                RestoreBackup.this.previousFolderPath = null;
                if (table.getSelectionIndex() != -1) {
                    RestoreBackup.this.restoreFolderGroup.setVisible(true);
                    RestoreBackup.this.restorePathGroup.setVisible(true);
                    TableItem item = table.getItem(table.getSelectionIndex());
                    RestoreBackup.this.selectedItem = (DeviceTo)item.getData();
                    RestoreBackup.this.deviceuid = RestoreBackup.this.selectedItem.getDeviceUid();
                    RestoreBackup.this.logger.debug("selected device: " + RestoreBackup.this.selectedItem.getDeviceName());
                    try {
                        foldertable.clearAll();
                        RestoreBackup.this.showPathLabel.setText("");
                        RestoreBackup.this.listFolders.clear();
                    }
                    catch (Exception e1) {
                        RestoreBackup.this.logger.trace("" + e1);
                        RestoreBackup.this.logger.error("Exception occured while clearing the folder List" + e1.getMessage());
                    }
                }
            }
        });
        table.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDoubleClick(MouseEvent event) {
                if (table.getSelectionIndex() != -1) {
                    TableItem item = table.getItem(table.getSelectionIndex());
                    RestoreBackup.this.selectedItem = (DeviceTo)item.getData();
                    RestoreBackup.this.logger.debug("selected device: " + RestoreBackup.this.selectedItem.getDeviceName());
                    RestoreBackup.this.logger.debug("deviceid is:" + RestoreBackup.this.selectedItem.getDeviceId());
                    RestoreBackup.this.deviceuid = RestoreBackup.this.selectedItem.getDeviceUid();
                    try {
                        RestoreBackup.this.fullPath = null;
                        RestoreBackup.this.previousFolderPath = null;
                        RestoreBackup.this.getBasePathFromServer(foldertable, RestoreBackup.this.fullPath);
                        RestoreBackup.this.showPathLabel.setText("");
                    }
                    catch (Exception e1) {
                        RestoreBackup.this.logger.trace("" + e1);
                        RestoreBackup.this.logger.error("Exception occured while getting the basepath from server" + e1.getMessage());
                    }
                }
            }
        });
        GridData tableData = new GridData(768);
        tableData.heightHint = 75;
        tableData.widthHint = 500;
        table.setLayoutData((Object)tableData);
        GridData tableFolderData = new GridData(768);
        tableFolderData.heightHint = 120;
        tableData.widthHint = 500;
        foldertable.setLayoutData((Object)tableFolderData);
        this.queryGroup = new Group(composite, 0x1000000);
        GridLayout queryGroupGridLayout = new GridLayout();
        queryGroupGridLayout.numColumns = 2;
        queryGroupGridLayout.makeColumnsEqualWidth = false;
        this.queryGroup.setLayout((Layout)queryGroupGridLayout);
        GridData queryGroupGridData = new GridData(768);
        queryGroupGridData.horizontalSpan = 2;
        this.queryGroup.setLayoutData((Object)queryGroupGridData);
        this.queryGroup.setText("Select the destination folder");
        this.queryGroup.setFont(this.fontsManager.getSmallNormalFont());
        final Text subtext = new Text((Composite)this.queryGroup, 2052);
        GridData subGridData = new GridData(768);
        subGridData.widthHint = 170;
        subtext.setLayoutData((Object)subGridData);
        subtext.setFont(this.fontsManager.getMediumNormalFont());
        Button folderSelectButton = new Button((Composite)this.queryGroup, 8);
        folderSelectButton.setText("Select Folder");
        folderSelectButton.setFont(this.fontsManager.getMediumNormalFont());
        Label showDestinationFolderHelpLabel = new Label((Composite)this.queryGroup, 0);
        showDestinationFolderHelpLabel.setLayoutData((Object)queryGroupGridData);
        showDestinationFolderHelpLabel.setText("Restored data will be downloaded to this folder");
        showDestinationFolderHelpLabel.setFont(this.fontsManager.getSmallNormalFont());
        folderSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dlg = new DirectoryDialog(shell);
                dlg.setFilterPath(subtext.getText());
                dlg.setText("Parablu");
                dlg.setMessage("Select the directory you want to restore to");
                String dir = dlg.open();
                if (dir != null) {
                    subtext.setText(dir);
                }
            }
        });
        Composite restoreStartGroup = new Composite(composite, 131072);
        GridLayout restoreStartGroupGridLayout = new GridLayout();
        restoreStartGroupGridLayout.numColumns = 2;
        restoreStartGroupGridLayout.makeColumnsEqualWidth = false;
        restoreStartGroup.setLayout((Layout)restoreStartGroupGridLayout);
        GridData restoreStartGroupGridData = new GridData(768);
        contactGroupGridData.horizontalSpan = 2;
        restoreStartGroup.setLayoutData((Object)restoreStartGroupGridData);
        this.restoreStatus = new Label(restoreStartGroup, 16384);
        GridData restoreGridData = new GridData(768);
        restoreGridData.widthHint = 180;
        this.restoreStatus.setLayoutData((Object)restoreGridData);
        this.restoreStatus.setText("Loading information");
        this.restoreStatus.setFont(this.fontsManager.getMediumNormalFont());
        Label dummy = new Label(restoreStartGroup, 16384);
        GridData dummygrid = new GridData(768);
        dummy.setLayoutData((Object)dummygrid);
        dummy.setVisible(false);
        this.currentFileBeingRestoredLabel = new Label(restoreStartGroup, 16384);
        GridData restoreFileGridData = new GridData(768);
        restoreFileGridData.horizontalSpan = 2;
        this.currentFileBeingRestoredLabel.setLayoutData((Object)restoreFileGridData);
        this.currentFileBeingRestoredLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.currentRestoreStatusLabel = new Label(restoreStartGroup, 16384);
        this.currentRestoreStatusLabel.setLayoutData((Object)new GridData(768));
        this.restoreButton = new Button(restoreStartGroup, 8);
        GridData buttonGridData = new GridData();
        this.restoreButton.setLayoutData((Object)buttonGridData);
        this.restoreButton.setText("Restore");
        this.restoreButton.setFont(this.fontsManager.getMediumNormalFont());
        this.restoreButton.setEnabled(false);
        Composite checkBoxComposite = new Composite(restoreStartGroup, 0x1000000);
        GridLayout checkBoxButtonLayout = new GridLayout();
        checkBoxButtonLayout.numColumns = 1;
        checkBoxButtonLayout.makeColumnsEqualWidth = false;
        checkBoxButtonLayout.horizontalSpacing = 100;
        checkBoxComposite.setLayout((Layout)checkBoxButtonLayout);
        GridData checkGridData = new GridData(768);
        checkGridData.horizontalSpan = 1;
        this.checkBox = new Button(checkBoxComposite, 32);
        this.checkBox.setText("Restore all versions");
        this.checkBox.setFont(this.fontsManager.getMediumNormalFont());
        this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RestoreBackup.this.checkBoxbtn = (Button)event.getSource();
                RestoreBackup.this.restoreAllVersionSelected = RestoreBackup.this.checkBoxbtn.getSelection();
                RestoreBackup.this.logger.debug("Check box selected :" + RestoreBackup.this.restoreAllVersionSelected);
                if (RestoreBackup.this.checkBoxbtn.getSelection()) {
                    MessageBox msg = new MessageBox(shell, 34);
                    msg.setText("Restore Alert");
                    msg.setMessage("Selecting all versions may result in a long restore operation and consume a lot of space on your hard drive. \n  Make sure there is enough disk space available.");
                    msg.open();
                }
            }
        });
        this.restoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RestoreActivityTO restoreActivityTo = new RestoreActivityTO();
                RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl = new RestoreActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
                NotificationHelper.setShowFileBeingRestored((boolean)false);
                RestoreBackup.this.logger.debug("the selected item is:(file-1/folder-0):" + RestoreBackup.this.restoreFolderorDevice);
                NotificationHelper.successfulRestore = 1;
                if (NotificationHelper.restoreStarted) {
                    return;
                }
                MessageBox msg = new MessageBox(shell, 34);
                String destinationFolder = subtext.getText();
                File file = new File(destinationFolder);
                if (RestoreBackup.this.selectedItem == null) {
                    msg.setText("No device selected");
                    msg.setMessage("Please select a device to restore from");
                    msg.open();
                } else if ("".equals(destinationFolder)) {
                    msg.setText("No folder selected");
                    msg.setMessage("Please select a folder to restore to");
                    msg.open();
                } else if (!file.isDirectory()) {
                    msg.setText("Error");
                    msg.setMessage("The selected path is not a valid folder");
                    msg.open();
                } else {
                    if (file.list().length > 0) {
                        msg.setText("Folder not empty");
                        msg.setMessage("The destination folder is not empty. Please note that any file with the same name will be overwritten.");
                        msg.open();
                    }
                    NotificationHelper.successfulRestore = 1;
                    if (RestoreBackup.this.restoreFolderorDevice == 0 || RestoreBackup.this.restoreFolderorDevice == 1) {
                        RestoreBackup.this.restoreButton.setEnabled(false);
                        RestoreBackup.this.closeButton.setEnabled(false);
                        NotificationHelper.setRestoreStarted((boolean)true);
                        NotificationHelper.restoreFinished = false;
                        if (RestoreBackup.this.restoreFolderorDevice == 1 || RestoreBackup.this.selectedFolder.getFilePath().length() <= 3 && RestoreBackup.this.selectedFolder.getFilePath().contains(":")) {
                            RestoreBackup.this.showInfoMessage();
                        }
                        Runnable runnable = () -> {
                            try {
                                RestoreBackup.this.restoredCount = 0;
                                String status = BackupLifeCycle.STARTED.toString();
                                RestoreBackup.this.logger.debug("Status" + status);
                                RestoreBackup.this.batchId = RestoreBackup.this.restoreBatchInitiated(status, "", "0/0");
                                RestoreBackup.this.restoreElement = new RestoreElement();
                                String selectedPathForRestore = destinationFolder;
                                NotificationHelper.setShowFileBeingRestored((boolean)true);
                                if (!RestoreBackup.this.batchId.equals("") && !"-1".equals(RestoreBackup.this.batchId)) {
                                    RestoreBackup.this.validatePreviousBatchStatus(restoreActivityHistoryDAOImpl);
                                    RestoreBackup.this.logger.debug("Inserting into restore table");
                                    restoreActivityTo.setRestoreBatchStatus(status);
                                    restoreActivityTo.setRestoreBatchId(RestoreBackup.this.batchId);
                                    restoreActivityHistoryDAOImpl.addEventToRestoreActivity(restoreActivityTo);
                                }
                                FileElement fileElement = null;
                                FileListElement listFolderFiles = new FileListElement();
                                if (RestoreBackup.this.restoreFolderorDevice == 0) {
                                    if (RestoreBackup.this.selectedFolder.getFolder().equalsIgnoreCase("true")) {
                                        selectedPathForRestore = destinationFolder + StringLiterals.FILE_SEPARATOR + RestoreBackup.this.selectedFolder.getFilePath().replace(":", "_DRIVE");
                                        fileElement = ObjectUtils.convertToFileElement((DeviceTo)RestoreBackup.this.selectedFolder);
                                        fileElement.setFileName("");
                                        RestoreBackup.this.restoreElement.setSelectedDevicePath(fileElement.getFileCompletePath());
                                        RestoreBackup.this.restoreElement.setDevicePath(fileElement.getFileCompletePath());
                                        RestoreBackup.this.restoreElement.setFileUserOwner(RestoreBackup.this.selectedFolder.getFileUserOwner());
                                        listFolderFiles.getFileElementList().add(fileElement);
                                    } else if (RestoreBackup.this.selectedFolder.getFolder().equalsIgnoreCase("false")) {
                                        RestoreBackup.this.restoreElement.setSelectedDevicePath(RestoreBackup.this.selectedFolder.getFileName());
                                        RestoreBackup.this.restoreElement.setDevicePath(RestoreBackup.this.selectedFolder.getFileName());
                                        RestoreBackup.this.restoreElement.setFileName(RestoreBackup.this.selectedFolder.getFilePath());
                                        RestoreBackup.this.restoreElement.setFileUserOwner(RestoreBackup.this.selectedFolder.getFileUserOwner());
                                        if (!RestoreBackup.this.restoreAllVersionSelected) {
                                            RestoreBackup.this.logger.debug("all versions not selected so set backup id>>>>>>" + RestoreBackup.this.selectedFolder.getFileUserOwner());
                                            RestoreBackup.this.restoreElement.setFileBackupId(RestoreBackup.this.selectedFolder.getBackupId());
                                        }
                                    }
                                } else if (RestoreBackup.this.restoreFolderorDevice == 1) {
                                    RestoreBackup.this.restoreElement.setFileUserOwner(SettingHelper.getUserName());
                                    fileElement = new FileElement();
                                }
                                RestoreBackup.this.restoreElement.setCloudName(SettingHelper.getCloudName());
                                RestoreBackup.this.restoreElement.setRestoreBatchId(RestoreBackup.this.batchId);
                                RestoreBackup.this.restoreElement.setDestinationPath(selectedPathForRestore);
                                RestoreBackup.this.restoreElement.setDeviceUUid(RestoreBackup.this.deviceuid);
                                RestoreBackup.this.restoreElement.setRestoreAllVersions(RestoreBackup.this.restoreAllVersionSelected);
                                RestoreBackup.this.getUploadIPForGateway();
                                if (fileElement != null) {
                                    String fileElementXml = CreateXmlObject.createXmlForFileElement((FileElement)fileElement);
                                    FileListElement listFolderFilesFromServer = RestoreBackup.this.backupAdapter.getAllFoldersForDevicePathToFileElement(SettingHelper.getCurrentCloudIpAddress(), RestoreBackup.this.port, RestoreBackup.this.deviceuid, SettingHelper.readTokenFromFile(), fileElementXml);
                                    listFolderFiles.getFileElementList().addAll(listFolderFilesFromServer.getFileElementList());
                                    List listFileElement = listFolderFiles.getFileElementList();
                                    RestoreBackup.this.logger.debug("filelist elements:" + listFolderFiles);
                                    for (FileElement element : listFileElement) {
                                        if (RestoreBackup.this.restoreThread.isInterrupted()) {
                                            RestoreBackup.this.logger.debug("Restore thread is interrupted...");
                                            return;
                                        }
                                        NotificationHelper.setRestoreStarted((boolean)true);
                                        NotificationHelper.restoreFinished = false;
                                        RestoreBackup.this.logger.debug("element devicepath:" + element.getFileCompletePath() + " filename:" + element.getFileName());
                                        String devicePath = element.getFileCompletePath();
                                        if (!StringUtils.isEmpty((String)element.getFileCompletePath()) && !StringUtils.isEmpty((String)element.getFileName())) {
                                            devicePath = element.getFileCompletePath() + "/" + element.getFileName();
                                        }
                                        if (StringUtils.isEmpty((String)element.getFileCompletePath())) {
                                            devicePath = element.getFileName();
                                        }
                                        RestoreBackup.this.restoreElement.setDevicePath(devicePath.replace("\\", "/"));
                                        RestoreBackup.this.logger.debug("restore element devicepath>" + RestoreBackup.this.restoreElement.getDevicePath());
                                        NotificationHelper.successfulRestore = 1;
                                        RestoreBackup.this.downloadFile();
                                        restoreActivityTo.setTotalRestoreCount(RestoreBackup.this.restoreElement.getRestoreCount());
                                        restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(restoreActivityTo);
                                        RestoreBackup.this.logger.debug("Resore count:" + RestoreBackup.this.restoreElement.getRestoreCount());
                                    }
                                } else {
                                    RestoreBackup.this.downloadFile();
                                }
                                return;
                            }
                            catch (Exception e1) {
                                NotificationHelper.successfulRestore = 0;
                                RestoreBackup.this.logger.trace("" + e1);
                                RestoreBackup.this.logger.error("unsuccessfulRestore, Exception e1: ", (Object)e1.getMessage());
                            }
                            finally {
                                String restoreCount;
                                if (NotificationHelper.successfulRestore == 1) {
                                    String status = BackupLifeCycle.COMPLETED.toString();
                                    restoreCount = RestoreBackup.this.restoreElement.getRestoreCount();
                                    RestoreBackup.this.batchId = RestoreBackup.this.restoreBatchInitiated(status, RestoreBackup.this.batchId, restoreCount);
                                    if (RestoreBackup.this.batchId != null && RestoreBackup.this.batchId != "-1") {
                                        restoreActivityTo.setRestoreBatchStatus(status);
                                        restoreActivityTo.setTotalRestoreCount(restoreCount);
                                        restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(restoreActivityTo);
                                    }
                                } else {
                                    String status = BackupLifeCycle.FAILED.toString();
                                    restoreCount = RestoreBackup.this.restoreElement.getRestoreCount();
                                    RestoreBackup.this.batchId = RestoreBackup.this.restoreBatchInitiated(status, RestoreBackup.this.batchId, restoreCount);
                                    if (RestoreBackup.this.batchId != null && RestoreBackup.this.batchId != "-1") {
                                        restoreActivityTo.setRestoreBatchStatus(status);
                                        restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(restoreActivityTo);
                                    }
                                }
                                NotificationHelper.setRestoreStarted((boolean)false);
                                NotificationHelper.restoreFinished = true;
                            }
                        };
                        RestoreBackup.this.restoreThread = new Thread(runnable);
                        RestoreBackup.this.restoreThread.start();
                    }
                }
            }
        });
        this.closeButton = new Button(restoreStartGroup, 8);
        this.closeButton.setLayoutData((Object)new GridData(768));
        this.closeButton.setText("Close");
        this.closeButton.setFont(this.fontsManager.getMediumNormalFont());
        this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                shell.close();
            }
        });
        Listener listener = arg0 -> {
            this.logger.debug("Closing the restore Window");
            try {
                this.restoreTimer.cancel();
                NotificationHelper.restoreFinished = false;
                if (NotificationHelper.isRestoreStarted() && this.restoreThread != null && this.restoreThread.isAlive()) {
                    this.restoreThread.stop();
                    this.restoreElement.setRestoreInterrupted(true);
                    NotificationHelper.setRestoreStarted((boolean)false);
                    this.restoreBatchUpdateBeforeExit();
                    this.logger.debug("Stopping thread for restore....");
                }
                RestoreUI.setUilock(false);
                this.disposeWidgets();
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("restoreTimer not cancelled" + e.getMessage());
            }
        };
        shell.addListener(21, listener);
        shell.pack();
        shell.open();
        shell.forceActive();
        return result;
    }

    public void restoreBatchUpdateBeforeExit() {
        String status = BackupLifeCycle.FAILED.toString();
        String restoreCount = this.restoreElement.getRestoreCount();
        RestoreActivityTO restoreActivityTo = new RestoreActivityTO();
        RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl = new RestoreActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        this.batchId = this.restoreBatchInitiated(status, this.batchId, restoreCount);
        if (this.batchId != null && this.batchId != "-1") {
            restoreActivityTo.setRestoreBatchId(this.batchId);
            restoreActivityTo.setRestoreBatchStatus(status);
            restoreActivityTo.setTotalRestoreCount(restoreCount);
            restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(restoreActivityTo);
        }
    }

    private void downloadFile() {
        boolean retry;
        AtomicInteger skipValue = new AtomicInteger(0);
        int retryCount = 0;
        int sleepMultiplier = 1;
        long sleepTime = 60000L * (long)sleepMultiplier;
        do {
            retry = false;
            try {
                if ((SettingHelper.getBackupLicenced().equalsIgnoreCase("true") || SettingHelper.getServerBackupLicensed().equalsIgnoreCase("true")) && SettingHelper.getIsExternalStorageSelected().equalsIgnoreCase("true") && !StringUtils.isEmpty((String)this.uploadIpForGateway)) {
                    int response1 = this.backupAdapter.downloadFileViaGateway1(this.uploadIpForGateway, this.port, SettingHelper.readTokenFromFile(), SettingHelper.getCloudName(), this.restoreElement, skipValue);
                    this.logger.debug("New restore all versions selected:" + this.restoreAllVersionSelected);
                    if (response1 == 204) {
                        NotificationHelper.successfulRestore = 5;
                    }
                    if (response1 != 4) {
                        NotificationHelper.successfulRestore = 0;
                    }
                    if (response1 != 4 || !"0".equalsIgnoreCase(this.restoreElement.getRestoreCount())) continue;
                    NotificationHelper.successfulRestore = 2;
                    continue;
                }
                NotificationHelper.successfulRestore = 0;
                this.logger.debug("Restore Failed");
            }
            catch (CrawlAdapterException e) {
                this.logger.debug("Exception : " + (Object)((Object)e));
                this.logger.error("Crawl Adapter Exception:" + e.getMessage());
                this.logger.debug("retry after time interval>>>" + sleepTime);
                retry = true;
                ParabluFileSystemUtils.sleepForGivenTime((long)sleepTime);
                sleepTime = 60000L * (long)sleepMultiplier;
            }
            catch (Exception e) {
                NotificationHelper.successfulRestore = 0;
                this.logger.error("unsuccessfulRestore, Exception: ", (Throwable)e);
            }
        } while (retry && retryCount < 6);
    }

    public void getBasePathFromServer(Table foldertable, String folderPath) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        foldertable.removeAll();
        this.restoreButton.setEnabled(false);
        NotificationHelper.successfulRestore = 3;
        NotificationHelper.restoreFinished = false;
        Runnable runnable = () -> {
            this.listFolders = null;
            try {
                this.listFolders = this.backupAdapter.getAllBasePathForRegisteredDevicesByUser(SettingHelper.getCurrentCloudIpAddress(), null, this.selectedItem.getDeviceId(), SettingHelper.readTokenFromFile(), folderPath);
                if (this.listFolders == null && SettingHelper.getCurrentCloudIpAddress().equals(SettingHelper.getPublicIpAddress()) && SettingHelper.getHttpsPort() != null) {
                    this.port = Integer.valueOf(SettingHelper.getHttpsPort());
                    this.listFolders = this.backupAdapter.getAllBasePathForRegisteredDevicesByUser(SettingHelper.getCurrentCloudIpAddress(), this.port, this.selectedItem.getDeviceId(), SettingHelper.readTokenFromFile(), folderPath);
                }
            }
            catch (Exception e) {
                this.logger.debug("Exception", (Throwable)e);
            }
            this.logger.debug(RESTORE_DEFAULT_STR);
            if (this.isDisposed() || this.getDisplay() == null) {
                return;
            }
            if (this.listFolders == null) {
                this.logger.debug(RESTORE_DEFAULT_STR);
                this.logger.debug("closing shell cause of z error");
                Runnable runble = () -> {
                    this.showErrorMessage();
                    this.getShell().close();
                };
                this.getDisplay().asyncExec(runble);
                return;
            }
            Runnable runner = () -> {
                this.addFolderDevicesToTable(foldertable);
                this.restoreButton.setEnabled(true);
                NotificationHelper.successfulRestore = 1;
                this.backLabel.setEnabled(true);
            };
            this.getDisplay().syncExec(runner);
        };
        new Thread(runnable).start();
    }

    private void pullRestoreDeviceListFromServer(Table table) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        NotificationHelper.restoreFinished = false;
        Runnable runnable = () -> {
            this.listDevices = null;
            try {
                this.listDevices = this.backupAdapter.getAllRegisteredDevicesByUser(SettingHelper.getCurrentCloudIpAddress(), null, SettingHelper.readTokenFromFile());
                if (this.listDevices == null && SettingHelper.getCurrentCloudIpAddress().equals(SettingHelper.getPublicIpAddress()) && SettingHelper.getHttpsPort() != null) {
                    this.port = Integer.valueOf(SettingHelper.getHttpsPort());
                    this.listDevices = this.backupAdapter.getAllRegisteredDevicesByUser(SettingHelper.getCurrentCloudIpAddress(), this.port, SettingHelper.readTokenFromFile());
                }
            }
            catch (Exception e) {
                this.logger.debug("Exception", (Throwable)e);
            }
            this.logger.debug(RESTORE_DEFAULT_STR);
            if (this.isDisposed() || this.getDisplay() == null) {
                Runnable runnble = () -> {
                    this.showErrorMessage();
                    this.getShell().close();
                };
                this.getDisplay().asyncExec(runnble);
                return;
            }
            if (this.listDevices == null || this.listDevices.isEmpty()) {
                this.logger.debug(RESTORE_DEFAULT_STR);
                this.logger.debug("closing shell cause of z error");
                Runnable runable = () -> {
                    this.showErrorMessageForDeviceListEmpty();
                    this.getShell().close();
                };
                this.getDisplay().asyncExec(runable);
                return;
            }
            Runnable rnble = () -> {
                this.addDevicesToTable(this.listDevices, table);
                this.restoreButton.setEnabled(true);
                NotificationHelper.successfulRestore = 1;
            };
            this.getDisplay().asyncExec(rnble);
        };
        new Thread(runnable).start();
    }

    private void addDevicesToTable(List<DisplayTo> listDevices, Table table) {
        for (DisplayTo deviceTo : listDevices) {
            TableItem item = new TableItem(table, 0);
            item.setText(0, deviceTo.getDeviceName());
            if (!StringUtils.isEmpty((String)deviceTo.getUserName())) {
                item.setText(1, deviceTo.getUserName());
            } else {
                item.setText(1, "");
            }
            item.setData((Object)deviceTo);
            if (deviceTo.getDeviceOsType().contains("Windows")) {
                item.setImage(0, this.imageWindows);
                continue;
            }
            item.setImage(0, this.imageMac);
        }
        for (int i = 0; i < table.getColumnCount(); ++i) {
            table.getColumn(i).pack();
        }
        table.getColumn(0).setWidth((int)((double)table.getClientArea().width * 0.5));
        table.getColumn(1).setWidth((int)((double)table.getClientArea().width * 0.5));
    }

    private void addFolderDevicesToTable(Table foldertable) {
        this.logger.debug("adding folders to the table");
        int counter = 1;
        foldertable.getColumn(0).setText("Folders/Files");
        if (this.listFolders.isEmpty() && this.previousFolderPath != null) {
            this.logger.debug("listSet is Empty:" + this.listFolders.isEmpty());
            this.logger.debug("path >>>>> " + this.previousFolderPath);
            this.showPathLabel.setText(this.previousFolderPath);
            this.fullPath = this.previousFolderPath;
            try {
                this.logger.debug("fullPath is:" + this.previousFolderPath);
                this.getBasePathFromServer(foldertable, this.previousFolderPath);
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("Exception in add folder device to table" + e.getMessage());
            }
        } else {
            this.setDataToFolderTable(foldertable, counter);
        }
    }

    private void showErrorMessage() {
        MessageBox msg = new MessageBox(this.getShell(), 34);
        msg.setText("Server unreachable");
        msg.setMessage("Cannot connect to the server. Please check the network connection and try again. If the problem persists, please contact your Administrator.");
        msg.open();
    }

    protected void createTempFile(File oldTempFile) throws IOException, InterruptedException {
        if (!oldTempFile.getParentFile().exists()) {
            oldTempFile.getParentFile().mkdirs();
        }
        if (oldTempFile.exists()) {
            oldTempFile.delete();
        }
        oldTempFile.createNewFile();
        oldTempFile.deleteOnExit();
    }

    public void startRestoreBackup() {
        if (this.restoreTimer == null) {
            this.restoreTimer = new Timer();
        }
        if (this.restoreTimerTask == null) {
            this.restoreTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        RestoreBackup.this.updateRestoreDisplay();
                    }
                    catch (Exception e) {
                        RestoreBackup.this.logger.error("error in updateRestoreDisplay", (Throwable)e);
                    }
                }
            };
            this.restoreTimer.schedule(this.restoreTimerTask, 1000L, 1000L);
        }
    }

    protected void updateRestoreDisplay() {
        if (this.getDisplay() == null) {
            return;
        }
        Runnable runnable = () -> {
            if (this.restoreButton == null || this.restoreButton.isDisposed()) {
                return;
            }
            try {
                if (NotificationHelper.isRestoreStarted()) {
                    String fileBeingRestored;
                    this.restoreButton.setEnabled(false);
                    this.closeButton.setEnabled(false);
                    this.restoreStatus.setText("Restore in progress");
                    this.restoreStatus.setFont(this.fontsManager.getSmallNormalFont());
                    this.restoreFolderGroup.setEnabled(false);
                    this.restorePathGroup.setEnabled(false);
                    this.restoreGroup.setEnabled(false);
                    this.checkBox.setEnabled(false);
                    if (!StringUtils.isEmpty((String)this.restoreElement.getFileBeingRestored())) {
                        NotificationHelper.setFileBeingRestored((String)this.restoreElement.getFileBeingRestored());
                    }
                    if ((fileBeingRestored = NotificationHelper.getFileBeingRestored()) != null && NotificationHelper.isShowFileBeingRestored()) {
                        this.currentFileBeingRestoredLabel.setVisible(true);
                        this.currentFileBeingRestoredLabel.setFont(this.fontsManager.getMediumNormalFont());
                        this.currentFileBeingRestoredLabel.setToolTipText(NotificationHelper.getFileBeingRestored());
                        this.currentRestoreStatusLabel.setVisible(true);
                        if (fileBeingRestored.length() > this.lengthForFileName) {
                            fileBeingRestored = new StringBuffer().append(fileBeingRestored.substring(0, this.lengthForFileName)).append("...").toString();
                        }
                        this.currentFileBeingRestoredLabel.setText("File being restored: " + fileBeingRestored);
                        String filesCount = this.restoreElement.getRestoreCount();
                        this.currentRestoreStatusLabel.setToolTipText("Restore in Progress. " + filesCount + "files ");
                        this.currentRestoreStatusLabel.setText("Restore in Progress. " + filesCount + "files ");
                        if (fileBeingRestored.length() > this.lengthForFileName) {
                            fileBeingRestored = new StringBuffer().append(fileBeingRestored.substring(0, this.lengthForFileName)).append("...").toString();
                        }
                        this.currentFileBeingRestoredLabel.setText("File being restored: " + fileBeingRestored);
                    }
                } else {
                    this.closeButton.setEnabled(true);
                    this.checkBox.setEnabled(true);
                    if (NotificationHelper.successfulRestore != 3) {
                        this.restoreButton.setEnabled(true);
                    }
                    this.currentFileBeingRestoredLabel.setVisible(false);
                    this.currentRestoreStatusLabel.setVisible(false);
                    this.currentRestoreStatusLabel.setText("");
                    if (NotificationHelper.restoreFinished) {
                        this.checkBox.setEnabled(true);
                        this.restoreFolderGroup.setEnabled(true);
                        this.restorePathGroup.setEnabled(true);
                        this.restoreGroup.setEnabled(true);
                        if (NotificationHelper.successfulRestore == 1) {
                            this.restoreStatus.setText("Restored successfully");
                        } else if (NotificationHelper.successfulRestore == 2) {
                            this.restoreStatus.setText("No files restored.");
                        } else if (NotificationHelper.successfulRestore == 0) {
                            if ("0".equalsIgnoreCase(this.restoreElement.getRestoreCount())) {
                                this.restoreStatus.setText("Unable to connect to the server.");
                            } else {
                                this.restoreStatus.setText("Restore completed - " + this.restoreElement.getRestoreCount() + " files ");
                            }
                        } else if (NotificationHelper.successfulRestore == 5) {
                            this.restoreStatus.setText("Error during restore. Token expired");
                        } else if (NotificationHelper.successfulRestore == 6) {
                            this.restoreStatus.setText("Restore aborted.  Please check your network connection and try again.");
                        }
                    } else if (NotificationHelper.successfulRestore == 3) {
                        this.restoreGroup.setEnabled(false);
                        this.restoreFolderGroup.setEnabled(false);
                        this.restorePathGroup.setEnabled(false);
                        this.checkBox.setEnabled(false);
                        this.queryGroup.setEnabled(false);
                        if (this.restoreLoadingStatus) {
                            this.restoreStatus.setText("Loading information..");
                        } else {
                            this.restoreStatus.setText("Loading information...");
                        }
                        this.restoreLoadingStatus = !this.restoreLoadingStatus;
                    } else {
                        this.restoreGroup.setEnabled(true);
                        this.checkBox.setEnabled(true);
                        this.restoreFolderGroup.setEnabled(true);
                        this.restorePathGroup.setEnabled(true);
                        this.queryGroup.setEnabled(true);
                        this.restoreStatus.setText("Click Restore to start restoration");
                        this.restoreStatus.setFont(this.fontsManager.getSmallNormalFont());
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("error in restoreStatus toggle", (Throwable)e);
            }
        };
        this.getDisplay().asyncExec(runnable);
    }

    public void disposeWidgets() {
        this.fontsManager.disposeFonts();
    }

    protected void checkSubclass() {
    }

    public String restoreBatchInitiated(String batchStatus, String batchId, String restoreCount) {
        String restoreBatchId;
        this.backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        String jobType = "RESTORE";
        try {
            BackupOrRestoreStatusTo backupOrRestoreStatusTo = new BackupOrRestoreStatusTo();
            backupOrRestoreStatusTo.setStatus(batchStatus);
            backupOrRestoreStatusTo.setIp(SettingHelper.getCurrentCloudIpAddress());
            backupOrRestoreStatusTo.setToken(SettingHelper.readTokenFromFile());
            backupOrRestoreStatusTo.setBatchId(batchId);
            backupOrRestoreStatusTo.setJobType(jobType);
            backupOrRestoreStatusTo.setDeviceName(SettingHelper.getDeviceName());
            backupOrRestoreStatusTo.setTotalCount(this.restoredCount);
            backupOrRestoreStatusTo.setErrorCode(909);
            backupOrRestoreStatusTo.setDeviceUUID(SettingHelper.getDeviceUUId());
            backupOrRestoreStatusTo.setTotalUploadSize(0L);
            backupOrRestoreStatusTo.setTotalUploadedCount(restoreCount);
            backupOrRestoreStatusTo.setCrawlCount(0);
            backupOrRestoreStatusTo.setCrawlTimeStamp("0");
            backupOrRestoreStatusTo.setFullBackup(false);
            backupOrRestoreStatusTo.setDiskSpaceDetails(new ParabluFileSystemUtils().getSystemSpace());
            backupOrRestoreStatusTo.setPolicyConfiguredFolders("");
            backupOrRestoreStatusTo.setRestoreDeviceUUID(this.deviceuid);
            this.setRestoreFolder(backupOrRestoreStatusTo);
            restoreBatchId = this.backupAdapter.sendEmailNotification(backupOrRestoreStatusTo);
        }
        catch (Exception e) {
            restoreBatchId = "-1";
            this.logger.trace("" + e);
            this.logger.debug(" Exception inside Sysytem Tray UI " + e.getMessage());
        }
        return restoreBatchId;
    }

    private void setRestoreFolder(BackupOrRestoreStatusTo backupOrRestoreStatusTo) {
        if (this.selectedFolder != null) {
            if (this.selectedFolder.getFileName() == null) {
                backupOrRestoreStatusTo.setRestoreFolder(this.selectedFolder.getFilePath());
            } else {
                backupOrRestoreStatusTo.setRestoreFolder(this.selectedFolder.getFileName() + "/" + this.selectedFolder.getFilePath());
            }
        } else {
            backupOrRestoreStatusTo.setRestoreFolder("All drives");
        }
    }

    private void showErrorMessageForDeviceListEmpty() {
        MessageBox msg = new MessageBox(this.getShell(), 34);
        if (RestoreHelper.licenseExpired) {
            msg.setText("License has Expired.  Please contact your Administrator.");
            msg.setMessage("License has Expired.  Please contact your Administrator.");
        } else if (RestoreHelper.deviceBlocked) {
            msg.setText(" User Device Blocked.");
            msg.setMessage(" User Device Blocked.");
        } else if (RestoreHelper.sessionExpired) {
            msg.setText(" User Device Blocked.");
            msg.setMessage(" User Device Blocked.");
        } else if (RestoreHelper.serviceUnavailable) {
            msg.setText("Service Unavailable");
            msg.setMessage("Service unavailable, please try again later");
            RestoreHelper.serviceUnavailable = false;
        } else {
            msg.setText("Device List is Empty");
            msg.setMessage("There is no device backed up for the user " + SettingHelper.getUserName());
        }
        msg.open();
    }

    private void getUploadIPForGateway() {
        if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true")) {
            try {
                GatewayTO uploadGatewayTo = PolicyManagementServerHelper.getPrivacyGatewayIP((String)"ANY", (String)"RESTORE");
                if (uploadGatewayTo != null) {
                    this.uploadIpForGateway = uploadGatewayTo.getGatewayName();
                }
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("error in get privacy gateway" + e.getMessage());
            }
            this.logger.debug("Restore Privacy Gateway IP:" + this.uploadIpForGateway);
        }
    }

    public void validatePreviousBatchStatus(RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl) {
        RestoreActivityTO activityTO = restoreActivityHistoryDAOImpl.getCurrentStatusFromRestoreActivityHistoryTable();
        if (activityTO != null && STARTED.equals(activityTO.getRestoreBatchStatus())) {
            this.logger.debug("user exit the app or network connection failed. so failed status to be sent");
            activityTO.setRestoreBatchStatus("FAILED");
            String batchIdentity = activityTO.getRestoreBatchId();
            this.logger.debug("batchid is" + batchIdentity);
            restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(activityTO);
            this.restoreBatchInitiated(activityTO.getRestoreBatchStatus(), batchIdentity, activityTO.getTotalRestoreCount());
        }
    }

    public void showupRevisions(Table foldertable, String fileName, String folderPath) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        foldertable.removeAll();
        foldertable.getColumn(0).setText("Versions");
        this.restoreButton.setEnabled(false);
        NotificationHelper.successfulRestore = 3;
        NotificationHelper.restoreFinished = false;
        Runnable runable1 = () -> {
            this.listFolders = null;
            try {
                this.listFolders = this.backupAdapter.getAllRevisionsForAFile(SettingHelper.getCurrentCloudIpAddress(), null, this.selectedItem.getDeviceId(), SettingHelper.readTokenFromFile(), folderPath, fileName);
            }
            catch (Exception e) {
                this.logger.debug(" EXCEPTION :", (Throwable)e);
            }
            this.logger.debug(RESTORE_DEFAULT_STR);
            if (this.isDisposed() || this.getDisplay() == null) {
                return;
            }
            if (this.listFolders == null) {
                this.logger.debug(RESTORE_DEFAULT_STR);
                Runnable runnable = () -> {
                    this.showErrorMessage();
                    this.getShell().close();
                };
                this.getDisplay().asyncExec(runnable);
                return;
            }
            Runnable runbl = () -> {
                this.showRevisionsInTable(foldertable);
                this.restoreButton.setEnabled(true);
                NotificationHelper.successfulRestore = 8;
                this.backLabel.setEnabled(true);
            };
            this.getDisplay().syncExec(runbl);
        };
        new Thread(runable1).start();
    }

    private void showRevisionsInTable(Table foldertable) {
        this.logger.debug("Adding folders to the table");
        ArrayList<DisplayTo> vesionsList = new ArrayList<DisplayTo>();
        int revisionCount = this.listFolders.size();
        for (DisplayTo displayTo : this.listFolders) {
            if (displayTo.getFilePath() == null || !displayTo.isExists()) {
                --revisionCount;
                continue;
            }
            displayTo.setDisplayName(" Version " + revisionCount);
            vesionsList.add(displayTo);
            --revisionCount;
        }
        if (this.listFolders.isEmpty() && this.previousFolderPath != null) {
            this.logger.debug("ListSet is Empty:" + this.listFolders.isEmpty());
            this.showPathLabel.setText(this.previousFolderPath);
            this.showPathLabel.setToolTipText(this.previousFolderPath);
            this.fullPath = this.previousFolderPath;
            try {
                this.logger.debug("Full Path is:" + this.previousFolderPath);
                this.getBasePathFromServer(foldertable, this.previousFolderPath);
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("Exception :" + e.getMessage());
            }
        } else {
            this.listFolders.clear();
            this.listFolders.addAll(vesionsList);
            this.setDataToFolderTable(foldertable, revisionCount);
        }
    }

    protected void showInfoMessage() {
        MessageBox msg = new MessageBox(this.getShell(), 34);
        msg.setText("Warning!");
        msg.setMessage("Restore operation could take many hours depending on number of files.Please ensure that system does not get into hibernate mode.\n For faster response,try restoring smaller sets of files at a time.");
        msg.open();
    }

    private int setDataToFolderTable(Table foldertable, int counter) {
        int columnCount = counter;
        foldertable.getColumn(0).setWidth((int)((double)foldertable.getClientArea().width * 0.5));
        foldertable.getColumn(1).setWidth((int)((double)foldertable.getClientArea().width * 0.3));
        foldertable.getColumn(2).setWidth((int)((double)foldertable.getClientArea().width * 0.2));
        for (DisplayTo displayTo : this.listFolders) {
            TableItem item1 = new TableItem(foldertable, 0);
            Date date = new Date(displayTo.getModifiedTime());
            if (displayTo.getDisplayName() == null) {
                displayTo.setDisplayName(displayTo.getFilePath());
            }
            item1.setText(0, displayTo.getDisplayName());
            if (Boolean.parseBoolean(displayTo.getFolder())) {
                item1.setImage(0, this.imageFolder);
                item1.setText(1, "");
                item1.setText(2, "");
            } else {
                item1.setImage(0, this.imageFile);
                item1.setText(1, this.sdf.format(date));
                item1.setText(2, String.valueOf(displayTo.getSize()));
            }
            item1.setData((Object)displayTo);
            ++columnCount;
        }
        for (int i = 0; i < foldertable.getColumnCount(); ++i) {
            foldertable.getColumn(i).pack();
        }
        foldertable.getColumn(0).setWidth((int)((double)foldertable.getClientArea().width * 0.5));
        foldertable.getColumn(1).setWidth((int)((double)foldertable.getClientArea().width * 0.3));
        foldertable.getColumn(2).setWidth((int)((double)foldertable.getClientArea().width * 0.2));
        return columnCount;
    }

    private void sortListForRestore(List<DisplayTo> list, String sortBy, boolean forwardSort) {
        Comparator comparator;
        switch (sortBy) {
            case "Folders/Files": {
                comparator = (d1, d2) -> {
                    if (forwardSort) {
                        return new CompareToBuilder().append(!Boolean.parseBoolean(d1.getFolder()), !Boolean.parseBoolean(d2.getFolder())).append((Object)d1.getDisplayName(), (Object)d2.getDisplayName()).toComparison();
                    }
                    return new CompareToBuilder().append(!Boolean.parseBoolean(d1.getFolder()), !Boolean.parseBoolean(d2.getFolder())).append((Object)d2.getDisplayName(), (Object)d1.getDisplayName()).toComparison();
                };
                break;
            }
            case "Size(KB)": {
                comparator = (d1, d2) -> {
                    if (forwardSort) {
                        return new CompareToBuilder().append(!Boolean.parseBoolean(d1.getFolder()), !Boolean.parseBoolean(d2.getFolder())).append(d1.getSize(), d2.getSize()).toComparison();
                    }
                    return new CompareToBuilder().append(!Boolean.parseBoolean(d1.getFolder()), !Boolean.parseBoolean(d2.getFolder())).append(d2.getSize(), d1.getSize()).toComparison();
                };
                break;
            }
            case "ModifiedTime": {
                comparator = (d1, d2) -> {
                    if (forwardSort) {
                        return new CompareToBuilder().append(!Boolean.parseBoolean(d1.getFolder()), !Boolean.parseBoolean(d2.getFolder())).append(d1.getModifiedTime(), d2.getModifiedTime()).toComparison();
                    }
                    return new CompareToBuilder().append(!Boolean.parseBoolean(d1.getFolder()), !Boolean.parseBoolean(d2.getFolder())).append(d2.getModifiedTime(), d1.getModifiedTime()).toComparison();
                };
                break;
            }
            case "Username": {
                comparator = (d1, d2) -> {
                    if (forwardSort) {
                        return d1.getUserName().compareTo(d2.getUserName());
                    }
                    return d2.getUserName().compareTo(d1.getUserName());
                };
                break;
            }
            default: {
                comparator = (d1, d2) -> {
                    if (forwardSort) {
                        return d1.getDeviceName().compareTo(d2.getDeviceName());
                    }
                    return d2.getDeviceName().compareTo(d1.getDeviceName());
                };
            }
        }
        Collections.sort(list, comparator);
    }

    public void closeRestoreBackup() {
        this.logger.debug("Closing restore display..");
        if (this.restoreTimer != null) {
            this.restoreTimer.cancel();
            this.restoreTimer = null;
        }
    }
}

