/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.core.adapter.BaseAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InsufficientResourcesException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class PingParacloudBlukrypt
extends BaseAdapter {
    private static HttpResponse response;
    private static final String RESPONSE_CODE = "Response Code: ";
    private static final String IO_EXCEPTION = "IOException ";
    private static final String CLIENT_PROTOCOL_EXCEPTION = "ClientProtocol Exception ";
    private static final String EXCEPTION = "Exception :";
    int deviceuuidCount = 0;
    static String IpAddr;
    static String url;
    static String ipaddrBluKrypt;
    static String urlBluKrypt;
    static String cloudName;
    public static final String FILE_SEPARATOR;
    static final Map<String, String> resultMap1;

    public PingParacloudBlukrypt(String cloudName, String keyStorePath) {
        super(cloudName, keyStorePath);
    }

    public static void main(String[] args) {
        try {
            String basePath = System.getProperty("user.home") + StringLiterals.FILE_SEPARATOR + ".ParaBlu" + FILE_SEPARATOR + "Parablu" + FILE_SEPARATOR + "Blusync" + FILE_SEPARATOR + "config.txt";
            PingParacloudBlukrypt.main1(basePath, "192.168.7.58", "/paracloud/ping/");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main1(String path, String paracloudIp, String paracloudurl) throws Exception {
        System.setOut(new PrintStream(System.out));
        PropertiesConfiguration config = null;
        System.out.println("Hello world!!");
        try {
            config = new PropertiesConfiguration(path);
        }
        catch (ConfigurationException e) {
            System.out.println("Config file error happened" + e.getMessage());
            try {
                new PingParacloudBlukrypt(cloudName, "keystore.jks");
                String responseCode2 = PingParacloudBlukrypt.pingGatewayIP(paracloudIp, paracloudurl, "testUtilityPvn");
                System.out.println(responseCode2);
                resultMap1.put(paracloudIp, responseCode2);
                for (Map.Entry<String, String> entry : resultMap1.entrySet()) {
                    String result1 = entry.getValue();
                    String[] resultValue = entry.getValue().split("##");
                    if (resultValue[0].equalsIgnoreCase(String.valueOf(200)) || resultValue[0].equalsIgnoreCase(String.valueOf(400))) {
                        result1 = "SUCCESS";
                    }
                    if (result1.equalsIgnoreCase("SUCCESS")) {
                        System.out.println("IP: " + entry.getKey() + " ResponseCode:" + result1 + " Time taken in sec " + resultValue[1]);
                        continue;
                    }
                    System.out.println("IP: " + entry.getKey() + " ResponseCode:" + result1);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return;
        }
        IpAddr = config.getProperty("IpAddr").toString();
        url = config.getProperty("Url").toString();
        ipaddrBluKrypt = config.getProperty("IpaddrBluKrypt").toString();
        urlBluKrypt = config.getProperty("UrlBluKrypt").toString();
        cloudName = config.getProperty("CloudName").toString();
        if (StringUtils.isEmpty((String)IpAddr) || StringUtils.isEmpty((String)url) || StringUtils.isEmpty((String)cloudName)) {
            throw new InsufficientResourcesException("Insufficient Data...");
        }
        IpAddr = IpAddr.replace("[", "");
        IpAddr = IpAddr.replace("]", "");
        ipaddrBluKrypt = ipaddrBluKrypt.replace("[", "");
        ipaddrBluKrypt = ipaddrBluKrypt.replace("]", "");
        List<String> IpAddrList = Arrays.asList(IpAddr.split(","));
        List<String> ipaddrBluKryptList = Arrays.asList(ipaddrBluKrypt.split(","));
        new PingParacloudBlukrypt(cloudName, "keystore.jks");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (String Ip : IpAddrList) {
            Ip = Ip.trim();
            System.out.println(String.valueOf(IpAddr) + " Pinging Ip:" + Ip);
            String responseCode = PingParacloudBlukrypt.pingGatewayIP(Ip, url, "testUtilityPvn");
            resultMap.put(Ip, responseCode);
        }
        System.out.println(" Pinging Ip:" + ipaddrBluKryptList.size());
        ipaddrBluKryptList.forEach(System.out::println);
        for (String Ip2 : ipaddrBluKryptList) {
            Ip2 = Ip2.trim();
            System.out.println(String.valueOf(IpAddr) + " Blu Pinging Ip:" + Ip2);
            String responseCode2 = PingParacloudBlukrypt.pingGatewayIP(Ip2, urlBluKrypt, "testUtilityPvn");
            resultMap.put(Ip2, responseCode2);
        }
        System.out.println("#################################################################");
        for (Map.Entry entry : resultMap.entrySet()) {
            String result = (String)entry.getValue();
            String[] resultValue = ((String)entry.getValue()).split("##");
            if (resultValue[0].equalsIgnoreCase(String.valueOf(200)) || resultValue[0].equalsIgnoreCase(String.valueOf(400))) {
                result = "SUCCESS";
            }
            if (result.equalsIgnoreCase("SUCCESS")) {
                System.out.println("IP: " + (String)entry.getKey() + " ResponseCode:" + result + " Time taken in sec " + resultValue[1]);
                continue;
            }
            System.out.println("IP: " + (String)entry.getKey() + " ResponseCode:" + result);
        }
        System.out.println("#################################################################");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String pingGatewayIP(String gatewayIP, String url, String deviceUUID) {
        String responseValue = "";
        URI uri = PingParacloudBlukrypt.formHttpsUri((String)gatewayIP, (String)url);
        long millis = System.currentTimeMillis();
        HttpGet httpGet = new HttpGet(uri.toString());
        try {
            System.out.println("URL:" + uri + httpGet);
            System.out.println(deviceUUID);
            httpGet.setHeader("deviceUUID", deviceUUID);
            response = httpclient.execute((HttpUriRequest)httpGet);
        }
        catch (Exception e3) {
            e3.printStackTrace();
            System.out.println("Exception ::" + e3.getMessage());
            System.out.println("" + e3);
            PingParacloudBlukrypt.closeResponseEntity();
            httpGet = null;
            String string = responseValue;
            return string;
        }
        finally {
            if (httpGet != null) {
                httpGet.abort();
                httpGet = null;
            }
            PingParacloudBlukrypt.closeResponseEntity();
        }
        if (httpGet != null) {
            httpGet.abort();
            httpGet = null;
        }
        PingParacloudBlukrypt.closeResponseEntity();
        responseValue = String.valueOf(response.getStatusLine().getStatusCode());
        long milliSecoundsTaken = System.currentTimeMillis() - millis;
        long sec = milliSecoundsTaken / 1000L % 60L;
        System.out.println("$$PING RESPONSE FOR GATEWAY IS " + responseValue + " time taken in seconds :" + milliSecoundsTaken / 1000L % 60L);
        PingParacloudBlukrypt.closeResponseEntity();
        httpGet = null;
        return responseValue + "##" + sec;
    }

    public static void closeResponseEntity() {
        block6: {
            try {
                if (response == null || response.getEntity() == null || !response.getEntity().isStreaming()) break block6;
                try {
                    if (response.getEntity().getContent() != null) {
                        response.getEntity().getContent().close();
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                    System.out.println("" + e);
                }
                catch (Exception e2) {
                    System.out.println("Exception in closing response entity");
                    System.out.println("" + e2);
                }
            }
            catch (Exception e2) {
                System.out.println("Exception in closing response entity outside");
                System.out.println("" + e2);
            }
        }
    }

    private static void lambda$0(String k, Integer v) {
        String result = "" + v;
        if (v == 200 || v == 400) {
            result = "SUCCESS";
        }
        System.out.println("IP: " + k + " ResponseCode:" + result);
    }

    static {
        FILE_SEPARATOR = System.getProperty("file.separator");
        resultMap1 = new HashMap<String, String>();
        response = null;
    }
}

