/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.notifications;

import com.parablu.epa.common.service.notification.EventHandler;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.service.support.SupportHelper;
import com.parablu.epa.service.alarm.BlusyncThreadHelper;
import com.parablu.epa.service.backup.MacCheckBackupPolicy;
import com.parablu.epa.service.sync.MacCheckSyncPolicy;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacEventsManagement {
    private Logger logger = LoggerFactory.getLogger(MacEventsManagement.class);
    private EventHandler eventHandler = new EventHandler();

    public void refreshPolicyTask() {
        List events = this.eventHandler.checkNotificationFromServer();
        events.forEach(action -> {
            if (EventHandler.Actions.PULL_AGENTLOGS.name().equalsIgnoreCase((String)action)) {
                if (SupportHelper.isSupportRequestInitiated()) {
                    this.logger.debug("isSupportRequestInitiated: " + SupportHelper.isSupportRequestInitiated());
                    return;
                }
                SupportHelper.sendNewSupportLogs((String)SettingHelper.getCloudName(), (String)SettingHelper.getUserName(), (String)SettingHelper.getDeviceName(), (boolean)true);
            }
            if (EventHandler.Actions.BACKUPPOLICY_REFRESH.name().equalsIgnoreCase((String)action)) {
                if (NotificationHelper.backUpStarted) {
                    MacCheckBackupPolicy.resetTimers();
                } else {
                    MacCheckBackupPolicy.checkGroupPolicy();
                }
                BlusyncThreadHelper.resetBackupTimer();
            }
            if (EventHandler.Actions.STOP_BACKUP.name().equalsIgnoreCase((String)action) && NotificationHelper.isBackUpStarted()) {
                this.logger.debug("Calling stop backup.");
                BlusyncThreadHelper.cancelCurrentBackupProcess(true);
            }
            if (EventHandler.Actions.SYNCPOLICY_REFRESH.name().equalsIgnoreCase((String)action) && SettingHelper.getSyncLicenced().equals("true")) {
                MacCheckSyncPolicy.checkSyncPolicy();
                BlusyncThreadHelper.resetSyncTimer();
            }
        });
    }
}

