/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.backup;

import com.parablu.epa.common.service.backup.MultiThreadBackupUpload;
import com.parablu.epa.common.service.backup.NewBackUpJob;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.core.to.DedupTO;
import com.parablu.epa.helper.BackupCrawlUtility;
import com.parablu.epa.service.alarm.BlusyncThreadHelper;
import com.parablu.epa.service.backup.MacBackupUploadJob;
import com.parablu.epa.service.backup.MacCheckBackupPolicy;
import com.parablu.epa.service.notifications.UIHelper;
import com.parablu.epa.service.settings.MacSettingsHelper;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacBackupJob
extends NewBackUpJob {
    private static Logger logger = LoggerFactory.getLogger(MacBackupJob.class);
    private MultiThreadBackupUpload backUpUpload = null;

    public MacBackupJob(boolean manualVal) {
        super(manualVal);
    }

    public void startBackUpThread(Set<DedupTO> dedupTOs, boolean restart, long restartId, String backupType) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        this.backUpUpload = new MacBackupUploadJob(SettingHelper.getCurrentCloudIpAddress(), this.currentPort, SettingHelper.getCloudName(), SettingHelper.readTokenFromFile(), SettingHelper.getBackUpDbUrl(), dedupTOs, restart, restartId, backupType);
        this.backUpUpload.setName("BackUpUpload");
        this.backUpUpload.start();
        this.backUpUpload.join();
    }

    public void updateSystrayToolTipNotification(String toolTipMessage, String toolTipmessage1) {
        UIHelper.updateSystrayToolTipNotification(toolTipMessage, toolTipmessage1);
    }

    protected void scanFileSystemByType(BackupFolderTO backupFolderTO) {
        BackupCrawlUtility backupCrawlUtility = new BackupCrawlUtility();
        backupCrawlUtility.crawlFolderEfficientStoringFullPaths(backupFolderTO.getFolderPath(), null);
    }

    public void updateSystrayImageAccordingToStage(String syncingImage) {
        if (NotificationHelper.getMainStatus() == 100) {
            UIHelper.updateSystrayImageAccordingToStage(MacSettingsHelper.baseResourceFolder + syncingImage);
        } else {
            UIHelper.displaySyncingGif();
        }
    }

    public void pauseBackup(boolean isManualStop) {
        if (this.backUpUpload != null && this.backUpUpload.isAlive()) {
            try {
                logger.debug("stopping the thread");
                this.backUpUpload.interrupt();
                if (isManualStop) {
                    PolicyManagementServerHelper.updateFailCodeToActivityHistory((int)1992);
                }
                logger.debug("Interrupted backup thread");
                this.backUpUpload.join(10000L);
                this.backUpUpload.interrupt();
                logger.debug("Interrupted backup thread again");
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Exception" + e.getMessage());
            }
        }
    }

    public void createVsnapshot(List<BackupFolderTO> arg0) {
    }

    public void deleteVsnapshot(List<BackupFolderTO> arg0) {
    }

    public boolean runScripts(String arg0, boolean arg1) {
        return true;
    }

    public void startBackupPolicyRefresh() {
        MacCheckBackupPolicy.checkGroupPolicy();
        BlusyncThreadHelper.resetBackupTimer();
    }

    public void updateSystrayToolTipNotification() {
        UIHelper.updateSystrayToolTipNotification("Parablu Blusync", "You have no folders configured for backup");
    }
}

