/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.adapter.pcb;

import com.parablu.epa.core.adapter.BaseAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.ChunkFileElement;
import com.parablu.epa.core.element.SyncPolicyElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.exception.UploadChunkFileException;
import com.parablu.epa.core.service.transformer.Xmlparser;
import com.parablu.epa.core.to.FileTO;
import com.parablu.epa.core.to.GzipTO;
import com.parablu.epa.core.to.ResponseTO;
import com.parablu.epa.helper.utils.MD5Generator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.NoRouteToHostException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncAdapter
extends BaseAdapter {
    private static final String PARACLOUD_DELTA_URL = "/crawl/delta";
    private static final String PARACLOUD_UPLOAD_FILE = "/upload";
    private static final String PARACLOUD_DOWNLOAD_FILE = "/download/";
    private static final String PARACLOUD_DOD_DOWNLOAD_FILE = "/download/thumbnail/";
    private static final String PARACLOUD_CRAWL_INITIATE_URL = "/crawl/initiate";
    private static final String UPLOAD_CHUNK_FILES = "/sync/upload/file/chunks/";
    private static final String IO_EXCEPTION = "IOException :";
    private static final String ERROR_MESSAGE = "errorMessage";
    private static final String EXCEPTION = "Exception ";
    private static final String CLIENT_PROTOCOL_EXCEPTION = "ClientProtocol Exception ";
    private static final String IOEXCEPTION_OCCURED = "IOException occured";
    private static final String CHUNK_FILE_DISK_FULL_EXCEPTION = "ChunkFile Disk Full  Exception ";
    private static final String CHUNK_FILE_USER_STORAGE_EXCEED_EXCEPTION = "ChunkFile User Limit Exceed ";
    private static final String PARACLOUD_MC_DELTA_URL = "/crawl/mc/delta";
    private static final String FILE_NOT_FOUND_EXCEPTION = "FileNotFoundException :";
    private static final String INTO_DOWNLOAD_FILE = "Entering DownloadFile";
    private static final String IS_DOD = "isDod: ";
    private static final String DOWNLOAD_FILE_URL = "Download File Url: ";
    private static final String DOWNLOAD_NULL_RESPONSE = "Download Response is null";
    private static final String DOWNLOAD_RESPONSE_CODE = "The response code for download is :";
    private static final String INSIDE_CATCH_BLOCK = "Inside Catch";
    private static final String NO_ROUTE_TO_HOST_EXCEPTION = "NoRouteToHostException ";
    private static final String HTTP_HOST_CONNECT_EXCEPTION = "HttpHostConnectException ";
    private static final String UNKNOWN_HOST_EXCEPTION = "UnknownHostException ";
    private static final Logger logger = LoggerFactory.getLogger(SyncAdapter.class);
    private HttpResponse response = null;
    private HttpPut httpPut = null;
    private HttpGet httpGet = null;
    private HttpPost httpPost = null;
    private MultipartEntity entity = null;

    public SyncAdapter(String cloudName, String keyStorePath) {
        super(cloudName, keyStorePath);
    }

    public ResponseTO initiateCrawlRequest(String ip, Integer port, String token) {
        logger.debug("Entering : ParacloudAdapter.initiateCrawlRequest");
        this.response = null;
        HttpPost httppost = null;
        int responseCode = 0;
        String responseXmlAsString = null;
        ResponseTO crawlresponseObject = null;
        try {
            URI uri = port != null ? SyncAdapter.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_CRAWL_INITIATE_URL) : SyncAdapter.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_CRAWL_INITIATE_URL);
            logger.debug(uri.toString());
            httppost = new HttpPost(uri);
            httppost.setHeader("Content-Type", "text/xml");
            httppost.setHeader("token", token);
            this.response = httpclient.execute((HttpUriRequest)httppost);
            responseCode = this.response.getStatusLine().getStatusCode();
            logger.debug("Response Code" + responseCode);
            crawlresponseObject = new ResponseTO();
            responseXmlAsString = this.parseResponseFromResponseEntityForDeltaRequest(responseCode, crawlresponseObject);
            crawlresponseObject.setResponse(responseXmlAsString);
        }
        catch (ClientProtocolException e) {
            logger.error(CLIENT_PROTOCOL_EXCEPTION + e.getMessage());
            logger.trace("" + (Object)((Object)e));
            responseCode = 404;
            crawlresponseObject = new ResponseTO();
            crawlresponseObject.setResponseCode(responseCode);
        }
        catch (NoRouteToHostException e) {
            logger.error(NO_ROUTE_TO_HOST_EXCEPTION + e);
            responseCode = 404;
            crawlresponseObject = new ResponseTO();
            crawlresponseObject.setResponseCode(responseCode);
        }
        catch (HttpHostConnectException e) {
            logger.error("Ip Incorrect; HttpHostConnectException: " + (Object)((Object)e));
            responseCode = 404;
            crawlresponseObject = new ResponseTO();
            crawlresponseObject.setResponseCode(responseCode);
        }
        catch (UnknownHostException e) {
            logger.error("Ip Incorrect; UnknownHostException: " + e);
            responseCode = 404;
            crawlresponseObject = new ResponseTO();
            crawlresponseObject.setResponseCode(responseCode);
        }
        catch (IOException e) {
            logger.error(IO_EXCEPTION + e.getMessage());
            logger.trace("" + e);
            responseCode = 404;
            crawlresponseObject = new ResponseTO();
            crawlresponseObject.setResponseCode(responseCode);
        }
        this.closeResponseEntity();
        return crawlresponseObject;
    }

    private String parseResponseFromResponseEntityForDeltaRequest(int responseCode, ResponseTO crawlresponseObject) throws IOException {
        String responseXmlAsString = null;
        if (responseCode == 200) {
            HttpEntity responseEntity = this.response.getEntity();
            if (responseEntity != null) {
                responseXmlAsString = EntityUtils.toString((HttpEntity)responseEntity);
            }
        } else if (responseCode == 500 || responseCode == 400) {
            if (this.response.getStatusLine() != null) {
                logger.debug(this.response.getStatusLine().getReasonPhrase());
            }
            if (this.response.getFirstHeader(ERROR_MESSAGE) != null) {
                logger.debug(this.response.getFirstHeader(ERROR_MESSAGE).getValue());
            }
        }
        crawlresponseObject.setResponseCode(responseCode);
        return responseXmlAsString;
    }

    private void closeResponseEntity() {
        if (this.response != null && this.response.getEntity() != null && this.response.getEntity().isStreaming()) {
            try {
                this.response.getEntity().getContent().close();
            }
            catch (IOException e) {
                logger.error(e.getMessage());
                logger.trace("" + e);
            }
        }
    }

    public GzipTO getDeltaGzip(byte[] b, String ip, Integer port, String miniCloudId, String baseFolderName, String token) throws CrawlAdapterException {
        logger.trace("Entering : ParacloudAdapter.getDelta");
        this.response = null;
        HttpPost httppost = null;
        ByteArrayEntity httpEntity = null;
        int responseCode = 0;
        GzipTO crawlresponseObject = null;
        try {
            URI uri = port != null ? ("0".equals(miniCloudId) ? SyncAdapter.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_DELTA_URL) : SyncAdapter.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_MC_DELTA_URL)) : ("0".equals(miniCloudId) ? SyncAdapter.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_DELTA_URL) : SyncAdapter.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_MC_DELTA_URL));
            logger.debug(uri.toString());
            httppost = new HttpPost(uri);
            httppost.setHeader("Content-Type", "text/xml");
            httppost.setHeader("Content-Encoding", "gzip");
            httppost.setHeader("multi-cloud-id", String.valueOf(miniCloudId));
            httppost.setHeader("file-path", baseFolderName);
            httppost.setHeader("token", token);
            httpEntity = new ByteArrayEntity(b);
            httppost.setEntity((HttpEntity)httpEntity);
            this.response = httpclient.execute((HttpUriRequest)httppost);
            if (this.response == null) {
                logger.error("Resonse for registration is null");
                throw new CrawlAdapterException("Response is null");
            }
            responseCode = this.response.getStatusLine().getStatusCode();
            logger.debug("Response code: " + responseCode);
            logger.trace(String.valueOf(responseCode));
            crawlresponseObject = this.downloadGzipResponseAsByteArray(responseCode);
        }
        catch (ClientProtocolException e) {
            logger.error(CLIENT_PROTOCOL_EXCEPTION + e.getMessage());
            logger.trace("" + (Object)((Object)e));
            responseCode = 404;
            crawlresponseObject = new GzipTO();
            crawlresponseObject.setResponseCode(responseCode);
        }
        catch (NoRouteToHostException e) {
            logger.error(NO_ROUTE_TO_HOST_EXCEPTION + e);
            responseCode = 404;
            crawlresponseObject = new GzipTO();
            crawlresponseObject.setResponseCode(responseCode);
        }
        catch (HttpHostConnectException e) {
            logger.error("Ip Incorrect " + (Object)((Object)e));
            responseCode = 404;
            crawlresponseObject = new GzipTO();
            crawlresponseObject.setResponseCode(responseCode);
        }
        catch (UnknownHostException e) {
            logger.error(UNKNOWN_HOST_EXCEPTION + e);
            responseCode = 404;
            crawlresponseObject = new GzipTO();
            crawlresponseObject.setResponseCode(responseCode);
        }
        catch (IOException e) {
            logger.error(IO_EXCEPTION + e.getMessage());
            logger.trace("" + e);
            responseCode = 404;
            crawlresponseObject = new GzipTO();
            crawlresponseObject.setResponseCode(responseCode);
        }
        this.closeResponseEntity();
        return crawlresponseObject;
    }

    private GzipTO downloadGzipResponseAsByteArray(int responseCode) throws IOException {
        GzipTO crawlresponseObject = new GzipTO();
        if (responseCode == 200) {
            HttpEntity responseEntity = this.response.getEntity();
            if (responseEntity != null) {
                try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    IOUtils.copy((InputStream)responseEntity.getContent(), (OutputStream)outputStream);
                    logger.trace("copying done");
                    crawlresponseObject.setResponse(outputStream.toByteArray());
                }
                catch (IOException e) {
                    throw new IOException(IOEXCEPTION_OCCURED, e);
                }
            }
        } else if (responseCode == 500 || responseCode == 400) {
            if (this.response.getStatusLine() != null) {
                logger.debug(this.response.getStatusLine().getReasonPhrase());
            }
            if (this.response.getFirstHeader(ERROR_MESSAGE) != null) {
                logger.debug(this.response.getFirstHeader(ERROR_MESSAGE).getValue());
            }
        }
        crawlresponseObject.setResponseCode(responseCode);
        return crawlresponseObject;
    }

    public int uploadFile(FileTO fileTO, String ip, Integer port, String tempPath, StringBuilder conflictedData, String token) throws CrawlAdapterException {
        logger.trace("Entering : ParacloudAdapter.uploadFile: Trying to upload:" + fileTO.getFileName());
        this.response = null;
        File file = null;
        try {
            URI uri = port != null ? SyncAdapter.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_UPLOAD_FILE) : SyncAdapter.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_UPLOAD_FILE);
            logger.trace(uri.toString());
            this.httpPut = new HttpPut(uri);
            logger.debug("File to upload: " + fileTO.getFileName());
            if (!fileTO.isFolder()) {
                file = new File(tempPath);
                this.setHeaderToHttpPutForFileUpload(fileTO, file, token, fileTO.getMiniCloudId());
                this.httpPut.setEntity((HttpEntity)new FileEntity(file, "binary/octet-stream"));
            } else {
                this.setHeaderToHttpPutForFileUpload(fileTO, null, token, fileTO.getMiniCloudId());
            }
            this.response = httpclient.execute((HttpUriRequest)this.httpPut);
            logger.trace("uploaded");
        }
        catch (ClientProtocolException e) {
            logger.error(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e));
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + (Object)((Object)e), e);
        }
        catch (FileNotFoundException e) {
            logger.error(FILE_NOT_FOUND_EXCEPTION + e.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        catch (IOException e) {
            logger.error(IO_EXCEPTION + e.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        int responseValue = this.parseUploadResponse(conflictedData);
        this.closeResponseEntity();
        this.httpPut = null;
        return responseValue;
    }

    public HttpPut getHttpPut() {
        return this.httpPut;
    }

    public void cancelHttpPut() {
        if (this.httpPut != null) {
            this.httpPut.abort();
            this.httpPut = null;
        }
    }

    private void setHeaderToHttpPutForFileUpload(FileTO fileTO, File file, String token, String minCloudId) {
        this.httpPut.setHeader("header-encoding", "base64");
        this.httpPut.setHeader("multi-cloud-id", String.valueOf(minCloudId));
        this.httpPut.setHeader("file-name", this.encodeUTFBase64(fileTO.getFileName()));
        this.httpPut.setHeader("modified", String.valueOf(fileTO.getLastModifiedTimestamp()));
        this.httpPut.setHeader("file-path", this.encodeUTFBase64(fileTO.getAbstractFilePath()));
        this.httpPut.setHeader("meta-data", this.encodeUTFBase64(fileTO.getMetaData()));
        this.httpPut.setHeader("is-folder", String.valueOf(fileTO.isFolder()));
        this.httpPut.setHeader("is-exists", String.valueOf(fileTO.isExists()));
        this.httpPut.setHeader("fileMD5", fileTO.getMd5checksum());
        this.httpPut.setHeader("token", token);
        if (file != null) {
            this.httpPut.setHeader("file-size", String.valueOf(file.length()));
        } else {
            this.httpPut.setHeader("file-size", "0");
        }
    }

    private int parseUploadResponse(StringBuilder conflictedData) {
        int responseValue;
        if (this.response == null) {
            responseValue = 1;
        } else if (this.response.getStatusLine().getStatusCode() != 200 && this.response.getStatusLine().getStatusCode() != 409) {
            logger.trace(this.response.getStatusLine().getReasonPhrase());
            logger.trace("response status code" + this.response.getStatusLine().getStatusCode());
            responseValue = 2;
            if (this.response.getStatusLine().getStatusCode() != 507 && this.response.getStatusLine().getStatusCode() != 419) {
                if (this.response.getStatusLine().getStatusCode() == 416) {
                    responseValue = 1005;
                } else if (this.response.getStatusLine().getStatusCode() == 420) {
                    responseValue = 1009;
                } else if (this.response.getStatusLine().getStatusCode() == 401) {
                    responseValue = 1010;
                } else if (this.response.getStatusLine().getStatusCode() == 421) {
                    responseValue = 1008;
                } else {
                    Header header = this.response.getFirstHeader(ERROR_MESSAGE);
                    if (header != null) {
                        logger.trace("ErrorMessage:" + header.getValue());
                    }
                }
            } else {
                responseValue = this.response.getStatusLine().getStatusCode() == 507 ? 1007 : 1006;
            }
        } else if (this.response.getStatusLine().getStatusCode() == 200) {
            responseValue = 3;
        } else {
            logger.trace("Status code:" + this.response.getStatusLine().getStatusCode());
            logger.trace(this.response.getStatusLine().getReasonPhrase());
            responseValue = 4;
            if (conflictedData != null) {
                conflictedData.append(this.response.getFirstHeader("upload-conflict").getValue());
            }
        }
        return responseValue;
    }

    public int downloadFile1(String ip, FileTO fileTO, Integer port, File downTempFile, boolean isDod, String token) throws CrawlAdapterException {
        String downloadFileUrl;
        logger.trace(INTO_DOWNLOAD_FILE);
        boolean fileTransferSuccess = true;
        String md5ofDownloadedFile = "";
        if (isDod) {
            logger.debug(IS_DOD + isDod);
            downloadFileUrl = "/paracloud/cloud" + this.cloudName + PARACLOUD_DOD_DOWNLOAD_FILE;
        } else {
            downloadFileUrl = "/paracloud/cloud" + this.cloudName + PARACLOUD_DOWNLOAD_FILE;
        }
        try {
            String filePath = fileTO.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + fileTO.getFileName();
            logger.debug("File Path" + filePath);
            logger.debug(DOWNLOAD_FILE_URL + downloadFileUrl);
            URI uri = port != null ? SyncAdapter.formHttpsUri(ip, port, downloadFileUrl) : SyncAdapter.formHttpsUri(ip, downloadFileUrl);
            logger.debug(uri.toString());
            this.httpGet = new HttpGet(uri);
            this.httpGet.setHeader("relative-path", filePath);
            this.httpGet.setHeader("multi-cloud-id", String.valueOf(fileTO.getMiniCloudId()));
            this.httpGet.setHeader("token", token);
            this.response = httpclient.execute((HttpUriRequest)this.httpGet);
        }
        catch (ClientProtocolException e) {
            logger.error(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e));
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + (Object)((Object)e), e);
        }
        catch (FileNotFoundException e) {
            logger.error(FILE_NOT_FOUND_EXCEPTION + e);
            logger.error(EXCEPTION + e);
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        catch (IOException ex) {
            logger.trace("" + ex);
            logger.error(IO_EXCEPTION + ex.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(ex.getMessage(), ex);
        }
        if (this.response == null) {
            logger.trace(DOWNLOAD_NULL_RESPONSE);
            this.closeResponseEntity();
            return 1;
        }
        if (this.response.getStatusLine().getStatusCode() != 200) {
            logger.trace(DOWNLOAD_RESPONSE_CODE + this.response.getStatusLine().getStatusCode());
            int responseStatusCode = this.response.getStatusLine().getStatusCode();
            this.closeResponseEntity();
            if (responseStatusCode == 507) {
                return 5;
            }
            if (responseStatusCode == 416) {
                return 1005;
            }
            if (responseStatusCode == 401) {
                return 1010;
            }
            if (this.response.getStatusLine().getStatusCode() == 420) {
                return 1009;
            }
            if (this.response.getStatusLine().getStatusCode() == 421) {
                return 1008;
            }
            return 2;
        }
        return this.parseResponseEntityAndDownloadFileToTempFolder(fileTO, downTempFile, isDod, fileTransferSuccess, md5ofDownloadedFile);
    }

    private int parseResponseEntityAndDownloadFileToTempFolder(FileTO fileTO, File downTempFile, boolean isDod, boolean fileTransferSuccess, String md5ofDownloadedFile) {
        String md5;
        InputStream inTemp;
        HttpEntity resEntity = this.response.getEntity();
        String md5ofDownloadedFileTemp = md5ofDownloadedFile;
        boolean fileTransferSuccessTemp = fileTransferSuccess;
        if (!isDod) {
            md5ofDownloadedFileTemp = this.response.getFirstHeader("fileMD5").getValue();
        }
        logger.debug("MD5 of file: " + fileTO.getFileName() + " is " + md5ofDownloadedFileTemp);
        try {
            inTemp = resEntity.getContent();
        }
        catch (Exception e) {
            this.closeResponseEntity();
            logger.trace(EXCEPTION + e);
            return 3;
        }
        fileTransferSuccessTemp = this.downloadFileFromServerUsingTheInputStream(inTemp, downTempFile, fileTransferSuccessTemp);
        this.closeResponseEntity();
        if (!fileTransferSuccessTemp) {
            return 3;
        }
        logger.trace("Will generate MD5 and checking " + new Date().toString() + " " + downTempFile);
        if (!isDod && !(md5 = MD5Generator.generateMD5OfFile((File)downTempFile)).equals(md5ofDownloadedFileTemp)) {
            logger.debug("Md5 mis match " + md5);
            return 3;
        }
        fileTO.setMd5checksum(md5ofDownloadedFileTemp);
        logger.trace("Generating MD5 and checking done" + new Date().toString());
        this.httpGet = null;
        return 4;
    }

    public int downloadFile(String ip, FileTO fileTO, Integer port, File downTempFile, boolean isDod, String token, String userName) throws CrawlAdapterException {
        String downloadFileUrl;
        logger.trace(INTO_DOWNLOAD_FILE);
        boolean fileTransferSuccess = true;
        String md5ofDownloadedFile = "";
        if (isDod) {
            logger.debug(IS_DOD + isDod);
            downloadFileUrl = "/paracloud/cloud" + this.cloudName + PARACLOUD_DOD_DOWNLOAD_FILE;
        } else {
            downloadFileUrl = "/BluKryptBuilder/cloud" + this.cloudName + "/sync/download/file/";
        }
        try {
            String filePath = fileTO.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + fileTO.getFileName();
            logger.debug("File Path" + filePath);
            logger.debug(DOWNLOAD_FILE_URL + downloadFileUrl);
            URI uri = port != null ? SyncAdapter.formHttpsUri(ip, port, downloadFileUrl) : SyncAdapter.formHttpsUri(ip, downloadFileUrl);
            logger.debug(uri.toString());
            this.httpGet = new HttpGet(uri);
            this.httpGet.setHeader("relative-path", filePath);
            this.httpGet.setHeader("multi-cloud-id", String.valueOf(fileTO.getMiniCloudId()));
            this.httpGet.setHeader("token", token);
            this.httpGet.setHeader("file-name", fileTO.getFileName());
            this.httpGet.setHeader("syncRevisionId", fileTO.getFileRevisionId());
            this.httpGet.setHeader("userName", userName);
            logger.debug("Revision Id.............>>>>>>>>>>>>>>" + fileTO.getFileRevisionId());
            this.response = httpclient.execute((HttpUriRequest)this.httpGet);
        }
        catch (ClientProtocolException e) {
            logger.error(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e));
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + (Object)((Object)e), e);
        }
        catch (FileNotFoundException e) {
            logger.error(FILE_NOT_FOUND_EXCEPTION + e);
            logger.error(EXCEPTION + e);
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        catch (IOException ex) {
            logger.trace("" + ex);
            logger.error(IO_EXCEPTION + ex.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(ex.getMessage(), ex);
        }
        if (this.response == null) {
            logger.trace(DOWNLOAD_NULL_RESPONSE);
            this.closeResponseEntity();
            return 1;
        }
        if (this.response.getStatusLine().getStatusCode() != 200) {
            logger.debug(DOWNLOAD_RESPONSE_CODE + this.response.getStatusLine().getStatusCode());
            int responseStatusCode = this.response.getStatusLine().getStatusCode();
            this.closeResponseEntity();
            if (responseStatusCode == 507) {
                return 5;
            }
            if (responseStatusCode == 416) {
                return 1005;
            }
            if (responseStatusCode == 401) {
                return 1010;
            }
            if (this.response.getStatusLine().getStatusCode() == 420) {
                return 1009;
            }
            if (this.response.getStatusLine().getStatusCode() == 421) {
                return 1008;
            }
            return 2;
        }
        logger.debug(DOWNLOAD_RESPONSE_CODE + this.response.getStatusLine().getStatusCode());
        return this.parseResponseEntityAndDownloadFileToTempFolder(fileTO, downTempFile, isDod, fileTransferSuccess, md5ofDownloadedFile);
    }

    public int uploadFileToBluKrypt(FileTO fileTO, String ip, Integer port, StringBuilder conflictedData, String token) throws CrawlAdapterException {
        logger.trace("Entering : ParacloudAdapter.uploadFile: Trying to upload:" + fileTO.getFileName());
        this.response = null;
        try {
            URI uri = port != null ? SyncAdapter.formHttpsUri(ip, port, "/BluKryptBuilder/sync/upload/file/") : SyncAdapter.formHttpsUri(ip, "/BluKryptBuilder/sync/upload/file/");
            logger.trace(uri.toString());
            this.httpPost = new HttpPost(uri);
            logger.debug("File: " + fileTO.getFileName());
            this.entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            this.entity.addPart("gatewayName", (ContentBody)new StringBody(ip));
            this.entity.addPart("fileMD5", (ContentBody)new StringBody(fileTO.getMd5checksum()));
            this.entity.addPart("dedupifiedBackupId", (ContentBody)new StringBody("d2323ee"));
            this.entity.addPart("maxVersions", (ContentBody)new StringBody(String.valueOf(3)));
            logger.debug("MAX Versions to keep:3");
            this.entity.addPart("is-base-folder", (ContentBody)new StringBody(String.valueOf(false)));
            this.entity.addPart("is-folder", (ContentBody)new StringBody(String.valueOf(fileTO.isFolder())));
            this.entity.addPart("is-exists", (ContentBody)new StringBody(String.valueOf(fileTO.isExists())));
            this.entity.addPart("fileMD5", (ContentBody)new StringBody(fileTO.getMd5checksum()));
            this.entity.addPart("token", (ContentBody)new StringBody(token));
            this.entity.addPart("modified", (ContentBody)new StringBody(String.valueOf(fileTO.getLastModifiedTimestamp())));
            this.entity.addPart("modified", (ContentBody)new StringBody(String.valueOf(fileTO.getLastModifiedTimestamp())));
            this.httpPost.setEntity((HttpEntity)this.entity);
            this.response = httpclient.execute((HttpUriRequest)this.httpPost);
            logger.trace("uploaded");
        }
        catch (ClientProtocolException e) {
            logger.error(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e));
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + (Object)((Object)e), e);
        }
        catch (FileNotFoundException e) {
            logger.error(FILE_NOT_FOUND_EXCEPTION + e.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        catch (IOException e) {
            logger.error(IO_EXCEPTION + e.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        int responseValue = this.parseUploadResponse(conflictedData);
        this.closeResponseEntity();
        this.httpPut = null;
        return responseValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextChunkValue(FileTO fileTO, String ip, Integer port, String cloudName, String token, ChunkFileElement chunkFileElement, String osName, String deviceUUID, String userName, String backupId, boolean viaGateway, String prevGatewayName, int maxVersionsToKeep) throws CrawlAdapterException {
        Header[] headerarr;
        UploadChunkFileException uploadChunkFileException;
        this.response = null;
        File file = null;
        int responseCode = 0;
        String fileChunks = StringUtils.join(chunkFileElement.getFileChunks(), (char)',');
        try {
            URI uri = viaGateway ? (port != null ? SyncAdapter.formHttpsUri(ip, port, "/BluKryptBuilder/sync/upload/file/chunks/") : SyncAdapter.formHttpsUri(ip, "/BluKryptBuilder/sync/upload/file/chunks/")) : (port != null ? SyncAdapter.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + "/files/chunk") : SyncAdapter.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + "/files/chunk"));
            file = new File(chunkFileElement.getFileCompletePath());
            this.httpPost = new HttpPost(uri.toString());
            logger.debug("URL:" + uri);
            this.entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            this.entity.addPart("file", (ContentBody)new FileBody(file));
            this.entity.addPart("fileChunkNames", (ContentBody)new StringBody(fileChunks));
            this.entity.addPart("token", (ContentBody)new StringBody(token));
            this.entity.addPart("checkSum", (ContentBody)new StringBody(chunkFileElement.getChecksum()));
            this.entity.addPart("fileName", (ContentBody)new StringBody(chunkFileElement.getFileName()));
            this.entity.addPart("fileCompletePath", (ContentBody)new StringBody(chunkFileElement.getFileName()));
            this.entity.addPart("deviceUUID", (ContentBody)new StringBody(chunkFileElement.getDeviceUUID()));
            this.entity.addPart("osType", (ContentBody)new StringBody(osName));
            this.entity.addPart("userName", (ContentBody)new StringBody(userName));
            this.entity.addPart("cloudName", (ContentBody)new StringBody(cloudName));
            this.entity.addPart("backupId", (ContentBody)new StringBody(backupId));
            this.entity.addPart("maxVersions", (ContentBody)new StringBody(String.valueOf(maxVersionsToKeep)));
            if (viaGateway) {
                this.entity.addPart("prevGatewayName", (ContentBody)new StringBody(prevGatewayName));
                this.entity.addPart("gatewayName", (ContentBody)new StringBody(ip));
                this.entity.addPart("deviceUUID", (ContentBody)new StringBody(deviceUUID));
                this.entity.addPart("originalFileName", (ContentBody)new StringBody(fileTO.getFileName()));
                this.entity.addPart("file-name", (ContentBody)new StringBody(fileTO.getFileName()));
                this.entity.addPart("file-path", (ContentBody)new StringBody(fileTO.getAbstractFilePath()));
                this.entity.addPart("is-base-folder", (ContentBody)new StringBody(String.valueOf(false)));
                this.entity.addPart("is-folder", (ContentBody)new StringBody(String.valueOf(fileTO.isFolder())));
                this.entity.addPart("is-exists", (ContentBody)new StringBody(String.valueOf(fileTO.isExists())));
                this.entity.addPart("modified", (ContentBody)new StringBody(String.valueOf(fileTO.getLastModifiedTimestamp())));
                this.entity.addPart("fileMD5", (ContentBody)new StringBody(String.valueOf(fileTO.getMd5checksum())));
            }
            this.entity.addPart("file-size", (ContentBody)new StringBody(String.valueOf(fileTO.getFileSize())));
            this.entity.addPart("fileSize", (ContentBody)new StringBody(String.valueOf(file.length())));
            this.httpPost.setEntity((HttpEntity)this.entity);
            this.response = httpclient.execute((HttpUriRequest)this.httpPost);
            logger.trace("Response code:" + this.response.getStatusLine().getStatusCode());
            responseCode = this.response.getStatusLine().getStatusCode();
        }
        catch (ClientProtocolException e) {
            logger.error(INSIDE_CATCH_BLOCK);
            this.closeResponseEntity();
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e), e);
        }
        catch (FileNotFoundException e) {
            logger.error(INSIDE_CATCH_BLOCK);
            this.closeResponseEntity();
            throw new CrawlAdapterException("IOException " + e, e);
        }
        catch (IOException e) {
            logger.error(INSIDE_CATCH_BLOCK);
            logger.error(IO_EXCEPTION + e.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        catch (RuntimeException e) {
            logger.trace("" + e);
            logger.error("Runtime exception :" + e.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("General exception in upload chunk :" + e.getMessage());
        }
        finally {
            this.httpPost.abort();
            this.closeResponseEntity();
            this.httpPost = null;
        }
        this.closeResponseEntity();
        if (responseCode == 507) {
            uploadChunkFileException = new UploadChunkFileException(CHUNK_FILE_DISK_FULL_EXCEPTION);
            uploadChunkFileException.setErrorStatus(507);
            throw uploadChunkFileException;
        }
        if (responseCode == 449) {
            uploadChunkFileException = new UploadChunkFileException(CHUNK_FILE_USER_STORAGE_EXCEED_EXCEPTION);
            uploadChunkFileException.setErrorStatus(1011);
            throw uploadChunkFileException;
        }
        this.httpPost = null;
        String nextChunkValue = "";
        for (Header header : headerarr = this.response.getAllHeaders()) {
            if (!"nextChunk".equals(header.getName())) continue;
            nextChunkValue = header.getValue();
            return nextChunkValue;
        }
        logger.debug("Response code:" + this.response.getStatusLine().getStatusCode());
        return nextChunkValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pingGatewayIP(String gatewayIP) {
        int responseValue = 0;
        URI uri = SyncAdapter.formHttpsUri(gatewayIP, "/BluKryptBuilder/ping/");
        this.httpGet = new HttpGet(uri.toString());
        try {
            logger.debug("The URL is:" + uri);
            this.response = httpclient.execute((HttpUriRequest)this.httpGet);
        }
        catch (ClientProtocolException e) {
            logger.error("ClientProtocolException" + e.getMessage());
            logger.trace("" + (Object)((Object)e));
            this.closeResponseEntity();
            this.httpGet = null;
            int n = responseValue;
            return n;
        }
        catch (IOException e) {
            logger.error(IO_EXCEPTION + e.getMessage());
            logger.trace("" + e);
            this.closeResponseEntity();
            this.httpGet = null;
            int n = responseValue;
            return n;
        }
        catch (Exception e) {
            logger.error(EXCEPTION + e.getMessage());
            logger.trace("" + e);
            this.closeResponseEntity();
            this.httpGet = null;
            int n = responseValue;
            return n;
        }
        finally {
            logger.debug("Inside finally pingGatewayIP.");
            if (this.httpGet != null) {
                this.httpGet.abort();
                this.httpGet = null;
            }
            this.closeResponseEntity();
        }
        responseValue = this.response.getStatusLine().getStatusCode();
        logger.debug("the ping response for gateway is:" + responseValue);
        this.closeResponseEntity();
        this.httpGet = null;
        return responseValue;
    }

    public InputStream downloadFileUsingMultiPart(String responseXml, String ip, Integer port, boolean isDod, String deviceUUID, String batchId) throws CrawlAdapterException, IOException {
        String downloadFileUrl;
        logger.trace(INTO_DOWNLOAD_FILE);
        if (isDod) {
            logger.debug(IS_DOD + isDod);
            downloadFileUrl = "/paracloud/cloud" + this.cloudName + PARACLOUD_DOD_DOWNLOAD_FILE;
        } else {
            downloadFileUrl = "/BluKryptBuilder/cloud" + this.cloudName + "/sync/restore/";
        }
        try {
            logger.debug(DOWNLOAD_FILE_URL + downloadFileUrl);
            URI uri = port != null ? SyncAdapter.formHttpsUri(ip, port, downloadFileUrl) : SyncAdapter.formHttpsUri(ip, downloadFileUrl);
            logger.debug(uri.toString());
            this.httpPost = new HttpPost(uri);
            this.httpPost.setHeader("Content-Type", "text/xml");
            this.httpPost.setHeader("deviceUUID", deviceUUID);
            this.httpPost.setHeader("batchId", batchId);
            ByteArrayEntity httpEntity = new ByteArrayEntity(responseXml.getBytes());
            this.httpPost.setEntity((HttpEntity)httpEntity);
            this.response = httpclient.execute((HttpUriRequest)this.httpPost);
        }
        catch (ClientProtocolException e) {
            logger.error(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e));
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + (Object)((Object)e), e);
        }
        catch (FileNotFoundException e) {
            logger.error(FILE_NOT_FOUND_EXCEPTION + e);
            logger.error(EXCEPTION + e);
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        catch (IOException ex) {
            logger.trace("" + ex);
            logger.error(IO_EXCEPTION + ex.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(ex.getMessage(), ex);
        }
        if (this.response == null) {
            logger.trace(DOWNLOAD_NULL_RESPONSE);
            this.closeResponseEntity();
            return null;
        }
        logger.debug(DOWNLOAD_RESPONSE_CODE + this.response.getStatusLine().getStatusCode());
        InputStream in = this.response.getEntity().getContent();
        return in;
    }

    public void cancelHttpget() {
        if (this.httpGet != null) {
            this.httpGet.abort();
            this.httpGet = null;
        }
    }

    private boolean downloadFileFromServerUsingTheInputStream(InputStream in, File downloadTempFile, boolean fileTransferSuccess) {
        FileOutputStream out = null;
        boolean fileTransferSuccessTemp = fileTransferSuccess;
        try {
            out = new FileOutputStream(downloadTempFile);
            byte[] buffer = new byte[1024];
            int len = 0;
            this.downloadFile(len, in, buffer, out, fileTransferSuccessTemp);
        }
        catch (FileNotFoundException e) {
            logger.error("Exception while reading inputstream while download", (Throwable)e);
            fileTransferSuccessTemp = false;
        }
        if (out != null) {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                logger.error("Couldnt close inputStream ", (Throwable)e);
                logger.error(EXCEPTION + e);
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                logger.error("Couldnt close inputStream " + e);
                logger.error(EXCEPTION + e);
            }
        }
        return fileTransferSuccessTemp;
    }

    private boolean downloadFile(int len, InputStream in, byte[] buffer, OutputStream out, boolean fileTransferSuccess) {
        boolean fileTransferSuccessTemp = fileTransferSuccess;
        int lenTemp = len;
        try {
            int gcSize = 0;
            int gcThreshold = 0x100000;
            while ((lenTemp = in.read(buffer)) > 0) {
                out.write(buffer, 0, lenTemp);
                if ((gcSize += lenTemp) <= gcThreshold) continue;
                gcSize = 0;
            }
        }
        catch (IOException e) {
            logger.error("Exception while reading inputstream while download", (Throwable)e);
            fileTransferSuccessTemp = false;
        }
        return fileTransferSuccessTemp;
    }

    public SyncPolicyElement getSyncPolicyElement(String ip, Integer port, String deviceName, String token, String deviceUUID, String userName, String serverBackupEnabled) throws CrawlAdapterException {
        HttpGet httpget = null;
        int responseCode = 0;
        HttpEntity responseEntity = null;
        String responseXmlAsString = null;
        SyncPolicyElement syncPolicyElement = null;
        try {
            URI uri = port != null ? SyncAdapter.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + "/groupSyncPolicy") : SyncAdapter.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + "/groupSyncPolicy");
            logger.debug("URI " + uri);
            httpget = new HttpGet(uri);
            httpget.setHeader("Content-Type", "text/xml");
            httpget.setHeader("deviceName", deviceName);
            httpget.setHeader("token", token);
            httpget.setHeader("deviceUUID", deviceUUID);
            httpget.setHeader("userName", userName);
            this.response = httpclient.execute((HttpUriRequest)httpget);
            responseCode = this.response.getStatusLine().getStatusCode();
            if (responseCode == 200) {
                responseEntity = this.response.getEntity();
                responseXmlAsString = EntityUtils.toString((HttpEntity)responseEntity);
                logger.debug("REsponse: " + responseXmlAsString);
                syncPolicyElement = Xmlparser.parseSyncPolicyElementResponse(responseXmlAsString);
            }
        }
        catch (ClientProtocolException e) {
            this.closeResponseEntity();
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e), e);
        }
        catch (NoRouteToHostException e) {
            logger.error(NO_ROUTE_TO_HOST_EXCEPTION + e);
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION + e, e);
        }
        catch (HttpHostConnectException e) {
            logger.error(HTTP_HOST_CONNECT_EXCEPTION + (Object)((Object)e));
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e), e);
        }
        catch (UnknownHostException e) {
            logger.error(UNKNOWN_HOST_EXCEPTION + e);
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION + e, e);
        }
        catch (IOException e) {
            logger.error(IO_EXCEPTION + e.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        catch (Exception ex) {
            throw new CrawlAdapterException(EXCEPTION, ex);
        }
        finally {
            this.closeResponseEntity();
            if (httpget != null) {
                httpget.abort();
                httpget = null;
            }
        }
        logger.debug("Response Code " + responseCode);
        return syncPolicyElement;
    }
}

