/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.adapter.pcb;

import com.google.common.util.concurrent.RateLimiter;
import com.parablu.epa.core.adapter.BaseAdapter;
import com.parablu.epa.core.exception.CrawlAdapterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPartBackupAdapter
extends BaseAdapter {
    private static Logger logger = LoggerFactory.getLogger(MultiPartBackupAdapter.class);
    private final String boundary;
    private static final String LINE_FEED = "\r\n";
    private HttpsURLConnection httpConn;
    private OutputStreamWriter writer;
    private static int count = 0;
    private static final String IO_EXCEPTION = "IO Exception";

    public MultiPartBackupAdapter(String ip, Integer port, String requestURL, String cloudName, String keyStorePath) throws IOException {
        super(cloudName, keyStorePath);
        this.boundary = "--PARABLUEOF";
        this.createSSLFactory();
        String urlString = this.createHttpsUrl(ip, port, requestURL);
        logger.debug("URL: " + urlString);
        URL url = new URL(urlString);
        if (this.httpConn != null) {
            logger.debug("Connection already open");
            return;
        }
        logger.debug("HTTP connection is null : " + count++);
        this.httpConn = (HttpsURLConnection)url.openConnection();
        this.httpConn.setDoOutput(true);
        this.httpConn.setRequestMethod("POST");
        this.httpConn.setUseCaches(false);
        this.httpConn.setChunkedStreamingMode(4096);
        this.httpConn.setConnectTimeout(120000);
        this.httpConn.setReadTimeout(1200000);
        this.writer = new OutputStreamWriter(this.httpConn.getOutputStream(), "UTF8");
        this.writer.append("Content-Type: multipart/form-data;boundary=--PARABLUEOF\r\n");
    }

    public void resumeConnection(String ip, Integer port, String requestURL) {
    }

    private String createHttpsUrl(String ip, Integer port, String requestURL) {
        String httpsUrl = "https://";
        String ipValue = port != null ? ip + ":" + port : ip;
        return httpsUrl + ipValue + "/BluKryptBuilder" + requestURL;
    }

    public void addFilePart(File uploadFile, RateLimiter rateLimiter) {
        try (FileInputStream inputStream = new FileInputStream(uploadFile);
             Base64InputStream inputStream2 = new Base64InputStream((InputStream)inputStream, true);){
            int bytesRead;
            this.writer.append(LINE_FEED);
            byte[] buffer = new byte[4096];
            logger.debug("Thread Name$:" + Thread.currentThread().getName() + "$$Before Writing into output stream" + uploadFile.getName());
            while ((bytesRead = inputStream2.read(buffer)) != -1) {
                rateLimiter.acquire();
                char[] charArray = this.convertByteToChar(buffer, bytesRead);
                this.writer.write(charArray, 0, bytesRead);
                this.writer.flush();
            }
            this.httpConn.getOutputStream().flush();
        }
        catch (IOException e) {
            logger.error("Exception while adding file part : " + e.getMessage());
            logger.trace("" + e);
            throw new CrawlAdapterException("IO EXCeption");
        }
    }

    public void addFilePart(InputStream inputStream, RateLimiter rateLimiter) {
        try {
            int bytesRead;
            Base64InputStream inputStream2 = new Base64InputStream(inputStream, true);
            this.writer.append(LINE_FEED);
            byte[] buffer = new byte[4096];
            logger.debug("Thread Name$:" + Thread.currentThread().getName() + "$$Before Writing into output stream");
            while ((bytesRead = inputStream2.read(buffer)) != -1) {
                rateLimiter.acquire();
                char[] charArray = this.convertByteToChar(buffer, bytesRead);
                this.writer.write(charArray, 0, bytesRead);
                this.writer.flush();
            }
            this.httpConn.getOutputStream().flush();
            logger.debug("$$After Writing into output stream File completed ");
        }
        catch (IOException e) {
            logger.error("Exception while adding file part : " + e.getMessage());
            logger.trace("" + e);
            throw new CrawlAdapterException("IO EXCeption");
        }
    }

    private char[] convertByteToChar(byte[] byteBuffer, int bytesRead) {
        char[] charBuffer2 = new char[bytesRead];
        for (int i = 0; i < bytesRead; ++i) {
            charBuffer2[i] = (char)(byteBuffer[i] & 0xFF);
        }
        return charBuffer2;
    }

    public void addFormField() {
        try {
            String boundry = "--" + this.boundary + LINE_FEED;
            this.writer.append(LINE_FEED);
            this.writer.append(boundry);
            String partHeader = "Content-Disposition: form-data;";
            this.writer.append(partHeader);
            this.writer.append(LINE_FEED);
        }
        catch (IOException e) {
            logger.error("Exception while adding form field : " + e.getMessage());
            logger.trace("" + e);
            throw new CrawlAdapterException(IO_EXCEPTION);
        }
    }

    public void addFormField(String value) {
        try {
            String boundry = "--" + this.boundary + LINE_FEED;
            String partHeader = "Content-Disposition: form-data;";
            this.writer.append(LINE_FEED);
            this.writer.append(boundry);
            this.writer.append(partHeader);
            this.writer.append(LINE_FEED);
        }
        catch (IOException e) {
            logger.error("Exception while adding form field(String) : " + e.getMessage() + "value" + value);
            logger.trace("" + e);
            throw new CrawlAdapterException(IO_EXCEPTION);
        }
    }

    public void addHeaderField(String name, String value) {
        try {
            String header = name + ": " + value;
            this.writer.append(header);
            this.writer.append(LINE_FEED);
            this.writer.flush();
        }
        catch (Exception e) {
            logger.error("Exception while adding header field : " + e.getMessage());
            logger.trace("" + e);
            throw new CrawlAdapterException(IO_EXCEPTION);
        }
    }

    public int finish() {
        int status;
        ArrayList<String> response = new ArrayList<String>();
        try {
            String finishBoundary = "--" + this.boundary + "--";
            this.writer.append(LINE_FEED);
            this.writer.append(finishBoundary);
            this.writer.append(LINE_FEED);
            String paddedString = MultiPartBackupAdapter.padRight("", 4096);
            this.writer.write(paddedString);
            this.writer.flush();
            status = this.httpConn.getResponseCode();
            if (status == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.httpConn.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    response.add(line);
                }
                reader.close();
            }
            this.httpConn.disconnect();
        }
        catch (IOException e) {
            logger.error("Exception while finish : " + e.getMessage());
            logger.trace("" + e);
            throw new CrawlAdapterException(IO_EXCEPTION);
        }
        return status;
    }

    public void cancelUpload() {
        try {
            logger.debug("Canceling upload in adapter>>>>");
            if (this.httpConn != null) {
                logger.debug("cancellingggg");
                this.writer.flush();
                this.httpConn.disconnect();
                this.httpConn = null;
            }
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error("Exception in Cancelling Upload :" + e.getMessage());
        }
    }

    public static String padRight(String s, int n) {
        String input = "%1$-" + n + "s";
        return String.format(input, s);
    }

    private void createSSLFactory() {
        final java.security.cert.X509Certificate[] xs = null;
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                return xs;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            logger.trace("" + e);
            logger.error("Exception in creating SSL Factory :" + e.getMessage());
        }
        if (sc != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = (hostname, session) -> true;
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
    }
}

