/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.adapter.pcb;

import com.parablu.epa.core.adapter.BaseAdapter;
import com.parablu.epa.core.element.DeviceListElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.service.transformer.Xmlparser;
import com.parablu.epa.core.to.DisplayTo;
import com.parablu.epa.core.to.GzipTO;
import com.parablu.epa.core.to.MediaTO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.NoRouteToHostException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaAdapter
extends BaseAdapter {
    private static final String PARACLOUD_MEDIA_VALIDATION = "/crawl/media";
    private static final String PARACLOUD_MEDIA_UPLOAD = "/upload/media";
    private static final String PARACLOUD_MEDIA_HUBSTATUS = "/media/webdav/status";
    private static final String IO_EXCEPTION = "IOException Exception ";
    private static final String CLIENT_PROTOCOL_EXCEPTION = "ClientProtocol Exception ";
    private static final String EXCEPTION = "Exception ";
    private static final String ERR_MSG = "errorMessage";
    private Logger logger = LoggerFactory.getLogger(MediaAdapter.class);
    private HttpResponse response = null;
    private HttpPut httpPut = null;

    public MediaAdapter(String cloudName, String keyStorePath) {
        super(cloudName, keyStorePath);
    }

    public MediaAdapter(InputStream inputStream, String cloudName) {
        super(inputStream, cloudName);
    }

    public List<DisplayTo> getListOfDeviceOnCloud(String ip, Integer port) {
        List<DisplayTo> listDevices = new ArrayList<DisplayTo>();
        HttpGet httpget = null;
        int responseCode = 0;
        HttpEntity responseEntity = null;
        String responseXmlAsString = null;
        try {
            URI uri = port != null ? MediaAdapter.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + "/device/all/") : MediaAdapter.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + "/device/all/");
            this.logger.debug("URL: " + uri);
            httpget = new HttpGet(uri);
            this.response = httpclient.execute((HttpUriRequest)httpget);
            responseCode = this.response.getStatusLine().getStatusCode();
            this.logger.debug("responseCode: " + responseCode);
            if (responseCode == 200) {
                responseEntity = this.response.getEntity();
                responseXmlAsString = EntityUtils.toString((HttpEntity)responseEntity);
                DeviceListElement listDeviceElement = Xmlparser.parseDeviceListResponse(responseXmlAsString);
                listDevices = ObjectUtils.convertToDeviceList(listDeviceElement);
            }
        }
        catch (ClientProtocolException e) {
            this.logger.error(CLIENT_PROTOCOL_EXCEPTION + e.getMessage());
            throw new CrawlAdapterException(EXCEPTION + (Object)((Object)e), e);
        }
        catch (IOException e) {
            this.logger.error(IO_EXCEPTION + e.getMessage());
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        finally {
            this.closeResponseEntity();
        }
        return listDevices;
    }

    private void closeResponseEntity() {
        if (this.response != null && this.response.getEntity().isStreaming()) {
            try {
                this.response.getEntity().getContent().close();
            }
            catch (IOException e) {
                this.logger.trace("" + e);
                this.logger.error("Close Response Entity" + e.getMessage());
            }
        }
    }

    private GzipTO downloadGzipResponseAsByteArray(int responseCode) throws IOException {
        GzipTO crawlresponseObject = new GzipTO();
        if (responseCode == 200) {
            HttpEntity responseEntity = this.response.getEntity();
            if (responseEntity != null) {
                try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    IOUtils.copy((InputStream)responseEntity.getContent(), (OutputStream)outputStream);
                    this.logger.trace("copying done");
                    crawlresponseObject.setResponse(outputStream.toByteArray());
                }
                catch (FileNotFoundException e) {
                    throw new IOException("FileNotFoundException occured", e);
                }
                catch (IOException e) {
                    throw new IOException("IOException occured", e);
                }
            }
        } else if (responseCode == 500 || responseCode == 400) {
            if (this.response.getStatusLine() != null) {
                this.logger.debug(this.response.getStatusLine().getReasonPhrase());
            }
            if (this.response.getFirstHeader(ERR_MSG) != null) {
                this.logger.debug(this.response.getFirstHeader(ERR_MSG).getValue());
            }
        }
        crawlresponseObject.setResponseCode(responseCode);
        return crawlresponseObject;
    }

    public GzipTO validateDeltaForMedia(byte[] gzipReq, String ip, boolean isFirstTime, String token) throws CrawlAdapterException {
        this.logger.trace("Entering : ParacloudAdapter.validateDeltaForBackUp");
        GzipTO gzipResponse = null;
        this.response = null;
        HttpPost httppost = null;
        ByteArrayEntity httpEntity = null;
        int responseCode = 0;
        try {
            URI uri = MediaAdapter.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_MEDIA_VALIDATION);
            this.logger.debug(uri.toString());
            httppost = new HttpPost(uri);
            httppost.setHeader("Content-Type", "text/xml");
            httppost.setHeader("Content-Encoding", "gzip");
            httppost.setHeader("complete-backup", String.valueOf(isFirstTime));
            httppost.setHeader("token", token);
            httpEntity = new ByteArrayEntity(gzipReq);
            httppost.setEntity((HttpEntity)httpEntity);
            this.response = httpclient.execute((HttpUriRequest)httppost);
            if (this.response == null) {
                this.logger.error("Resonse for registration is null");
                throw new CrawlAdapterException("Response is null");
            }
            responseCode = this.response.getStatusLine().getStatusCode();
            this.logger.debug("Reponse" + responseCode);
            gzipResponse = this.downloadGzipResponseAsByteArray(responseCode);
        }
        catch (ClientProtocolException e) {
            this.logger.error(CLIENT_PROTOCOL_EXCEPTION + e.getMessage());
            this.logger.trace("" + (Object)((Object)e));
        }
        catch (NoRouteToHostException e) {
            this.logger.error("NoRouteToHostException " + e);
        }
        catch (HttpHostConnectException e) {
            this.logger.error("HttpHostConnectException " + (Object)((Object)e));
        }
        catch (UnknownHostException e) {
            this.logger.error("UnknownHostException " + e);
        }
        catch (IOException e) {
            this.logger.error(IO_EXCEPTION + e.getMessage());
            this.logger.trace("" + e);
        }
        this.closeResponseEntity();
        return gzipResponse;
    }

    private void setHeaderToHttpPutForFileUploadToMedia(MediaTO fileTO, File file, String token) {
        this.httpPut.setHeader("header-encoding", "base64");
        this.httpPut.setHeader("file-name", this.encodeUTFBase64(fileTO.getFileName()));
        this.httpPut.setHeader("extension", this.encodeUTFBase64(fileTO.getExtension()));
        this.httpPut.setHeader("file-path", this.encodeUTFBase64(fileTO.getAbstractFilePath()));
        this.httpPut.setHeader("meta-data", this.encodeUTFBase64(fileTO.getMetaData()));
        this.httpPut.setHeader("modified", String.valueOf(fileTO.getLastModifiedTimestamp()));
        this.httpPut.setHeader("is-folder", String.valueOf(fileTO.isFolder()));
        this.httpPut.setHeader("is-exists", String.valueOf(fileTO.isExists()));
        this.httpPut.setHeader("fileMD5", fileTO.getMd5checksum());
        this.httpPut.setHeader("token", token);
        this.httpPut.setHeader("media-type", fileTO.getMediaType());
        if (file != null) {
            this.httpPut.setHeader("file-size", String.valueOf(file.length()));
        } else {
            this.httpPut.setHeader("file-size", "0");
        }
    }

    private int parseUploadResponse() {
        int responseValue;
        if (this.response == null) {
            responseValue = 1;
        } else if (this.response.getStatusLine().getStatusCode() != 200) {
            this.logger.trace(this.response.getStatusLine().getReasonPhrase());
            this.logger.trace("response status code" + this.response.getStatusLine().getStatusCode());
            responseValue = 2;
            if (this.response.getStatusLine().getStatusCode() != 507 && this.response.getStatusLine().getStatusCode() != 419) {
                if (this.response.getStatusLine().getStatusCode() == 416) {
                    responseValue = 1005;
                } else if (this.response.getStatusLine().getStatusCode() == 420) {
                    responseValue = 1009;
                } else if (this.response.getStatusLine().getStatusCode() == 421) {
                    responseValue = 1008;
                } else {
                    Header header = this.response.getFirstHeader(ERR_MSG);
                    if (header != null) {
                        this.logger.trace("ErrorMessage:" + header.getValue());
                    }
                }
            } else {
                responseValue = this.response.getStatusLine().getStatusCode() == 507 ? 1007 : 1006;
            }
        } else {
            responseValue = 3;
        }
        return responseValue;
    }

    public int uploadMediaFile(MediaTO mediaTO, String ip, String tempPath, String token) throws CrawlAdapterException {
        this.logger.trace("Entering : ParacloudAdapter.uploadFile");
        this.response = null;
        File file = null;
        try {
            URI uri = MediaAdapter.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_MEDIA_UPLOAD);
            this.logger.trace("Upload Url for this file: " + uri);
            this.httpPut = new HttpPut(uri);
            if (!mediaTO.isFolder()) {
                file = new File(tempPath);
                this.setHeaderToHttpPutForFileUploadToMedia(mediaTO, file, token);
                this.httpPut.setEntity((HttpEntity)new FileEntity(file, "binary/octet-stream"));
            } else {
                this.setHeaderToHttpPutForFileUploadToMedia(mediaTO, null, token);
            }
            this.response = httpclient.execute((HttpUriRequest)this.httpPut);
            this.logger.trace("uploaded, response: " + this.response);
        }
        catch (ClientProtocolException e) {
            this.logger.error(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e));
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + (Object)((Object)e), e);
        }
        catch (FileNotFoundException e) {
            this.logger.error("FileNotFoundException " + e);
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        catch (IOException e) {
            this.logger.error(IO_EXCEPTION + e.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        int responseValue = this.parseUploadResponse();
        this.closeResponseEntity();
        this.httpPut = null;
        return responseValue;
    }

    public boolean checkIfMediaHubIsEnabled(String ip, Integer port, String token) throws CrawlAdapterException {
        this.logger.trace("Entering : ParacloudAdapter.uploadFile");
        this.response = null;
        boolean status = false;
        try {
            URI uri = port != null ? MediaAdapter.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_MEDIA_HUBSTATUS) : MediaAdapter.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_MEDIA_HUBSTATUS);
            this.logger.trace("Upload Url for this file: " + uri);
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader("token", token);
            this.response = httpclient.execute((HttpUriRequest)httpGet);
            int statusCode = this.response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                Header header = this.response.getFirstHeader("status");
                if (header == null) {
                    throw new CrawlAdapterException(EXCEPTION);
                }
                if ("on".equals(header.getValue())) {
                    status = true;
                }
            }
        }
        catch (ClientProtocolException e) {
            this.logger.error(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e));
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + (Object)((Object)e), e);
        }
        catch (IOException e) {
            this.logger.error(IO_EXCEPTION + e.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        this.closeResponseEntity();
        return status;
    }

    public void cancelHttpPut() {
        if (this.httpPut != null) {
            this.httpPut.abort();
            this.httpPut = null;
        }
    }
}

