/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.mock;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.awtui.TestRunner;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.struts.action.ActionFormBean;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.FormPropertyConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.ModuleConfigFactory;
import org.apache.struts.mock.MockHttpServletRequest;
import org.apache.struts.mock.MockHttpServletResponse;
import org.apache.struts.mock.MockHttpSession;
import org.apache.struts.mock.MockPageContext;
import org.apache.struts.mock.MockPrincipal;
import org.apache.struts.mock.MockServletConfig;
import org.apache.struts.mock.MockServletContext;

public class TestMockBase
extends TestCase {
    protected ModuleConfig moduleConfig = null;
    protected ModuleConfig moduleConfig2 = null;
    protected ModuleConfig moduleConfig3 = null;
    protected MockServletConfig config = null;
    protected MockServletContext context = null;
    protected MockPageContext page = null;
    protected MockPrincipal principal = null;
    protected MockHttpServletRequest request = null;
    protected MockHttpServletResponse response = null;
    protected MockHttpSession session = null;

    public TestMockBase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.main(new String[]{TestMockBase.class.getName()});
    }

    public static Test suite() {
        return new TestSuite(TestMockBase.class);
    }

    public void setUp() {
        this.context = new MockServletContext();
        this.config = new MockServletConfig(this.context);
        this.session = new MockHttpSession(this.context);
        this.request = new MockHttpServletRequest(this.session);
        this.principal = new MockPrincipal("username", new String[]{"admin", "manager"});
        this.request.setUserPrincipal(this.principal);
        this.response = new MockHttpServletResponse();
        this.page = new MockPageContext(this.config, (ServletRequest)this.request, (ServletResponse)this.response);
        this.setUpDefaultApp();
        this.setUpSecondApp();
        this.setUpThirdApp();
    }

    protected void setUpDefaultApp() {
        ActionFormBean formBean = null;
        ActionMapping mapping = null;
        ModuleConfigFactory factoryObject = ModuleConfigFactory.createFactory();
        this.moduleConfig = factoryObject.createModuleConfig("");
        this.context.setAttribute("org.apache.struts.action.MODULE", this.moduleConfig);
        this.moduleConfig.addForwardConfig(new ActionForward("external", "http://jakarta.apache.org/", false));
        this.moduleConfig.addForwardConfig(new ActionForward("foo", "/bar.jsp", false));
        this.moduleConfig.addForwardConfig(new ActionForward("relative1", "relative.jsp", false));
        this.moduleConfig.addForwardConfig(new ActionForward("relative2", "relative.jsp", false));
        formBean = new ActionFormBean("static", "org.apache.struts.mock.MockFormBean");
        this.moduleConfig.addFormBeanConfig(formBean);
        mapping = new ActionMapping();
        mapping.setInput("/static.jsp");
        mapping.setName("static");
        mapping.setPath("/static");
        mapping.setScope("request");
        mapping.setType("org.apache.struts.mock.MockAction");
        this.moduleConfig.addActionConfig(mapping);
        formBean = new ActionFormBean("dynamic", "org.apache.struts.action.DynaActionForm");
        formBean.addFormPropertyConfig(new FormPropertyConfig("booleanProperty", "boolean", "false"));
        formBean.addFormPropertyConfig(new FormPropertyConfig("stringProperty", "java.lang.String", null));
        this.moduleConfig.addFormBeanConfig(formBean);
        mapping = new ActionMapping();
        mapping.setInput("/dynamic.jsp");
        mapping.setName("dynamic");
        mapping.setPath("/dynamic");
        mapping.setScope("session");
        mapping.setType("org.apache.struts.mock.MockAction");
        this.moduleConfig.addActionConfig(mapping);
        formBean = new ActionFormBean("dynamic0", "org.apache.struts.action.DynaActionForm");
        formBean.addFormPropertyConfig(new FormPropertyConfig("booleanProperty", "boolean", "true"));
        formBean.addFormPropertyConfig(new FormPropertyConfig("stringProperty", "java.lang.String", "String Property"));
        formBean.addFormPropertyConfig(new FormPropertyConfig("intArray1", "int[]", "{1,2,3}", 4));
        formBean.addFormPropertyConfig(new FormPropertyConfig("intArray2", "int[]", null, 5));
        formBean.addFormPropertyConfig(new FormPropertyConfig("principal", "org.apache.struts.mock.MockPrincipal", null));
        formBean.addFormPropertyConfig(new FormPropertyConfig("stringArray1", "java.lang.String[]", "{aaa,bbb,ccc}", 2));
        formBean.addFormPropertyConfig(new FormPropertyConfig("stringArray2", "java.lang.String[]", null, 3));
        this.moduleConfig.addFormBeanConfig(formBean);
        mapping = new ActionMapping();
        mapping.setName("dynamic0");
        mapping.setPath("/dynamic0");
        mapping.setScope("request");
        mapping.setType("org.apache.struts.mock.MockAction");
        this.moduleConfig.addActionConfig(mapping);
        mapping = new ActionMapping();
        mapping.setPath("/noform");
        mapping.setType("org.apache.struts.mock.MockAction");
        this.moduleConfig.addActionConfig(mapping);
        this.moduleConfig.addForwardConfig(new ForwardConfig("moduleForward", "/module/forward", false));
        this.moduleConfig.addForwardConfig(new ForwardConfig("moduleRedirect", "/module/redirect", true));
        this.moduleConfig.addForwardConfig(new ForwardConfig("contextForward", "/forward", false, "/context"));
        this.moduleConfig.addForwardConfig(new ForwardConfig("contextRedirect", "/redirect", true, "/context"));
        this.moduleConfig.addForwardConfig(new ForwardConfig("moduleNoslash", "module/noslash", false));
        this.moduleConfig.addForwardConfig(new ForwardConfig("contextNoslash", "noslash", false, "/context"));
    }

    protected void setUpSecondApp() {
        ActionFormBean formBean = null;
        ActionMapping mapping = null;
        ModuleConfigFactory factoryObject = ModuleConfigFactory.createFactory();
        this.moduleConfig2 = factoryObject.createModuleConfig("/2");
        this.context.setAttribute("org.apache.struts.action.MODULE/2", this.moduleConfig2);
        this.moduleConfig2.addForwardConfig(new ActionForward("external", "http://jakarta.apache.org/", false));
        this.moduleConfig2.addForwardConfig(new ActionForward("foo", "/baz.jsp", false));
        this.moduleConfig2.addForwardConfig(new ActionForward("relative1", "relative.jsp", false));
        this.moduleConfig2.addForwardConfig(new ActionForward("relative2", "relative.jsp", false));
        formBean = new ActionFormBean("static", "org.apache.struts.mock.MockFormBean");
        this.moduleConfig2.addFormBeanConfig(formBean);
        mapping = new ActionMapping();
        mapping.setInput("/static.jsp");
        mapping.setName("static");
        mapping.setPath("/static");
        mapping.setScope("request");
        mapping.setType("org.apache.struts.mock.MockAction");
        this.moduleConfig2.addActionConfig(mapping);
        formBean = new ActionFormBean("dynamic2", "org.apache.struts.action.DynaActionForm");
        formBean.addFormPropertyConfig(new FormPropertyConfig("booleanProperty", "boolean", "false"));
        formBean.addFormPropertyConfig(new FormPropertyConfig("stringProperty", "java.lang.String", null));
        this.moduleConfig2.addFormBeanConfig(formBean);
        mapping = new ActionMapping();
        mapping.setInput("/dynamic2.jsp");
        mapping.setName("dynamic2");
        mapping.setPath("/dynamic2");
        mapping.setScope("session");
        mapping.setType("org.apache.struts.mock.MockAction");
        this.moduleConfig2.addActionConfig(mapping);
        mapping = new ActionMapping();
        mapping.setPath("/noform");
        mapping.setType("org.apache.struts.mock.MockAction");
        this.moduleConfig2.addActionConfig(mapping);
        this.moduleConfig2.addForwardConfig(new ForwardConfig("moduleForward", "/module/forward", false));
        this.moduleConfig2.addForwardConfig(new ForwardConfig("moduleRedirect", "/module/redirect", true));
        this.moduleConfig2.addForwardConfig(new ForwardConfig("contextForward", "/forward", false, "/context"));
        this.moduleConfig2.addForwardConfig(new ForwardConfig("contextRedirect", "/redirect", true, "/context"));
        this.moduleConfig2.addForwardConfig(new ForwardConfig("moduleNoslash", "module/noslash", false));
        this.moduleConfig2.addForwardConfig(new ForwardConfig("contextNoslash", "noslash", false, "/context"));
    }

    protected void setUpThirdApp() {
        ModuleConfigFactory factoryObject = ModuleConfigFactory.createFactory();
        this.moduleConfig3 = factoryObject.createModuleConfig("/3");
        this.context.setAttribute("org.apache.struts.action.MODULE/3", this.moduleConfig3);
        ControllerConfig controller = new ControllerConfig();
        this.moduleConfig3.setControllerConfig(controller);
        controller.setForwardPattern("/forwarding$M$P");
        controller.setInputForward(true);
        controller.setPagePattern("/paging$M$P");
        this.moduleConfig3.addForwardConfig(new ForwardConfig("moduleForward", "/module/forward", false));
        this.moduleConfig3.addForwardConfig(new ForwardConfig("moduleRedirect", "/module/redirect", true));
        this.moduleConfig3.addForwardConfig(new ForwardConfig("contextForward", "/forward", false, "/context"));
        this.moduleConfig3.addForwardConfig(new ForwardConfig("contextRedirect", "/redirect", true, "/context"));
        this.moduleConfig3.addForwardConfig(new ForwardConfig("moduleNoslash", "module/noslash", false));
        this.moduleConfig3.addForwardConfig(new ForwardConfig("contextNoslash", "noslash", false, "/context"));
    }

    public void tearDown() {
        this.moduleConfig3 = null;
        this.moduleConfig2 = null;
        this.moduleConfig = null;
        this.config = null;
        this.context = null;
        this.page = null;
        this.principal = null;
        this.request = null;
        this.response = null;
        this.session = null;
    }

    public void testUtilBaseEnvironment() {
        TestMockBase.assertNotNull("config is present", this.config);
        TestMockBase.assertNotNull("context is present", this.context);
        TestMockBase.assertNotNull("page is present", (Object)this.page);
        TestMockBase.assertNotNull("principal is present", this.principal);
        TestMockBase.assertNotNull("request is present", this.request);
        TestMockBase.assertNotNull("response is present", this.response);
        TestMockBase.assertNotNull("session is present", this.session);
        TestMockBase.assertEquals("page-->config", this.config, this.page.getServletConfig());
        TestMockBase.assertEquals("config-->context", this.context, this.config.getServletContext());
        TestMockBase.assertEquals("page-->context", this.context, this.page.getServletContext());
        TestMockBase.assertEquals("page-->request", this.request, this.page.getRequest());
        TestMockBase.assertEquals("page-->response", this.response, this.page.getResponse());
        TestMockBase.assertEquals("page-->session", this.session, this.page.getSession());
        TestMockBase.assertEquals("request-->principal", this.principal, this.request.getUserPrincipal());
        TestMockBase.assertEquals("request-->session", this.session, this.request.getSession());
        TestMockBase.assertEquals("session-->context", this.context, this.session.getServletContext());
        TestMockBase.assertNotNull("moduleConfig is present", this.moduleConfig);
        TestMockBase.assertEquals("context-->moduleConfig", this.moduleConfig, this.context.getAttribute("org.apache.struts.action.MODULE"));
        TestMockBase.assertNotNull("moduleConfig2 is present", this.moduleConfig2);
        TestMockBase.assertEquals("context-->moduleConfig2", this.moduleConfig2, this.context.getAttribute("org.apache.struts.action.MODULE/2"));
    }
}

