/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions;

import junit.extensions.TestDecorator;
import junit.framework.Test;
import junit.framework.TestResult;

public class RepeatedTest
extends TestDecorator {
    private int fTimesRepeat;

    public RepeatedTest(Test test2, int repeat) {
        super(test2);
        if (repeat < 0) {
            throw new IllegalArgumentException("Repetition count must be > 0");
        }
        this.fTimesRepeat = repeat;
    }

    public int countTestCases() {
        return super.countTestCases() * this.fTimesRepeat;
    }

    public void run(TestResult result) {
        int i = 0;
        while (i < this.fTimesRepeat) {
            if (result.shouldStop()) break;
            super.run(result);
            ++i;
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + "(repeated)";
    }
}

