/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.Device;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class LatestStorageUtilized {
    static AtomicInteger devcount = new AtomicInteger();
    static boolean updatePgSize = false;
    static boolean updateStorageUtilized = false;
    static boolean latestVerStorageUtilized = false;
    static boolean updateProdTable = false;

    public static void main(String[] args) throws ConfigurationException {
        try {
            PropertiesConfiguration config = null;
            config = new PropertiesConfiguration(args[0]);
            String mongoIP = config.getProperty("mongoIP").toString();
            String mongoPort = config.getProperty("mongoPort").toString();
            String deviceUUIDList = "";
            if (config.getProperty("updateProdTable") != null) {
                updateProdTable = Boolean.parseBoolean(config.getProperty("updateProdTable").toString());
            }
            if (config.getProperty("updatePgSize") != null) {
                updatePgSize = Boolean.parseBoolean(config.getProperty("updatePgSize").toString());
            }
            if (config.getProperty("updatePgSize") != null) {
                updatePgSize = Boolean.parseBoolean(config.getProperty("updatePgSize").toString());
            }
            if (config.getProperty("updateStorageUtilized") != null) {
                updateStorageUtilized = Boolean.parseBoolean(config.getProperty("updateStorageUtilized").toString());
            }
            if (config.getProperty("latestVerStorageUtilized") != null) {
                latestVerStorageUtilized = Boolean.parseBoolean(config.getProperty("latestVerStorageUtilized").toString());
            }
            if (config.getProperty("deviceUUID") != null) {
                deviceUUIDList = config.getProperty("deviceUUID").toString();
            }
            if (config.getProperty("deviceUUID") != null) {
                deviceUUIDList = config.getProperty("deviceUUID").toString();
            }
            if (StringUtils.isEmpty(mongoIP) || StringUtils.isEmpty(mongoPort)) {
                System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
                throw new ArrayIndexOutOfBoundsException();
            }
            System.out.println("mongo IP:" + mongoIP);
            MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
            MongoClient client = new MongoClient(uri);
            MongoDatabase db = client.getDatabase(uri.getDatabase());
            System.out.println("connectivity success  " + updatePgSize);
            MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
            MongoCollection<Document> deviceBkpOverviewColl = db.getCollection("DEVICE_BACKUP_OVERVIEW");
            MongoCollection<Document> bkpPGColl = db.getCollection("BACKUP_PG");
            if (StringUtils.isEmpty(deviceUUIDList)) {
                DistinctIterable<String> iterable = deviceColl.distinct("deviceUUID", String.class);
                MongoCursor cursor = iterable.iterator();
                ArrayList<String> list = new ArrayList<String>();
                while (cursor.hasNext()) {
                    list.add((String)cursor.next());
                }
                System.out.println("...devlist..." + list.size());
                deviceUUIDList = list.stream().collect(Collectors.joining(","));
            }
            String[] deviceUUIDs = deviceUUIDList.split(",");
            ArrayList<String> uuids = new ArrayList<String>();
            String[] stringArray = deviceUUIDs;
            int n = deviceUUIDs.length;
            int n2 = 0;
            while (n2 < n) {
                String uuid = stringArray[n2];
                uuid = uuid.replace("[", "");
                uuid = uuid.replace("]", "");
                uuid = uuid.trim();
                uuids.add(uuid);
                ++n2;
            }
            System.out.println("uuids ..." + uuids);
            BasicDBObject inQuery = new BasicDBObject();
            inQuery.append("deviceUUID", new BasicDBObject("$in", uuids));
            FindIterable<Document> devices = deviceColl.find(inQuery);
            ArrayList<Device> devList = new ArrayList<Device>();
            for (Document dev : devices) {
                Device device2 = new Device();
                device2.setDeviceUUID(dev.getString("deviceUUID"));
                device2.setDestCollection(dev.getString("destCollection"));
                devList.add(device2);
            }
            System.out.println("total device size is...." + devList.size());
            MongoCollection<Document> newDeviceBkpOverviewColl = db.getCollection("NEW_DEVICE_BACKUP_OVERVIEW");
            if (newDeviceBkpOverviewColl == null) {
                db.createCollection("NEW_DEVICE_BACKUP_OVERVIEW");
            }
            long deviceCount = devList.size();
            long devprocessed = 0L;
            Date date = Calendar.getInstance().getTime();
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss");
            String strDate = dateFormat.format(date);
            System.out.println("....STARTDEVICE......" + strDate);
            devList.parallelStream().forEach(device -> {
                if (updateProdTable) {
                    MongoCollection<Document> newDeviceBkpOverviewCollection;
                    if (updatePgSize) {
                        LatestStorageUtilized.updatePgSizeForDevice(device, db, deviceBkpOverviewColl, newDeviceBkpOverviewColl, deviceCount, devprocessed);
                    }
                    if ((newDeviceBkpOverviewCollection = db.getCollection("NEW_DEVICE_BACKUP_OVERVIEW")) != null) {
                        String deviceUUID = device.getDeviceUUID();
                        BasicDBObject andQuery = new BasicDBObject();
                        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
                        BasicDBObject deviceCriteria = new BasicDBObject("deviceUUID", deviceUUID);
                        whereQuery.add(deviceCriteria);
                        andQuery.put("$and", whereQuery);
                        long existingStagedStorUtilized = 0L;
                        Document newdeviceBkpOverviewInfo = (Document)newDeviceBkpOverviewCollection.find(andQuery).first();
                        if (newdeviceBkpOverviewInfo.get("existingStorageUtilized") != null) {
                            existingStagedStorUtilized = (Long)newdeviceBkpOverviewInfo.get("existingStorageUtilized");
                        }
                        long storageUtilized = 0L;
                        Document deviceBkpOverviewInfo = (Document)deviceBkpOverviewColl.find(andQuery).first();
                        if (deviceBkpOverviewInfo.get("storageUtilized") != null) {
                            storageUtilized = (Long)deviceBkpOverviewInfo.get("storageUtilized");
                        }
                        long newRecalclExistingStagedStorUtilized = 0L;
                        if (newdeviceBkpOverviewInfo.get("storageUtilized") != null) {
                            newRecalclExistingStagedStorUtilized = (Long)newdeviceBkpOverviewInfo.get("storageUtilized");
                        }
                        System.out.println(String.valueOf(deviceUUID) + "....updating storage utilized values ..... (" + storageUtilized + "-" + existingStagedStorUtilized + ")+" + newRecalclExistingStagedStorUtilized + ")");
                        long latestUpdatedSize = storageUtilized - existingStagedStorUtilized + newRecalclExistingStagedStorUtilized;
                        long existingStagedLatestVersionSize = 0L;
                        if (newdeviceBkpOverviewInfo.get("existingLatestVersionStorageUtilized") != null) {
                            existingStagedLatestVersionSize = (Long)newdeviceBkpOverviewInfo.get("existingLatestVersionStorageUtilized");
                        }
                        long latestVersionsSize = 0L;
                        MongoCollection<Document> latestDeviceBkpInfoColl = db.getCollection("LATEST_DEVICE_BACKUP_INFO");
                        Document latestDeviceBkpInfo = (Document)latestDeviceBkpInfoColl.find(andQuery).first();
                        if (latestDeviceBkpInfo.get("latestVersionsSize") != null) {
                            latestVersionsSize = (Long)latestDeviceBkpInfo.get("latestVersionsSize");
                        }
                        long newRecalcLatestVersionStorageUtilized = 0L;
                        if (newdeviceBkpOverviewInfo.get("latestVersionStorageUtilized") != null) {
                            newRecalcLatestVersionStorageUtilized = (Long)newdeviceBkpOverviewInfo.get("latestVersionStorageUtilized");
                        }
                        System.out.println(String.valueOf(deviceUUID) + "....updating latest version utilized size values ..... (" + latestVersionsSize + "-" + existingStagedLatestVersionSize + ")+" + newRecalcLatestVersionStorageUtilized + ")");
                        long latestVersionsUpdatedSize = latestVersionsSize - existingStagedLatestVersionSize + newRecalcLatestVersionStorageUtilized;
                        BasicDBObject updateFields = new BasicDBObject();
                        BasicDBObject updateQuery = new BasicDBObject();
                        updateFields.append("storageUtilized", latestUpdatedSize);
                        updateQuery.append("$set", updateFields);
                        updateQuery = new BasicDBObject();
                        updateFields.append("latestVersionsSize", latestVersionsUpdatedSize);
                        updateQuery.append("$set", updateFields);
                    }
                } else {
                    if (updateStorageUtilized) {
                        LatestStorageUtilized.updateTotalStorageUtilizedSizeForDevice(device, db, deviceBkpOverviewColl, newDeviceBkpOverviewColl, deviceCount, devprocessed);
                    }
                    if (latestVerStorageUtilized) {
                        LatestStorageUtilized.updateLatestVerStorageUtilizedSizeForDevice(device, db, deviceBkpOverviewColl, newDeviceBkpOverviewColl, deviceCount, devprocessed);
                    }
                }
            });
            date = Calendar.getInstance().getTime();
            strDate = dateFormat.format(date);
            System.out.println(".... end of utility ..." + strDate);
        }
        catch (Exception e) {
            System.out.println("Exception..." + e.getMessage());
            e.printStackTrace();
        }
    }

    private static long getTotalSizeInPg(MongoDatabase db, String deviceUUID, BasicDBObject deviceCriteria) {
        MongoCollection<Document> bkpPGColl = db.getCollection("BACKUP_PG");
        BasicDBObject match = new BasicDBObject("$match", new BasicDBObject("deviceUUID", deviceUUID));
        BasicDBObject group = new BasicDBObject("$group", new BasicDBObject("_id", null).append("total", new BasicDBObject("$sum", "$size")));
        System.out.println(" starting  device for calculating total12  ......");
        AggregateIterable<Document> aggregate = bkpPGColl.aggregate(Arrays.asList(match, group)).allowDiskUse(true);
        long total = 0L;
        for (Document next : aggregate) {
            System.out.println("...iterated results ... " + next);
            if (next == null || next.get("total") == null) continue;
            System.out.println("...iterated results total.... " + next.get("total"));
            total = (Long)next.get("total");
        }
        System.out.println(" finished device for calculating total  ......" + total);
        return total;
    }

    private static long updatePgSizeForDevice(Device device, MongoDatabase db, MongoCollection deviceBkpOverviewColl, MongoCollection newDeviceBkpOverviewColl, long deviceCount, long devprocessed) {
        String deviceUUID = device.getDeviceUUID();
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        BasicDBObject deviceCriteria = new BasicDBObject("deviceUUID", deviceUUID);
        whereQuery.add(deviceCriteria);
        andQuery.put("$and", whereQuery);
        long updateSizeInKB = LatestStorageUtilized.getTotalSizeInPg(db, deviceUUID, deviceCriteria);
        Document deviceBkpOverviewInfo = LatestStorageUtilized.getExistingSizeInPg(deviceBkpOverviewColl, deviceUUID);
        System.out.println("......storage UtilizedInPg existing..." + deviceBkpOverviewInfo.get("storageUtilizedInPg") + ".....latest size ...." + (updateSizeInKB /= 1024L));
        BasicDBObject updateFields = new BasicDBObject();
        BasicDBObject updateQuery = new BasicDBObject();
        updateFields.append("storageUtilizedInPg", updateSizeInKB);
        updateQuery.append("$set", updateFields);
        if (deviceBkpOverviewInfo != null) {
            deviceBkpOverviewColl.updateOne(andQuery, updateQuery);
        }
        System.out.println(String.valueOf(deviceUUID) + "....completed pg size........" + devcount.get() + "/" + deviceCount);
        return ++devprocessed;
    }

    private static long updateTotalStorageUtilizedSizeForDevice(Device device, MongoDatabase db, MongoCollection deviceBkpOverviewColl, MongoCollection newDeviceBkpOverviewColl, long deviceCount, long devprocessed) {
        String deviceUUID = device.getDeviceUUID();
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        BasicDBObject deviceCriteria = new BasicDBObject("deviceUUID", deviceUUID);
        whereQuery.add(deviceCriteria);
        andQuery.put("$and", whereQuery);
        long updateSizeInKB = LatestStorageUtilized.getTotalSizeForDevice(db, deviceUUID, deviceCriteria, device.getDestCollection());
        Document deviceBkpOverviewInfo = LatestStorageUtilized.getExistingSizeInPg(deviceBkpOverviewColl, deviceUUID);
        System.out.println("......storage Utilized  existing..." + deviceBkpOverviewInfo.get("storageUtilized") + ".....latest size ...." + updateSizeInKB);
        BasicDBObject updateFields = new BasicDBObject();
        BasicDBObject updateQuery = new BasicDBObject();
        updateFields.append("storageUtilized", updateSizeInKB);
        updateFields.append("existingStorageUtilized", deviceBkpOverviewInfo.get("storageUtilized"));
        updateQuery.append("$set", updateFields);
        Document newdeviceBkpOverviewInfo = (Document)newDeviceBkpOverviewColl.find(andQuery).first();
        if (newdeviceBkpOverviewInfo == null) {
            Document doc = new Document();
            doc.put("deviceUUID", (Object)deviceUUID);
            doc.put("storageUtilized", (Object)updateSizeInKB);
            doc.put("existingStorageUtilized", deviceBkpOverviewInfo.get("storageUtilized"));
            newDeviceBkpOverviewColl.insertOne(doc);
        } else {
            newDeviceBkpOverviewColl.updateOne(andQuery, updateQuery);
        }
        System.out.println(String.valueOf(deviceUUID) + ".... completed total storage........" + devcount.get() + "/" + deviceCount);
        return ++devprocessed;
    }

    private static long updateLatestVerStorageUtilizedSizeForDevice(Device device, MongoDatabase db, MongoCollection deviceBkpOverviewColl, MongoCollection newDeviceBkpOverviewColl, long deviceCount, long devprocessed) {
        String deviceUUID = device.getDeviceUUID();
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        BasicDBObject deviceCriteria = new BasicDBObject("deviceUUID", deviceUUID);
        whereQuery.add(deviceCriteria);
        andQuery.put("$and", whereQuery);
        long updateSizeInKB = LatestStorageUtilized.getLatestVerSizeForDevice(device, db, deviceUUID, deviceCriteria, device.getDestCollection());
        BasicDBObject andQuery1 = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery1 = new ArrayList<BasicDBObject>();
        whereQuery1.add(new BasicDBObject("deviceUUID", deviceUUID));
        whereQuery1.add(new BasicDBObject("isDecoupled", false));
        andQuery1.put("$and", whereQuery1);
        MongoCollection<Document> latestDeviceBkpInfoColl = db.getCollection("LATEST_DEVICE_BACKUP_INFO");
        Document latestDeviceBkpInfo = (Document)latestDeviceBkpInfoColl.find(andQuery1).first();
        long existingLatestVerSize = 0L;
        if (latestDeviceBkpInfo.get("latestVersionsSize") != null) {
            existingLatestVerSize = (Long)latestDeviceBkpInfo.get("latestVersionsSize");
        }
        System.out.println("......storage Utilized  existing..." + existingLatestVerSize + ".....latest size ...." + updateSizeInKB);
        BasicDBObject updateFields = new BasicDBObject();
        BasicDBObject updateQuery = new BasicDBObject();
        updateFields.append("latestVersionStorageUtilized", updateSizeInKB);
        updateFields.append("existingLatestVersionStorageUtilized", existingLatestVerSize);
        updateQuery.append("$set", updateFields);
        Document newdeviceBkpOverviewInfo = (Document)newDeviceBkpOverviewColl.find(andQuery).first();
        if (newdeviceBkpOverviewInfo == null) {
            Document doc = new Document();
            doc.put("deviceUUID", (Object)deviceUUID);
            doc.put("latestVersionStorageUtilized", (Object)updateSizeInKB);
            doc.put("existingLatestVersionStorageUtilized", (Object)existingLatestVerSize);
            newDeviceBkpOverviewColl.insertOne(doc);
        } else {
            newDeviceBkpOverviewColl.updateOne(andQuery, updateQuery);
        }
        devcount.incrementAndGet();
        System.out.println(String.valueOf(deviceUUID) + "....ENDDEVICE latestversion storage........" + devcount.get() + "/" + deviceCount);
        return ++devprocessed;
    }

    private static long getTotalSizeForDevice(MongoDatabase db, String deviceUUID, BasicDBObject deviceCriteria, String destCollection) {
        MongoCollection<Document> bkpColl = db.getCollection(destCollection);
        Document matches = new Document("$match", new Document("deviceUUID", deviceUUID).append("folder", false).append("present", true));
        BasicDBObject group = new BasicDBObject("$group", new BasicDBObject("_id", null).append("total", new BasicDBObject("$sum", "$size")));
        System.out.println(" starting  device for calculating matches  ......");
        AggregateIterable<Document> aggregate = bkpColl.aggregate(Arrays.asList(matches, group)).allowDiskUse(true);
        long total = 0L;
        for (Document next : aggregate) {
            System.out.println("...iterated results ... " + next);
            if (next == null || next.get("total") == null) continue;
            System.out.println("...iterated results total.... " + next.get("total"));
            total = (Long)next.get("total");
        }
        System.out.println(" finished device for calculating total  ......" + total);
        return total;
    }

    private static long getLatestVerSizeForDevice(Device device, MongoDatabase db, String deviceUUID, BasicDBObject deviceCriteria, String destCollection) {
        FindIterable<Document> folders;
        MongoCollection<Document> bkpColl = db.getCollection(device.getDestCollection());
        MongoCollection<Document> deviceBkpOverviewColl = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        Document deviceBkpOverview = (Document)deviceBkpOverviewColl.find(new BasicDBObject("deviceUUID", deviceUUID)).first();
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
        whereQuery.add(new BasicDBObject("folder", true));
        whereQuery.add(new BasicDBObject("present", true));
        andQuery.put("$and", whereQuery);
        ArrayList<Document> allFoldersList = new ArrayList<Document>();
        int skip = 0;
        System.out.println("getting folders................");
        while ((folders = bkpColl.find(andQuery).skip(skip * 500).limit(500)).first() != null) {
            for (Document document : folders) {
                allFoldersList.add(document);
            }
            ++skip;
        }
        System.out.println("Done folders   " + allFoldersList.size() + " for deviceUUID " + deviceUUID);
        long latestFileSizes = 0L;
        for (Document folder : allFoldersList) {
            String folderName = "";
            folderName = StringUtils.isEmpty(folder.getString("devicePath")) ? folder.getString("fileName") : String.valueOf(folder.getString("devicePath")) + "/" + folder.getString("fileName");
            andQuery = new BasicDBObject();
            whereQuery = new ArrayList();
            whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
            whereQuery.add(new BasicDBObject("folder", false));
            whereQuery.add(new BasicDBObject("present", true));
            whereQuery.add(new BasicDBObject("devicePath", folderName));
            andQuery.put("$and", whereQuery);
            FindIterable<Document> files = bkpColl.find(andQuery);
            ArrayList<BackUpImage> allFilesList = new ArrayList<BackUpImage>();
            for (Document document : files) {
                BackUpImage backUpImage = new BackUpImage();
                backUpImage.setDevicePath(document.getString("devicePath"));
                backUpImage.setFileName(document.getString("fileName"));
                backUpImage.setLastServerModifiedTime(document.getLong("lastServerModifiedTime"));
                if (StringUtils.isEmpty(backUpImage.getDevicePath()) || StringUtils.isEmpty(backUpImage.getFileName())) continue;
                backUpImage.setSize(document.getLong("size"));
                allFilesList.add(backUpImage);
            }
            List<BackUpImage> list = LatestStorageUtilized.getFilteredBackupImageList(allFilesList);
            long folderSize = 0L;
            for (BackUpImage image : list) {
                latestFileSizes += image.getSize();
                folderSize += image.getSize();
            }
        }
        System.out.println("Total size...................................... :" + latestFileSizes + " for deviceUUID " + deviceUUID);
        return latestFileSizes;
    }

    private static List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }

    private static Document getExistingSizeInPg(MongoCollection deviceBkpOverviewColl, String deviceUUID) {
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
        andQuery.put("$and", whereQuery);
        Document deviceBkpOverviewInfo = (Document)deviceBkpOverviewColl.find(andQuery).first();
        return deviceBkpOverviewInfo;
    }
}

