/*
 * Decompiled with CFR 0.152.
 */
package utility.thread;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.Device;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.springframework.util.CollectionUtils;

public class LatestVerUpdateWithThreadNew {
    private static int skipValue;
    private static TimerTask backupTimerTask;
    private static Timer timer;
    private static int count;
    int deviceuuidCount;
    private static int threads;
    private static int limit;
    private static List<Device> devList;

    static {
        devList = new ArrayList<Device>();
    }

    public static void main(String[] args) throws ConfigurationException {
        try {
            File file = new File("serverOutput.txt");
            if (!file.exists()) {
                file.createNewFile();
            } else {
                file.delete();
                file.createNewFile();
            }
            PrintStream o = new PrintStream(file);
            System.setOut(o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("This will be written to the text file");
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String thread = config.getProperty("thread").toString();
        String deviceUUID = config.getProperty("deviceUUID").toString();
        int threadCount = Integer.parseInt(thread);
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
        MongoCollection<Document> latestDeviceBkpInfoColl = db.getCollection("LATEST_DEVICE_BACKUP_INFO");
        MongoCollection<Document> deviceBkpOverviewColl = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        Object devices = null;
        BasicDBObject andQuery2 = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery2 = new ArrayList<BasicDBObject>();
        whereQuery2.add(new BasicDBObject("deviceUUID", deviceUUID));
        andQuery2.put("$and", whereQuery2);
        Document latestDevice = (Document)deviceColl.find(andQuery2).first();
        Device device1 = new Device();
        device1.setDeviceUUID(latestDevice.getString("deviceUUID"));
        device1.setDestCollection(latestDevice.getString("destCollection"));
        device1.setDecoupled((Boolean)latestDevice.get("decoupled"));
        devList.add(device1);
        System.out.println("Converting device Db object to list of  device ...");
        System.out.println("total device size is...." + devList.size());
        int threadSizeVal = threadCount;
        ExecutorService executor = Executors.newFixedThreadPool(threadSizeVal);
        ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
        LatestVerUpdateWithThreadNew.checkThreadStatusAndStartUpdate(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, pool);
        int i = 0;
        while (i < threadSizeVal) {
            System.out.println("Creating thread for first time>>>>>>>>> i value::");
            LatestVerUpdateWithThreadNew.callUpdateDBEntries(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, pool);
            ++i;
        }
        Device device = LatestVerUpdateWithThreadNew.getDeviceFromList();
        if (device != null) {
            LatestVerUpdateWithThreadNew.updateLatestSize(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, device);
        }
    }

    private static synchronized Device getDeviceFromList() {
        Device dev = null;
        try {
            if (!CollectionUtils.isEmpty(devList) && devList.get(0) != null) {
                dev = devList.get(0);
                System.out.println(".............." + dev.getDeviceUUID());
                devList.remove(dev);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dev;
    }

    private static void checkThreadStatusAndStartUpdate(final MongoDatabase db, final MongoCollection latestDeviceBkpInfoColl, final MongoCollection deviceBkpOverviewColl, final CompletionService<String> pool) {
        if (timer == null) {
            timer = new Timer();
        }
        if (backupTimerTask == null) {
            backupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        Future future = pool.take();
                        if (future.isDone()) {
                            System.out.println(String.valueOf(Thread.currentThread().getName()) + " future is done........");
                            LatestVerUpdateWithThreadNew.callUpdateDBEntries(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, pool);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            timer.schedule(backupTimerTask, 1000L, 1000L);
        }
    }

    private static void callUpdateDBEntries(MongoDatabase db, MongoCollection latestDeviceBkpInfoColl, MongoCollection deviceBkpOverviewColl, CompletionService<String> pool) {
        Device device = LatestVerUpdateWithThreadNew.getDeviceFromList();
        if (device != null) {
            Runnable uploadJob = () -> {
                try {
                    LatestVerUpdateWithThreadNew.updateLatestSize(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, device);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            };
            pool.submit(uploadJob, "");
        }
    }

    private static List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }

    private static void updateLatestSize(MongoDatabase db, MongoCollection latestDeviceBkpInfoColl, MongoCollection deviceBkpOverviewColl, Device device) {
        FindIterable<Document> folders;
        if (device == null) {
            System.out.println(String.valueOf(Thread.currentThread().getName()) + ".......Device is empty so return");
            return;
        }
        System.out.println(String.valueOf(Thread.currentThread().getName()) + "Satrted for device :" + device.getDeviceUUID() + " on " + System.currentTimeMillis());
        MongoCollection<Document> bkpColl = db.getCollection(device.getDestCollection());
        String deviceUUID = device.getDeviceUUID();
        Document deviceBkpOverview = (Document)deviceBkpOverviewColl.find(new BasicDBObject("deviceUUID", deviceUUID)).first();
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
        whereQuery.add(new BasicDBObject("folder", true));
        whereQuery.add(new BasicDBObject("present", true));
        andQuery.put("$and", whereQuery);
        ArrayList<Document> allFoldersList = new ArrayList<Document>();
        int skip = 0;
        System.out.println(String.valueOf(Thread.currentThread().getName()) + " getting folders................");
        long latestFileSizes = 0L;
        while ((folders = bkpColl.find(andQuery).skip(skip * 200).limit(200)).first() != null) {
            for (Document document : folders) {
                allFoldersList.add(document);
            }
            ++skip;
        }
        System.out.println(String.valueOf(Thread.currentThread().getName()) + " getting folders list................" + allFoldersList.size());
        latestFileSizes = LatestVerUpdateWithThreadNew.calacluateSizeForPaths(bkpColl, deviceUUID, allFoldersList, latestFileSizes);
        allFoldersList = new ArrayList();
        System.out.println(String.valueOf(Thread.currentThread().getName()) + "Ended for device :" + device.getDeviceUUID() + " on " + System.currentTimeMillis());
    }

    private static long calacluateSizeForPaths(MongoCollection bkpColl, String deviceUUID, List<Document> allFoldersList, long latestFileSizes) {
        for (Document folder : allFoldersList) {
            FindIterable files;
            String folderName = "";
            folderName = StringUtils.isEmpty(folder.getString("devicePath")) ? folder.getString("fileName") : String.valueOf(folder.getString("devicePath")) + "/" + folder.getString("fileName");
            BasicDBObject andQuery1 = new BasicDBObject();
            ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
            whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
            whereQuery.add(new BasicDBObject("devicePath", folderName));
            whereQuery.add(new BasicDBObject("folder", false));
            whereQuery.add(new BasicDBObject("present", true));
            andQuery1.put("$and", whereQuery);
            int skip1 = 0;
            int count = 0;
            while ((files = bkpColl.find(andQuery1).skip(skip1 * 200).limit(200)).first() != null) {
                ++skip1;
                ArrayList<BackUpImage> allFilesList = new ArrayList<BackUpImage>();
                int k = 0;
                for (Document document : files) {
                    ++k;
                    BackUpImage backUpImage = new BackUpImage();
                    backUpImage.setDevicePath(document.getString("devicePath"));
                    backUpImage.setFileName(document.getString("fileName"));
                    backUpImage.setLastServerModifiedTime(document.getLong("lastServerModifiedTime"));
                    if (StringUtils.isEmpty(backUpImage.getDevicePath()) || StringUtils.isEmpty(backUpImage.getFileName())) continue;
                    backUpImage.setSize(document.getLong("size"));
                    allFilesList.add(backUpImage);
                }
                List<BackUpImage> list = LatestVerUpdateWithThreadNew.getFilteredBackupImageList(allFilesList);
                for (BackUpImage image : list) {
                    ++count;
                    latestFileSizes += image.getSize();
                    System.out.println("@PVN@" + image.getDevicePath() + "\\" + image.getFileName() + "|" + image.getSize());
                }
            }
            System.out.println(String.valueOf(folderName) + "| " + count + "|" + latestFileSizes);
        }
        return latestFileSizes;
    }
}

