/*
 * Decompiled with CFR 0.152.
 */
package utility.thread;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.Device;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.springframework.util.CollectionUtils;

public class LatestVerUpdateWithThread {
    private static int skipValue;
    private static TimerTask backupTimerTask;
    private static Timer timer;
    private static int count;
    int deviceuuidCount;
    private static int threads;
    private static int limit;
    private static List<Device> devList;

    static {
        devList = new ArrayList<Device>();
    }

    public static void main(String[] args) throws ConfigurationException {
        String mongoIP = "192.168.7.161";
        String mongoPort = "27017";
        int threadCount = 150;
        boolean startOver = false;
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
        MongoCollection<Document> latestDeviceBkpInfoColl = db.getCollection("LATEST_DEVICE_BACKUP_INFO");
        MongoCollection<Document> deviceBkpOverviewColl = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        FindIterable<Document> devices = null;
        devices = deviceColl.find();
        System.out.println("Converting device Db object to list of  device ...");
        devList = new ArrayList<Device>();
        for (Document dev : devices) {
            Device device = new Device();
            device.setDeviceUUID(dev.getString("deviceUUID"));
            device.setDestCollection(dev.getString("destCollection"));
            device.setDecoupled((Boolean)dev.get("decoupled"));
            if (!startOver) {
                BasicDBObject andQuery1 = new BasicDBObject();
                ArrayList<BasicDBObject> whereQuery1 = new ArrayList<BasicDBObject>();
                whereQuery1.add(new BasicDBObject("deviceUUID", device.getDeviceUUID()));
                andQuery1.put("$and", whereQuery1);
                Document latestDeviceBkpInfo = (Document)latestDeviceBkpInfoColl.find(andQuery1).first();
                if (latestDeviceBkpInfo != null) continue;
                devList.add(device);
                continue;
            }
            devList.add(device);
        }
        System.out.println("total device size is...." + devList.size());
        int threadSizeVal = threadCount;
        ExecutorService executor = Executors.newFixedThreadPool(threadSizeVal);
        ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
        LatestVerUpdateWithThread.checkThreadStatusAndStartUpdate(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, pool);
        int i = 0;
        while (i < threadSizeVal) {
            System.out.println("Creating thread for first time>>>>>>>>> i value::");
            LatestVerUpdateWithThread.callUpdateDBEntries(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, pool);
            ++i;
        }
        Device device = LatestVerUpdateWithThread.getDeviceFromList();
        if (device != null) {
            LatestVerUpdateWithThread.updateLatestSize(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, device);
        }
    }

    private static synchronized Device getDeviceFromList() {
        Device dev = null;
        try {
            if (!CollectionUtils.isEmpty(devList) && devList.get(0) != null) {
                dev = devList.get(0);
                System.out.println(".............." + dev.getDeviceUUID());
                devList.remove(dev);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dev;
    }

    private static void checkThreadStatusAndStartUpdate(final MongoDatabase db, final MongoCollection latestDeviceBkpInfoColl, final MongoCollection deviceBkpOverviewColl, final CompletionService<String> pool) {
        if (timer == null) {
            timer = new Timer();
        }
        if (backupTimerTask == null) {
            backupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        Future future = pool.take();
                        if (future.isDone()) {
                            System.out.println(String.valueOf(Thread.currentThread().getName()) + " future is done........");
                            LatestVerUpdateWithThread.callUpdateDBEntries(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, pool);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            timer.schedule(backupTimerTask, 1000L, 1000L);
        }
    }

    private static void callUpdateDBEntries(MongoDatabase db, MongoCollection latestDeviceBkpInfoColl, MongoCollection deviceBkpOverviewColl, CompletionService<String> pool) {
        Device device = LatestVerUpdateWithThread.getDeviceFromList();
        if (device != null) {
            Runnable uploadJob = () -> {
                try {
                    LatestVerUpdateWithThread.updateLatestSize(db, latestDeviceBkpInfoColl, deviceBkpOverviewColl, device);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            };
            pool.submit(uploadJob, "");
        }
    }

    private static List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }

    private static void updateLatestSize(MongoDatabase db, MongoCollection latestDeviceBkpInfoColl, MongoCollection deviceBkpOverviewColl, Device device) {
        FindIterable<Document> folders;
        if (device == null) {
            System.out.println(String.valueOf(Thread.currentThread().getName()) + ".......Device is empty so return");
            return;
        }
        System.out.println(String.valueOf(Thread.currentThread().getName()) + "Satrted for device :" + device.getDeviceUUID() + " on " + System.currentTimeMillis());
        MongoCollection<Document> bkpColl = db.getCollection(device.getDestCollection());
        String deviceUUID = device.getDeviceUUID();
        Document deviceBkpOverview = (Document)deviceBkpOverviewColl.find(new BasicDBObject("deviceUUID", deviceUUID)).first();
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
        whereQuery.add(new BasicDBObject("folder", true));
        whereQuery.add(new BasicDBObject("present", true));
        andQuery.put("$and", whereQuery);
        ArrayList<Document> allFoldersList = new ArrayList<Document>();
        int skip = 0;
        System.out.println(String.valueOf(Thread.currentThread().getName()) + " getting folders................");
        while ((folders = bkpColl.find(andQuery).skip(skip * 500).limit(500)).first() != null) {
            for (Document document : folders) {
                allFoldersList.add(document);
            }
            ++skip;
        }
        System.out.println(String.valueOf(Thread.currentThread().getName()) + " Done folders   " + allFoldersList.size() + " for deviceUUID " + deviceUUID);
        long latestFileSizes = 0L;
        for (Document folder : allFoldersList) {
            FindIterable<Document> files;
            String folderName = "";
            folderName = StringUtils.isEmpty(folder.getString("devicePath")) ? folder.getString("fileName") : String.valueOf(folder.getString("devicePath")) + "/" + folder.getString("fileName");
            andQuery = new BasicDBObject();
            whereQuery = new ArrayList();
            whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
            whereQuery.add(new BasicDBObject("devicePath", folderName));
            whereQuery.add(new BasicDBObject("folder", false));
            whereQuery.add(new BasicDBObject("present", true));
            andQuery.put("$and", whereQuery);
            int skip1 = 0;
            while ((files = bkpColl.find(andQuery).skip(skip1 * 200).limit(200)).first() != null) {
                ++skip1;
                ArrayList<BackUpImage> allFilesList = new ArrayList<BackUpImage>();
                int k = 0;
                for (Document document : files) {
                    ++k;
                    BackUpImage backUpImage = new BackUpImage();
                    backUpImage.setDevicePath(document.getString("devicePath"));
                    backUpImage.setFileName(document.getString("fileName"));
                    backUpImage.setLastServerModifiedTime(document.getLong("lastServerModifiedTime"));
                    if (StringUtils.isEmpty(backUpImage.getDevicePath()) || StringUtils.isEmpty(backUpImage.getFileName())) continue;
                    backUpImage.setSize(document.getLong("size"));
                    allFilesList.add(backUpImage);
                }
                List<BackUpImage> list = LatestVerUpdateWithThread.getFilteredBackupImageList(allFilesList);
                for (BackUpImage image : list) {
                    latestFileSizes += image.getSize();
                }
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " " + k + " .... path and size .... " + latestFileSizes + folderName + "..... for deviceUUID " + deviceUUID);
            }
        }
        BasicDBObject andQuery1 = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery1 = new ArrayList<BasicDBObject>();
        whereQuery1.add(new BasicDBObject("deviceUUID", deviceUUID));
        whereQuery1.add(new BasicDBObject("isDecoupled", false));
        andQuery1.put("$and", whereQuery1);
        Document latestDeviceBkpInfo = (Document)latestDeviceBkpInfoColl.find(andQuery1).first();
        if (latestDeviceBkpInfo == null) {
            Document latestBkpOverviewInfo = new Document();
            latestBkpOverviewInfo.put("deviceUUID", (Object)deviceUUID);
            latestBkpOverviewInfo.put("latestVersionsSize", (Object)latestFileSizes);
            BasicDBObject bkpOverviewAnd = new BasicDBObject();
            ArrayList<BasicDBObject> bkpOverviewQuery = new ArrayList<BasicDBObject>();
            bkpOverviewQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
            bkpOverviewQuery.add(new BasicDBObject("createdTimeStamp", (Object)System.currentTimeMillis()));
            bkpOverviewQuery.add(new BasicDBObject("isDecoupled", false));
            bkpOverviewAnd.put("$and", bkpOverviewQuery);
            if (deviceBkpOverview != null) {
                latestBkpOverviewInfo.put("storageUtilized", deviceBkpOverview.get("storageUtilized"));
            }
            latestBkpOverviewInfo.put("isDecoupled", (Object)device.isDecoupled());
            latestDeviceBkpInfoColl.insertOne(latestBkpOverviewInfo);
        } else {
            BasicDBObject updateFields = new BasicDBObject();
            BasicDBObject updateQuery = new BasicDBObject();
            updateFields.append("latestVersionsSize", latestFileSizes);
            if (deviceBkpOverview != null) {
                updateFields.put("storageUtilized", deviceBkpOverview.get("storageUtilized"));
            }
            updateFields.append("latestVersionsSize", latestFileSizes);
            updateQuery.append("$set", updateFields);
            latestDeviceBkpInfoColl.updateOne(andQuery1, updateQuery);
        }
        System.out.println(String.valueOf(Thread.currentThread().getName()) + "Ended for device :" + device.getDeviceUUID() + " on " + System.currentTimeMillis());
    }
}

