/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.artifact.TransferUtils;
import org.apache.maven.shared.artifact.filter.resolve.AbstractFilter;
import org.apache.maven.shared.artifact.filter.resolve.AndFilter;
import org.apache.maven.shared.artifact.filter.resolve.Node;
import org.apache.maven.shared.artifact.filter.resolve.PatternExclusionsFilter;
import org.apache.maven.shared.artifact.filter.resolve.PatternInclusionsFilter;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.artifact.filter.resolve.transform.ArtifactIncludeFilterTransformer;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.dependencies.resolve.DependencyResolverException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="purge-local-repository", threadSafe=true, requiresProject=false)
public class PurgeLocalRepositoryMojo
extends AbstractMojo {
    private static final String VERSION_FUZZINESS = "version";
    private static final String ARTIFACT_ID_FUZZINESS = "artifactId";
    private static final String GROUP_ID_FUZZINESS = "groupId";
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${mojo}", required=true, readonly=true)
    private MojoExecution mojoExecution;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Parameter
    private List<String> manualIncludes;
    @Parameter(property="manualInclude")
    private String manualInclude;
    @Parameter
    private List<String> includes;
    @Parameter(property="include")
    private String include;
    @Parameter
    private List<String> excludes;
    @Parameter(property="exclude")
    private String exclude;
    @Parameter(property="reResolve", defaultValue="true")
    private boolean reResolve;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Component
    private DependencyResolver dependencyResolver;
    @Component
    private ArtifactResolver artifactResolver;
    @Parameter(property="resolutionFuzziness", defaultValue="version")
    private String resolutionFuzziness;
    @Parameter(property="actTransitively", defaultValue="true")
    private boolean actTransitively;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="snapshotsOnly", defaultValue="false")
    private boolean snapshotsOnly;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info("Skipping plugin execution");
            return;
        }
        if (!StringUtils.isEmpty(this.manualInclude)) {
            this.manualIncludes = this.parseIncludes(this.manualInclude);
        }
        if (this.manualIncludes != null && this.manualIncludes.size() > 0) {
            this.manualPurge(this.manualIncludes);
            return;
        }
        HashSet<Artifact> purgedArtifacts = new HashSet<Artifact>();
        if (this.shouldPurgeAllProjectsInReactor()) {
            for (MavenProject reactorProject : this.reactorProjects) {
                this.purgeLocalRepository(reactorProject, purgedArtifacts);
            }
        } else {
            this.purgeLocalRepository(this.project, purgedArtifacts);
        }
    }

    private boolean shouldPurgeAllProjectsInReactor() {
        MojoExecution.Source source = this.mojoExecution.getSource();
        return this.reactorProjects.size() > 1 && source == MojoExecution.Source.CLI;
    }

    private void purgeLocalRepository(MavenProject theProject, Set<Artifact> purgedArtifacts) throws MojoFailureException {
        TransformableFilter dependencyFilter;
        List<Dependency> dependencies = theProject.getDependencies();
        Set<Artifact> resolvedArtifactsToPurge = this.getFilteredResolvedArtifacts(theProject, dependencies, dependencyFilter = this.createPurgeArtifactsFilter(theProject, dependencies, purgedArtifacts));
        if (resolvedArtifactsToPurge.isEmpty()) {
            this.getLog().info("No artifacts included for purge for project: " + theProject.getId());
            return;
        }
        this.verbose("Purging dependencies for project: " + theProject.getId());
        this.purgeArtifacts(resolvedArtifactsToPurge);
        purgedArtifacts.addAll(resolvedArtifactsToPurge);
        if (this.reResolve) {
            ArtifactFilter artifactFilter = dependencyFilter.transform(new ArtifactIncludeFilterTransformer());
            try {
                this.reResolveArtifacts(theProject, resolvedArtifactsToPurge, artifactFilter);
            }
            catch (ArtifactResolutionException e) {
                String failureMessage = "Failed to refresh project dependencies for: " + theProject.getId();
                MojoFailureException failure = new MojoFailureException(failureMessage);
                failure.initCause(e);
                throw failure;
            }
            catch (ArtifactNotFoundException e) {
                String failureMessage = "Failed to refresh project dependencies for: " + theProject.getId();
                MojoFailureException failure = new MojoFailureException(failureMessage);
                failure.initCause(e);
                throw failure;
            }
        }
    }

    private void manualPurge(List<String> theIncludes) throws MojoExecutionException {
        for (String gavPattern : theIncludes) {
            File purgeDir;
            if (StringUtils.isEmpty(gavPattern)) {
                this.getLog().debug("Skipping empty gav pattern: " + gavPattern);
                continue;
            }
            String relativePath = this.gavToPath(gavPattern);
            if (StringUtils.isEmpty(relativePath) || !(purgeDir = new File(this.localRepository.getBasedir(), relativePath)).exists()) continue;
            this.getLog().debug("Deleting directory: " + purgeDir);
            try {
                FileUtils.deleteDirectory(purgeDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to purge directory: " + purgeDir);
            }
        }
    }

    private String gavToPath(String gav) {
        if (StringUtils.isEmpty(gav)) {
            return null;
        }
        String[] pathComponents = gav.split(":");
        StringBuilder path = new StringBuilder(pathComponents[0].replace('.', '/'));
        for (int i = 1; i < pathComponents.length; ++i) {
            path.append("/").append(pathComponents[i]);
        }
        return path.toString();
    }

    private TransformableFilter createPurgeArtifactsFilter(MavenProject theProject, List<Dependency> dependencies, Set<Artifact> purgedArtifacts) {
        ArrayList<TransformableFilter> subFilters = new ArrayList<TransformableFilter>();
        subFilters.add(ScopeFilter.excluding("system"));
        if (this.snapshotsOnly) {
            subFilters.add(new SnapshotsFilter());
        }
        if (!StringUtils.isEmpty(this.include)) {
            this.includes = this.parseIncludes(this.include);
        }
        if (this.includes != null) {
            subFilters.add(new PatternInclusionsFilter(this.includes));
        }
        if (!StringUtils.isEmpty(this.exclude)) {
            this.excludes = this.parseIncludes(this.exclude);
        }
        if (this.excludes != null) {
            subFilters.add(new PatternExclusionsFilter(this.excludes));
        }
        if (!this.actTransitively) {
            subFilters.add(new DirectDependencyFilter(theProject.getArtifact(), dependencies));
        }
        ArrayList<String> exclusions = new ArrayList<String>(this.reactorProjects.size());
        for (MavenProject reactorProject : this.reactorProjects) {
            exclusions.add(this.toPatternExcludes(reactorProject.getArtifact()));
        }
        for (Artifact purgedArtifact : purgedArtifacts) {
            exclusions.add(this.toPatternExcludes(purgedArtifact));
        }
        subFilters.add(new PatternExclusionsFilter(exclusions));
        return new AndFilter(subFilters);
    }

    private String toPatternExcludes(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getArtifactHandler().getExtension() + ":" + artifact.getVersion();
    }

    private List<String> parseIncludes(String theInclude) {
        ArrayList<String> theIncludes = new ArrayList<String>();
        if (theInclude != null) {
            String[] elements = theInclude.split(",");
            theIncludes.addAll(Arrays.asList(elements));
        }
        return theIncludes;
    }

    private Set<Artifact> getFilteredResolvedArtifacts(MavenProject theProject, List<Dependency> dependencies, TransformableFilter filter) {
        try {
            Iterable<ArtifactResult> results = this.dependencyResolver.resolveDependencies(this.session.getProjectBuildingRequest(), theProject.getModel(), filter);
            LinkedHashSet<Artifact> resolvedArtifacts = new LinkedHashSet<Artifact>();
            for (ArtifactResult artResult : results) {
                resolvedArtifacts.add(artResult.getArtifact());
            }
            return resolvedArtifacts;
        }
        catch (DependencyResolverException e) {
            this.getLog().info("Unable to resolve all dependencies for: " + theProject.getGroupId() + ":" + theProject.getArtifactId() + ":" + theProject.getVersion() + ". Falling back to non-transitive mode for initial artifact resolution.");
            LinkedHashSet<Artifact> resolvedArtifacts = new LinkedHashSet<Artifact>();
            ArtifactFilter artifactFilter = filter.transform(new ArtifactIncludeFilterTransformer());
            for (Dependency dependency : dependencies) {
                DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
                coordinate.setGroupId(dependency.getGroupId());
                coordinate.setArtifactId(dependency.getArtifactId());
                coordinate.setVersion(dependency.getVersion());
                coordinate.setExtension(this.artifactHandlerManager.getArtifactHandler(dependency.getType()).getExtension());
                try {
                    Artifact artifact = this.artifactResolver.resolveArtifact(this.session.getProjectBuildingRequest(), coordinate).getArtifact();
                    if (!artifactFilter.include(artifact)) continue;
                    resolvedArtifacts.add(artifact);
                }
                catch (ArtifactResolverException e2) {
                    this.getLog().debug("Unable to resolve artifact: " + coordinate);
                }
            }
            return resolvedArtifacts;
        }
    }

    private void purgeArtifacts(Set<Artifact> artifacts) throws MojoFailureException {
        for (Artifact artifact : artifacts) {
            this.verbose("Purging artifact: " + artifact.getId());
            File deleteTarget = this.findDeleteTarget(artifact);
            this.verbose("Deleting: " + deleteTarget);
            if (deleteTarget.isDirectory()) {
                try {
                    FileUtils.deleteDirectory(deleteTarget);
                }
                catch (IOException e) {
                    this.getLog().warn("Unable to purge local repository location: " + deleteTarget, e);
                }
            } else if (!deleteTarget.delete()) {
                deleteTarget.deleteOnExit();
                this.getLog().warn("Unable to purge local repository location immediately: " + deleteTarget);
            }
            artifact.setResolved(false);
        }
    }

    private void reResolveArtifacts(MavenProject theProject, Set<Artifact> artifacts, ArtifactFilter filter) throws ArtifactResolutionException, ArtifactNotFoundException {
        for (Artifact artifact : artifacts) {
            try {
                this.artifactResolver.resolveArtifact(this.session.getProjectBuildingRequest(), TransferUtils.toArtifactCoordinate(artifact));
            }
            catch (ArtifactResolverException e) {
                this.verbose(e.getMessage());
            }
        }
        ArrayList<Artifact> missingArtifacts = new ArrayList<Artifact>();
        for (Artifact artifact : artifacts) {
            this.verbose("Resolving artifact: " + artifact.getId());
            try {
                this.artifactResolver.resolveArtifact(this.session.getProjectBuildingRequest(), artifact);
            }
            catch (ArtifactResolverException e) {
                this.verbose(e.getMessage());
                missingArtifacts.add(artifact);
            }
        }
        if (missingArtifacts.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer("required artifacts missing:\n");
            for (Artifact missingArtifact : missingArtifacts) {
                stringBuffer.append("  ").append(missingArtifact.getId()).append('\n');
            }
            stringBuffer.append("\nfor the artifact:");
            throw new ArtifactResolutionException(stringBuffer.toString(), theProject.getArtifact(), theProject.getRemoteArtifactRepositories());
        }
    }

    private File findDeleteTarget(Artifact artifact) {
        File deleteTarget = new File(this.localRepository.getBasedir(), this.localRepository.pathOf(artifact));
        if (GROUP_ID_FUZZINESS.equals(this.resolutionFuzziness)) {
            deleteTarget = deleteTarget.getParentFile().getParentFile().getParentFile();
        } else if (ARTIFACT_ID_FUZZINESS.equals(this.resolutionFuzziness)) {
            deleteTarget = deleteTarget.getParentFile().getParentFile();
        } else if (VERSION_FUZZINESS.equals(this.resolutionFuzziness)) {
            deleteTarget = deleteTarget.getParentFile();
        }
        return deleteTarget;
    }

    private void verbose(String message) {
        if (this.verbose || this.getLog().isDebugEnabled()) {
            this.getLog().info(message);
        }
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    private class SnapshotsFilter
    extends AbstractFilter {
        private SnapshotsFilter() {
        }

        @Override
        public boolean accept(Node node, List<Node> parents) {
            if (node.getDependency() == null) {
                return false;
            }
            return ArtifactUtils.isSnapshot(node.getDependency().getVersion());
        }
    }

    private class DirectDependencyFilter
    extends AbstractFilter {
        private Artifact projectArtifact;
        private List<Dependency> directDependencies;

        DirectDependencyFilter(Artifact projectArtifact, List<Dependency> directDependencies) {
            this.projectArtifact = projectArtifact;
            this.directDependencies = directDependencies;
        }

        @Override
        public boolean accept(Node node, List<Node> parents) {
            if (this.artifactsGAMatch(node, this.projectArtifact.getGroupId(), this.projectArtifact.getArtifactId())) {
                return true;
            }
            for (Dependency dep : this.directDependencies) {
                if (!this.artifactsGAMatch(node, dep.getGroupId(), dep.getArtifactId())) continue;
                return true;
            }
            return false;
        }

        private boolean artifactsGAMatch(Node node, String groupId, String artifactId) {
            if (node.getDependency() == null) {
                return false;
            }
            if (!node.getDependency().getGroupId().equals(groupId)) {
                PurgeLocalRepositoryMojo.this.getLog().debug("Different groupId: " + node.getDependency() + "  " + groupId);
                return false;
            }
            if (!node.getDependency().getArtifactId().equals(artifactId)) {
                PurgeLocalRepositoryMojo.this.getLog().debug("Different artifactId: " + node.getDependency() + "  " + artifactId);
                return false;
            }
            return true;
        }
    }
}

