/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.container.initialization;

import java.util.Map;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.container.initialization.AbstractCoreComponentInitializationPhase;
import org.codehaus.plexus.container.initialization.ContainerInitializationContext;
import org.codehaus.plexus.container.initialization.ContainerInitializationException;
import org.codehaus.plexus.logging.LoggerManager;

public class InitializeLoggerManagerPhase
extends AbstractCoreComponentInitializationPhase {
    public void initializeCoreComponent(ContainerInitializationContext context) throws ContainerInitializationException {
        LoggerManager loggerManager = context.getContainer().getLoggerManager();
        if (loggerManager == null) {
            try {
                Map<String, Object> loggers = context.getContainer().lookupMap(LoggerManager.ROLE);
                loggerManager = (LoggerManager)loggers.get(loggers.keySet().iterator().next());
                context.getContainer().setLoggerManager(loggerManager);
            }
            catch (ComponentLookupException e) {
                throw new ContainerInitializationException("Unable to locate logger manager", e);
            }
        }
        context.getContainer().enableLogging(loggerManager.getLoggerForComponent(PlexusContainer.class.getName()));
    }
}

