/*
 * Decompiled with CFR 0.152.
 */
package com.pg.sync.service.impl;

import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.dao.UserSyncOverViewDao;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.ConsolidatedImage;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.FileRevision;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.SyncPolicy;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserSyncOverView;
import com.pg.dao.FileDao;
import com.pg.dao.SyncFileDao;
import com.pg.domain.BackupFile;
import com.pg.domain.ChunkFile;
import com.pg.domain.FileInfo;
import com.pg.element.SyncFileElement;
import com.pg.encryption.service.FileEncryptionService;
import com.pg.exception.BaseException;
import com.pg.exception.ParacloudBackupException;
import com.pg.exception.ResourceFunnelException;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MD5Generator;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.service.UtilService;
import com.pg.service.impl.BaseUploadService;
import com.pg.sync.service.SyncUploadService;
import com.pg.util.FileUtils;
import com.pg.util.PathConversionHelper;
import com.pg.util.PathGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SyncUploadServiceImpl
extends BaseUploadService
implements SyncUploadService {
    private static Logger logger = LoggerFactory.getLogger(SyncUploadServiceImpl.class);
    private FileDao fileDao;
    private DeviceDao deviceDao;
    private ExternalStorageBackupFileDao externalStorageBackupFileDao;
    private SyncFileDao syncFileDao;
    @Autowired
    private FileEncryptionService fileEncryptionService;
    @Autowired
    private UtilService utilService;
    private UserDao userDao;
    private UserSyncOverViewDao userSyncOverViewDao;

    public void setFileDao(FileDao fileDao) {
        this.fileDao = fileDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public void setExternalStorageBackupFileDao(ExternalStorageBackupFileDao externalStorageBackupFileDao) {
        this.externalStorageBackupFileDao = externalStorageBackupFileDao;
    }

    public void setSyncFileDao(SyncFileDao syncFileDao) {
        this.syncFileDao = syncFileDao;
    }

    public void setFileEncryptionService(FileEncryptionService fileEncryptionService) {
        this.fileEncryptionService = fileEncryptionService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public void setUserSyncOverViewDao(UserSyncOverViewDao userSyncOverViewDao) {
        this.userSyncOverViewDao = userSyncOverViewDao;
    }

    private void uploadFileToAzureBlob(String cloudName, File file, String deviceUUID, BackupFile fileInfo, String gatewayName, boolean nonChunkable) throws BaseException {
        File encryptedFile;
        String pathname = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + cloudName + "/sync-upload/" + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        this.createFoldersForUpload(pathname);
        String encryptedFileName = file.getName() + "." + fileInfo.getBackupId().toString();
        if (!StringUtils.isEmpty((String)PCHelperConstant.getPropertyFileValueEncryptionEnabled()) && "true".equals(PCHelperConstant.getPropertyFileValueEncryptionEnabled())) {
            encryptedFile = new File(pathname + "encrypted/" + encryptedFileName);
            String syncUniqueKey = "d8e87c0927539672f54462c837be0b7f";
            String saltKey = this.utilService.getEncryptionKey(1, "sync");
            encryptedFile = this.fileEncryptionService.encrypt(saltKey, syncUniqueKey, file, encryptedFile);
            logger.debug(encryptedFileName + "after Encryption........^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        } else {
            encryptedFile = file;
            logger.debug("fileName...." + encryptedFile.getName());
        }
        logger.debug(" BEFORE UPLOAD FILE .... ");
        if (PCHelperConstant.getPropertyFileValueSyncFtpEnabled()) {
            SyncUploadServiceImpl.uploadFile(encryptedFile);
        } else {
            this.uploadFileInLocalPath(encryptedFile);
        }
        logger.debug(" AFTER UPLOAD FILE .... ");
        try {
            ChunkFile chunkFile = new ChunkFile();
            chunkFile.setFileName(file.getName());
            chunkFile.setMd5(MD5Generator.generateMD5OfFile((File)file));
            chunkFile.setFileId(file.getName());
            chunkFile.setFileSource(file.getName());
            chunkFile.setfSPath("fSPath");
            chunkFile.setUploadedTimeStamp(System.currentTimeMillis());
            fileInfo.getChunkFiles().add(chunkFile);
        }
        catch (Exception e) {
            logger.error(" JSON EXEPTION " + e);
        }
        encryptedFile.deleteOnExit();
    }

    private void uploadFileInLocalPath(File encryptedFile) {
        String intermediateUploadFolder = PCHelperConstant.getPropertyFileValueSyncUploadPath();
        try {
            File intermediateFile = new File(intermediateUploadFolder + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + encryptedFile.getName());
            FileInputStream inputStream = new FileInputStream(encryptedFile);
            this.readFileItemAndUploadToTempPath(encryptedFile.getName(), intermediateUploadFolder, intermediateFile, inputStream);
        }
        catch (NoSuchAlgorithmException e) {
            logger.trace("" + e);
            logger.error("Exception While Uploading File In Local Path :" + e.getMessage());
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error("Exception While Uploading File in Local Path :" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uploadFile(File file) {
        FTPClient ftpClient = new FTPClient();
        try {
            ftpClient.connect(PCHelperConstant.getSyncFtpHostProperty());
            boolean login = ftpClient.login(PCHelperConstant.getSyncFtpUserProperty(), PCHelperConstant.getSyncFtpPwdProperty());
            ftpClient.setFileType(2);
            if (login) {
                logger.debug("Connection established...");
                FileInputStream inputStream = new FileInputStream(file);
                boolean uploaded = ftpClient.storeFile(PCHelperConstant.getPropertyFileValueSyncUploadPath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + file.getName(), (InputStream)inputStream);
                logger.debug(file.getPath() + " .....File path and file name....   " + file.getName());
                if (uploaded) {
                    logger.debug("File uploaded successfully !");
                } else {
                    logger.debug("Error in uploading file !!!!! " + ftpClient.getReplyCode());
                }
                boolean logout = ftpClient.logout();
                if (logout) {
                    logger.debug("Connection close...");
                }
            } else {
                logger.debug("Connection fail...");
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Uploading File :" + e.getMessage());
        }
        finally {
            try {
                ftpClient.disconnect();
            }
            catch (IOException e) {
                logger.trace("" + e);
                logger.error("Exception While Uploading File :" + e.getMessage());
            }
        }
    }

    @Override
    public boolean uploadAllSyncFilesToLocalStorage(String cloudName, FileInfo fileInfo, String gatewayName) {
        logger.debug("  INSIDE uploadAllSyncFilesToLocalStorage ..... ");
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
        String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "chunk";
        BackupFile backupFile = new BackupFile();
        backupFile.setChunkFiles(new ArrayList());
        backupFile.setFileName(fileInfo.getFileName());
        backupFile.setFilePath(fileInfo.getFilePath());
        backupFile.setMd5(fileInfo.getMd5());
        backupFile.setSize(fileInfo.getSize());
        backupFile.setBackupId(new ObjectId(fileInfo.getId()));
        backupFile.setDeviceUUID(fileInfo.getDeviceUUID());
        if (StringUtils.isEmpty((String)fileInfo.getDedupBackupId())) {
            logger.debug("  INSIDE uploadAllSyncFilesToLocalStorage no dedup  ..... ");
            this.uploadAllChunksToAzureBlob(cloudName, fileInfo, gatewayName, chunkFilePath, backupFile);
        } else {
            logger.debug("@#@#@#INside dedupification ..... ");
            List<ChunkFile> list = this.utilService.getSyncFileIfExists(fileInfo.getDedupBackupId());
            if (CollectionUtils.isEmpty(list)) {
                logger.debug("@#@#@#INside dedupification list empty..... false");
                return false;
            }
            backupFile.setChunkFiles(list);
        }
        backupFile.setDedupBackupId(fileInfo.getDedupBackupId());
        this.updateSyncRevisionTable(cloudName, backupFile.getBackupId().toString(), "ES");
        logger.debug("  Before calling sync ");
        this.saveSyncFileInfoInMainDB(backupFile, cloudName, gatewayName);
        logger.debug("@#@#@#FILE upload success for dedup ..... true");
        return true;
    }

    private void uploadAllChunksToAzureBlob(String cloudName, FileInfo fileInfo, String gatewayName, String chunkFilePath, BackupFile backupFile) {
        if (StringUtils.isEmpty((String)PCHelperConstant.getPropertyFileValueEncryptionEnabled()) || !"true".equals(PCHelperConstant.getPropertyFileValueEncryptionEnabled())) {
            String filePath = this.mergeAllChunksAndCreateSingleFile(fileInfo, chunkFilePath, cloudName);
            File file = new File(filePath);
            logger.debug("AzureBlob upload  FILE started inside no encryption..... " + file.getName());
            long fileSize = file.length();
            Long uploadSpeed = this.checkNThrottleAndUploadChunkFileToAzureBlob(cloudName, fileInfo, gatewayName, backupFile, file.getName(), file, fileSize);
            if (uploadSpeed != null) {
                // empty if block
            }
            return;
        }
        for (String fileName : fileInfo.getChunkFiles()) {
            logger.debug("AzureBlob upload  FILE started ..... " + fileName);
            File file = new File(chunkFilePath + "/" + fileName);
            long fileSize = file.length();
            Long uploadSpeed = this.checkNThrottleAndUploadChunkFileToAzureBlob(cloudName, fileInfo, gatewayName, backupFile, fileName, file, fileSize);
            if (uploadSpeed == null) continue;
        }
    }

    private String mergeAllChunksAndCreateSingleFile(FileInfo fileInfo, String chunkFilePath, String cloudName) {
        logger.debug("inside merge into a single file............");
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
        String destinationPath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "merge" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileInfo.getFileName();
        FileUtils.merge((List)fileInfo.getChunkFiles(), (String)chunkFilePath, (String)destinationPath);
        return destinationPath;
    }

    private Long checkNThrottleAndUploadChunkFileToAzureBlob(String cloudName, FileInfo fileInfo, String gatewayName, BackupFile backupFile, String fileName, File file, long fileSize) {
        Long uploadSpeed = 0L;
        logger.debug("throttle limit not reached");
        try {
            this.uploadFileToAzureBlob(cloudName, file, fileInfo.getDeviceUUID(), backupFile, gatewayName, false);
        }
        catch (Exception e) {
            BackupFile backupFileObj;
            logger.trace("" + e);
            logger.error("Exception While Checking Throttle and Uploading File to Azure Blob :" + e.getMessage());
            logger.debug(" UNABLE TO UPLOAD FILES ..... " + file.getName());
            if (!StringUtils.isEmpty((String)fileInfo.getPrevBackupId()) && (backupFileObj = this.fileDao.getSyncFile("", cloudName, fileInfo.getPrevBackupId(), gatewayName)) != null) {
                for (ChunkFile chunkFile : backupFileObj.getChunkFiles()) {
                    if (!fileName.equals(chunkFile.getFileName())) continue;
                    backupFile.getChunkFiles().add(chunkFile);
                }
            }
            uploadSpeed = null;
        }
        return uploadSpeed;
    }

    @Override
    public void deleteUploadedFiles(FileInfo fileInfo, String cloudName, String gatewayName) {
        this.fileDao.deleteSyncFile(fileInfo, cloudName, gatewayName);
    }

    @Override
    public long getThreadSize(String cloudName) {
        return this.fileDao.getThreadSize(cloudName);
    }

    private void updateSyncRevisionTable(String cloudName, String syncRevisionId, String storagePlace) {
        logger.debug("INSIDE update sync table after upload to external storage ..... ");
        CloseableHttpClient httpclient = HttpClientUtil.getSSlConnection();
        try {
            String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/paracloud/cloud/" + cloudName + "/update/sync/table";
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("syncRevisionId", syncRevisionId);
            httpPost.setHeader("storage-place", storagePlace);
            httpclient.execute((HttpUriRequest)httpPost);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Updating Sync Revision Table :" + e.getMessage());
        }
    }

    private void readFileItemAndUploadToTempPath(String fileName, String intermediateUploadCompleteFolderPath, File intermediateFile, InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        File intermediateFolder = new File(intermediateUploadCompleteFolderPath);
        logger.debug("inside local storage sync>>>>>>>>>>>>2222222222222222222222");
        if (!intermediateFolder.exists() && !intermediateFolder.mkdirs()) {
            throw new ParacloudBackupException("Folder Cannot be created", 500);
        }
        this.tranferFileFromStream(inputStream, intermediateFile);
    }

    private void tranferFileFromStream(InputStream inputStream, File intermediateFile) throws NoSuchAlgorithmException, IOException {
        logger.debug("inside local storage sync>>>>>>>>>>>>3333333333333");
        byte[] b = new byte[4096];
        intermediateFile.createNewFile();
        try (FileOutputStream outstream = new FileOutputStream(intermediateFile);){
            int buff = -1;
            while ((buff = inputStream.read(b)) != -1) {
                outstream.write(b, 0, buff);
            }
        }
        catch (FileNotFoundException e) {
            logger.debug("Exception", (Throwable)e);
            intermediateFile.delete();
            throw new ParacloudBackupException("IO Exception while creating tempFile" + e, 500);
        }
        catch (IOException e) {
            logger.debug("Exception", (Throwable)e);
            intermediateFile.delete();
            throw new ParacloudBackupException("IO Exception while transfering from client" + e, 500);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    @Override
    public FileRevision insertSyncEntryForFile(int cloudId, String cloudName, Cloud cloud, SyncFileElement fileElement, int miniCloudId, String deviceUUID, boolean isCompressed) throws BaseException {
        logger.debug("Uploading file ............. " + deviceUUID);
        String fileName = null;
        String convertedPath = null;
        ConsolidatedImage consolidatedImageOldRecord = null;
        String newStatus = "";
        try {
            String userName;
            Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, cloudName, deviceUUID);
            String osType = device.getOsType();
            boolean type = osType.equals("Android");
            convertedPath = PathConversionHelper.getServerCompatiblePath((String)fileElement.getFileCompletePath(), (boolean)type);
            fileElement.setFileCompletePath(convertedPath);
            fileName = fileElement.getFileName();
            String userNameVal = userName = device.getUserName();
            boolean isPathInsideMC = this.isPathInsideMC(cloudId, fileElement.getFileCompletePath());
            if (isPathInsideMC) {
                userNameVal = "";
            }
            consolidatedImageOldRecord = this.readFromConsolidatedImageDb(cloud.getCloudId(), userNameVal, cloudName, fileElement);
            boolean lastRecordPresent = this.isRecordPresent(consolidatedImageOldRecord);
            boolean isSizeAlreadyAdded = false;
            boolean noChange = false;
            if (lastRecordPresent) {
                noChange = this.checkIfRevisionHasBeenModified(fileElement, consolidatedImageOldRecord);
            }
            if (lastRecordPresent && noChange) {
                logger.debug(" File already exists no change in file ....");
                FileRevision latestRevision = this.syncFileDao.getLatestRevision(cloudId, cloudName, consolidatedImageOldRecord.getId());
                if (latestRevision != null) {
                    newStatus = latestRevision.getStatus();
                }
                isSizeAlreadyAdded = true;
            } else {
                newStatus = lastRecordPresent ? PCHelperConstant.REVISION_STATUS.MODIFIED.toString() : PCHelperConstant.REVISION_STATUS.ADDED.toString();
            }
            if (!isSizeAlreadyAdded) {
                long filesize = Long.parseLong(fileElement.getSize());
                double fileSizeInKb = (long)Math.ceil((double)filesize / 1024.0);
                logger.debug(" filesize---->>> " + filesize);
                double storageUtilized = 0.0;
                User user = this.userDao.getUserByName(1, userName);
                if (user != null) {
                    UserSyncOverView userSyncOverView = user.getUserSyncOverView();
                    if (userSyncOverView != null) {
                        storageUtilized = userSyncOverView.getStorageUtilized();
                        storageUtilized += fileSizeInKb;
                    } else {
                        userSyncOverView = new UserSyncOverView();
                    }
                    userSyncOverView.setStorageUtilized(storageUtilized);
                    this.userSyncOverViewDao.saveUserSyncOverViewToDB(cloudId, userSyncOverView);
                }
            }
            logger.debug(newStatus + " before  updateModifiedTimeStamp " + lastRecordPresent);
            this.updateModifiedTimeStamp(cloudId, userName, cloudName, fileElement.getFileCompletePath(), System.currentTimeMillis());
            logger.debug(" after  updateModifiedTimeStamp  " + lastRecordPresent);
            return this.uploadFileToCloudForSync(cloud, cloudName, fileElement, device, fileName, newStatus, consolidatedImageOldRecord, isPathInsideMC, isCompressed);
        }
        catch (Exception e) {
            logger.error("@Exception@", (Throwable)e);
            throw new ResourceFunnelException("Exception occured in uploadImpl" + e, 500);
        }
    }

    private FileRevision uploadFileToCloudForSync(Cloud cloud, String cloudName, SyncFileElement fileElement, Device device, String fileName, String newStatus, ConsolidatedImage consolidatedImage, boolean isPathInsideMC, boolean isCompressed) throws IOException, NoSuchAlgorithmException {
        ConsolidatedImage consolidatedImageTemp = consolidatedImage;
        String intermediateUploadFolder = device.getDeviceTempPath();
        File intermediateFile = new File(intermediateUploadFolder + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
        long fileSizeinBytes = Long.parseLong(fileElement.getSize());
        long filesizeInKB = (long)Math.ceil((double)fileSizeinBytes / 1024.0);
        fileElement.setSize(String.valueOf(filesizeInKB));
        if (consolidatedImageTemp == null) {
            consolidatedImageTemp = new ConsolidatedImage();
        }
        consolidatedImageTemp.setUserName(device.getUserName());
        this.convertToConsolidatedImageForSync(fileElement, device.getDeviceUUID(), consolidatedImageTemp);
        FileRevision fileRevision = new FileRevision();
        String fsPath = PathGenerator.getFsPath((String)consolidatedImageTemp.getMD5());
        SyncUploadServiceImpl.convertToFileRevision(consolidatedImageTemp, device.getDeviceUUID(), fileRevision, fsPath, newStatus, device.getUserName());
        fileRevision.setGatewayName(fileElement.getGatewayName());
        fileRevision.setCompressed(isCompressed);
        return this.saveFileRevisionToDatabaseForSync(cloud.getCloudId(), device.getUserName(), cloudName, cloud, fileRevision, intermediateFile, device.getDeviceUUID(), fsPath, fileSizeinBytes, consolidatedImageTemp, isPathInsideMC);
    }

    private void convertToConsolidatedImageForSync(SyncFileElement fileElement, String regID, ConsolidatedImage conso) {
        conso.setDevicePath(fileElement.getFileCompletePath());
        conso.setFileName(fileElement.getFileName());
        long modifiedTimeStampDate = fileElement.getLastModifiedTimestamp();
        long timeMilliSec = System.currentTimeMillis();
        conso.setCrawlStartTimestamp(timeMilliSec);
        conso.setFolder(fileElement.isFolder());
        conso.setPresent(fileElement.isExists());
        conso.setMD5(fileElement.getMd5checksum());
        conso.setMetaData(fileElement.getMetaData());
        conso.setRegID(regID);
        conso.setModifiedTime(String.valueOf(modifiedTimeStampDate));
        try {
            if (fileElement.getSize() != null && !"".equals(fileElement.getSize())) {
                conso.setSize(Double.parseDouble(fileElement.getSize()));
            }
        }
        catch (Exception e) {
            logger.debug("Exception", (Throwable)e);
        }
    }

    public FileRevision saveFileRevisionToDatabaseForSync(int cloudId, String userName, String cloudName, Cloud cloud, FileRevision fileRevision, File fileIntermediateLocation, String regId, String fsPath, long fileSizeinBytes, ConsolidatedImage oldImage, boolean isPathInsideMC) throws IOException {
        this.createParentFolderIfNotExists(cloud.getCloudId(), cloudName, fileRevision.getConsolidatedImage(), regId, fsPath, fileRevision.getUserName(), isPathInsideMC);
        this.saveToDatabase(cloud.getCloudId(), cloudName, fileRevision.getConsolidatedImage());
        this.syncFileDao.saveRevision(cloud.getCloudId(), cloudName, fileRevision);
        String pathToOriginalFile = PCHelperConstant.getPropertyFileValueParabluFolderBasePath((String)cloudName) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
        File fileInOriginalCompleteUploadFolder = new File(pathToOriginalFile);
        File parentFolderInOriginalCompleteUploadFolder = fileInOriginalCompleteUploadFolder.getParentFile();
        if (!parentFolderInOriginalCompleteUploadFolder.exists()) {
            parentFolderInOriginalCompleteUploadFolder.mkdirs();
        }
        this.handleVersioning(cloud, userName, cloudName, fileRevision);
        return fileRevision;
    }

    public void createParentFolderIfNotExists(int cloudId, String cloudName, ConsolidatedImage consolidatedImageForChild, String regId, String fsPath, String userName, boolean isPathInsideMC) {
        ConsolidatedImage consolidatedImageForParent;
        String status = PCHelperConstant.REVISION_STATUS.ADDED.toString();
        String parent = consolidatedImageForChild.getDevicePath();
        int lastIndex = parent.lastIndexOf(47);
        if (lastIndex == -1) {
            return;
        }
        String devicePath = parent.substring(0, parent.lastIndexOf(47));
        String fileName = parent.substring(devicePath.length() + 1, parent.length());
        logger.debug("RESOURCE FUNNEL>>>>>>>>>>DEVICE PATH>>>>>>>>" + devicePath + "fileName>>>>>>>>>>>" + fileName);
        String userNameVal = userName;
        if (isPathInsideMC) {
            userNameVal = "";
        }
        if ((consolidatedImageForParent = this.syncFileDao.getConsolidatedImageDBRecordByDevicePathWithoutRegex(cloudId, userNameVal, cloudName, devicePath, fileName)) == null || consolidatedImageForParent.isPresent()) {
            return;
        }
        consolidatedImageForParent.setPresent(true);
        consolidatedImageForParent.setRegID(consolidatedImageForChild.getRegID());
        consolidatedImageForParent.setCrawlStartTimestamp(System.currentTimeMillis());
        consolidatedImageForParent.setUserName(userName);
        FileRevision fileRevision = new FileRevision();
        SyncUploadServiceImpl.convertToFileRevision(consolidatedImageForParent, regId, fileRevision, fsPath, status, userName);
        this.syncFileDao.saveToConsolidatedImageDB(cloudId, cloudName, consolidatedImageForParent);
        this.syncFileDao.saveRevision(cloudId, cloudName, fileRevision);
        this.createParentFolderIfNotExists(cloudId, cloudName, consolidatedImageForParent, regId, fsPath, userName, isPathInsideMC);
    }

    private boolean isRecordPresent(ConsolidatedImage consolidatedImage) {
        return consolidatedImage != null && consolidatedImage.isPresent();
    }

    private ConsolidatedImage readFromConsolidatedImageDb(int cloudId, String userName, String cloudName, SyncFileElement fileElement) {
        ConsolidatedImage consolidatedImageOldRecord = this.readFromAccordingToPathDatabase(cloudId, userName, cloudName, fileElement.getFileCompletePath(), fileElement.getFileName());
        return consolidatedImageOldRecord;
    }

    public void updateModifiedTimeStamp(int cloudId, String userName, String cloudName, String tempPath, long time) {
        String[] params;
        String tempPathVar = tempPath;
        while (!tempPathVar.isEmpty() && tempPathVar != "" && (params = tempPathVar.split("/")).length > 1) {
            String fName = params[params.length - 1];
            String fPath = tempPathVar.substring(0, tempPathVar.length() - (fName.length() + 1));
            ConsolidatedImage iFile = this.syncFileDao.getConsolidatedImageDBRecordByDevicePathWithoutRegex(cloudId, userName, cloudName, fPath, fName);
            if (iFile == null || !iFile.isFolder() || !iFile.isPresent()) break;
            iFile.setModifiedTime(Long.toString(time));
            this.syncFileDao.saveToConsolidatedImageDB(cloudId, cloudName, iFile);
            tempPathVar = fPath;
        }
    }

    public synchronized ConsolidatedImage readFromAccordingToPathDatabase(int cloudId, String userName, String cloudName, String relativePath, String fileName) {
        ConsolidatedImage consolidatedImageOldRecord = this.syncFileDao.getConsolidatedImageDBRecordByDevicePathWithoutRegex(cloudId, userName, cloudName, relativePath, fileName);
        return consolidatedImageOldRecord;
    }

    private boolean checkIfRevisionHasBeenModified(SyncFileElement fileElement, ConsolidatedImage consolidatedImage) {
        if (consolidatedImage.isFolder() && fileElement.isFolder()) {
            return true;
        }
        return consolidatedImage.getMD5().equals(fileElement.getMd5checksum());
    }

    public static void convertToFileRevision(ConsolidatedImage consolidatedImage, String regId, FileRevision fileRevision, String fsPath, String status, String userName) {
        fileRevision.setConsolidatedImage(consolidatedImage);
        fileRevision.setFolder(consolidatedImage.isFolder());
        fileRevision.setfSPath(fsPath);
        fileRevision.setLastModifiedTime(consolidatedImage.getCrawlStartTimestamp());
        fileRevision.setMd5(consolidatedImage.getMD5());
        fileRevision.setMetaData(consolidatedImage.getMetaData());
        fileRevision.setRegID(regId);
        fileRevision.setSize(consolidatedImage.getSize());
        fileRevision.setStatus(status);
        fileRevision.setUserName(userName);
    }

    public synchronized void saveToDatabase(int cloudId, String cloudName, ConsolidatedImage consolidatedImageOldRecord) {
        this.syncFileDao.saveToConsolidatedImageDB(cloudId, cloudName, consolidatedImageOldRecord);
    }

    private void handleVersioning(Cloud cloud, String userName, String cloudName, FileRevision fileRevision) {
        BackupFile backupFile;
        User user = this.userDao.getUserByName(cloud.getCloudId(), userName);
        SyncPolicy syncPolicy = this.userDao.getSyncPolicyByPolicyName(cloud.getCloudId(), user.getSyncPolicyName());
        if (syncPolicy.getMaxVersions() == 0 || syncPolicy.getMaxVersions() == -1) {
            return;
        }
        FileRevision oldFileRevision = this.syncFileDao.getPresentRevisionByRevisionNumber(cloud.getCloudId(), cloudName, fileRevision.getConsolidatedImage().getId(), cloud.getVersioningEnabled());
        if (oldFileRevision != null && (backupFile = this.utilService.getSyncFile(1, cloudName, userName, oldFileRevision.getId().toString())) != null) {
            logger.debug(" deleted revisions............");
            this.syncFileDao.deleteRevision(cloud.getCloudId(), cloudName, oldFileRevision);
            List chunkFiles = backupFile.getChunkFiles();
            block4: for (ChunkFile chunkFile : chunkFiles) {
                String dedupVal = this.getDedupValue(userName);
                ChunkDetail chunkDetail = null;
                chunkDetail = this.utilService.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(userName, dedupVal, chunkFile.getMd5(), backupFile.getLastServerModifiedTime(), chunkDetail, false);
                if (chunkDetail == null) {
                    logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                    chunkDetail = this.utilService.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(userName, dedupVal, chunkFile.getMd5(), backupFile.getLastServerModifiedTime(), chunkDetail, true);
                }
                if (chunkDetail == null) continue;
                try {
                    chunkDetail.setRefCount(chunkDetail.getRefCount() - 1);
                    this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetail);
                    logger.debug(" Chunk updated succcessfully ..........");
                }
                catch (OptimisticLockingFailureException e) {
                    logger.trace("" + (Object)((Object)e));
                    logger.error("Exception while handling versioning :" + (Object)((Object)e));
                    int count = 0;
                    int maxTries = PCHelperConstant.getMaxRetryForChunkUpdate();
                    while (true) {
                        try {
                            logger.debug(" retry chunk update ..............." + chunkFile.getMd5());
                            ChunkDetail chunkDetailObj = this.utilService.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(userName, dedupVal, chunkFile.getMd5(), backupFile.getLastServerModifiedTime(), chunkDetail, true);
                            if (chunkDetail == null) {
                                logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                                chunkDetail = this.utilService.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(userName, dedupVal, chunkFile.getMd5(), backupFile.getLastServerModifiedTime(), chunkDetail, true);
                            }
                            chunkDetailObj.setRefCount(chunkDetailObj.getRefCount() - 1);
                            logger.debug(chunkFile.getMd5() + " @@@@@@ ................ retry count " + count);
                            this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetailObj);
                            continue block4;
                        }
                        catch (Exception ex) {
                            logger.trace("" + ex);
                            logger.error(" ex ..." + ex.getMessage());
                            if (++count != maxTries) continue;
                        }
                        break;
                    }
                }
            }
        }
    }

    private boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"ODB Enabled".equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }

    public void deleteFileRevisionPermanently(int cloudId, String userName, String cloudName, File file, FileRevision fileRevision) {
        this.syncFileDao.deleteRevision(cloudId, cloudName, fileRevision);
        if (fileRevision.isFolder() || file == null) {
            return;
        }
        if (!file.delete()) {
            throw new ResourceFunnelException("coudlnt delete file", 500);
        }
    }

    private boolean isPathInsideMC(int cloudId, String path) {
        String mcNameFromPath = SyncUploadServiceImpl.getMCName(path);
        if (StringUtils.isEmpty((String)mcNameFromPath)) {
            return false;
        }
        List cloudElementList = this.syncFileDao.getAllMiniClouds(cloudId);
        boolean isPathInsideMC = false;
        for (MiniCloud miniCloudElement : cloudElementList) {
            if (!mcNameFromPath.equalsIgnoreCase(miniCloudElement.getMiniCloudName())) continue;
            isPathInsideMC = true;
            break;
        }
        return isPathInsideMC;
    }

    private static String getMCName(String path) {
        String[] list = path.split("/");
        if (list != null && list.length == 1) {
            return "";
        }
        return list[1];
    }

    @Override
    public int[] getChunkSizeForSyncUser(int cloudId, String cloudName, String userName) {
        int[] chunkDetails = new int[2];
        int chunkSize = 0;
        int pftSize = 0;
        User user = this.userDao.getUserByName(cloudId, userName);
        SyncPolicy syncPolicy = this.userDao.getSyncPolicyByPolicyName(cloudId, user.getSyncPolicyName());
        if (syncPolicy != null) {
            chunkSize = syncPolicy.getFileChunkableSize();
            pftSize = syncPolicy.getPftSize();
        }
        chunkDetails[0] = chunkSize;
        chunkDetails[1] = pftSize;
        return chunkDetails;
    }

    private String getDedupValue(String userName) {
        String dedupVal = null;
        User user = this.userDao.getUserByName(1, userName);
        if (user != null) {
            SyncPolicy syncPolicy = this.userDao.getSyncPolicyByPolicyName(1, user.getSyncPolicyName());
            dedupVal = syncPolicy.getDedup();
        }
        return dedupVal;
    }

    @Override
    public List<FileInfo> getSyncFailFilesForReUpload(String cloudName) {
        return this.fileDao.getSyncFailFilesForReUpload(cloudName);
    }

    @Override
    public boolean restoreSyncFailedFiles(FileInfo fileInfo, Cloud cloud) {
        this.fileDao.moveFailedFilesToBkpQueueAndDeleteInLocalForSync(fileInfo, cloud.getCloudName(), false);
        return true;
    }

    @Override
    public SyncPolicy getSyncPolicyForUser(int cloudId, String userName) {
        User user = this.userDao.getUserByName(cloudId, userName);
        SyncPolicy syncPolicy = this.userDao.getSyncPolicyByPolicyName(cloudId, user.getSyncPolicyName());
        return syncPolicy;
    }
}

