/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.google.gson.JsonPrimitive;
import com.microsoft.graph.concurrency.ChunkedUploadProvider;
import com.microsoft.graph.concurrency.IProgressCallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.extensions.Drive;
import com.microsoft.graph.models.extensions.DriveItem;
import com.microsoft.graph.models.extensions.DriveItemUploadableProperties;
import com.microsoft.graph.models.extensions.Folder;
import com.microsoft.graph.models.extensions.IGraphServiceClient;
import com.microsoft.graph.models.extensions.UploadSession;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IDriveRequestBuilder;
import com.microsoft.graph.requests.extensions.IUserCollectionPage;
import com.microsoft.graph.serializer.AdditionalDataManager;
import com.microsoft.graph.serializer.DefaultSerializer;
import com.parablu.microsoft.graph.models.extensions.PBDriveItemUploadableProperties;
import com.parablu.pcbd.dao.PciAuthorizationTokensDao;
import com.parablu.pcbd.domain.BlackListUser;
import com.parablu.pcbd.domain.MSGTokens;
import com.parablu.pcbd.domain.User;
import com.pg.dao.FileDao;
import com.pg.dao.Office365Dao;
import com.pg.element.FileStatusElement;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MD5Generator;
import com.pg.helper.utils.MemoryStore;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.odb.util.OneDriveUtil;
import com.pg.service.GraphUploadService;
import com.pg.service.UtilService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GraphUploadServiceImpl
implements GraphUploadService {
    private static Logger logger = LoggerFactory.getLogger(GraphUploadServiceImpl.class);
    private FileDao fileDao;
    private Office365Dao office365Dao;
    @Autowired
    private UtilService utilService;
    @Autowired
    private PciAuthorizationTokensDao pciAuthorizationTokensDao;
    private static final String BEARER = "Bearer ";
    private static final String PARACLOUD_CLOUD_PATH = "/paracloud/cloud/";
    private static final String BLACK_LIST_USERS = "BlackListUsers";
    private static final String COUNT_429 = "CountOf429";
    public static DefaultSerializer serializer;

    public void setFileDao(FileDao fileDao) {
        this.fileDao = fileDao;
    }

    public void setOffice365Dao(Office365Dao office365Dao) {
        this.office365Dao = office365Dao;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64((String)encodedString), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return decodedString;
    }

    @Override
    public FileStatusElement uploadFileToODB(String accessToken, PciAuthorizationTokenElement pciTokenElement, File encryptedFile, String cloudStoragePath, String deviceUUID, String gateWayName, String uploadingFileName, FileStatusElement fileStatusElement, String driveId) {
        String encodedFileName = "";
        PciAuthorizationTokenElement pciTokenElementTemp = pciTokenElement;
        FileStatusElement element = new FileStatusElement();
        String accessTokenTemp = accessToken;
        if (pciTokenElementTemp != null) {
            String userName = pciTokenElementTemp.getUserName();
            String accountId = pciTokenElementTemp.getAccountId();
            if (!StringUtils.isEmpty((String)accessTokenTemp)) {
                String pbFolderName = this.office365Dao.getOdbFolderName(1);
                if (StringUtils.isEmpty((String)pbFolderName)) {
                    pbFolderName = "PB";
                }
                logger.debug("%^%^%^%^%^%^%^ AFTER...." + uploadingFileName);
                encodedFileName = this.convertStringTOBase64(uploadingFileName).replaceAll("/", "_");
                FileStatusElement writeElement = this.write(pciTokenElementTemp.getSharePointUrl(), accessTokenTemp, encryptedFile, accountId, userName, pciTokenElementTemp, cloudStoragePath, encodedFileName, false, pbFolderName, deviceUUID, gateWayName, fileStatusElement, driveId);
                boolean uploadSuccess = writeElement.isUploadStatus();
                element.setUploadStatuscode(writeElement.getUploadStatuscode());
                if (!uploadSuccess) {
                    encodedFileName = "";
                }
                element.setEncodedFileName(encodedFileName);
            }
        }
        return element;
    }

    private static String getUniqueODUserFolder(String deviceUUID) {
        String convertedString = "";
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            String md5Val = MD5Generator.generateMD5OfString((String)deviceUUID);
            Long l = ByteBuffer.wrap(md5Val.toString().getBytes()).getLong();
            convertedString = Long.toString(l, 36);
        }
        return convertedString;
    }

    private Drive getDriveForUser(int cloudId, String accessToken, String userName) {
        if (accessToken == null) {
            logger.error("....Token not mapped....");
            return null;
        }
        Drive drive = null;
        try {
            IGraphServiceClient graphClient = OneDriveUtil.getGraphClient(accessToken);
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + userName + "'")));
            IUserCollectionPage iUserCollectionPage = graphClient.users().buildRequest(requestOptions).top(1).get();
            String userId = "";
            for (com.microsoft.graph.models.extensions.User userObj : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                userId = userObj.id;
            }
            logger.debug(userId + ".. get drive1 for user given name.... " + userName);
            drive = graphClient.users(userId).drive().buildRequest().get();
            if (drive != null) {
                logger.debug(userName + "....drive id for user ... " + drive.id);
            }
        }
        catch (GraphServiceException e) {
            logger.error(" ... error trying to get token ..." + e.getResponseCode());
            if (e.getResponseCode() == 401) {
                logger.debug("..sleep for 90 sec...");
                try {
                    Thread.sleep(90000L);
                    MSGTokens msgTokens = this.getMsgTokes(cloudId);
                    drive = this.getDriveForUser(cloudId, msgTokens.getAccessToken(), userName);
                }
                catch (InterruptedException interruptedException) {}
            } else if (e.getResponseCode() == 404) {
                logger.error("... not able to access resource check right user token is mapped .... " + userName);
            }
        }
        catch (Exception ee) {
            logger.error(".... exception......" + ee.getMessage());
        }
        return drive;
    }

    private MSGTokens getMsgTokes(int cloudId) {
        return this.office365Dao.getMSGTokens(cloudId);
    }

    public static int upload(String accessToken, String emailId, final File file, String userFolder, String path, String encodedFileName, String driveId) {
        int responseCode;
        block3: {
            responseCode = 500;
            try {
                IGraphServiceClient graphClient = OneDriveUtil.getGraphClient(accessToken);
                IDriveRequestBuilder pbdrive1 = graphClient.drives(driveId);
                PBDriveItemUploadableProperties driveItemUploadableProperties = new PBDriveItemUploadableProperties();
                FileInputStream inputStream = new FileInputStream(file);
                int fileSize = ((InputStream)inputStream).available();
                IProgressCallback<DriveItem> callback = new IProgressCallback<DriveItem>(){

                    public void progress(long current, long max) {
                        logger.debug("The driveItem(" + file.getName() + ") with size is:" + max + ", and the current progress: " + current);
                    }

                    public void success(DriveItem result) {
                        String finishedItemId = result.id;
                        logger.debug("Successfully uploaded item ID:" + finishedItemId);
                    }

                    public void failure(ClientException ex) {
                        logger.debug("ClientException happens at IProgressCallback ", (Throwable)ex);
                    }
                };
                driveItemUploadableProperties.name = encodedFileName;
                driveItemUploadableProperties.conflictBehavior = "fail";
                AdditionalDataManager additionalDataManager = driveItemUploadableProperties.additionalDataManager();
                additionalDataManager.put((Object)"name", (Object)new JsonPrimitive(encodedFileName));
                additionalDataManager.put((Object)"@microsoft.graph.conflictBehavior", (Object)new JsonPrimitive("fail"));
                logger.debug("...graph api file upload started fail if conflict happens... " + encodedFileName);
                UploadSession uploadSession = pbdrive1.root().itemWithPath(userFolder + "/" + path + "/" + encodedFileName).createUploadSession((DriveItemUploadableProperties)driveItemUploadableProperties).buildRequest().post();
                ChunkedUploadProvider chunkedUploadProvider = new ChunkedUploadProvider(uploadSession, graphClient, (InputStream)inputStream, (long)fileSize, DriveItem.class);
                chunkedUploadProvider.upload(null, (IProgressCallback)callback, new int[]{0x320000});
                logger.debug("graph api file upload ended ... ");
                responseCode = 201;
            }
            catch (IOException e) {
                logger.error(".... exception......" + e.getMessage());
            }
            catch (GraphServiceException e) {
                logger.error("Grpagh service exception:" + e.getResponseCode());
                logger.error("Grpagh service exception:", (Throwable)e);
                if (e.getResponseCode() != 409) break block3;
                logger.error("Graph api file conflict so return:");
                responseCode = 200;
            }
        }
        return responseCode;
    }

    public static void main(String[] args) {
    }

    public static int uploadGraph(String accessToken, String emailId, final File file, String path, String encodedFileName, String driveId) {
        int responseCode = 500;
        try {
            IGraphServiceClient graphClient = OneDriveUtil.getGraphClient(accessToken);
            IDriveRequestBuilder pbdrive1 = graphClient.drives(driveId);
            PBDriveItemUploadableProperties driveItemUploadableProperties = new PBDriveItemUploadableProperties();
            FileInputStream inputStream = new FileInputStream(file);
            int fileSize = ((InputStream)inputStream).available();
            IProgressCallback<DriveItem> callback = new IProgressCallback<DriveItem>(){

                public void progress(long current, long max) {
                    logger.debug("The driveItem(" + file.getName() + ") with size is:" + max + ", and the current progress: " + current);
                }

                public void success(DriveItem result) {
                    String finishedItemId = result.id;
                    logger.debug("Successfully uploaded item ID:" + finishedItemId);
                }

                public void failure(ClientException ex) {
                    logger.debug("ClientException happens at IProgressCallback " + (Object)((Object)ex));
                }
            };
            AdditionalDataManager additionalDataManager = driveItemUploadableProperties.additionalDataManager();
            additionalDataManager.put((Object)"@microsoft.graph.conflictBehavior", (Object)new JsonPrimitive("fail"));
            logger.debug(path + "...graph api file upload started fail if conflict happens... " + encodedFileName);
            UploadSession uploadSession = pbdrive1.root().itemWithPath(path + "/" + encodedFileName).createUploadSession((DriveItemUploadableProperties)driveItemUploadableProperties).buildRequest().post();
            ChunkedUploadProvider chunkedUploadProvider = new ChunkedUploadProvider(uploadSession, graphClient, (InputStream)inputStream, (long)fileSize, DriveItem.class);
            chunkedUploadProvider.upload(null, (IProgressCallback)callback, new int[]{0x320000});
            logger.debug("graph api file upload ended ... ");
            responseCode = 201;
        }
        catch (IOException e) {
            logger.error(".... exception......" + e.getMessage());
        }
        return responseCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private FileStatusElement write(String sharePointURL, String token, File file, String accountId, String userName, PciAuthorizationTokenElement pciTokenElement, String cloudStoragePath, String encodedFileName, boolean uploadAdminAcc, String pbFolderName, String deviceUUID, String gateWayName, FileStatusElement fileStatusElement, String driveId) {
        int responseCode;
        boolean uploadSuccess;
        FileStatusElement element;
        block63: {
            CloseableHttpClient httpclient;
            CloseableHttpResponse result;
            HttpPut httpPut;
            block62: {
                Object obj;
                boolean isProxyEnabled;
                int port;
                String host;
                String password;
                String proxyUserName;
                int cloudId;
                String tokenTemp;
                String userNameToGetUrl;
                PciAuthorizationTokenElement pciTokenElementTemp;
                block61: {
                    Set blackUsersList;
                    pciTokenElementTemp = pciTokenElement;
                    element = new FileStatusElement();
                    userNameToGetUrl = userName;
                    tokenTemp = token;
                    cloudId = 1;
                    uploadSuccess = false;
                    if (!uploadAdminAcc) {
                        userNameToGetUrl = "";
                    }
                    if (!StringUtils.isEmpty((String)deviceUUID)) {
                        userNameToGetUrl = GraphUploadServiceImpl.getUniqueODUserFolder(deviceUUID);
                        logger.debug("....device unique id ....... " + userNameToGetUrl);
                    }
                    if (StringUtils.isEmpty((String)driveId)) {
                        logger.debug("...empty driveid so try after 1 min .... " + pciTokenElement.getAccountId());
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        pciTokenElementTemp = this.office365Dao.getMSGTokenElement(1, pciTokenElementTemp.getUserName());
                        pciTokenElementTemp.setAccountId(pciTokenElement.getAccountId());
                        token = pciTokenElementTemp.getAccessToken();
                        driveId = OneDriveUtil.getPBFolderItemId(token, pciTokenElementTemp.getAccountId());
                    }
                    if (StringUtils.isEmpty((String)driveId)) {
                        element.setUploadStatus(false);
                        return element;
                    }
                    String fileUrl = "https://graph.microsoft.com/v1.0/drives/" + driveId + "/root:/" + userNameToGetUrl + "/" + cloudStoragePath + "/" + encodedFileName + ":/content";
                    logger.debug(file.length() + "...graph url>>>>>>>>>>>" + fileUrl);
                    httpPut = new HttpPut(fileUrl);
                    httpPut.setEntity((HttpEntity)new FileEntity(file));
                    httpPut.addHeader("Authorization", BEARER + tokenTemp);
                    if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
                        httpPut.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
                        logger.debug("..add THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
                    }
                    logger.debug("..check THROTTLE_DECOR...............");
                    result = null;
                    httpclient = null;
                    proxyUserName = PCHelperConstant.getProxyUserName();
                    password = PCHelperConstant.getProxyPassword();
                    host = PCHelperConstant.getProxyHost();
                    port = PCHelperConstant.getProxyPort();
                    isProxyEnabled = false;
                    responseCode = 0;
                    obj = MemoryStore.get((String)BLACK_LIST_USERS);
                    if (obj == null || !(blackUsersList = (Set)obj).contains(userName)) break block61;
                    logger.debug("...user is blacklisted.... " + userName);
                    element.setUploadStatus(false);
                    element.setUploadStatuscode(555);
                    FileStatusElement fileStatusElement2 = element;
                    httpPut.releaseConnection();
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                    return fileStatusElement2;
                }
                try {
                    String userBlockedForWrite;
                    boolean success;
                    if (!StringUtils.isEmpty((String)driveId)) {
                        if (StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
                            httpclient = HttpClients.createDefault();
                            logger.debug(" filelengths ...." + file.length());
                            if (file.length() > 4000000L) {
                                try {
                                    responseCode = GraphUploadServiceImpl.upload(token, accountId, file, userNameToGetUrl, cloudStoragePath, encodedFileName, driveId);
                                }
                                catch (GraphServiceException e) {
                                    try {
                                        Thread.sleep(60000L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    pciTokenElementTemp = this.office365Dao.getMSGTokenElement(1, pciTokenElementTemp.getUserName());
                                    token = pciTokenElementTemp.getAccessToken();
                                    responseCode = GraphUploadServiceImpl.upload(token, accountId, file, userNameToGetUrl, cloudStoragePath, encodedFileName, driveId);
                                }
                                logger.debug("... large fileuploaded usinggraph...." + responseCode);
                            } else {
                                result = httpclient.execute((HttpUriRequest)httpPut);
                                responseCode = result.getStatusLine().getStatusCode();
                                logger.debug("...fileuploaded usinggraph...." + responseCode);
                            }
                        } else {
                            isProxyEnabled = true;
                            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                            credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
                            httpclient = null;
                            httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                            HttpHost proxy = new HttpHost(host, port);
                            int timeout = 10;
                            RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).setProxy(proxy).build();
                            httpPut.setConfig(config);
                            result = httpclient.execute((HttpUriRequest)httpPut);
                            responseCode = result.getStatusLine().getStatusCode();
                            logger.debug("...less than 4 mb with proxy success...." + responseCode);
                        }
                    } else {
                        logger.error("..driveid is empty.... so return 403");
                        responseCode = 403;
                    }
                    String pathTobeCreated = cloudStoragePath;
                    if (!StringUtils.isEmpty((String)userNameToGetUrl)) {
                        pathTobeCreated = userNameToGetUrl + "/" + cloudStoragePath;
                    }
                    if (responseCode == 200 || responseCode == 201) {
                        logger.debug("..graph success writing..." + responseCode);
                        this.remove429Count();
                        uploadSuccess = true;
                        if (responseCode == 200) {
                            fileStatusElement.setChunkAlreadyExist(uploadSuccess);
                        }
                        this.utilService.deleteBlackListUserByUserName(cloudId, userName);
                        break block62;
                    }
                    if (responseCode == 401) {
                        uploadSuccess = false;
                        logger.error(" ... token expired so try after 1 min ... ");
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException proxy) {
                            // empty catch block
                        }
                        pciTokenElementTemp = this.office365Dao.getMSGTokenElement(1, pciTokenElementTemp.getUserName());
                        if (pciTokenElementTemp != null) {
                            tokenTemp = pciTokenElementTemp.getAccessToken();
                            uploadSuccess = this.retryWrite(sharePointURL, tokenTemp, file, accountId, userNameToGetUrl, pciTokenElementTemp, cloudStoragePath, encodedFileName, pbFolderName, isProxyEnabled, gateWayName, fileStatusElement, userName, driveId);
                        }
                        break block62;
                    }
                    BlackListUser blackListUserObj = this.utilService.getBlackListUserbyNameAndLocalHost(cloudId, userName, gateWayName);
                    if (responseCode == 403) {
                        try {
                            logger.debug("%%%%%%%%%%%%%%%%%%%%%%%%%%%INSIDE403..................." + pathTobeCreated);
                            success = this.createLibraryIfNotExistsUsingGraph(driveId, pciTokenElementTemp.getAccessToken(), userNameToGetUrl, cloudStoragePath);
                            uploadSuccess = false;
                            if (success) {
                                uploadSuccess = this.retryWrite(sharePointURL, tokenTemp, file, accountId, userNameToGetUrl, pciTokenElementTemp, cloudStoragePath, encodedFileName, pbFolderName, isProxyEnabled, gateWayName, fileStatusElement, userName, driveId);
                            } else {
                                this.utilService.updateUserBackupTargetStatus(cloudId, userName, 403);
                                userBlockedForWrite = "403_" + userName;
                                obj = MemoryStore.get((String)userBlockedForWrite);
                                if (obj == null) {
                                    MemoryStore.add((String)userBlockedForWrite, (Object)userName, (long)1800000L);
                                    if (blackListUserObj == null) {
                                        BlackListUser blackListUser = new BlackListUser();
                                        blackListUser.setResponseCode("403");
                                        blackListUser.setUserName(userName);
                                        blackListUser.setLocalHost(PCHelperConstant.getComponentName());
                                        this.utilService.saveBlackListUser(cloudId, blackListUser);
                                    }
                                }
                            }
                            break block62;
                        }
                        catch (Exception e) {
                            logger.error("..responseCode 403..... " + e.getMessage());
                            logger.error("..responseCode 403..... " + e);
                        }
                        break block62;
                    }
                    if (responseCode == 404) {
                        logger.debug("...before calling createLibraryIfNotExistsUsingGraph... " + pathTobeCreated);
                        success = this.createLibraryIfNotExistsUsingGraph(driveId, pciTokenElementTemp.getAccessToken(), userNameToGetUrl, cloudStoragePath);
                        if (!success) {
                            if ((pciTokenElementTemp = this.office365Dao.getMSGTokenElement(1, pciTokenElementTemp.getUserName())) != null) {
                                tokenTemp = pciTokenElementTemp.getAccessToken();
                                success = this.createLibraryIfNotExistsUsingGraph(driveId, pciTokenElementTemp.getAccessToken(), userNameToGetUrl, cloudStoragePath);
                                if (success) {
                                    uploadSuccess = this.retryWrite(sharePointURL, tokenTemp, file, accountId, userNameToGetUrl, pciTokenElementTemp, cloudStoragePath, encodedFileName, pbFolderName, isProxyEnabled, gateWayName, fileStatusElement, userName, driveId);
                                } else {
                                    this.utilService.updateUserBackupTargetStatus(cloudId, userName, 404);
                                    logger.debug(" user not mapped .... " + userName);
                                    uploadSuccess = false;
                                    userBlockedForWrite = "404_" + userName;
                                    obj = MemoryStore.get((String)userBlockedForWrite);
                                    if (obj == null) {
                                        MemoryStore.add((String)userBlockedForWrite, (Object)userName, (long)1800000L);
                                        if (blackListUserObj == null) {
                                            BlackListUser blackListUser = new BlackListUser();
                                            blackListUser.setResponseCode("404");
                                            blackListUser.setUserName(userName);
                                            blackListUser.setLocalHost(PCHelperConstant.getComponentName());
                                            this.utilService.saveBlackListUser(cloudId, blackListUser);
                                        } else if (!blackListUserObj.getResponseCode().equalsIgnoreCase("404")) {
                                            this.utilService.updateBlackListUserWithCode(cloudId, userName, gateWayName, "404");
                                        }
                                    } else if (blackListUserObj != null && !blackListUserObj.getResponseCode().equalsIgnoreCase("404")) {
                                        this.utilService.updateBlackListUserWithCode(cloudId, userName, gateWayName, "404");
                                    }
                                }
                            }
                        } else {
                            logger.debug("...why failed ..." + responseCode);
                            uploadSuccess = false;
                            uploadSuccess = this.retryWrite(sharePointURL, tokenTemp, file, accountId, userNameToGetUrl, pciTokenElementTemp, cloudStoragePath, encodedFileName, pbFolderName, isProxyEnabled, gateWayName, fileStatusElement, userName, driveId);
                        }
                        break block62;
                    }
                    if (responseCode == 400) {
                        String chunkPath = userNameToGetUrl + "/" + cloudStoragePath;
                        uploadSuccess = this.checkIfFileAlreadyExists(userNameToGetUrl, chunkPath, encodedFileName, pbFolderName, pciTokenElementTemp, proxyUserName, password, host, port);
                        fileStatusElement.setChunkAlreadyExist(uploadSuccess);
                        break block62;
                    }
                    if (responseCode == 200 && responseCode == 201) break block62;
                    logger.debug("... why failed ..." + responseCode);
                    if (responseCode == 429) {
                        try {
                            try {
                                Object countOf429 = MemoryStore.get((String)COUNT_429);
                                logger.debug("....429 get count " + countOf429);
                                if (countOf429 != null) {
                                    int count = (Integer)countOf429 + 1;
                                    logger.debug("....429 adding count " + count);
                                    MemoryStore.add((String)COUNT_429, (Object)count++, (long)1800000L);
                                } else {
                                    logger.debug("....429 user ading count 1");
                                    MemoryStore.add((String)COUNT_429, (Object)1, (long)1800000L);
                                }
                            }
                            catch (Exception e) {
                                logger.trace("" + e);
                                logger.error("Exception While adding in 429 count :" + e.getMessage());
                            }
                            String value = result.getFirstHeader("Retry-After").getValue();
                            logger.debug("*****************429head**************************" + value);
                            long waitTime = Long.parseLong(value);
                            long addn429wait = PCHelperConstant.getAddn429WaitMultiplier();
                            long millis = addn429wait * waitTime * 1000L;
                            this.closeResponse(result);
                            this.closeHttpClient(httpclient);
                            logger.debug("...Sleeping for " + waitTime + "..milli..." + millis + "....for userName..." + userName);
                            logger.debug("...PB429User..." + userName + "...resp code..." + responseCode + "..odbwait.." + waitTime + "..pbwait.." + addn429wait + "..millis to wait.." + millis);
                            this.sleepForGivenTime(millis);
                            logger.debug("...sleep completed........for userName..." + userName);
                        }
                        catch (Exception e) {
                            logger.trace("" + e);
                            logger.error("Exception While Writting :" + e.getMessage());
                        }
                    }
                    uploadSuccess = false;
                    uploadSuccess = this.retryWrite(sharePointURL, tokenTemp, file, accountId, userNameToGetUrl, pciTokenElementTemp, cloudStoragePath, encodedFileName, pbFolderName, isProxyEnabled, gateWayName, fileStatusElement, userName, driveId);
                }
                catch (GraphServiceException ee) {
                    uploadSuccess = false;
                    logger.error("......graph exception ..." + ee.getMessage());
                    httpPut.releaseConnection();
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                    break block63;
                }
                catch (Exception e) {
                    uploadSuccess = false;
                    logger.trace("" + e);
                    logger.error("Exception While Writting :" + e.getMessage());
                    uploadSuccess = this.retryWrite(sharePointURL, tokenTemp, file, accountId, userNameToGetUrl, pciTokenElementTemp, cloudStoragePath, encodedFileName, pbFolderName, isProxyEnabled, gateWayName, fileStatusElement, userName, driveId);
                    {
                        catch (Throwable throwable) {
                            httpPut.releaseConnection();
                            this.closeResponse(result);
                            this.closeHttpClient(httpclient);
                            throw throwable;
                        }
                    }
                    httpPut.releaseConnection();
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                }
            }
            httpPut.releaseConnection();
            this.closeResponse(result);
            this.closeHttpClient(httpclient);
        }
        if (!uploadSuccess) {
            logger.debug("Response code...:" + responseCode + " for the userName..." + userName);
        }
        if (!uploadSuccess && responseCode != 429 && responseCode != 503 && responseCode != 409) {
            Set<String> blackUsersList = new HashSet<String>();
            Object obj = MemoryStore.get((String)BLACK_LIST_USERS);
            if (obj != null) {
                blackUsersList = (Set)obj;
            }
            blackUsersList.add(userName.toLowerCase());
            logger.debug("......marking user as blacklisted ..code..." + responseCode);
            MemoryStore.add((String)BLACK_LIST_USERS, blackUsersList, (long)1800000L);
        }
        element.setUploadStatus(uploadSuccess);
        element.setUploadStatuscode(responseCode);
        return element;
    }

    private void closeHttpClient(CloseableHttpClient httpclient) {
        if (httpclient != null) {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                logger.error("error in closing http client:" + e.getMessage());
            }
        }
    }

    private void closeResponse(CloseableHttpResponse result) {
        if (result != null) {
            try {
                result.close();
            }
            catch (IOException e) {
                logger.error("error in closing http client:" + e.getMessage());
            }
        }
    }

    private void remove429Count() {
        try {
            logger.debug("....429 inside remove429Count");
            Object countOf429 = MemoryStore.get((String)COUNT_429);
            if (countOf429 != null) {
                logger.debug("....429 get count for 200 case " + countOf429);
                MemoryStore.delete((String)COUNT_429);
            } else {
                logger.debug("....429 count is empty");
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While adding in 429 count :" + e.getMessage());
        }
    }

    private boolean checkIfFileAlreadyExists(String userNameFol, String cloudStoragePath, String encodedFileName, String pbFolderName, PciAuthorizationTokenElement pciTokenElementTemp, String proxyUserName, String password, String host, int port) {
        boolean uploadSuccess = false;
        String driveId = OneDriveUtil.getPBFolderItemId(pciTokenElementTemp.getAccessToken(), pciTokenElementTemp.getAccountId());
        String downloadurl = PCHelperConstant.getGraphLibraryDownloadUrl((String)driveId, (String)userNameFol, (String)cloudStoragePath, (String)encodedFileName);
        logger.debug(" .........graph api new download url from helper................." + downloadurl);
        try {
            HttpResponse result = this.executeDownload(proxyUserName, password, host, port, downloadurl, pciTokenElementTemp);
            int responseCode = result.getStatusLine().getStatusCode();
            logger.debug(" Response status code: " + responseCode);
            if (responseCode == 200) {
                uploadSuccess = true;
                logger.debug(" ... already exists ..." + responseCode);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Downloading File From One Drive :" + e.getMessage());
        }
        return uploadSuccess;
    }

    private HttpResponse executeDownload(String proxyUserName, String password, String host, int port, String downloadurl, PciAuthorizationTokenElement authorizationTokenElement) throws IOException, ClientProtocolException {
        CloseableHttpResponse result;
        HttpGet httpGet = new HttpGet(downloadurl);
        httpGet.addHeader("Authorization", BEARER + authorizationTokenElement.getAccessToken());
        httpGet.addHeader("Accept", "application/json;odata=verbose");
        httpGet.addHeader("Content-Type", "*/*");
        if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
            httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
            logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
        }
        if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
            logger.debug(" without proxy ....");
            CloseableHttpClient httpclient = HttpClientUtil.getSSlConnection();
            result = httpclient.execute((HttpUriRequest)httpGet);
        } else {
            logger.debug(" using proxy ....");
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
            CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            HttpHost proxy = new HttpHost(host, port);
            RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
            httpGet.setConfig(config);
            result = httpclient.execute((HttpUriRequest)httpGet);
        }
        logger.debug("...Inside execute..." + result.getStatusLine().getStatusCode());
        return result;
    }

    /*
     * Exception decompiling
     */
    private boolean retryWrite(String sharePointURL, String token, File file, String accountId, String encodedFolderPath, PciAuthorizationTokenElement pciTokenElement, String cloudStoragePath, String encodedFileName, String pbFolderName, boolean proxyEnabled, String gateWayName, FileStatusElement fileStatusElement, String userName1, String driveId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long sleepForGivenTime(long sleepTime) {
        long sleepTimeTemp = sleepTime;
        try {
            logger.debug("SleepTime is" + sleepTimeTemp);
            Thread.sleep(sleepTimeTemp);
            int sleepMultiplier = 2;
            sleepTimeTemp *= (long)sleepMultiplier;
        }
        catch (InterruptedException e1) {
            logger.error("Thread interupted error");
        }
        return sleepTimeTemp;
    }

    @Override
    public PciAuthorizationTokenElement getAccessToken(PciAuthorizationTokenElement pciAuthorizationTokenElement) {
        return this.office365Dao.getAccessToken(pciAuthorizationTokenElement);
    }

    @Override
    public long getThreadSize(String cloudName) {
        return this.fileDao.getThreadSize(cloudName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String deleteEntryForBackup(String backupId, String cloudName, String userName, String dedupedBkId) {
        logger.debug("Delete entry for backup ..... ");
        CloseableHttpClient httpclient = HttpClientUtil.getSSlConnection();
        CloseableHttpResponse response = null;
        String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + PARACLOUD_CLOUD_PATH + cloudName + "/externalbackup/" + userName + "/delete/";
        HttpPost httpPost = new HttpPost(url);
        try {
            Header[] headerarr;
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            entity.addPart("backupId", (ContentBody)new StringBody(backupId));
            entity.addPart("dedupedBkId", (ContentBody)new StringBody(dedupedBkId));
            httpPost.setEntity((HttpEntity)entity);
            response = httpclient.execute((HttpUriRequest)httpPost);
            for (Header header : headerarr = response.getAllHeaders()) {
                if (!"isFileDeleted".equals(header.getName())) continue;
                logger.debug("Deleted backup Id for file ..... " + header.getName());
            }
        }
        catch (Exception e) {
            try {
                logger.trace("" + e);
                logger.error("Exception While Deleting Entry For Backup :" + e.getMessage());
            }
            catch (Throwable throwable) {
                httpPost.releaseConnection();
                this.closeResponse(response);
                this.closeHttpClient(httpclient);
                throw throwable;
            }
            httpPost.releaseConnection();
            this.closeResponse(response);
            this.closeHttpClient(httpclient);
        }
        httpPost.releaseConnection();
        this.closeResponse(response);
        this.closeHttpClient(httpclient);
        return backupId;
    }

    private String convertStringTOBase64(String name) {
        String base64EncodeString = null;
        if (name != null) {
            byte[] bytes = DigestUtils.md5((String)name);
            byte[] bytesEncoded = Base64.encodeBase64((byte[])bytes);
            base64EncodeString = new String(bytesEncoded);
            base64EncodeString = base64EncodeString.substring(0, base64EncodeString.length() - 2);
            logger.debug("ecncoded value for given string is " + base64EncodeString);
        }
        return base64EncodeString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCountOfFilesInFolder(PciAuthorizationTokenElement ppciTokenElement, String cloudStoragePath, String deviceUUID) {
        int statusCode;
        CloseableHttpClient httpclient;
        CloseableHttpResponse result;
        HttpGet httpGet;
        int count;
        block11: {
            block10: {
                String userNameToGetUrl = "";
                if (!StringUtils.isEmpty((String)deviceUUID)) {
                    userNameToGetUrl = GraphUploadServiceImpl.getUniqueODUserFolder(deviceUUID);
                    logger.debug("....device unique id ....... " + userNameToGetUrl);
                }
                PciAuthorizationTokenElement pciTokenElement = ppciTokenElement;
                String pbFolderName = this.office365Dao.getOdbFolderName(1);
                String paraBluFolderPath = PCHelperConstant.getParabluLibraryUrl((String)pciTokenElement.getSharePointUrl(), (String)pciTokenElement.getAccountId(), (String)userNameToGetUrl, (String)cloudStoragePath, (String)pbFolderName);
                logger.debug(" latest PATH from onedrive ............ " + paraBluFolderPath);
                count = 0;
                String fileUrl = paraBluFolderPath + "/itemcount";
                httpGet = new HttpGet(fileUrl);
                httpGet.addHeader("Authorization", BEARER + pciTokenElement.getAccessToken());
                result = null;
                httpclient = null;
                String proxyUserName = PCHelperConstant.getProxyUserName();
                String password = PCHelperConstant.getProxyPassword();
                String host = PCHelperConstant.getProxyHost();
                int port = PCHelperConstant.getProxyPort();
                if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
                    logger.debug(" #$##$@$ without proxy .getCountOfFilesInFolder.." + fileUrl);
                    httpclient = HttpClientUtil.getSSlConnection();
                    result = httpclient.execute((HttpUriRequest)httpGet);
                } else {
                    logger.debug(" #$##$@$ using proxy .getCountOfFilesInFolder.." + fileUrl);
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
                    httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                    HttpHost proxy = new HttpHost(host, port);
                    int timeout = 5;
                    RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).setProxy(proxy).build();
                    httpGet.setConfig(config);
                    result = httpclient.execute((HttpUriRequest)httpGet);
                }
                statusCode = result.getStatusLine().getStatusCode();
                if (statusCode != 401) break block10;
                logger.debug(" token expired ........... retry count .....");
                if (pciTokenElement == null) break block10;
                String userNameTemp = pciTokenElement.getUserName();
                MSGTokens msgTokens = this.pciAuthorizationTokensDao.getMSGTokens(1);
                pciTokenElement = this.getMSGTokenElement(msgTokens, null);
                pciTokenElement.setUserName(userNameTemp);
                int config = this.getCountOfFilesInFolder(pciTokenElement, cloudStoragePath, deviceUUID);
                httpGet.releaseConnection();
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
                return config;
            }
            if (statusCode == 200) break block11;
            logger.error(" path doesnot exists ......... " + statusCode);
            int userNameTemp = count;
            httpGet.releaseConnection();
            this.closeResponse(result);
            this.closeHttpClient(httpclient);
            return userNameTemp;
        }
        try {
            logger.debug(" status code ................ " + statusCode);
            String json = EntityUtils.toString((HttpEntity)result.getEntity());
            JSONObject jsonObject = new JSONObject(json);
            String itemCount = jsonObject.optString("d");
            if (itemCount != null) {
                jsonObject = new JSONObject(new String(itemCount));
                itemCount = jsonObject.optString("ItemCount");
                count = Integer.parseInt(itemCount);
            }
            logger.debug(" item count ................ " + itemCount);
        }
        catch (Exception e) {
            try {
                logger.trace("" + e);
                logger.error("Exception While Getting Count of Files In Folder :" + e.getMessage());
            }
            catch (Throwable throwable) {
                httpGet.releaseConnection();
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
                throw throwable;
            }
            httpGet.releaseConnection();
            this.closeResponse(result);
            this.closeHttpClient(httpclient);
        }
        httpGet.releaseConnection();
        this.closeResponse(result);
        this.closeHttpClient(httpclient);
        return count;
    }

    private PciAuthorizationTokenElement getMSGTokenElement(MSGTokens msgTokens, User user) {
        PciAuthorizationTokenElement tokenElement = new PciAuthorizationTokenElement();
        if (msgTokens == null) {
            return tokenElement;
        }
        tokenElement.setAccessToken(msgTokens.getAccessToken());
        tokenElement.setClientId(msgTokens.getClientId());
        tokenElement.setClientSecret(msgTokens.getClientSecret());
        tokenElement.setRedirectUri(msgTokens.getRedirectUri());
        tokenElement.setRefreshToken(msgTokens.getRefreshToken());
        tokenElement.setAccountId(msgTokens.getAccountId());
        tokenElement.setSharePointUrl(msgTokens.getSharePointUrl());
        tokenElement.setCloudName(msgTokens.getCloudName());
        if (user != null) {
            if (StringUtils.isEmpty((String)user.getOdbLoginId())) {
                tokenElement.setAccountId(user.getEmailId());
            } else {
                tokenElement.setAccountId(user.getOdbLoginId());
            }
            tokenElement.setUserName(user.getUserName());
        }
        return tokenElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileStatusElement deleteFileFromODB(PciAuthorizationTokenElement pciTokenElement, String fileName, String cloudStoragePath, String deviceUUID, String driveId) {
        boolean retry;
        String fileNameTemp = fileName;
        FileStatusElement fileStatusElement = new FileStatusElement();
        PciAuthorizationTokenElement authorizationTokenElementTemp = pciTokenElement;
        String userNameInPath = "";
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            userNameInPath = GraphUploadServiceImpl.getUniqueODUserFolder(deviceUUID);
            logger.debug("....device unique id ....... " + userNameInPath);
        }
        logger.debug(".................." + fileNameTemp);
        String itemId = this.getItemIdForPathToDelete(pciTokenElement, fileNameTemp, cloudStoragePath, deviceUUID, driveId);
        if (StringUtils.isEmpty((String)itemId)) {
            logger.debug("File not found on any path so return false ");
            return fileStatusElement;
        }
        logger.debug("......after item val...." + itemId);
        String deleteFileUrl = "https://graph.microsoft.com/v1.0/drives/" + driveId + "/items/" + itemId;
        int retryCount = 0;
        do {
            FileStatusElement fileStatusElement2;
            int responseCode;
            CloseableHttpClient httpclient;
            CloseableHttpResponse result;
            HttpPost httpPost;
            block13: {
                retry = false;
                logger.debug(retryCount + "..retrycount...url>>>>>>>>>>>" + deleteFileUrl);
                httpPost = new HttpPost(deleteFileUrl);
                httpPost.addHeader("Authorization", BEARER + authorizationTokenElementTemp.getAccessToken());
                httpPost.addHeader("X-HTTP-Method", "DELETE");
                String proxyUserName = PCHelperConstant.getProxyUserName();
                String password = PCHelperConstant.getProxyPassword();
                String host = PCHelperConstant.getProxyHost();
                int port = PCHelperConstant.getProxyPort();
                result = null;
                httpclient = null;
                if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
                    httpclient = HttpClientUtil.getSSlConnection();
                    result = httpclient.execute((HttpUriRequest)httpPost);
                } else {
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
                    httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                    HttpHost proxy = new HttpHost(host, port);
                    int timeout = 10;
                    RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).setProxy(proxy).build();
                    httpPost.setConfig(config);
                    result = httpclient.execute((HttpUriRequest)httpPost);
                }
                responseCode = result.getStatusLine().getStatusCode();
                logger.debug("Response Code.." + responseCode);
                if (responseCode != 204) break block13;
                fileStatusElement.setDeleteStatus(true);
                fileStatusElement2 = fileStatusElement;
                httpPost.releaseConnection();
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
                return fileStatusElement2;
            }
            try {
                if (responseCode == 401) {
                    logger.debug("inside get access token...");
                    retry = true;
                    ++retryCount;
                    logger.error(" ... token expired so try after 1 min ... ");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    authorizationTokenElementTemp = this.office365Dao.getMSGTokenElement(1, authorizationTokenElementTemp.getUserName());
                }
                logger.debug("retry...." + retry + " count:" + retryCount);
            }
            catch (Exception e) {
                try {
                    logger.error("error while trying to delete file...." + e.getMessage());
                    logger.error("error while trying to delete file...." + e);
                    fileStatusElement2 = fileStatusElement;
                }
                catch (Throwable throwable) {
                    httpPost.releaseConnection();
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                    throw throwable;
                }
                httpPost.releaseConnection();
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
                return fileStatusElement2;
            }
            httpPost.releaseConnection();
            this.closeResponse(result);
            this.closeHttpClient(httpclient);
        } while (retry && retryCount < 2);
        return fileStatusElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getItemIdForPathToDelete(PciAuthorizationTokenElement authorizationTokenElement, String fileName, String chunkFilePath, String deviceUUID, String driveId) {
        boolean retry;
        logger.debug(" file delete from ODB");
        PciAuthorizationTokenElement authorizationTokenElementTemp = authorizationTokenElement;
        String userNameInPath = "";
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            userNameInPath = GraphUploadServiceImpl.getUniqueODUserFolder(deviceUUID);
            logger.debug("....device unique id ....... " + userNameInPath);
        }
        String downloadurl = "";
        String graphBaseUrl = "https://graph.microsoft.com/v1.0/drives/" + driveId + "/root:/";
        String pathVal = userNameInPath + "/" + chunkFilePath + "/" + fileName;
        logger.debug("..... graph path ...." + pathVal);
        String proxyUserName = PCHelperConstant.getProxyUserName();
        String password = PCHelperConstant.getProxyPassword();
        String host = PCHelperConstant.getProxyHost();
        int port = PCHelperConstant.getProxyPort();
        boolean incrementPath = false;
        boolean decrementPath = false;
        boolean newPathCheck = false;
        boolean oldStylePath = false;
        boolean customOldStylePath = false;
        boolean increOldStylePath = false;
        boolean decreOldStylePath = false;
        int retryCount = 0;
        int sleepMultiplier = 1;
        long sleepTime = 5000L * (long)sleepMultiplier;
        do {
            retry = false;
            CloseableHttpResponse result = null;
            CloseableHttpClient httpclient = null;
            HttpGet httpGet = null;
            String modifiedPath = chunkFilePath;
            try {
                downloadurl = graphBaseUrl + userNameInPath + "/" + modifiedPath + "/" + fileName;
                logger.debug(downloadurl + "......download path........." + retryCount);
                httpGet = new HttpGet(downloadurl);
                httpGet.addHeader("Authorization", BEARER + authorizationTokenElementTemp.getAccessToken());
                if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
                    httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
                    logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
                }
                if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
                    logger.debug(" without proxy ...");
                    httpclient = HttpClientUtil.getSSlConnection();
                    result = httpclient.execute((HttpUriRequest)httpGet);
                } else {
                    logger.debug(" using proxy ...");
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
                    httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                    HttpHost proxy = new HttpHost(host, port);
                    RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
                    httpGet.setConfig(config);
                    result = httpclient.execute((HttpUriRequest)httpGet);
                }
                int responseCode = result.getStatusLine().getStatusCode();
                logger.debug(">>>>>>>>>>>>>>>>>Retry Response status code: " + responseCode);
                if (responseCode == 200) {
                    logger.debug("File found so return id is " + downloadurl);
                    String json = EntityUtils.toString((HttpEntity)result.getEntity());
                    JSONObject jsonObject = new JSONObject(json);
                    String id = jsonObject.optString("id");
                    logger.debug("...objectid .... " + id);
                    String string = id;
                    httpGet.releaseConnection();
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                    return string;
                }
                if (responseCode == 401) {
                    retry = true;
                    ++retryCount;
                    logger.error(" ... token expired so try after 1 min ... ");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException json) {
                        // empty catch block
                    }
                    authorizationTokenElementTemp = this.office365Dao.getMSGTokenElement(1, authorizationTokenElementTemp.getUserName());
                } else if (responseCode != 200) {
                    retry = true;
                    sleepTime = responseCode != 404 ? this.sleepForGivenTime(sleepTime) : 0L;
                    logger.debug("..retry attempt for response code ...." + responseCode + "...." + ++retryCount + "....." + authorizationTokenElementTemp.getEmailId());
                    logger.debug("..retry url ...." + downloadurl);
                    if (responseCode == 404) {
                        String cloudPath;
                        this.closeResponse(result);
                        this.closeHttpClient(httpclient);
                        if (!increOldStylePath) {
                            cloudPath = chunkFilePath;
                            if (StringUtils.isNotEmpty((String)cloudPath)) {
                                int path = Integer.parseInt(cloudPath);
                                cloudPath = "" + (path + 1);
                            }
                            downloadurl = graphBaseUrl + userNameInPath + "/" + modifiedPath + "/" + fileName;
                            modifiedPath = cloudPath;
                            logger.debug("...increOldStylePath..." + modifiedPath);
                            increOldStylePath = true;
                        } else if (!newPathCheck && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                            cloudPath = chunkFilePath;
                            if (StringUtils.isNotEmpty((String)cloudPath)) {
                                int path = Integer.parseInt(cloudPath);
                                cloudPath = "" + (path + PCHelperConstant.getRetryOdbFolderValue());
                            }
                            downloadurl = graphBaseUrl + userNameInPath + "/" + modifiedPath + "/" + fileName;
                            newPathCheck = true;
                            modifiedPath = cloudPath;
                            logger.debug("...newPathCheck ..." + modifiedPath);
                        } else if (!decrementPath) {
                            cloudPath = chunkFilePath;
                            if (StringUtils.isNotEmpty((String)cloudPath)) {
                                int path = Integer.parseInt(cloudPath);
                                cloudPath = "" + (path - 1);
                            }
                            downloadurl = graphBaseUrl + userNameInPath + "/" + modifiedPath + "/" + fileName;
                            decrementPath = true;
                            modifiedPath = cloudPath;
                            logger.debug("...decre new path..." + modifiedPath);
                        } else if (!incrementPath) {
                            cloudPath = chunkFilePath;
                            if (StringUtils.isNotEmpty((String)cloudPath)) {
                                int path = Integer.parseInt(cloudPath);
                                cloudPath = "" + (path + 1);
                            }
                            downloadurl = graphBaseUrl + userNameInPath + "/" + modifiedPath + "/" + fileName;
                            modifiedPath = cloudPath;
                            logger.debug("...incre new path..." + modifiedPath);
                            incrementPath = true;
                        } else if (!oldStylePath) {
                            downloadurl = graphBaseUrl + userNameInPath + "/" + modifiedPath + "/" + fileName;
                            oldStylePath = true;
                            logger.debug("...oldStylePath restore ...");
                        } else if (!customOldStylePath && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                            cloudPath = chunkFilePath;
                            if (StringUtils.isNotEmpty((String)cloudPath)) {
                                int path = Integer.parseInt(cloudPath);
                                cloudPath = "" + (path + PCHelperConstant.getRetryOdbFolderValue());
                            }
                            downloadurl = graphBaseUrl + userNameInPath + "/" + modifiedPath + "/" + fileName;
                            customOldStylePath = true;
                            modifiedPath = cloudPath;
                            logger.debug("...customOldStylePath retryodbValue ..." + modifiedPath);
                        } else if (!decreOldStylePath) {
                            cloudPath = chunkFilePath;
                            if (StringUtils.isNotEmpty((String)cloudPath)) {
                                int path = Integer.parseInt(cloudPath);
                                cloudPath = "" + (path - 1);
                            }
                            downloadurl = graphBaseUrl + userNameInPath + "/" + modifiedPath + "/" + fileName;
                            decreOldStylePath = true;
                            modifiedPath = cloudPath;
                            logger.debug("...decreOldStylePath..." + modifiedPath);
                        }
                    }
                }
                httpGet.releaseConnection();
            }
            catch (Exception e) {
                retry = true;
                ++retryCount;
                sleepTime = this.sleepForGivenTime(sleepTime);
                logger.trace("" + e);
                logger.error("Exception While Retying Download File From One Drive :" + e.getMessage());
                continue;
            }
            finally {
                httpGet.releaseConnection();
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
            }
            this.closeResponse(result);
            this.closeHttpClient(httpclient);
        } while (retry && retryCount < 8);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String checkOdbFolders(PciAuthorizationTokenElement authorizationTokenElement, String folderUrl, Map<String, Long> foldersMap, StringBuilder response) {
        HttpGet httpGet;
        CloseableHttpResponse result;
        CloseableHttpClient httpclient;
        block13: {
            logger.debug(".folderUrl.." + folderUrl);
            PciAuthorizationTokenElement pciTokenElement = authorizationTokenElement;
            String proxyUserName = PCHelperConstant.getProxyUserName();
            String password = PCHelperConstant.getProxyPassword();
            String host = PCHelperConstant.getProxyHost();
            int port = PCHelperConstant.getProxyPort();
            httpclient = null;
            result = null;
            httpGet = new HttpGet(folderUrl);
            try {
                String folders;
                httpGet.addHeader("Authorization", BEARER + authorizationTokenElement.getAccessToken());
                httpGet.addHeader("Accept", "application/json;odata=verbose");
                httpGet.addHeader("Content-Type", "*/*");
                if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
                    httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
                    logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
                }
                if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
                    logger.debug(" without proxy ...");
                    httpclient = HttpClientUtil.getSSlConnection();
                    result = httpclient.execute((HttpUriRequest)httpGet);
                } else {
                    logger.debug(" using proxy ...");
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
                    httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                    HttpHost proxy = new HttpHost(host, port);
                    RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
                    httpGet.setConfig(config);
                    result = httpclient.execute((HttpUriRequest)httpGet);
                }
                int statusCode = result.getStatusLine().getStatusCode();
                logger.debug("..........." + statusCode);
                if (statusCode == 401) {
                    logger.error(" ... token expired so try after 1 min ... ");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException proxy) {
                        // empty catch block
                    }
                    pciTokenElement = this.office365Dao.getMSGTokenElement(1, pciTokenElement.getUserName());
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                    this.checkOdbFolders(pciTokenElement, folderUrl, foldersMap, response);
                }
                if (statusCode != 200) break block13;
                logger.debug("  path doesnot exists ......... " + statusCode);
                String json = EntityUtils.toString((HttpEntity)result.getEntity());
                logger.debug(json);
                JSONObject jsonObject = new JSONObject(json);
                String itemCount = jsonObject.optString("d");
                if (itemCount == null || !StringUtils.isNotEmpty((String)(folders = (jsonObject = new JSONObject(new String(itemCount))).optString("Folders")))) break block13;
                String reslut = new JSONObject(new String(folders)).get("results").toString();
                JSONArray jsonArray = new JSONArray(new String(reslut));
                for (Object jsonObj : jsonArray) {
                    JSONObject folderJson = (JSONObject)jsonObj;
                    JSONObject files = folderJson.getJSONObject("Files");
                    JSONObject __deferred = files.getJSONObject("__deferred");
                    String folderName = __deferred.getString("uri").toString();
                    if (foldersMap.containsKey(folderName)) continue;
                    foldersMap.put(folderName, folderJson.getLong("ItemCount"));
                    logger.debug(".....Path " + folderName.substring(folderName.lastIndexOf("("), folderName.lastIndexOf(")")) + " count " + folderJson.getLong("ItemCount") + "\n");
                    int countOfFiles = PCHelperConstant.getCountOfODBFiles();
                    if (countOfFiles == 0) {
                        countOfFiles = 4500;
                    }
                    logger.debug("checking odb folders " + countOfFiles);
                    if (folderJson.getLong("ItemCount") > (long)countOfFiles) {
                        String path = folderName.substring(folderName.lastIndexOf("("), folderName.lastIndexOf(")"));
                        response.append(authorizationTokenElement.getAccountId() + " Path " + path + " count " + folderJson.getLong("ItemCount") + "\n");
                    }
                    logger.debug(folderName);
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                    this.checkOdbFolders(pciTokenElement, folderName.replace("Files", "?$select=StorageMetrics&$expand=Folders"), foldersMap, response);
                }
            }
            catch (Exception e) {
                try {
                    logger.trace("" + e);
                    logger.error("Exception While Retying Download File From One Drive :" + e.getMessage());
                }
                catch (Throwable throwable) {
                    httpGet.releaseConnection();
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                    throw throwable;
                }
                httpGet.releaseConnection();
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
            }
        }
        httpGet.releaseConnection();
        this.closeResponse(result);
        this.closeHttpClient(httpclient);
        return response.toString();
    }

    public boolean createLibraryIfNotExistsUsingGraph(String driveId, String token, String userNameFold, String folderPath) {
        logger.debug(" URL for  createLibraryIfNotExistsUsingGraph ........... ");
        boolean isLibraryExists = this.isLibraryExistsUsingGraph(driveId, token);
        logger.debug(isLibraryExists + "  .....isLibraryExistsUsingGraph URL ........... ");
        if (!isLibraryExists) {
            return false;
        }
        return this.createFolderInsideLibraryUsingGraph(driveId, token, userNameFold, folderPath);
    }

    private boolean createFolderInsideLibraryUsingGraph(String driveId, String token, String userNameFold, String folderPath) {
        boolean success = false;
        try {
            Folder folder;
            DriveItem driveItem;
            IGraphServiceClient graphClient = OneDriveUtil.getGraphClient(token);
            DriveItem driveItemParent = null;
            try {
                driveItemParent = (DriveItem)graphClient.customRequest("/drives/" + driveId + "/root:/" + userNameFold, DriveItem.class).buildRequest().get();
            }
            catch (GraphServiceException graphServiceException) {
                // empty catch block
            }
            if (driveItemParent == null) {
                driveItem = new DriveItem();
                driveItem.name = userNameFold;
                driveItem.folder = folder = new Folder();
                graphClient.drives(driveId).root().children().buildRequest().post(driveItem);
                driveItemParent = (DriveItem)graphClient.customRequest("/drives/" + driveId + "/root:/" + userNameFold, DriveItem.class).buildRequest().get();
            }
            driveItem = new DriveItem();
            driveItem.name = folderPath;
            driveItem.folder = folder = new Folder();
            graphClient.drives(driveId).items(driveItemParent.id).children().buildRequest().post(driveItem);
            success = true;
        }
        catch (GraphServiceException ee) {
            logger.error("....error trying to create folder ..." + ee.getMessage());
        }
        return success;
    }

    private boolean isLibraryExistsUsingGraph(String driveId, String token) {
        boolean success = false;
        if (!StringUtils.isEmpty((String)driveId)) {
            success = true;
        }
        return success;
    }

    /*
     * Exception decompiling
     */
    @Override
    public FileStatusElement uploadToOneDriveUsingGraph(String accessToken, PciAuthorizationTokenElement pciTokenElement, File file, String uploadingFileName, String accountId, String userName, String cloudStoragePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

