/*
 * Decompiled with CFR 0.152.
 */
package com.pg.httpclient.util;

import com.pg.helper.constant.PCHelperConstant;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;

public class HttpClientUtil {
    private static Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);
    private static final String JSSE_ENABLE_SNI_EXTENSION = "jsse.enableSNIExtension";
    private static final String FALSE = "false";

    private HttpClientUtil() {
        System.setProperty(JSSE_ENABLE_SNI_EXTENSION, FALSE);
    }

    public static CloseableHttpClient getSSlConnection() {
        System.setProperty(JSSE_ENABLE_SNI_EXTENSION, FALSE);
        if (!PCHelperConstant.getPropertyFileValueSslAuthEnabled().isEmpty() && FALSE.equalsIgnoreCase(PCHelperConstant.getPropertyFileValueSslAuthEnabled())) {
            HttpClientBuilder builder = HttpClients.custom().setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
            builder.evictExpiredConnections();
            builder.evictIdleConnections(30L, TimeUnit.SECONDS);
            CloseableHttpClient client = builder.build();
            return client;
        }
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.evictExpiredConnections();
        builder.evictIdleConnections(30L, TimeUnit.SECONDS);
        CloseableHttpClient client = builder.build();
        return client;
    }

    public static HttpComponentsClientHttpRequestFactory getHttpRequestFactory() {
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        System.setProperty(JSSE_ENABLE_SNI_EXTENSION, FALSE);
        if (!PCHelperConstant.getPropertyFileValueSslAuthEnabled().isEmpty() && FALSE.equalsIgnoreCase(PCHelperConstant.getPropertyFileValueSslAuthEnabled())) {
            try {
                HttpClientBuilder builder = HttpClients.custom().setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
                logger.debug("Inside allow all host name verifier############");
                PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager();
                builder.evictExpiredConnections();
                builder.evictIdleConnections(30L, TimeUnit.SECONDS);
                builder.setConnectionManager((HttpClientConnectionManager)connMgr);
                CloseableHttpClient client = builder.build();
                requestFactory.setHttpClient((HttpClient)client);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Exception While Getting HTTP Request Factory :" + e.getMessage());
            }
        }
        return requestFactory;
    }
}

