/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.encryption;

import com.sun.org.apache.xml.internal.security.c14n.Canonicalizer;
import com.sun.org.apache.xml.internal.security.encryption.Serializer;
import com.sun.org.apache.xml.internal.security.encryption.XMLEncryptionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractSerializer
implements Serializer {
    protected Canonicalizer canon;

    @Override
    public void setCanonicalizer(Canonicalizer canonicalizer) {
        this.canon = canonicalizer;
    }

    public String serialize(Element element) throws Exception {
        return this.canonSerialize(element);
    }

    @Override
    public byte[] serializeToByteArray(Element element) throws Exception {
        return this.canonSerializeToByteArray(element);
    }

    public String serialize(NodeList nodeList) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.canon.setWriter(byteArrayOutputStream);
        this.canon.notReset();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.canon.canonicalizeSubtree(nodeList.item(i));
        }
        String string = byteArrayOutputStream.toString("UTF-8");
        byteArrayOutputStream.reset();
        return string;
    }

    @Override
    public byte[] serializeToByteArray(NodeList nodeList) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.canon.setWriter(byteArrayOutputStream);
        this.canon.notReset();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.canon.canonicalizeSubtree(nodeList.item(i));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String canonSerialize(Node node) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.canon.setWriter(byteArrayOutputStream);
        this.canon.notReset();
        this.canon.canonicalizeSubtree(node);
        String string = byteArrayOutputStream.toString("UTF-8");
        byteArrayOutputStream.reset();
        return string;
    }

    @Override
    public byte[] canonSerializeToByteArray(Node node) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.canon.setWriter(byteArrayOutputStream);
        this.canon.notReset();
        this.canon.canonicalizeSubtree(node);
        return byteArrayOutputStream.toByteArray();
    }

    public abstract Node deserialize(String var1, Node var2) throws XMLEncryptionException;

    @Override
    public abstract Node deserialize(byte[] var1, Node var2) throws XMLEncryptionException;

    protected static byte[] createContext(byte[] byArray, Node node) throws XMLEncryptionException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?><dummy");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
                NamedNodeMap namedNodeMap = node2.getAttributes();
                if (namedNodeMap == null) continue;
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Node node3 = namedNodeMap.item(i);
                    String string = node3.getNodeName();
                    if (!string.equals("xmlns") && !string.startsWith("xmlns:") || hashMap.containsKey(node3.getNodeName())) continue;
                    outputStreamWriter.write(" ");
                    outputStreamWriter.write(string);
                    outputStreamWriter.write("=\"");
                    outputStreamWriter.write(node3.getNodeValue());
                    outputStreamWriter.write("\"");
                    hashMap.put(string, node3.getNodeValue());
                }
            }
            outputStreamWriter.write(">");
            outputStreamWriter.flush();
            byteArrayOutputStream.write(byArray);
            outputStreamWriter.write("</dummy>");
            outputStreamWriter.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XMLEncryptionException("empty", unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new XMLEncryptionException("empty", iOException);
        }
    }

    protected static String createContext(String string, Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><dummy");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            NamedNodeMap namedNodeMap = node2.getAttributes();
            if (namedNodeMap == null) continue;
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node3 = namedNodeMap.item(i);
                String string2 = node3.getNodeName();
                if (!string2.equals("xmlns") && !string2.startsWith("xmlns:") || hashMap.containsKey(node3.getNodeName())) continue;
                stringBuilder.append(" " + string2 + "=\"" + node3.getNodeValue() + "\"");
                hashMap.put(string2, node3.getNodeValue());
            }
        }
        stringBuilder.append(">" + string + "</dummy>");
        return stringBuilder.toString();
    }
}

