/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.ConsolidatedImage;
import com.pg.domain.FileInfo;
import com.pg.element.DeletedUser;
import com.pg.element.DeletedUsersElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MemoryStore;
import com.pg.service.UtilService;
import com.pg.sync.service.SyncCloudUploadService;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.bson.types.ObjectId;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class SyncUploadJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LoggerFactory.getLogger(SyncUploadJob.class);
    private static final String UPLOAD = "/sync-upload/";
    public static final String ENCRYPTED = "/encrypted/";
    public static final String CHUNK = "/chunk/";
    private static final String BLACK_LIST_USERS = "BlackListUsers";
    private static List<FileInfo> fileInfoList = null;
    private Set<String> filesUnderProcess = new HashSet<String>();
    private TimerTask syncTimerTask = null;
    private Timer syncTimer = null;
    private SyncCloudUploadService syncCloudUploadService;
    private UtilService utilService;

    public void setSyncCloudUploadService(SyncCloudUploadService syncCloudUploadService) {
        this.syncCloudUploadService = syncCloudUploadService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"syncUploadJobTrigger")) {
            logger.debug("SyncUploadJob ............... disabled");
            return;
        }
        logger.debug("@@@@SyncUploadJob started ..... ");
        ExecutorService executor = null;
        try {
            boolean isJobsShouldStop = PCHelperConstant.isJobsStopEnabled();
            if (isJobsShouldStop) {
                logger.debug("stopJobsEnabled in privacygateway.properties so return");
                return;
            }
            Cloud cloud = this.utilService.getCloud(1);
            long threadSize = this.utilService.getThreadSize(cloud.getCloudId(), cloud.getCloudName());
            if (threadSize == 0L) {
                threadSize = PCHelperConstant.getThreadLimit();
            }
            List deletedUsersElements = this.utilService.getAllDeletedUsers(1);
            List<String> deletedUserList = this.getDeletedUsersFromElements(deletedUsersElements);
            logger.debug(" threads val........" + threadSize);
            int threadSizeVal = (int)threadSize;
            executor = Executors.newFixedThreadPool(threadSizeVal);
            fileInfoList = this.syncCloudUploadService.getFilesForUpload(cloud.getCloudName());
            ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
            this.checkThreadStatusAndStartUpload(cloud, executor, pool, deletedUserList);
            for (int i = 0; i < threadSizeVal; ++i) {
                logger.debug("Creating thread for first time>>>>>>>>> i value::" + i);
                this.callUploadFiles(cloud, executor, pool, deletedUserList);
            }
            logger.debug(" exit upload part..........");
        }
        catch (Exception e) {
            logger.error(" exception in backup upload job......." + e.getMessage());
            logger.trace("" + e);
        }
    }

    private void callUploadFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool, List<String> deletedUserList) {
        logger.debug("Files to sync ............... :");
        Runnable uploadJob = () -> this.uploadFiles(cloud, executor, pool, deletedUserList);
        pool.submit(uploadJob, "");
    }

    private void uploadFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool, List<String> deletedUserList) {
        do {
            logger.debug("....inside while loop..........");
            FileInfo fileInfo = null;
            try {
                logger.debug("message list......................................." + fileInfoList.size());
                fileInfo = this.getFileForProcessing(cloud, deletedUserList);
                if (fileInfo != null) {
                    this.processMessage(fileInfo, cloud);
                    logger.error(fileInfo.getId() + " %%%%%%% upload completed for file ...." + fileInfo.getFileName());
                }
                logger.debug("Thread ready for next File .... " + fileInfoList.size());
            }
            catch (Exception e) {
                logger.error("exception inside SyncUploadJob .... " + e.getMessage());
                logger.trace("exception inside SyncUploadJoblatest ...." + e);
            }
            if (fileInfo == null || !StringUtils.isNotEmpty((String)fileInfo.getId())) continue;
            this.filesUnderProcess.remove(fileInfo.getId());
        } while (!CollectionUtils.isEmpty(fileInfoList));
        logger.error("no files to upload so wait and then retry>>>>");
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.callUploadFiles(cloud, executor, pool, deletedUserList);
    }

    private synchronized FileInfo getFileForProcessing(Cloud cloud, List<String> deletedUserList) {
        if (CollectionUtils.isEmpty(fileInfoList) && CollectionUtils.isEmpty(fileInfoList = this.getMessagesToProcess(cloud, deletedUserList))) {
            return null;
        }
        FileInfo fileInfo = fileInfoList.get(0);
        if (fileInfo != null) {
            if (this.filesUnderProcess.contains(fileInfo.getId())) {
                fileInfoList.remove(fileInfo);
                return this.getFileForProcessing(cloud, deletedUserList);
            }
            fileInfoList.remove(fileInfo);
            this.filesUnderProcess.add(fileInfo.getId());
        }
        logger.debug("...after list size....." + fileInfoList.size());
        return fileInfo;
    }

    public void processMessage(FileInfo fileInfo, Cloud cloud) {
        try {
            logger.debug("Processing " + fileInfo.getFileName());
            logger.debug("Processing " + fileInfo.getFileName());
            String userBlockedForWrite = "429_" + fileInfo.getUserName();
            Object userBlockedFor429 = MemoryStore.get((String)userBlockedForWrite);
            String userUnMapped = "404_" + fileInfo.getUserName();
            Object userUnMapped404 = MemoryStore.get((String)userUnMapped);
            if (userBlockedFor429 != null) {
                logger.error(fileInfo.getUserName() + "........user acct has too many requests ........move file to bkp queue .............");
                this.syncCloudUploadService.moveSyncFailedFilesToBkpQueue(cloud.getCloudName(), fileInfo);
                this.syncCloudUploadService.deleteUploadedFiles(fileInfo, cloud.getCloudName());
            } else if (userUnMapped404 != null) {
                logger.error(fileInfo.getUserName() + "........unmapped user.............");
                this.utilService.saveSyncFailedFile(cloud.getCloudId(), fileInfo);
                this.syncCloudUploadService.deleteUploadedFiles(fileInfo, cloud.getCloudName());
            } else {
                boolean isFileUploaded = this.uploadFile(fileInfo, cloud);
                if (isFileUploaded) {
                    this.acknowlwdgeAndCloseSession(cloud, fileInfo, false);
                } else {
                    this.syncCloudUploadService.moveSyncFailedFilesToBkpQueue(cloud.getCloudName(), fileInfo);
                    this.syncCloudUploadService.deleteUploadedFiles(fileInfo, cloud.getCloudName());
                    logger.error(fileInfo.getFileName() + "................failed case not deleting file..............");
                }
                logger.debug(" message status.............. " + isFileUploaded);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception inside SyncUploadJob Processor PooledConnectionFactory !" + e.getMessage());
        }
    }

    private List<FileInfo> getMessagesToProcess(Cloud cloud, List<String> deletedUserList) {
        List latestList = this.syncCloudUploadService.getFilesForUpload(cloud.getCloudName());
        int i = 0;
        for (FileInfo fileInfo : latestList) {
            Set blackUsersList;
            String userName = fileInfo.getUserName().toLowerCase();
            if (deletedUserList.contains(userName)) {
                logger.debug("it contains deleted user so remove from message queue.....");
                this.acknowlwdgeAndCloseSession(cloud, fileInfo, true);
                continue;
            }
            Object obj = MemoryStore.get((String)BLACK_LIST_USERS);
            if (obj != null && (blackUsersList = (Set)obj).contains(userName)) {
                logger.debug("it contains #blackList# user so remove from message queue.....userName:" + fileInfo.getUserName());
                this.syncCloudUploadService.moveSyncFailedFilesToBkpQueue(cloud.getCloudName(), fileInfo);
                this.syncCloudUploadService.deleteUploadedFiles(fileInfo, cloud.getCloudName());
                continue;
            }
            String userBlockedForWrite = "429_" + fileInfo.getUserName();
            Object userBlockedFor429 = MemoryStore.get((String)userBlockedForWrite);
            if (userBlockedFor429 != null) {
                this.syncCloudUploadService.moveSyncFailedFilesToBkpQueue(cloud.getCloudName(), fileInfo);
                this.syncCloudUploadService.deleteUploadedFiles(fileInfo, cloud.getCloudName());
                continue;
            }
            String unMappedUser = "404_" + fileInfo.getUserName();
            Object unMappedUser404 = MemoryStore.get((String)unMappedUser);
            if (unMappedUser404 != null) {
                this.utilService.saveSyncFailedFile(cloud.getCloudId(), fileInfo);
                this.syncCloudUploadService.deleteUploadedFiles(fileInfo, cloud.getCloudName());
                continue;
            }
            ConsolidatedImage consolidatedImage = this.syncCloudUploadService.getConsolImgbyFilenameDevicepathandUsername(cloud.getCloudId(), fileInfo.getFileName(), fileInfo.getFilePath(), fileInfo.getUserName());
            if (consolidatedImage != null && !consolidatedImage.isPresent() && !this.syncCloudUploadService.isRevisionExistforConsId(cloud.getCloudId(), consolidatedImage.getId())) {
                this.acknowlwdgeAndCloseSession(cloud, fileInfo, true);
                continue;
            }
            fileInfoList.add(fileInfo);
            ++i;
        }
        return fileInfoList;
    }

    private boolean uploadFile(FileInfo fileInfo, Cloud cloud) {
        boolean isFileUploaded = false;
        String cloudName = cloud.getCloudName();
        try {
            isFileUploaded = this.syncCloudUploadService.uploadAllSyncFilesToCloud(cloudName, fileInfo, PCHelperConstant.getComponentName(), cloud);
        }
        catch (Exception e) {
            logger.error(fileInfo.getFileName() + "#####FILE NOT UPLOADED SUCCESSFULLY .. " + e);
            logger.trace("" + e);
        }
        return isFileUploaded;
    }

    private void acknowlwdgeAndCloseSession(Cloud cloud, FileInfo fileInfo, boolean deletedFile) {
        for (String name : fileInfo.getChunkFiles()) {
            int occurance = StringUtils.countMatches((String)name, (String)".");
            if (occurance > 1) {
                name = name.substring(0, name.lastIndexOf(46));
            }
            this.deleteUnReferencedChunk(fileInfo.getDeviceUUID(), cloud.getCloudName(), name, deletedFile);
        }
        this.syncCloudUploadService.deleteUploadedFiles(fileInfo, cloud.getCloudName());
        this.syncCloudUploadService.removeBackupFromTempDb(cloud, new ObjectId(fileInfo.getId()));
        logger.debug(fileInfo.getFileName() + ".....file deleted ..... " + fileInfo.getId());
    }

    private void deleteUnReferencedChunk(String deviceUUID, String cloudName, String name, boolean deletedFile) {
        String parabluBaseMountFolder = PCHelperConstant.getParabluFolderBasePath();
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            String chunkPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + CHUNK;
            String encryptedPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + ENCRYPTED;
            try {
                File deleteEncryptedFile = new File(encryptedPath + name);
                String destPath = chunkPath + name;
                String path = chunkPath + name;
                int dedupCount = 0;
                File deleteChunkFile = null;
                if (deletedFile) {
                    while (new File(destPath).exists()) {
                        File dedupFile = new File(destPath);
                        if (!dedupFile.exists()) continue;
                        if (dedupCount >= 2) {
                            deleteChunkFile = new File(path + "_" + (dedupCount - 1));
                        }
                        FileUtils.copyFile((File)dedupFile, (File)deleteChunkFile);
                        dedupFile.delete();
                        destPath = path + "_" + ++dedupCount;
                    }
                } else {
                    while (new File(destPath).exists()) {
                        deleteChunkFile = new File(destPath);
                        destPath = path + "_" + ++dedupCount;
                        deleteChunkFile.delete();
                    }
                }
                if (deleteEncryptedFile.exists()) {
                    deleteEncryptedFile.delete();
                }
                if (deleteEncryptedFile.exists()) {
                    deleteEncryptedFile.delete();
                }
            }
            catch (Exception e) {
                logger.error("Error trying to clean files ..... " + e.getMessage());
                logger.trace("" + e);
            }
        }
        String portalDeviceUUID = "Portal";
        String chunkPath = parabluBaseMountFolder + cloudName + UPLOAD + portalDeviceUUID + CHUNK;
        String encryptedPath = parabluBaseMountFolder + cloudName + UPLOAD + portalDeviceUUID + ENCRYPTED;
        try {
            File deleteEncryptedFile = new File(encryptedPath + name);
            String destPath = chunkPath + name;
            String path = chunkPath + name;
            int dedupCount = 1;
            File deleteChunkFile = null;
            if (deletedFile) {
                while (new File(destPath).exists()) {
                    File dedupFile = new File(destPath);
                    if (!dedupFile.exists()) continue;
                    if (dedupCount >= 2) {
                        deleteChunkFile = new File(path + "_" + (dedupCount - 1));
                    }
                    FileUtils.copyFile((File)dedupFile, (File)deleteChunkFile);
                    dedupFile.delete();
                    destPath = path + "_" + ++dedupCount;
                }
            } else {
                while (new File(destPath).exists()) {
                    deleteChunkFile = new File(destPath);
                    destPath = path + "_" + ++dedupCount;
                    deleteChunkFile.delete();
                }
            }
            if (deleteEncryptedFile.exists()) {
                deleteEncryptedFile.delete();
            }
        }
        catch (Exception e) {
            logger.error("Error trying to clean files ..... " + e.getMessage());
            logger.trace("" + e);
        }
    }

    public void checkThreadStatusAndStartUpload(final Cloud cloud, final ExecutorService executor, final CompletionService<String> pool, final List<String> deletedUserList) {
        if (this.syncTimer == null) {
            this.syncTimer = new Timer();
        }
        if (this.syncTimerTask == null) {
            this.syncTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.error("Check the task is completed>>>>>>>>");
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed so assign new task>>>>>>>>>>>");
                            SyncUploadJob.this.callUploadFiles(cloud, executor, pool, deletedUserList);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartUpload", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            this.syncTimer.schedule(this.syncTimerTask, 1000L, 1000L);
        }
    }

    private List<String> getDeletedUsersFromElements(List<DeletedUsersElement> deletedUsersElements) {
        ArrayList<String> delUsers = new ArrayList<String>();
        for (DeletedUsersElement deletedUsersElement : deletedUsersElements) {
            for (DeletedUser deletedUser : deletedUsersElement.getDeletedUsers()) {
                delUsers.add(deletedUser.getUserName().toLowerCase());
            }
        }
        return delUsers;
    }
}

