/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.Cloud;
import com.pg.domain.FileInfo;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UtilService;
import com.pg.sync.service.SyncUploadService;
import com.pg.timer.RestoreFailedFilesJob;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class RestoreSyncFailedFilesJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LoggerFactory.getLogger(RestoreFailedFilesJob.class);
    public static final String ENCRYPTED = "/encrypted/";
    public static final String CHUNK = "/chunk/";
    private static List<FileInfo> fileInfoList = null;
    private TimerTask backupTimerTask = null;
    private Timer backupTimer = null;
    private SyncUploadService syncUploadService;
    private UtilService utilService;

    public void setSyncUploadService(SyncUploadService syncUploadService) {
        this.syncUploadService = syncUploadService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"restoreSyncFailedLatestJobTrigger")) {
            logger.debug("RestoreFailedFilesJob ............ disabled");
            return;
        }
        logger.debug("@@@@restoreSyncFailedLatestJobTrigger started ..... " + PCHelperConstant.getODBCallFrequency());
        ExecutorService executor = null;
        try {
            Cloud cloud = this.utilService.getCloud(1);
            boolean threadSizeVal = true;
            executor = Executors.newFixedThreadPool(1);
            fileInfoList = this.syncUploadService.getSyncFailFilesForReUpload(cloud.getCloudName());
            ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
            this.checkThreadStatusAndStartUpload(cloud, executor, pool);
            for (int i = 0; i < 1; ++i) {
                logger.debug("Creating thread for first time>>>>>>>>> i value::" + i);
                this.callUploadFiles(cloud, executor, pool);
            }
            logger.debug(" exit upload part..........");
        }
        catch (Exception e) {
            logger.error(" exception in backup upload job......." + e.getMessage());
            logger.trace("exception in backup upload job ......." + e);
        }
    }

    private void callUploadFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        logger.debug("Files to backup ............... :");
        Runnable uploadJob = () -> this.uploadFiles(cloud, executor, pool);
        pool.submit(uploadJob, "");
    }

    private void uploadFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        try {
            List<FileInfo> filesList = this.getListToProcess(cloud);
            logger.debug("message list......................................." + filesList.size());
            if (!CollectionUtils.isEmpty(filesList)) {
                int i = 0;
                for (FileInfo fileInfo : filesList) {
                    this.processMessage(fileInfo, cloud);
                    logger.error(i + "..files processing ..." + fileInfo.getId() + " %%%%%%% completed file name ...." + fileInfo.getFileName());
                    ++i;
                }
                logger.debug(" session commited.......with 30 sec delay.....");
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    logger.error("Exception..........." + e.getMessage());
                }
            } else {
                logger.error("no files to upload so wait and then retry>>>>");
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.callUploadFiles(cloud, executor, pool);
            }
            logger.debug("message upload completed for restore bkp queue..... ");
        }
        catch (Exception e) {
            logger.error("exception inside RestoreFailedFilesJob .... " + e.getMessage());
            logger.trace("exception inside RestoreFailedFilesJob ...." + e);
        }
    }

    private synchronized List<FileInfo> getListToProcess(Cloud cloud) {
        ArrayList<Object> list;
        int limitValue = 10;
        boolean lastRecords = false;
        logger.debug("..... getListToProcess..... " + fileInfoList.size());
        if (fileInfoList.size() >= limitValue) {
            list = new ArrayList(fileInfoList.stream().limit(limitValue).collect(Collectors.toList()));
        } else {
            list = new ArrayList<FileInfo>(fileInfoList);
            lastRecords = true;
        }
        fileInfoList.removeAll(list);
        if (lastRecords && CollectionUtils.isEmpty(fileInfoList)) {
            fileInfoList = this.getMessagesToProcess(cloud);
        }
        return list;
    }

    private List<FileInfo> getMessagesToProcess(Cloud cloud) {
        List latestList = this.syncUploadService.getSyncFailFilesForReUpload(cloud.getCloudName());
        logger.debug("..... getmessageToProcess..... " + latestList.size());
        fileInfoList = latestList;
        return fileInfoList;
    }

    public void checkThreadStatusAndStartUpload(final Cloud cloud, final ExecutorService executor, final CompletionService<String> pool) {
        if (this.backupTimer == null) {
            this.backupTimer = new Timer();
        }
        if (this.backupTimerTask == null) {
            this.backupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.error("Check the task is completed>>>>>>>>");
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed so assign new task>>>>>>>>>>>");
                            RestoreSyncFailedFilesJob.this.callUploadFiles(cloud, executor, pool);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartUpload", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            this.backupTimer.schedule(this.backupTimerTask, 1000L, 1000L);
        }
    }

    private boolean uploadFile(FileInfo fileInfo, Cloud cloud) {
        boolean isFileUploaded = false;
        try {
            isFileUploaded = this.syncUploadService.restoreSyncFailedFiles(fileInfo, cloud);
        }
        catch (Exception e) {
            logger.debug("" + e);
            logger.error(fileInfo.getFileName() + "#####FILE NOT UPLOADED SUCCESSFULLY .. " + e.getMessage());
        }
        return isFileUploaded;
    }

    public void processMessage(FileInfo fileInfo, Cloud cloud) {
        try {
            logger.debug("Processing " + fileInfo.getFileName());
            boolean isFileUploaded = this.uploadFile(fileInfo, cloud);
            logger.debug(" message status.............. " + isFileUploaded);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception inside RestoreFailedFilesJob Processor PooledConnectionFactory !" + e.getMessage());
        }
    }
}

