/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.BlocklistedFolders;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.Cloud;
import com.pg.element.FileStatusElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.DeleteExternalStorageDataService;
import com.pg.service.UtilService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.bson.types.ObjectId;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class LatestChunkDeleteJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LoggerFactory.getLogger(LatestChunkDeleteJob.class);
    private UtilService utilService;
    private TimerTask backupTimerTask = null;
    private Timer backupTimer = null;
    private List<String> chunkCollectionNames = new ArrayList<String>();
    private List<BlocklistedFolders> blockListFolders = new ArrayList<BlocklistedFolders>();
    private List<String> deletedChunkCollectionNames = new ArrayList<String>();
    private List<ObjectId> failedChunkIds = new ArrayList<ObjectId>();
    private Set<String> chunksUnderProcess = new HashSet<String>();
    private DeleteExternalStorageDataService deleteExternalStorageDataService;
    private static List<ChunkDetail> chunkDetailList = null;
    public static final String CHUNK_DETAIL = "CHUNK_DETAIL";

    public DeleteExternalStorageDataService getDeleteExternalStorageDataService() {
        return this.deleteExternalStorageDataService;
    }

    public void setDeleteExternalStorageDataService(DeleteExternalStorageDataService deleteExternalStorageDataService) {
        this.deleteExternalStorageDataService = deleteExternalStorageDataService;
    }

    public UtilService getUtilService() {
        return this.utilService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"backupUploadLatestJobTrigger")) {
            logger.debug("LatestChunkDeleteJob ............. disabled");
            return;
        }
        ExecutorService executor = null;
        try {
            boolean isJobsShouldStop = PCHelperConstant.isJobsStopEnabled();
            if (isJobsShouldStop) {
                logger.debug("stopJobsEnabled in privacygateway.properties so return");
                return;
            }
            Cloud cloud = this.utilService.getCloud(1);
            int threadSizeVal = 10;
            this.getAllChunkBuketNames();
            executor = Executors.newFixedThreadPool(10);
            chunkDetailList = this.getChunksToDelete(cloud);
            ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
            this.checkThreadStatusAndStartUpload(cloud, executor, pool);
            for (int i = 0; i < 10; ++i) {
                logger.debug("Creating thread for first time>>>>>>>>> i value::" + i);
                this.callDeleteChunks(cloud, executor, pool);
            }
            logger.debug(" exit upload part..........");
        }
        catch (Exception e) {
            logger.error(" exception in backup upload job......." + e.getMessage());
            logger.trace("exception in backup upload job ......." + e);
        }
    }

    private void callDeleteChunks(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        logger.debug("Files to delete ............... :");
        Runnable deleteJob = () -> this.deleteChunks(cloud, executor, pool);
        pool.submit(deleteJob, "");
    }

    public void checkThreadStatusAndStartUpload(final Cloud cloud, final ExecutorService executor, final CompletionService<String> pool) {
        if (this.backupTimer == null) {
            this.backupTimer = new Timer();
        }
        if (this.backupTimerTask == null) {
            this.backupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.error("Check the task is completed>>>>>>>>");
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed so assign new task>>>>>>>>>>>");
                            LatestChunkDeleteJob.this.callDeleteChunks(cloud, executor, pool);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartUpload", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            this.backupTimer.schedule(this.backupTimerTask, 1000L, 1000L);
        }
    }

    private void deleteChunks(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        do {
            logger.debug("....inside while loop..........");
            ChunkDetail chunkDetail = null;
            try {
                logger.debug("message list......................................." + chunkDetailList.size());
                chunkDetail = this.getFileForProcessing(cloud);
                if (chunkDetail != null) {
                    this.processMessage(chunkDetail, cloud);
                    logger.error(chunkDetail.getId() + " %%%%%%% upload completed for file ...." + chunkDetail.getCloudChunkName());
                }
                logger.debug("Thread ready for next File .... " + chunkDetailList.size());
            }
            catch (Exception e) {
                logger.error("exception inside BackupUploadJob .... " + e.getMessage());
                logger.trace("exception inside BackupUploadJob ...." + e);
            }
            if (chunkDetail != null && StringUtils.isNotEmpty((String)chunkDetail.getId().toString())) {
                this.chunksUnderProcess.remove(chunkDetail.getId().toString());
            }
            if (!CollectionUtils.isEmpty(chunkDetailList)) continue;
            chunkDetailList = this.getChunksToDelete(cloud);
        } while (!CollectionUtils.isEmpty(chunkDetailList));
        logger.error("no files to upload so wait and then retry>>>>");
        try {
            Thread.sleep(TimeUnit.MINUTES.toMillis(60L));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.callDeleteChunks(cloud, executor, pool);
    }

    public void processMessage(ChunkDetail chunkDetail, Cloud cloud) {
        try {
            logger.debug("Processing " + chunkDetail.getCloudChunkName());
            this.deleteExternalStorageDataService.updateChunkAsDeleteStarted(cloud.getCloudId(), chunkDetail, true);
            boolean isFileUploaded = this.deleteChunk(chunkDetail, cloud);
            logger.debug(" message status.............. " + isFileUploaded);
            if (!isFileUploaded) {
                this.failedChunkIds.add(chunkDetail.getId());
                this.deleteExternalStorageDataService.updateChunkAsDeleteStarted(cloud.getCloudId(), chunkDetail, false);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception inside BackupUploadJob Processor PooledConnectionFactory !" + e.getMessage());
        }
    }

    private boolean deleteChunk(ChunkDetail chunkDetail, Cloud cloud) {
        FileStatusElement isFileUploaded = new FileStatusElement();
        try {
            isFileUploaded = this.deleteExternalStorageDataService.deleteChunkFromCloud(cloud, chunkDetail, this.blockListFolders);
        }
        catch (Exception e) {
            logger.debug("" + e);
        }
        return isFileUploaded.isDeleteStatus();
    }

    private synchronized ChunkDetail getFileForProcessing(Cloud cloud) {
        if (CollectionUtils.isEmpty(chunkDetailList)) {
            chunkDetailList = this.getChunksToDelete(cloud);
        }
        if (CollectionUtils.isEmpty(chunkDetailList)) {
            return null;
        }
        ChunkDetail chunkDetail = chunkDetailList.get(0);
        if (chunkDetail != null) {
            if (chunkDetail.isChunkBusy() && chunkDetail.getLastRefrdTimeFrClDedup() > System.currentTimeMillis() - 7889400000L) {
                chunkDetailList.remove(chunkDetail);
                return this.getFileForProcessing(cloud);
            }
            if (this.chunksUnderProcess.contains(chunkDetail.getId().toString())) {
                chunkDetailList.remove(chunkDetail);
                return this.getFileForProcessing(cloud);
            }
            chunkDetailList.remove(chunkDetail);
            this.chunksUnderProcess.add(chunkDetail.getId().toString());
        }
        logger.debug("...after list size....." + chunkDetailList.size());
        return chunkDetail;
    }

    private void getAllChunkBuketNames() {
        int toatalChunkBuckets = PCHelperConstant.getChunkTotalBuckets();
        if (PCHelperConstant.isChunkCollectionQueryRequired()) {
            this.chunkCollectionNames.add(CHUNK_DETAIL);
        }
        for (int chunkBucket = 0; chunkBucket < toatalChunkBuckets; ++chunkBucket) {
            String chunkBucketName = "CHUNK_DETAIL_" + chunkBucket;
            this.chunkCollectionNames.add(chunkBucketName);
        }
    }

    private List<ChunkDetail> getChunksToDelete(Cloud cloud) {
        logger.debug("...Inside getChunksToDelete....");
        List<Object> chunksToDelete = new ArrayList<ChunkDetail>();
        this.chunkCollectionNames.removeAll(this.deletedChunkCollectionNames);
        if (CollectionUtils.isEmpty(this.chunkCollectionNames)) {
            this.getAllChunkBuketNames();
            this.deletedChunkCollectionNames = new ArrayList<String>();
        }
        for (String coll : this.chunkCollectionNames) {
            chunksToDelete = this.deleteExternalStorageDataService.getUnreferencedChunks(cloud.getCloudId(), coll, this.failedChunkIds, 10);
            if (CollectionUtils.isEmpty(chunksToDelete)) {
                this.deletedChunkCollectionNames.add(coll);
                this.failedChunkIds = new ArrayList<ObjectId>();
                continue;
            }
            return chunksToDelete;
        }
        return chunksToDelete;
    }
}

