/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.DailyUserBackupOverView;
import com.parablu.pcbd.domain.Device;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UtilService;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class DailyUserStorageOverviewTimer
extends QuartzJobBean {
    private static Logger logger = LoggerFactory.getLogger(DailyUserStorageOverviewTimer.class);
    private UtilService utilService;

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public static List<File> findDirectoriesWithGivenName(String name, File basePath) {
        ArrayList<File> result = new ArrayList<File>();
        for (File file : basePath.listFiles()) {
            if (!file.isDirectory()) continue;
            if (file.getName().equals(name)) {
                result.add(file);
            }
            result.addAll(DailyUserStorageOverviewTimer.findDirectoriesWithGivenName(name, file));
        }
        return result;
    }

    private static long getStartofDay(long millis) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(millis);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"dailyUserBackupOverviewTrigger")) {
            logger.debug("DailyUserStorageOverviewTimer ................. diisabled");
            return;
        }
        Cloud cloud = this.utilService.getCloud(1);
        Map userAndDevices = this.utilService.getAllDeviceForUser(cloud.getCloudId());
        for (Map.Entry entry : userAndDevices.entrySet()) {
            List devices = (List)entry.getValue();
            String userName = (String)entry.getKey();
            if (CollectionUtils.isEmpty((Collection)devices)) continue;
            for (Device device : devices) {
                String deviceUUID = device.getDeviceUUID();
                String deviceName = device.getDeviceName();
                String deviceBaseUploadPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloud.getCloudName()) + deviceUUID;
                File deviceUUIDPath = new File(deviceBaseUploadPath);
                logger.debug(userName + " device path&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& " + deviceBaseUploadPath);
                long totalFilesSize = 0L;
                if (deviceUUIDPath.exists()) {
                    List<File> list = DailyUserStorageOverviewTimer.findDirectoriesWithGivenName("chunk", deviceUUIDPath);
                    for (File f : list) {
                        for (File file : f.listFiles()) {
                            long fileSizeInBytes = file.length();
                            totalFilesSize += fileSizeInBytes;
                        }
                    }
                }
                if (totalFilesSize > 0L) {
                    totalFilesSize /= 1024L;
                }
                DailyUserBackupOverView dailyUserBackupOverView = new DailyUserBackupOverView();
                dailyUserBackupOverView.setUserName(userName);
                dailyUserBackupOverView.setDeviceUUID(deviceUUID);
                dailyUserBackupOverView.setDeviceName(deviceName);
                dailyUserBackupOverView.setStorageUtilizedInPg(totalFilesSize);
                HashMap<String, Long> blukryptStorageMap = new HashMap<String, Long>();
                String blukryptNameFromMachine = this.getBlukryptNameFromMachine();
                logger.debug("Blukrypt machine name......" + blukryptNameFromMachine);
                blukryptStorageMap.put(blukryptNameFromMachine, totalFilesSize);
                dailyUserBackupOverView.setBlukryptStorageUtilized(blukryptStorageMap);
                dailyUserBackupOverView.setStorageDate(DailyUserStorageOverviewTimer.getStartofDay(System.currentTimeMillis()));
                this.utilService.saveDailyUserBackupOverView(cloud.getCloudId(), dailyUserBackupOverView);
            }
        }
    }

    private String getBlukryptNameFromMachine() {
        String blukryptName = "";
        InetAddress myHost = null;
        try {
            myHost = InetAddress.getLocalHost();
            if (myHost != null) {
                blukryptName = !StringUtils.isEmpty((String)myHost.getCanonicalHostName()) ? myHost.getCanonicalHostName() : myHost.getHostName();
            }
        }
        catch (UnknownHostException e) {
            logger.error("unable to get host name......... " + e.getMessage());
            logger.trace("exception ... " + e);
        }
        blukryptName = blukryptName.replace(".", "-");
        return blukryptName;
    }
}

