/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.Cloud;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import com.pg.timer.ChunkDeletionJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class CheckODBFoldersCountJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LoggerFactory.getLogger(ChunkDeletionJob.class);
    private UtilService utilService;
    private UploadService uploadService;

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"checkODBFoldersCountJobTrigger")) {
            logger.debug("checkODBFoldersCountJobTrigger ........... disabled");
            return;
        }
        try {
            File tempFilePath = new File("/parablu/reports/odbCheck.log");
            if (tempFilePath.exists()) {
                tempFilePath.delete();
            }
            tempFilePath.createNewFile();
            Cloud cloud = this.utilService.getCloud(1);
            StringBuilder result = new StringBuilder();
            result.append("File created on " + new Date() + "\n");
            StringBuilder checkOdbFolders = this.uploadService.checkOdbFolders(cloud, new StringBuilder());
            logger.debug("Final..." + checkOdbFolders);
            if (StringUtils.isEmpty((String)checkOdbFolders.toString())) {
                checkOdbFolders = new StringBuilder("No folders found with files over the limit\n");
            }
            result.append(checkOdbFolders.toString());
            CheckODBFoldersCountJob.appendStrToFile(tempFilePath.getAbsolutePath(), result.toString());
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception :", (Object)e.getMessage());
        }
    }

    public static void appendStrToFile(String fileName, String str) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fileName, true));
            out.write(str);
            out.close();
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error("Exception :", (Object)e.getMessage());
        }
    }

    public UploadService getUploadService() {
        return this.uploadService;
    }

    public void setUploadService(UploadService uploadService) {
        this.uploadService = uploadService;
    }

    public UtilService getUtilService() {
        return this.utilService;
    }
}

