/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.Cloud;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import java.util.Collection;
import java.util.List;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class BlackListUserFilesRetryJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LoggerFactory.getLogger(BlackListUserFilesRetryJob.class);
    public static final String ENCRYPTED = "/encrypted/";
    public static final String CHUNK = "/chunk/";
    private UploadService uploadService;
    private UtilService utilService;

    public void setUploadService(UploadService uploadService) {
        this.uploadService = uploadService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        logger.debug("@@@@BlackListUserFilesRetryJob started ..... ");
        try {
            Cloud cloud = this.utilService.getCloud(1);
            int cloudId = 1;
            logger.debug("@@@@BlackListUserFilesRetryJob started ..1... ");
            List blackListUsers = this.utilService.getAllBlackListUsers(cloudId);
            List uniqueBlackListUserLocal = this.utilService.getAllUniqueBlackListUsersFromLocal(cloudId, cloud.getCloudName());
            if (!CollectionUtils.isEmpty((Collection)uniqueBlackListUserLocal)) {
                uniqueBlackListUserLocal.parallelStream().forEach(userName -> {
                    logger.debug("... unique users list ..." + userName);
                    boolean isMoved = this.uploadService.restoreOneFileForBlackListUser(userName, cloud);
                    logger.debug("... user file movved... " + isMoved);
                });
            }
            logger.debug("@@@@BlackListUserFilesRetryJob ended ..5... ");
        }
        catch (Exception e) {
            logger.error(" exception in BlackListUserFilesRetryJob......." + e.getMessage());
            logger.trace("exception in BlackListUserFilesRetryJob ......." + e);
        }
    }
}

