/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.springframework.util.CollectionUtils;

public class WiproUpdateStorageSize {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String secMongoIP = config.getProperty("secMongoIP").toString();
        String secMongoPort = config.getProperty("secMongoPort").toString();
        String priMongoIP = config.getProperty("priMongoIP").toString();
        String priMongoPort = config.getProperty("priMongoPort").toString();
        String policyNames = config.getProperty("policyNames").toString();
        int limit = Integer.parseInt(config.getProperty("limit").toString());
        boolean canUpdate = Boolean.parseBoolean(config.getProperty("canUpdate").toString());
        if (StringUtils.isEmpty(secMongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        MongoClientURI priURI = new MongoClientURI("mongodb://neil:parablu@" + priMongoIP + ":" + priMongoPort + "/parablu001");
        MongoClient priClient = new MongoClient(priURI);
        MongoDatabase priDB = priClient.getDatabase(priURI.getDatabase());
        MongoCollection<Document> bkpOverviewDBCollection = priDB.getCollection("DEVICE_BACKUP_OVERVIEW");
        System.out.println("mongo IP:" + secMongoIP);
        MongoClientURI secURI = new MongoClientURI("mongodb://neil:parablu@" + secMongoIP + ":" + secMongoPort + "/parablu001");
        MongoClient secClient = new MongoClient(secURI);
        MongoDatabase secDB = secClient.getDatabase(secURI.getDatabase());
        MongoCollection<Document> deviceColl = secDB.getCollection("DEVICE");
        MongoCollection<Document> userDBCollection = secDB.getCollection("USER");
        ArrayList<String> policyNameList = new ArrayList<String>();
        System.out.println("Policy Names :" + policyNameList);
        policyNameList.addAll(Arrays.asList(policyNames.split(",")));
        System.out.println("Policy Length " + policyNameList.size());
        HashMap policyBasedUserNames = new HashMap();
        for (String string : policyNameList) {
            String string4 = string.replace("[", "");
            string4 = string4.replace("]", "");
            string4 = string4.trim();
            System.out.println("Started for Policy Name...:" + string4);
            FindIterable<Document> users = userDBCollection.find(new BasicDBObject("policyName", string4));
            ArrayList<String> userNamesList = new ArrayList<String>();
            for (Document user : users) {
                if (!StringUtils.isNotEmpty(user.getString("userName"))) continue;
                userNamesList.add(user.getString("userName"));
            }
            System.out.println("Outside Total user size " + userNamesList.size() + " for policyName " + string4);
            if (CollectionUtils.isEmpty(userNamesList)) continue;
            policyBasedUserNames.put(string4, userNamesList);
            System.out.println("Inside Total user size " + userNamesList.size() + " for policyName " + string4);
        }
        System.out.println("Before MAP...........");
        for (Map.Entry entry : policyBasedUserNames.entrySet()) {
            try {
                String policyName = (String)entry.getKey();
                System.out.println("Started to " + policyName);
                int userCount = 0;
                ++userCount;
                List userNames = (List)entry.getValue();
                for (String userName : userNames) {
                    if (!StringUtils.isNotEmpty(userName)) continue;
                    System.out.println("Started for userName " + userName);
                    FindIterable<Document> devices = deviceColl.find(new BasicDBObject("userName", userName));
                    ArrayList<Document> deviceDBList = new ArrayList<Document>();
                    for (Document device : devices) {
                        deviceDBList.add(device);
                    }
                    for (Document device : deviceDBList) {
                        try {
                            if (!StringUtils.isNotEmpty(device.getString("deviceUUID")) || !StringUtils.isNotEmpty(device.getString("destCollection"))) continue;
                            String deviceUUID = device.getString("deviceUUID");
                            Document deviceBkpOverview = (Document)bkpOverviewDBCollection.find(new BasicDBObject("deviceUUID", deviceUUID)).first();
                            if (deviceBkpOverview != null && deviceBkpOverview.get("storageUtilized") != null) {
                                FindIterable<Document> files;
                                MongoCollection<Document> bkpColl = secDB.getCollection(device.getString("destCollection"));
                                BasicDBObject bkpCollQuery = new BasicDBObject();
                                ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
                                whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
                                whereQuery.add(new BasicDBObject("present", true));
                                bkpCollQuery.put("$and", whereQuery);
                                int skip = 0;
                                long size = 0L;
                                while ((files = bkpColl.find(bkpCollQuery).skip(skip * limit).limit(limit)).first() != null) {
                                    for (Document document : files) {
                                        size += document.getLong("size").longValue();
                                    }
                                    System.out.println("Total Size :" + size + " for deviceUUID " + deviceUUID + " Skip value " + skip + " limit " + limit + " " + System.currentTimeMillis());
                                    ++skip;
                                }
                                if (size == 0L) continue;
                                BasicDBObject updateFields = new BasicDBObject();
                                BasicDBObject updateQuery = new BasicDBObject();
                                updateFields.append("storageUtilized", size);
                                updateQuery.append("$set", updateFields);
                                BasicDBObject andQuery = new BasicDBObject("deviceUUID", deviceUUID);
                                if (canUpdate) {
                                    bkpOverviewDBCollection.updateOne(andQuery, updateQuery);
                                }
                                System.out.println("updated," + device.getString("userName") + "," + deviceUUID + "," + size + "," + deviceBkpOverview.get("storageUtilized") + "," + userCount);
                                continue;
                            }
                            System.out.println("deviceUUID:" + deviceUUID + ",devicebkpOverview/storage is Empty");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                System.out.println("Ended to " + policyName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

