/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class UpdateBackupBatchToCompleted {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String path = config.getProperty("path").toString();
        boolean canUpdate = Boolean.parseBoolean(config.getProperty("canUpdate").toString());
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("mongo connectivity success  " + db.getName());
        MongoCollection<Document> userDBCollection = db.getCollection("USER");
        MongoCollection<Document> deviceDBCollection = db.getCollection("DEVICE");
        MongoCollection<Document> bkpBatchDBCollection = db.getCollection("BACKUP_BATCH");
        try {
            BufferedReader reader = new BufferedReader(new FileReader(path));
            String line = reader.readLine();
            while (line != null) {
                try {
                    String[] userNameAndDeviceName = line.split(",");
                    String userName = userNameAndDeviceName[0].trim();
                    String deviceName = userNameAndDeviceName[1].trim();
                    BasicDBObject andQuery = new BasicDBObject();
                    ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
                    whereQuery.add(new BasicDBObject("userName", userName));
                    whereQuery.add(new BasicDBObject("deviceName", deviceName));
                    andQuery.put("$and", whereQuery);
                    Document device = (Document)deviceDBCollection.find(andQuery).first();
                    if (device != null && !StringUtils.isEmpty(device.getString("deviceUUID"))) {
                        String deviceUUID = device.getString("deviceUUID");
                        andQuery = new BasicDBObject();
                        whereQuery = new ArrayList();
                        whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
                        whereQuery.add(new BasicDBObject("jobType", "BACKUP"));
                        andQuery.put("$and", whereQuery);
                        Document batch = (Document)bkpBatchDBCollection.find(andQuery).sort(new BasicDBObject("batchStartTimestamp", (Object)-1)).limit(1).first();
                        if (batch != null) {
                            System.out.println("UserName :" + userName + " deviceName :" + deviceName + " Batch status :" + batch.getString("status") + " " + batch.getObjectId("_id"));
                            if (StringUtils.isNotEmpty(batch.getString("status")) && !batch.getString("status").equalsIgnoreCase("STARTED") && !batch.getString("status").equalsIgnoreCase("COMPLETED") && canUpdate) {
                                System.out.println("Batch status is not started or completed so changed to Completed...");
                                BasicDBObject updateFields = new BasicDBObject();
                                BasicDBObject updateQuery = new BasicDBObject();
                                updateFields.append("status", "COMPLETED");
                                updateQuery.append("$set", updateFields);
                                BasicDBObject query = new BasicDBObject("_id", batch.getObjectId("_id"));
                                Document batch1 = (Document)bkpBatchDBCollection.find(query).first();
                                bkpBatchDBCollection.updateOne(query, updateQuery);
                                System.out.println(".._id..." + batch1.getObjectId("_id"));
                            }
                        } else {
                            System.out.println("No Batch found for UserName :" + userName + " deviceName :" + deviceName);
                        }
                    } else {
                        System.out.println("No device found for UserName :" + userName + " deviceName :" + deviceName);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

