/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import Utility.com.parablu.WeeklyMailChanges;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackupHistoryElement;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EmailProps;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.springframework.util.CollectionUtils;

public class NewWeeklyEmailChanges {
    private static final String MM_DD_YYYY = "MM/dd/yyyy";
    private static final String INSIDE_SEND_CLOUD_OVER_VIEW_JOB_TIMER = " @@@@@@@@@@@@@@@@@@@@@@@@@@ inside send cloud over view job timer ";
    private static final String BEFORE_SENDING_MAIL = " @@@ Before sending mail ";
    private static final String NO_ATTEMPT = "No Attempt";
    private static final String NILL = " ";
    private static final String PARSE_EXCEPTION = "ParseException  ";
    private static final String INVALID_DAY_VALUE = "Invalid Day value";
    private static final String NUMBER_FORMAT_EXCEPTION = "NumberFormatException  ";
    private static final String MM_DD_YYYY_HH_MM_SS = "MM/dd/yyyy HH:mm:ss";

    public static void main(String[] args) {
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@192.168.7.161:27017/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoCollection<Document> userExcludedFoldersDBCollection = db.getCollection("BACKUP_BATCH");
        MongoCollection<Document> devicebkpCol = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        Document device1 = (Document)devicebkpCol.find(new BasicDBObject("userName", "user18")).first();
        DeviceBackupOverView device = new DeviceBackupOverView();
        device.setFirstBkpStartTime(device1.getString("firstBkpStartTime"));
        device.setFirstBkpEndTime(device1.getString("firstBkpEndTime"));
        device.setLastBkpStartTime(device1.getString("lastBkpStartTime"));
        device.setLastBkpEndTime(device1.getString("lastBkpEndTime"));
        device.setLastSuccessfulBkp(device1.getString("lastSuccessfulBkp"));
        device.setLastBkpStatus(device1.getString("lastBkpStatus"));
        device.setEpaInstallationDate(device1.getString("epaInstallationDate"));
        FindIterable<Document> batchList = userExcludedFoldersDBCollection.find(new BasicDBObject("userName", "user18"));
        ArrayList<BackupHistoryElement> backupHistoryElements = new ArrayList<BackupHistoryElement>();
        StringBuilder bodyData = new StringBuilder();
        for (Document document : batchList) {
            BackupHistoryElement backupHistoryElement = new BackupHistoryElement();
            backupHistoryElement.setBatchId(document.getObjectId("_id").toString());
            backupHistoryElement.setDeviceName("bat");
            backupHistoryElement.setUserName("batUserName");
            backupHistoryElement.setPolicyName("policyName");
            backupHistoryElement.setStartTime(NewWeeklyEmailChanges.getDate(document.getLong("batchStartTimestamp")));
            backupHistoryElement.setEndTime(NewWeeklyEmailChanges.getDate(document.getLong("batchEndTimestamp")));
            backupHistoryElement.setUploadedSize(document.getString("uploadedSize"));
            System.out.println(document.toJson());
            backupHistoryElement.setAction(NewWeeklyEmailChanges.getCommentsForBackupBatch(document.getString("errorCode")));
            String uploadedFiles = document.getString("uploadedFiles");
            String[] parts = uploadedFiles.split("/");
            try {
                backupHistoryElement.setNoOfFiles(Integer.parseInt(parts[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            backupHistoryElements.add(backupHistoryElement);
        }
        EmailProps email = new EmailProps();
        ArrayList emailRecipents = new ArrayList();
        EmailProps tempEmail = new EmailProps();
        NewWeeklyEmailChanges.setDaysElementForSendmail(tempEmail);
        int i = 0;
        while (i < 7) {
            String dateToCheck = NewWeeklyEmailChanges.getDateForApproprioteDay(i);
            System.out.println(String.valueOf(dateToCheck) + NILL + i);
            backupHistoryElements.sort(Comparator.comparing(BackupHistoryElement::getEndTime));
            NewWeeklyEmailChanges.setDate(tempEmail, NewWeeklyEmailChanges.getDayOfTheWeek(dateToCheck), dateToCheck);
            for (BackupHistoryElement backupHistoryElement : backupHistoryElements) {
                int startDayVal;
                List<Integer> previousDays;
                int dayVal;
                if (backupHistoryElement == null) continue;
                if (dateToCheck.equals(NewWeeklyEmailChanges.getDay(backupHistoryElement.getEndTime()))) {
                    dayVal = NewWeeklyEmailChanges.getDayOfTheWeek(NewWeeklyEmailChanges.getDay(backupHistoryElement.getEndTime()));
                    previousDays = NewWeeklyEmailChanges.getDaysOfBatch(NewWeeklyEmailChanges.getDay(backupHistoryElement.getStartTime()), dayVal);
                    NewWeeklyEmailChanges.setBackupStatusForPreviousDays(tempEmail, previousDays, backupHistoryElement.getBatchId());
                    if (NewWeeklyEmailChanges.isBackupStartedinWindowPeriod(NewWeeklyEmailChanges.getDay(backupHistoryElement.getStartTime()))) {
                        startDayVal = NewWeeklyEmailChanges.getDayOfTheWeek(NewWeeklyEmailChanges.getDay(backupHistoryElement.getStartTime()));
                        NewWeeklyEmailChanges.setBackupStatusForDay(tempEmail, startDayVal, NewWeeklyEmailChanges.getStatusWithTime(backupHistoryElement.getStartTime(), "Backup Started"), null, NewWeeklyEmailChanges.getDay(backupHistoryElement.getStartTime()));
                        System.out.println("1");
                    }
                    if ("Successfully Completed".equals(backupHistoryElement.getAction())) {
                        NewWeeklyEmailChanges.setBackupStatusForDay(tempEmail, dayVal, NewWeeklyEmailChanges.getStatusWithTime(backupHistoryElement.getEndTime(), "Completed"), null, dateToCheck);
                        continue;
                    }
                    if ("User stopped BackUp manually".equals(backupHistoryElement.getAction())) {
                        NewWeeklyEmailChanges.setBackupStatusForDay(tempEmail, dayVal, "User stopped BackUp manually", null, dateToCheck);
                        continue;
                    }
                    NewWeeklyEmailChanges.setBackupStatusForDay(tempEmail, dayVal, "In progress", backupHistoryElement.getAction(), dateToCheck);
                    continue;
                }
                if (!NewWeeklyEmailChanges.isdateAfter(backupHistoryElement.getEndTime(), NewWeeklyEmailChanges.getEndDate()) || !dateToCheck.equals(NewWeeklyEmailChanges.getDay(backupHistoryElement.getStartTime()))) continue;
                dayVal = NewWeeklyEmailChanges.getDayOfTheWeek(NewWeeklyEmailChanges.getDay(backupHistoryElement.getEndTime()));
                previousDays = NewWeeklyEmailChanges.getDaysOfBatch(NewWeeklyEmailChanges.getDay(backupHistoryElement.getStartTime()), dayVal);
                NewWeeklyEmailChanges.setBackupStatusForPreviousDays(tempEmail, previousDays, backupHistoryElement.getBatchId());
                if (!NewWeeklyEmailChanges.isBackupStartedinWindowPeriod(NewWeeklyEmailChanges.getDay(backupHistoryElement.getStartTime()))) continue;
                startDayVal = NewWeeklyEmailChanges.getDayOfTheWeek(NewWeeklyEmailChanges.getDay(backupHistoryElement.getStartTime()));
                NewWeeklyEmailChanges.setBackupStatusForDay(tempEmail, startDayVal, NewWeeklyEmailChanges.getStatusWithTime(backupHistoryElement.getStartTime(), "Backup Started"), null, NewWeeklyEmailChanges.getDay(backupHistoryElement.getStartTime()));
            }
            ++i;
        }
        NewWeeklyEmailChanges.setNoAttemptForSendmail(tempEmail, device, backupHistoryElements);
        bodyData.append(NewWeeklyEmailChanges.setDynamicDeviceTemplate(device, tempEmail));
        email.setBodyData(bodyData.toString());
        System.out.println(bodyData.toString());
    }

    private static String getDate(long dateVal) {
        String date = "";
        try {
            SimpleDateFormat df2 = new SimpleDateFormat(MM_DD_YYYY_HH_MM_SS);
            Date dateD = new Date(dateVal);
            date = df2.format(dateD);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return date;
    }

    private static String getEndDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 23);
        cal.set(12, 55);
        ((Calendar)cal).add(5, -1);
        Date date = cal.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat(MM_DD_YYYY);
        return formatter.format(date);
    }

    private static String getStartDate() {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(5, -7);
        Date fiveDaysAgo = cal.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat(MM_DD_YYYY);
        return formatter.format(fiveDaysAgo);
    }

    private static String getDateForApproprioteDay(int i) {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(5, -7 + i);
        Date fiveDaysAgo = cal.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat(MM_DD_YYYY);
        return formatter.format(fiveDaysAgo);
    }

    private static String getDay(String startDate) {
        String date = "";
        try {
            SimpleDateFormat df2 = new SimpleDateFormat(MM_DD_YYYY);
            Date dateD = new Date(startDate);
            date = df2.format(dateD);
        }
        catch (NumberFormatException e) {
            e.getStackTrace();
        }
        return date;
    }

    private static int getDayOfTheWeek(String dat) {
        SimpleDateFormat format = new SimpleDateFormat(MM_DD_YYYY);
        Date date = null;
        try {
            date = format.parse(dat);
        }
        catch (ParseException e) {
            e.getStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(7);
    }

    private static void setBackupStatusForDay(EmailProps email, int dayValue, String status, String remark, String date) {
        System.out.println("==========" + date);
        String tempRemark = NILL;
        if (!StringUtils.isEmpty(remark)) {
            tempRemark = remark;
        }
        switch (dayValue) {
            case 1: {
                email.setSundayStatus(status);
                email.setSundayRemark(tempRemark);
                email.setSundayDate(date);
                break;
            }
            case 2: {
                email.setMondayStatus(status);
                email.setMondayRemark(tempRemark);
                email.setMondayDate(date);
                break;
            }
            case 3: {
                email.setTuesdayStatus(status);
                email.setTuesdayRemark(tempRemark);
                email.setTuesdayDate(date);
                break;
            }
            case 4: {
                email.setWednesdayStatus(status);
                email.setWednesdayRemark(tempRemark);
                email.setWednesdayDate(date);
                break;
            }
            case 5: {
                email.setThursdayStatus(status);
                email.setThursdayRemark(tempRemark);
                email.setThursdayDate(date);
                break;
            }
            case 6: {
                email.setFridayStatus(status);
                email.setFridayRemark(tempRemark);
                email.setFridayDate(date);
                break;
            }
            case 7: {
                email.setSaturdayStatus(status);
                email.setSaturdayRemark(tempRemark);
                email.setSaturdayDate(date);
            }
        }
    }

    private static void setDaysElementForSendmail(EmailProps email) {
        email.setMonday(WeeklyMailChanges.DaysEnum.MONDAY.toString());
        email.setMondayRemark(NILL);
        email.setTuesday(WeeklyMailChanges.DaysEnum.TUESDAY.toString());
        email.setTuesdayRemark(NILL);
        email.setWednesday(WeeklyMailChanges.DaysEnum.WEDNESDAY.toString());
        email.setWednesdayRemark(NILL);
        email.setThursday(WeeklyMailChanges.DaysEnum.THURSDAY.toString());
        email.setThursdayRemark(NILL);
        email.setFriday(WeeklyMailChanges.DaysEnum.FRIDAY.toString());
        email.setFridayRemark(NILL);
        email.setSaturday(WeeklyMailChanges.DaysEnum.SATURDAY.toString());
        email.setSaturdayRemark(NILL);
        email.setSunday(WeeklyMailChanges.DaysEnum.SUNDAY.toString());
        email.setSundayRemark(NILL);
    }

    public static String formatFileSize(long size) {
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : dec.format(m).concat(" MB"));
        return hrSize;
    }

    public static String avgStoragePerUser(long size, Long noOfUsers) {
        String hrSize;
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        if (t > 1.0) {
            double avgSize = t / (double)noOfUsers.longValue();
            hrSize = dec.format(avgSize).concat(" TB");
        } else if (g > 1.0) {
            double avgSize = g / (double)noOfUsers.longValue();
            hrSize = dec.format(avgSize).concat(" GB");
        } else {
            double avgSize = m / (double)noOfUsers.longValue();
            hrSize = dec.format(avgSize).concat(" MB");
        }
        return hrSize;
    }

    private static String setDynamicDeviceTemplate(DeviceBackupOverView device, EmailProps email) {
        StringBuilder bodyData = new StringBuilder("<table class=\"table\" style=\"width:100%\">");
        bodyData.append("<thead>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: center\">").append("Device Name").append("</th>").append("<th colspan=\"3\" style=\"border: 1px solid black;text-align: center\">").append(device.getDeviceName()).append("</th>").append("</tr>").append("</thead>").append("<tbody>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: center\">").append("Last Successful").append("<br>").append("Backup").append("</th>").append("<th colspan=\"3\" style=\"border: 1px solid black;text-align: center\">").append(Optional.ofNullable(device.getLastSuccessfulBkp()).orElse("")).append("</th>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append("Day Wise Status").append("</th>").append("</tr>").append("<th style=\"border: 1px solid black;text-align: center\">").append("Day").append("</th>").append("<th style=\"border: 1px solid black;text-align: center\">").append("Date").append("</th>").append("<th style=\"border: 1px solid black;text-align: center\">").append("Backup Status").append("</th>").append("<th style=\"border: 1px solid black;text-align: center\">").append("Details").append("</th>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;width:").append("20%;\">").append(NewWeeklyEmailChanges.getWeekDay(7)).append("</td>").append("<td style=\"border: 1px solid black;width:").append(";\">").append(NewWeeklyEmailChanges.getWeekDate(7)).append("</td>").append("<td style=\"border: 1px solid black;width:").append("30%;\">").append(NewWeeklyEmailChanges.getMultipleStatusTemplate(NewWeeklyEmailChanges.getStatus(7, email))).append("</td>").append("<td style=\"border: 1px solid black;width:").append("40%;\">").append(NewWeeklyEmailChanges.getRemarks(7, email)).append("</td>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getWeekDay(6)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getWeekDate(6)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getMultipleStatusTemplate(NewWeeklyEmailChanges.getStatus(6, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getRemarks(6, email)).append("</td>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getWeekDay(5)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getWeekDate(5)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getMultipleStatusTemplate(NewWeeklyEmailChanges.getStatus(5, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getRemarks(5, email)).append("</td>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getWeekDay(4)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getWeekDate(4)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getMultipleStatusTemplate(NewWeeklyEmailChanges.getStatus(4, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getRemarks(4, email)).append("</td>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getWeekDay(3)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getWeekDate(3)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getMultipleStatusTemplate(NewWeeklyEmailChanges.getStatus(3, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getRemarks(3, email)).append("</td>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getWeekDay(2)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getWeekDate(2)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getMultipleStatusTemplate(NewWeeklyEmailChanges.getStatus(2, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getRemarks(2, email)).append("</td>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getWeekDay(1)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getWeekDate(1)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getMultipleStatusTemplate(NewWeeklyEmailChanges.getStatus(1, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(NewWeeklyEmailChanges.getRemarks(1, email)).append("</td>").append("</tr>").append("</tbody>").append("</table>").append("<br>");
        return bodyData.toString();
    }

    private static void setDate(EmailProps email, int dayValue, String date) {
        switch (dayValue) {
            case 1: {
                email.setSundayDate(date);
                break;
            }
            case 2: {
                email.setMondayDate(date);
                break;
            }
            case 3: {
                email.setTuesdayDate(date);
                break;
            }
            case 4: {
                email.setWednesdayDate(date);
                break;
            }
            case 5: {
                email.setThursdayDate(date);
                break;
            }
            case 6: {
                email.setFridayDate(date);
                break;
            }
            case 7: {
                email.setSaturdayDate(date);
            }
        }
    }

    private static void setBackupStatusForPreviousDays(EmailProps email, List<Integer> batchStartDayValue, String batchId) {
        String status = "In progress";
        batchStartDayValue.stream().forEach(dayValue -> {
            switch (dayValue) {
                case 7: {
                    email.setSaturdayStatus(status);
                    break;
                }
                case 6: {
                    email.setFridayStatus(status);
                    break;
                }
                case 5: {
                    email.setThursdayStatus(status);
                    break;
                }
                case 4: {
                    email.setWednesdayStatus(status);
                    break;
                }
                case 3: {
                    email.setTuesdayStatus(status);
                    break;
                }
                case 2: {
                    email.setMondayStatus(status);
                    break;
                }
                case 1: {
                    email.setSundayStatus(status);
                }
            }
        });
    }

    private static String getWeekDay(int day) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat simpleDateformat = new SimpleDateFormat("EEEE");
        if (day != 0) {
            cal.add(5, -day);
        }
        return simpleDateformat.format(cal.getTime());
    }

    private static String getWeekDate(int day) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat simpleDateformat = new SimpleDateFormat("dd/MM/yyyy");
        if (day != 0) {
            cal.add(5, -day);
        }
        return simpleDateformat.format(cal.getTime());
    }

    private static List<String> getStatus(int day, EmailProps email) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -day);
        int dayValue = cal.get(7);
        switch (dayValue) {
            case 7: {
                return email.getSaturdayStatus();
            }
            case 6: {
                return email.getFridayStatus();
            }
            case 5: {
                return email.getThursdayStatus();
            }
            case 4: {
                return email.getWednesdayStatus();
            }
            case 3: {
                return email.getTuesdayStatus();
            }
            case 2: {
                return email.getMondayStatus();
            }
            case 1: {
                return email.getSundayStatus();
            }
        }
        return null;
    }

    private static String getRemarks(int day, EmailProps email) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -day);
        int dayValue = cal.get(7);
        switch (dayValue) {
            case 7: {
                return email.getSaturdayRemark();
            }
            case 6: {
                return email.getFridayRemark();
            }
            case 5: {
                return email.getThursdayRemark();
            }
            case 4: {
                return email.getWednesdayRemark();
            }
            case 3: {
                return email.getTuesdayRemark();
            }
            case 2: {
                return email.getMondayRemark();
            }
            case 1: {
                return email.getSundayRemark();
            }
        }
        return "";
    }

    private static List<Integer> getDaysOfBatch(String activityStartDateString, int currentDayTemp) {
        int currentDay = currentDayTemp;
        String batchStartDateString = NewWeeklyEmailChanges.getDateForApproprioteDay(0);
        Date activityStartTime = null;
        Date batchStartTime = null;
        SimpleDateFormat format = new SimpleDateFormat(MM_DD_YYYY);
        try {
            activityStartTime = format.parse(activityStartDateString);
            batchStartTime = format.parse(batchStartDateString);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Date date = activityStartTime != null && activityStartTime.before(batchStartTime) ? batchStartTime : activityStartTime;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int startDay = calendar.get(7);
        ArrayList<Integer> days = new ArrayList<Integer>();
        if (startDay > currentDay) {
            currentDay += 7;
        }
        if (activityStartTime != null && !activityStartTime.before(batchStartTime)) {
            ++startDay;
        }
        int i = startDay;
        while (i < currentDay) {
            int day = i % 7;
            if (day == 0) {
                day = 7;
            }
            days.add(day);
            ++i;
        }
        return days;
    }

    private static String getMultipleStatusTemplate(List<String> statusList) {
        StringBuilder statusTemplate = new StringBuilder();
        if (!CollectionUtils.isEmpty(statusList)) {
            statusList.forEach(status -> statusTemplate.append((String)status).append("<br>"));
        }
        return statusTemplate.toString();
    }

    private static void setNoAttemptForSendmail(EmailProps email, DeviceBackupOverView device, List<BackupHistoryElement> backupHistoryElements) {
        if (CollectionUtils.isEmpty(email.getMondayStatus())) {
            if (NewWeeklyEmailChanges.checkIsBkpRunning(backupHistoryElements)) {
                email.setMondayStatus("In progress");
            } else if (!NewWeeklyEmailChanges.checkDeviceRegister(device, email.getMondayDate())) {
                email.setMondayStatus("N/A");
            } else {
                email.setMondayStatus(NO_ATTEMPT);
            }
        }
        if (CollectionUtils.isEmpty(email.getTuesdayStatus())) {
            if (NewWeeklyEmailChanges.checkIsBkpRunning(backupHistoryElements)) {
                email.setTuesdayStatus("In progress");
            } else if (!NewWeeklyEmailChanges.checkDeviceRegister(device, email.getTuesdayDate())) {
                email.setTuesdayStatus("N/A");
            } else {
                email.setTuesdayStatus(NO_ATTEMPT);
            }
        }
        if (CollectionUtils.isEmpty(email.getWednesdayStatus())) {
            if (NewWeeklyEmailChanges.checkIsBkpRunning(backupHistoryElements)) {
                email.setWednesdayStatus("In progress");
            } else if (!NewWeeklyEmailChanges.checkDeviceRegister(device, email.getWednesdayDate())) {
                email.setWednesdayStatus("N/A");
            } else {
                email.setWednesdayStatus(NO_ATTEMPT);
            }
        }
        if (CollectionUtils.isEmpty(email.getThursdayStatus())) {
            if (NewWeeklyEmailChanges.checkIsBkpRunning(backupHistoryElements)) {
                email.setThursdayStatus("In progress");
            } else if (!NewWeeklyEmailChanges.checkDeviceRegister(device, email.getThursdayDate())) {
                email.setThursdayStatus("N/A");
            } else {
                email.setThursdayStatus(NO_ATTEMPT);
            }
        }
        if (CollectionUtils.isEmpty(email.getFridayStatus())) {
            if (NewWeeklyEmailChanges.checkIsBkpRunning(backupHistoryElements)) {
                email.setFridayStatus("In progress");
            } else if (!NewWeeklyEmailChanges.checkDeviceRegister(device, email.getFridayDate())) {
                email.setFridayStatus("N/A");
            } else {
                email.setFridayStatus(NO_ATTEMPT);
            }
        }
        if (CollectionUtils.isEmpty(email.getSaturdayStatus())) {
            if (NewWeeklyEmailChanges.checkIsBkpRunning(backupHistoryElements)) {
                email.setSaturdayStatus("In progress");
            } else if (!NewWeeklyEmailChanges.checkDeviceRegister(device, email.getSaturdayDate())) {
                email.setSaturdayStatus("N/A");
            } else {
                email.setSaturdayStatus(NO_ATTEMPT);
            }
        }
        if (CollectionUtils.isEmpty(email.getSundayStatus())) {
            if (NewWeeklyEmailChanges.checkIsBkpRunning(backupHistoryElements)) {
                email.setSundayStatus("In progress");
            } else if (!NewWeeklyEmailChanges.checkDeviceRegister(device, email.getSundayDate())) {
                email.setSundayStatus("N/A");
            } else {
                email.setSundayStatus(NO_ATTEMPT);
            }
        }
    }

    private static boolean checkIsBkpRunning(List<BackupHistoryElement> backupHistoryElements) {
        boolean result = false;
        if (!CollectionUtils.isEmpty(backupHistoryElements) && backupHistoryElements.size() == 1 && backupHistoryElements.get(0) != null) {
            try {
                Date batchStartDate = new SimpleDateFormat(MM_DD_YYYY).parse(backupHistoryElements.get(0).getStartTime());
                Date batchEndDate = new SimpleDateFormat(MM_DD_YYYY).parse(backupHistoryElements.get(0).getStartTime());
                Calendar cal = Calendar.getInstance();
                cal.add(5, -8);
                Date mailStartDate = cal.getTime();
                boolean isBefore = mailStartDate.before(batchStartDate);
                cal = Calendar.getInstance();
                cal.add(5, -1);
                Date mailEndDate = cal.getTime();
                boolean isAfter = batchEndDate.after(mailEndDate);
                System.out.println(String.valueOf(backupHistoryElements.get(0).getStartTime()) + NILL + batchStartDate + NILL + isAfter + NILL + isBefore + NILL + batchEndDate);
                if (isAfter && isBefore) {
                    System.out.println("-------");
                    result = true;
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static boolean checkDeviceRegister(DeviceBackupOverView device, String daysDate) {
        boolean result = false;
        if (device != null && StringUtils.isNotEmpty(device.getEpaInstallationDate()) && !StringUtils.isEmpty(daysDate)) {
            try {
                Date date = new SimpleDateFormat(MM_DD_YYYY).parse(daysDate);
                SimpleDateFormat df2 = new SimpleDateFormat(MM_DD_YYYY);
                Date dateD = new Date(Long.parseLong(device.getEpaInstallationDate()));
                df2.format(dateD);
                Date dateD1 = new SimpleDateFormat(MM_DD_YYYY).parse(df2.format(dateD));
                boolean isAfter = date.after(dateD1);
                System.out.println("+++++++++++" + isAfter + "  " + dateD1 + ".." + df2.format(dateD) + ".." + date);
                if (isAfter) {
                    result = true;
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static String getStatusWithTime(String time, String status) {
        String formatedTime = NewWeeklyEmailChanges.getTime(time);
        return status + " - " + formatedTime;
    }

    private static String getTime(String startDate) {
        String date = "";
        try {
            SimpleDateFormat df2 = new SimpleDateFormat("HH:mm");
            Date dateD = new Date(startDate);
            date = df2.format(dateD);
        }
        catch (NumberFormatException e) {
            e.getStackTrace();
        }
        return date;
    }

    private static boolean isBackupStartedinWindowPeriod(String activityStartDateString) {
        String batchStartDateString = NewWeeklyEmailChanges.getDateForApproprioteDay(0);
        Date activityStartTime = null;
        Date batchStartTime = null;
        SimpleDateFormat format = new SimpleDateFormat(MM_DD_YYYY);
        try {
            activityStartTime = format.parse(activityStartDateString);
            batchStartTime = format.parse(batchStartDateString);
        }
        catch (ParseException e) {
            e.getStackTrace();
        }
        return activityStartTime == null || !activityStartTime.before(batchStartTime);
    }

    private static boolean isdateAfter(String batchEndDate, String windowEndDate) {
        boolean isdateBefore = false;
        try {
            SimpleDateFormat format = new SimpleDateFormat(MM_DD_YYYY);
            if (StringUtils.isNotEmpty(batchEndDate) && StringUtils.isNotEmpty(windowEndDate)) {
                Date formatedBatchEndDate = format.parse(batchEndDate);
                Date formatedWindowEndDate = format.parse(windowEndDate);
                isdateBefore = formatedBatchEndDate.after(formatedWindowEndDate);
            }
        }
        catch (Exception e) {
            e.getStackTrace();
        }
        return isdateBefore;
    }

    private static String getCommentsForBackupBatch(String errorCode) {
        String comments = "";
        if (StringUtils.isEmpty(errorCode)) {
            return "";
        }
        if ("0".equals(errorCode)) {
            comments = "Successfully Completed";
        }
        if ("909".equals(errorCode)) {
            comments = "Network disconnected during backup";
        }
        if ("911".equals(errorCode)) {
            comments = "User Exited the agent manually";
        }
        if ("912".equals(errorCode)) {
            comments = "Machine Utilization exceeded during backup";
        }
        if ("2304".equals(errorCode)) {
            comments = "Backup temporarily suspended because server is busy.Will be retried later";
        }
        if ("1992".equals(errorCode)) {
            comments = "User paused BackUp manually.";
        }
        if ("1981".equals(errorCode)) {
            comments = "User storage limit reached.";
        }
        if ("1996".equals(errorCode)) {
            comments = "Backup Deferred.";
        }
        if ("1207".equals(errorCode)) {
            comments = "User stopped BackUp manually";
        }
        return comments;
    }
}

