/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import org.bson.Document;

public class MongoRollBack {
    public static void main(String[] args) {
        MongoClient mongoClient = MongoRollBack.createMongoDBClient();
        MongoDatabase localDB = mongoClient.getDatabase("blukrypt");
        MongoCollection<Document> local = localDB.getCollection("LOCAL");
        MongoDatabase db = mongoClient.getDatabase("parablu001");
        MongoCollection<Document> main = db.getCollection("MAIN");
        MongoRollBack.rollback(mongoClient, main, local);
    }

    public static MongoClient createMongoDBClient() {
        ArrayList<ServerAddress> seedList = new ArrayList<ServerAddress>();
        seedList.add(new ServerAddress("192.168.7.161", 27017));
        seedList.add(new ServerAddress("192.168.7.161", 27017));
        ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
        credentials.add(MongoCredential.createScramSha1Credential("neil", "admin", "parablu".toCharArray()));
        MongoClientOptions options = MongoClientOptions.builder().socketTimeout(2000).connectionsPerHost(1).build();
        return new MongoClient(seedList, credentials, options);
    }

    private static void rollback(MongoClient client, MongoCollection local, MongoCollection main) {
        ClientSession session = client.startSession();
        try {
            try {
                session.startTransaction(TransactionOptions.builder().writeConcern(WriteConcern.MAJORITY).build());
                Document localDoc = new Document();
                localDoc.put("local", (Object)System.currentTimeMillis());
                local.insertOne(localDoc);
                MongoRollBack.sleep();
                Document mainDoc = new Document();
                mainDoc.put("local", (Object)System.currentTimeMillis());
                main.insertOne(mainDoc);
                session.commitTransaction();
            }
            catch (MongoCommandException e) {
                session.abortTransaction();
                System.out.println("####### ROLLBACK TRANSACTION #######");
                session.close();
                System.out.println("####################################\n");
            }
        }
        finally {
            session.close();
            System.out.println("####################################\n");
        }
    }

    private static void sleep() {
        System.out.println("Sleeping 30 seconds...");
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException e) {
            System.err.println("Oups...");
            e.printStackTrace();
        }
    }
}

