/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.DeleteResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class DeletedUserDeviceCleaner {
    public static final String CHUNK_DETAIL = "CHUNK_DETAIL";

    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String deviceUUIDs = config.getProperty("deviceUUIDs").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        MongoCollection<Document> deviceDBCollection = db.getCollection("DEVICE");
        MongoCollection<Document> userDBCollection = db.getCollection("USER");
        MongoCollection<Document> alertHistoryDBCollection = db.getCollection("ALERT_HISTORY");
        MongoCollection<Document> bkpBatchDBCollection = db.getCollection("BACKUP_BATCH");
        MongoCollection<Document> dailyUserBkpOverviewDBCollection = db.getCollection("DAILY_USER_BACKUP_OVERVIEW");
        MongoCollection<Document> deviceBkpOverviewDBCollection = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        System.out.println("started on :" + System.currentTimeMillis());
        ArrayList<String> deviceUUIDList = new ArrayList<String>();
        System.out.println("Policy Names :" + deviceUUIDList);
        deviceUUIDList.addAll(Arrays.asList(deviceUUIDs.split(",")));
        for (String deviceUUID : deviceUUIDList) {
            try {
                deviceUUID = deviceUUID.replace("[", "");
                deviceUUID = deviceUUID.replace("]", "");
                deviceUUID = deviceUUID.trim();
                System.out.println("Started deletion for deviceUUID :" + deviceUUID);
                BasicDBObject deviceUUIDQuery = new BasicDBObject("deviceUUID", deviceUUID);
                Document device = (Document)deviceDBCollection.find(deviceUUIDQuery).first();
                if (device != null) {
                    if (device.get("user") == null) continue;
                    DBRef userRef = (DBRef)device.get("user");
                    Document userDBObject = (Document)userDBCollection.find(new Document("_id", userRef.getId())).first();
                    String userName = userDBObject.getString("userName");
                    DeletedUserDeviceCleaner.makeRefCount0(userName, db);
                    alertHistoryDBCollection.deleteMany(new BasicDBObject("device", device));
                    bkpBatchDBCollection.deleteMany(new BasicDBObject("device", device));
                    dailyUserBkpOverviewDBCollection.deleteMany(new BasicDBObject("deviceUUID", deviceUUID));
                    DBRef deviceBkpOverviewRef = (DBRef)device.get("deviceBackupOverView");
                    Document deviceBkpOverviewDBObject = (Document)deviceBkpOverviewDBCollection.find(new Document("_id", deviceBkpOverviewRef.getId())).first();
                    deviceBkpOverviewDBCollection.deleteOne(deviceBkpOverviewDBObject);
                    MongoCollection<Document> bkpDBCollection = db.getCollection(device.getString("destCollection"));
                    DeleteResult deleteMany = bkpDBCollection.deleteMany(new BasicDBObject("deviceUUID", deviceUUID));
                    System.out.println("Total bkp image data deleted is :" + deleteMany.getDeletedCount() + " Device " + device.toString());
                    deviceDBCollection.deleteOne(device);
                    continue;
                }
                System.out.println("Device not found for deviceUUID :" + deviceUUID);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("Endend on :" + System.currentTimeMillis());
    }

    private static void makeRefCount0(String userName, MongoDatabase db) {
        System.out.println("Deleteing chunk detail for userName :" + userName);
        List<String> chunkCollectionNames = DeletedUserDeviceCleaner.getAllChunkBuketNames();
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("userName", userName));
        whereQuery.add(new BasicDBObject("userName", userName.toLowerCase()));
        andQuery.put("$or", whereQuery);
        for (String coll : chunkCollectionNames) {
            MongoCollection<Document> collection = db.getCollection(coll);
            DeleteResult deleteResult = collection.deleteMany(andQuery);
        }
    }

    private static List<String> getAllChunkBuketNames() {
        int toatalChunkBuckets = 102;
        ArrayList<String> chunkCollectionNames = new ArrayList<String>();
        chunkCollectionNames.add(CHUNK_DETAIL);
        int chunkBucket = 0;
        while (chunkBucket < toatalChunkBuckets) {
            String chunkBucketName = "CHUNK_DETAIL_" + chunkBucket;
            chunkCollectionNames.add(chunkBucketName);
            ++chunkBucket;
        }
        return chunkCollectionNames;
    }
}

