/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackupElement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.json.JSONObject;

public class CheckAlltheFolderExistsFromCSVAndInsert {
    public static void main(String[] args) {
        try {
            String st;
            PropertiesConfiguration config = null;
            config = new PropertiesConfiguration(args[0]);
            String mongoIP = config.getProperty("mongoIP").toString();
            String mongoPort = config.getProperty("mongoPort").toString();
            String path = config.getProperty("path").toString();
            MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
            MongoClient client = new MongoClient(uri);
            MongoDatabase db = client.getDatabase(uri.getDatabase());
            MongoCollection<Document> deviceDBCollection = db.getCollection("DEVICE");
            File file = new File(path);
            BufferedReader br = new BufferedReader(new FileReader(file));
            boolean lineNo = false;
            ArrayList folderList = new ArrayList();
            while ((st = br.readLine()) != null) {
                JSONObject json = new JSONObject(st);
                Document doc = Document.parse(json.toString());
                String folderPath = String.valueOf(doc.getString("devicePath")) + "/" + doc.getString("fileName");
                Document device = (Document)deviceDBCollection.find(new BasicDBObject("deviceUUID", doc.getString("deviceUUID"))).first();
                List<BackupElement> parentfolders = CheckAlltheFolderExistsFromCSVAndInsert.getParentfolders(folderPath);
                for (BackupElement parentFolder : parentfolders) {
                    if (!StringUtils.isNotEmpty(parentFolder.getFileCompletePath()) || !StringUtils.isNotEmpty(parentFolder.getFileName())) continue;
                    ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
                    BasicDBObject andQuery = new BasicDBObject();
                    whereQuery = new ArrayList();
                    whereQuery.add(new BasicDBObject("deviceUUID", doc.getString("deviceUUID")));
                    whereQuery.add(new BasicDBObject("folder", true));
                    whereQuery.add(new BasicDBObject("devicePath", parentFolder.getFileCompletePath()));
                    whereQuery.add(new BasicDBObject("fileName", parentFolder.getFileName()));
                    andQuery.put("$and", whereQuery);
                    MongoCollection<Document> bkpDBCollection = db.getCollection(device.getString("destCollection"));
                    long count = bkpDBCollection.count(andQuery);
                    if (count == 0L) {
                        System.out.println("PATH NOT EXIST ........ " + device.getString("destCollection") + " ........ " + parentFolder.getFileCompletePath() + " ........ " + parentFolder.getFileName() + " ........ " + doc);
                        continue;
                    }
                    System.out.println("for the file " + folderPath + " file exists..." + parentFolder.getFileName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static List<BackupElement> getParentfolders(String parentFilePath) {
        String fileName;
        String parentFilePathTemp = parentFilePath;
        ArrayList<BackupElement> elements = new ArrayList<BackupElement>();
        BackupElement fileElement = new BackupElement();
        if (parentFilePathTemp == null) {
            return null;
        }
        int lastIndex = parentFilePathTemp.lastIndexOf(47);
        if (lastIndex == -1 && "".equals(parentFilePathTemp)) {
            return null;
        }
        if (parentFilePathTemp.endsWith("/")) {
            parentFilePathTemp = parentFilePathTemp.substring(0, lastIndex);
            lastIndex = parentFilePathTemp.lastIndexOf(47);
            fileName = parentFilePathTemp;
        } else {
            fileName = parentFilePathTemp.substring(lastIndex + 1);
        }
        String filePath = null;
        if (lastIndex != -1) {
            filePath = parentFilePathTemp.substring(0, parentFilePathTemp.length() - fileName.length() - 1);
        }
        fileElement.setFileName(fileName);
        fileElement.setFolder(true);
        if (filePath != null && filePath.isEmpty()) {
            filePath = "ROOT";
        }
        fileElement.setFileCompletePath(filePath);
        fileElement.setMd5Checksum("null");
        fileElement.setPresent(true);
        fileElement.setSize(0L);
        elements.add(fileElement);
        List<BackupElement> elements2 = CheckAlltheFolderExistsFromCSVAndInsert.getParentfolders(fileElement.getFileCompletePath());
        if (elements2 != null) {
            elements.addAll(elements2);
        }
        return elements;
    }
}

