/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackupElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.springframework.util.CollectionUtils;

public class CheckAlltheFolderExistsAndInsert {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String policNames = config.getProperty("policNames").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
        MongoCollection<Document> userDBCollection = db.getCollection("USER");
        ArrayList<String> policyNameList = new ArrayList<String>();
        policyNameList.addAll(Arrays.asList(policNames.split(",")));
        for (String policName : policyNameList) {
            policName = policName.replace("[", "");
            policName = policName.replace("]", "");
            System.out.println("Started to " + policName);
            FindIterable<Document> users = userDBCollection.find(new BasicDBObject("policyName", policName));
            ArrayList<Document> userDBList = new ArrayList<Document>();
            for (Document user : users) {
                userDBList.add(user);
            }
            System.out.println("Total user size " + userDBList.size() + " for policName " + policName);
            for (Document user : userDBList) {
                try {
                    if (user == null || !StringUtils.isNotEmpty(user.getString("userName"))) continue;
                    String userName = user.getString("userName");
                    System.out.println("Started for userName " + userName);
                    FindIterable<Document> devices = deviceColl.find(new BasicDBObject("userName", userName));
                    for (Document device : devices) {
                        try {
                            System.out.println("Started for userName " + userName + "  and deviceName " + device.getString("deviceName"));
                            MongoCollection<Document> bkpColl = db.getCollection(device.getString("destCollection"));
                            List<Document> allFoldersList = CheckAlltheFolderExistsAndInsert.getFoldersByDeviceUUID(bkpColl, device);
                            if (CollectionUtils.isEmpty(allFoldersList)) continue;
                            ArrayList<Document> copyList = new ArrayList<Document>();
                            for (Document folder : allFoldersList) {
                                String devicePath;
                                if (!StringUtils.isNotEmpty(folder.getString("devicePath")) || !folder.getString("devicePath").contains("/")) continue;
                                String temp = devicePath = folder.getString("devicePath");
                                if (devicePath.endsWith("/")) {
                                    temp = devicePath.substring(0, devicePath.length());
                                }
                                String folderName = temp.substring(temp.lastIndexOf("/") + 1, temp.length());
                                String folderPath = devicePath.substring(0, devicePath.lastIndexOf("/"));
                                ArrayList filter = new ArrayList();
                                filter.addAll(allFoldersList.stream().filter(line -> Objects.nonNull(line) && StringUtils.isNotEmpty(line.getString("devicePath")) && StringUtils.isNotEmpty(line.getString("fileName")) && line.getString("devicePath").equals(folderPath) && line.getString("fileName").equals(folderName)).collect(Collectors.toList()));
                                filter.addAll(copyList.stream().filter(line -> Objects.nonNull(line) && StringUtils.isNotEmpty(line.getString("devicePath")) && StringUtils.isNotEmpty(line.getString("fileName")) && line.getString("devicePath").equals(folderPath) && line.getString("fileName").equals(folderName)).collect(Collectors.toList()));
                                if (!CollectionUtils.isEmpty(filter)) continue;
                                System.out.println("Empty folder " + folder);
                                copyList.add(folder);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            System.out.println("Ended to " + policName);
        }
    }

    private static List<String> getCompletePathsFromFolders(List<Document> allFoldersList) {
        ArrayList<String> completePaths = new ArrayList<String>();
        for (Document folders : allFoldersList) {
            if (StringUtils.isNotEmpty(folders.getString("devicePath"))) {
                completePaths.add(String.valueOf(folders.getString("devicePath")) + "/" + folders.getString("fileName"));
                continue;
            }
            completePaths.add(folders.getString("fileName"));
        }
        return completePaths;
    }

    private static List<Document> getFoldersByDeviceUUID(MongoCollection bkpColl, Document device) {
        ArrayList<Document> allFoldersList = new ArrayList<Document>();
        if (device != null && StringUtils.isNotEmpty(device.getString("destCollection")) && StringUtils.isNotEmpty(device.getString("deviceUUID"))) {
            FindIterable folders;
            int skip = 0;
            BasicDBObject andQuery = new BasicDBObject();
            ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
            whereQuery.add(new BasicDBObject("deviceUUID", device.getString("deviceUUID")));
            whereQuery.add(new BasicDBObject("folder", true));
            whereQuery.add(new BasicDBObject("present", true));
            andQuery.put("$and", whereQuery);
            while ((folders = bkpColl.find(andQuery).skip(skip * 500).limit(500)).first() != null) {
                for (Document document : folders) {
                    allFoldersList.add(document);
                }
                ++skip;
            }
        }
        System.out.println("toatal folder size ..." + allFoldersList.size());
        return allFoldersList;
    }

    private static List<BackupElement> getParentfolders(String parentFilePath) {
        String fileName;
        String parentFilePathTemp = parentFilePath;
        ArrayList<BackupElement> elements = new ArrayList<BackupElement>();
        BackupElement fileElement = new BackupElement();
        if (parentFilePathTemp == null) {
            return null;
        }
        int lastIndex = parentFilePathTemp.lastIndexOf(47);
        if (lastIndex == -1 && "".equals(parentFilePathTemp)) {
            return null;
        }
        if (parentFilePathTemp.endsWith("/")) {
            parentFilePathTemp = parentFilePathTemp.substring(0, lastIndex);
            lastIndex = parentFilePathTemp.lastIndexOf(47);
            fileName = parentFilePathTemp;
        } else {
            fileName = parentFilePathTemp.substring(lastIndex + 1);
        }
        String filePath = null;
        if (lastIndex != -1) {
            filePath = parentFilePathTemp.substring(0, parentFilePathTemp.length() - fileName.length() - 1);
        }
        fileElement.setFileName(fileName);
        fileElement.setFolder(true);
        if (filePath != null && filePath.isEmpty()) {
            filePath = "ROOT";
        }
        fileElement.setFileCompletePath(filePath);
        fileElement.setMd5Checksum("null");
        fileElement.setPresent(true);
        fileElement.setSize(0L);
        elements.add(fileElement);
        List<BackupElement> elements2 = CheckAlltheFolderExistsAndInsert.getParentfolders(fileElement.getFileCompletePath());
        if (elements2 != null) {
            elements.addAll(elements2);
        }
        return elements;
    }
}

