/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackupElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class CheckAlltheFolderExists {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String deviceUUID = config.getProperty("deviceUUID").toString();
        String policyNames = config.getProperty("deviceUUID").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        MongoCollection<Document> bkpDBCollection = db.getCollection("BACKUP_120");
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
        whereQuery.add(new BasicDBObject("folder", true));
        whereQuery.add(new BasicDBObject("present", true));
        andQuery.put("$and", whereQuery);
        FindIterable<Document> folders = bkpDBCollection.find(andQuery);
        System.out.println("Got folder list from db.....");
        ArrayList<String> folderList = new ArrayList<String>();
        for (Document document : folders) {
            if (!StringUtils.isNotEmpty(document.getString("devicePath"))) continue;
            folderList.add(String.valueOf(document.getString("devicePath")) + "/" + document.getString("fileName"));
        }
        System.out.println("All the folders are converted to list of strings....." + folderList.size());
        HashSet<String> set = new HashSet<String>();
        set.addAll(folderList);
        folderList.clear();
        folderList.addAll(set);
        System.out.println("After removing duplicates enties....." + folderList.size());
        int proccessed = folderList.size();
        int total = folderList.size();
        for (String folderPath : folderList) {
            System.out.println("........PROCESSED......" + ++proccessed + "/" + total);
            List<BackupElement> parentfolders = CheckAlltheFolderExists.getParentfolders(folderPath);
            for (BackupElement parentFolder : parentfolders) {
                if (!StringUtils.isNotEmpty(parentFolder.getFileCompletePath()) || !StringUtils.isNotEmpty(parentFolder.getFileName())) continue;
                whereQuery = new ArrayList();
                whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
                whereQuery.add(new BasicDBObject("folder", true));
                whereQuery.add(new BasicDBObject("devicePath", parentFolder.getFileCompletePath()));
                whereQuery.add(new BasicDBObject("fileName", parentFolder.getFileName()));
                andQuery.put("$and", whereQuery);
                long count = bkpDBCollection.count(andQuery);
                if (count == 0L) {
                    System.out.println("Inside this path " + parentFolder.getFileCompletePath() + " ........PATH NOT EXIST....... " + parentFolder.getFileName());
                    continue;
                }
                System.out.println("for the file " + folderPath + " file exists..." + parentFolder.getFileName());
            }
        }
    }

    private static List<BackupElement> getParentfolders(String parentFilePath) {
        String fileName;
        String parentFilePathTemp = parentFilePath;
        ArrayList<BackupElement> elements = new ArrayList<BackupElement>();
        BackupElement fileElement = new BackupElement();
        if (parentFilePathTemp == null) {
            return null;
        }
        int lastIndex = parentFilePathTemp.lastIndexOf(47);
        if (lastIndex == -1 && "".equals(parentFilePathTemp)) {
            return null;
        }
        if (parentFilePathTemp.endsWith("/")) {
            parentFilePathTemp = parentFilePathTemp.substring(0, lastIndex);
            lastIndex = parentFilePathTemp.lastIndexOf(47);
            fileName = parentFilePathTemp;
        } else {
            fileName = parentFilePathTemp.substring(lastIndex + 1);
        }
        String filePath = null;
        if (lastIndex != -1) {
            filePath = parentFilePathTemp.substring(0, parentFilePathTemp.length() - fileName.length() - 1);
        }
        fileElement.setFileName(fileName);
        fileElement.setFolder(true);
        if (filePath != null && filePath.isEmpty()) {
            filePath = "ROOT";
        }
        fileElement.setFileCompletePath(filePath);
        fileElement.setMd5Checksum("null");
        fileElement.setPresent(true);
        fileElement.setSize(0L);
        elements.add(fileElement);
        List<BackupElement> elements2 = CheckAlltheFolderExists.getParentfolders(fileElement.getFileCompletePath());
        if (elements2 != null) {
            elements.addAll(elements2);
        }
        return elements;
    }
}

