/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class BackupPolicyUtility {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        MongoCollection<Document> userDefinedFoldersDBCollection = db.getCollection("USER_DEFINED_FOLDERS");
        MongoCollection<Document> userExcludedFoldersDBCollection = db.getCollection("USER_EXCLUDED_FOLDERS");
        MongoCollection<Document> excludedFoldersDBCollection = db.getCollection("EXCLUDED_FOLDERS");
        MongoCollection<Document> bkpPolicyDBCollection = db.getCollection("BACKUP_POLICY");
        MongoCollection<Document> globalExclodedDBCollection = db.getCollection("GLOBAL_EXCLUDED_FOLDERS");
        BasicDBObject query = new BasicDBObject("folderType", new BasicDBObject("$exists", false));
        FindIterable<Document> userDefinedFoldersList = userDefinedFoldersDBCollection.find(query);
        for (Document userDefinedFolder : userDefinedFoldersList) {
            BasicDBObject userDefinedFolderSearchQuery = new BasicDBObject();
            userDefinedFolderSearchQuery.append("_id", userDefinedFolder.get("_id"));
            Iterator userDefinedUpdateFields = new BasicDBObject();
            ((BasicDBObject)((Object)userDefinedUpdateFields)).append("folderType", "INCLUSION");
            BasicDBObject updateDeviceQuery = new BasicDBObject();
            updateDeviceQuery.append("$set", userDefinedUpdateFields);
            userDefinedFoldersDBCollection.updateOne(userDefinedFolderSearchQuery, updateDeviceQuery);
        }
        BasicDBObject excludedQuery = new BasicDBObject("deviceUUID", new BasicDBObject("$exists", true));
        FindIterable<Document> userExcludedFoldersList = userExcludedFoldersDBCollection.find(excludedQuery);
        for (Document userExcludedFolder : userExcludedFoldersList) {
            try {
                userExcludedFolder.put("folderType", (Object)"EXCLUSION");
                userDefinedFoldersDBCollection.insertOne(userExcludedFolder);
            }
            catch (Exception e) {
                System.out.println(userExcludedFolder.getObjectId("_id") + e.getMessage());
            }
        }
        excludedQuery = new BasicDBObject("deviceUUID", new BasicDBObject("$exists", false));
        userExcludedFoldersList = userExcludedFoldersDBCollection.find(excludedQuery);
        for (Document userExcludedFolder : userExcludedFoldersList) {
            try {
                excludedFoldersDBCollection.insertOne(userExcludedFolder);
            }
            catch (Exception e) {
                System.out.println(userExcludedFolder.getObjectId("_id") + e.getMessage());
            }
        }
        FindIterable<Document> bkpPolicyList = bkpPolicyDBCollection.find();
        for (Document bkpPolicy : bkpPolicyList) {
            ArrayList<DBRef> excludedFolders = new ArrayList<DBRef>();
            System.out.println("Updating backup policy :" + bkpPolicy.getString("policyName"));
            if (bkpPolicy.get("userExcludedFolders") != null) {
                List userExcludedFolders = (List)bkpPolicy.get("userExcludedFolders");
                for (DBRef userExcludedFolder : userExcludedFolders) {
                    DBRef dbRef = new DBRef("EXCLUDED_FOLDERS", userExcludedFolder.getId());
                    excludedFolders.add(dbRef);
                }
            }
            if (StringUtils.isNotEmpty(bkpPolicy.getString("osType"))) {
                String osType = bkpPolicy.getString("osType");
                System.out.println("Inside........" + osType);
                BasicDBObject macquery = new BasicDBObject();
                if (osType.equals("mac")) {
                    macquery = new BasicDBObject("osType", "mac");
                } else if (osType.equals("windows")) {
                    macquery = new BasicDBObject("osType", "win");
                }
                FindIterable<Document> macGlobleEXclusionFolders = globalExclodedDBCollection.find(macquery);
                for (Document globleExcl : macGlobleEXclusionFolders) {
                    DBRef dbRef = new DBRef("EXCLUDED_FOLDERS", globleExcl.getObjectId("_id"));
                    globleExcl.remove("osType");
                    if (excludedFoldersDBCollection.count(new BasicDBObject("_id", globleExcl.getObjectId("_id"))) == 0L) {
                        excludedFoldersDBCollection.insertOne(globleExcl);
                        System.out.println(globleExcl.toJson());
                    }
                    excludedFolders.add(dbRef);
                }
            }
            System.out.println(excludedFolders.size());
            BasicDBObject bkpPolicySearchQuery = new BasicDBObject();
            bkpPolicySearchQuery.append("_id", bkpPolicy.get("_id"));
            BasicDBObject bkpPolicydUpdateFields = new BasicDBObject();
            bkpPolicydUpdateFields.append("excludedFolders", excludedFolders);
            BasicDBObject updatebkpPolicyQuery = new BasicDBObject();
            updatebkpPolicyQuery.append("$set", bkpPolicydUpdateFields);
            bkpPolicyDBCollection.updateOne(bkpPolicySearchQuery, updatebkpPolicyQuery);
        }
        System.out.println("Well its Done ");
    }
}

