/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class B2ExecutorUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void shutdownAndAwaitTermination(ExecutorService executor, int gracefulSecs, int otherSecs) {
        executor.shutdown();
        try {
            if (executor.awaitTermination(gracefulSecs, TimeUnit.SECONDS)) return;
            executor.shutdownNow();
            if (executor.awaitTermination(otherSecs, TimeUnit.SECONDS)) return;
        }
        catch (InterruptedException ie) {
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static ThreadFactory createThreadFactory(String nameFormat) {
        AtomicInteger count = new AtomicInteger(0);
        return runnable -> {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setName(String.format(nameFormat, count.getAndIncrement()));
            return thread;
        };
    }
}

