/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonException;

public class VersionRange {
    public static final VersionRange ALL_VERSIONS = new VersionRange(Integer.MIN_VALUE, Integer.MAX_VALUE);
    private final int firstVersion;
    private final int lastVersion;

    private VersionRange(int firstVersion2, int lastVersion) {
        this.firstVersion = firstVersion2;
        this.lastVersion = lastVersion;
    }

    public static VersionRange range(int firstVersion2, int lastVersion) throws B2JsonException {
        if (lastVersion < firstVersion2) {
            throw new B2JsonException("last version " + lastVersion + " is before first version " + firstVersion2);
        }
        return new VersionRange(firstVersion2, lastVersion);
    }

    public static VersionRange allVersionsFrom(int firstVersion2) {
        return new VersionRange(firstVersion2, Integer.MAX_VALUE);
    }

    public boolean includesVersion(int version) {
        return this.firstVersion <= version && version <= this.lastVersion;
    }
}

