/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class B2JsonUnionTypeMap {
    private final Map<String, Class<?>> typeNameToClass;
    private final Map<Class<?>, String> classToTypeName;

    private B2JsonUnionTypeMap(Map<String, Class<?>> typeNameToClass, Map<Class<?>, String> classToTypeName) {
        this.typeNameToClass = typeNameToClass;
        this.classToTypeName = classToTypeName;
    }

    public Map<String, Class<?>> getTypeNameToClass() {
        return this.typeNameToClass;
    }

    public String getTypeNameOrNullForClass(Class<?> clazz) {
        return this.classToTypeName.get(clazz);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, Class<?>> typeNameToClass = new HashMap();
        private final Map<Class<?>, String> classToTypeName = new HashMap();

        private Builder() {
        }

        public Builder put(String typeName, Class<?> typeClass) throws B2JsonException {
            if (this.typeNameToClass.containsKey(typeName)) {
                throw new B2JsonException("duplicate type name in union type map: '" + typeName + "'");
            }
            if (this.classToTypeName.containsKey(typeClass)) {
                throw new B2JsonException("duplicate class in union type map: " + typeClass);
            }
            this.typeNameToClass.put(typeName, typeClass);
            this.classToTypeName.put(typeClass, typeName);
            return this;
        }

        public B2JsonUnionTypeMap build() {
            return new B2JsonUnionTypeMap(Collections.unmodifiableMap(this.typeNameToClass), Collections.unmodifiableMap(this.classToTypeName));
        }
    }
}

