/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2Json;
import com.backblaze.b2.json.B2JsonBadValueException;
import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonHandlerMap;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonTypeHandlerWithDefaults;
import com.backblaze.b2.json.B2JsonUnionBaseHandler;
import com.backblaze.b2.json.B2JsonUtil;
import com.backblaze.b2.json.B2JsonWriter;
import com.backblaze.b2.json.B2TypeResolver;
import com.backblaze.b2.json.FieldInfo;
import com.backblaze.b2.json.VersionRange;
import com.backblaze.b2.util.B2Collections;
import com.backblaze.b2.util.B2Preconditions;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class B2JsonObjectHandler<T>
extends B2JsonTypeHandlerWithDefaults<T> {
    private final Class<T> clazz;
    private final B2TypeResolver typeResolver;
    private final Class<?> unionClass;
    private final String unionTypeFieldName;
    private final String unionTypeFieldValue;
    private FieldInfo[] fields;
    private final Map<String, FieldInfo> fieldMap = new HashMap<String, FieldInfo>();
    private Constructor<T> constructor;
    private int constructorParamCount;
    private Integer versionParamIndexOrNull;
    private Set<String> fieldsToDiscard;

    B2JsonObjectHandler(Class<T> clazz) throws B2JsonException {
        this(clazz, null);
    }

    B2JsonObjectHandler(Class<T> clazz, Type[] actualTypeArguments) throws B2JsonException {
        this.clazz = clazz;
        this.typeResolver = new B2TypeResolver(clazz, actualTypeArguments);
        Class<T> unionClass = null;
        String fieldName = null;
        String fieldValue = null;
        for (Class<T> parent = clazz.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
            if (!B2JsonHandlerMap.isUnionBase(parent)) continue;
            unionClass = parent;
            fieldName = parent.getAnnotation(B2Json.union.class).typeField();
            fieldValue = B2JsonUnionBaseHandler.getUnionTypeMap(parent).getTypeNameOrNullForClass(clazz);
            if (fieldValue != null) break;
            throw new B2JsonException("class " + clazz + " inherits from " + parent + ", but is not in the type map");
        }
        this.unionClass = unionClass;
        this.unionTypeFieldName = fieldName;
        this.unionTypeFieldValue = fieldValue;
    }

    @Override
    protected void initializeImplementation(B2JsonHandlerMap handlerMap) throws B2JsonException {
        int constructorParamCount;
        if (this.unionClass != null) {
            handlerMap.getUninitializedHandler(this.unionClass);
        }
        for (Field field : B2JsonHandlerMap.getObjectFieldsForJson(this.clazz)) {
            FieldInfo.FieldRequirement requirement = B2JsonHandlerMap.getFieldRequirement(this.clazz, field);
            Type resolvedFieldType = this.typeResolver.resolveType(field);
            B2JsonTypeHandler handler = handlerMap.getUninitializedHandler(resolvedFieldType);
            String defaultValueJsonOrNull = this.getDefaultValueJsonOrNull(field);
            VersionRange versionRange2 = this.getVersionRange(field);
            boolean isSensitive = field.getAnnotation(B2Json.sensitive.class) != null;
            boolean omitNull = this.omitNull(field);
            FieldInfo fieldInfo = new FieldInfo(field, handler, requirement, defaultValueJsonOrNull, versionRange2, isSensitive, omitNull);
            this.fieldMap.put(field.getName(), fieldInfo);
        }
        this.fields = this.fieldMap.values().toArray(new FieldInfo[this.fieldMap.size()]);
        Arrays.sort(this.fields);
        Constructor<?> chosenConstructor = null;
        for (Constructor<?> candidate : this.clazz.getDeclaredConstructors()) {
            if (candidate.getAnnotation(B2Json.constructor.class) == null) continue;
            if (chosenConstructor != null) {
                throw new B2JsonException(this.clazz.getName() + " has two constructors selected");
            }
            chosenConstructor = candidate;
            chosenConstructor.setAccessible(true);
        }
        if (chosenConstructor == null) {
            throw new B2JsonException(this.clazz.getName() + " has no constructor annotated with B2Json.constructor");
        }
        this.constructor = chosenConstructor;
        B2Json.constructor constructor2 = chosenConstructor.getAnnotation(B2Json.constructor.class);
        String versionParamOrEmpty = constructor2.versionParam();
        int numberOfVersionParams = versionParamOrEmpty.isEmpty() ? 0 : 1;
        String paramsWithCommas = constructor2.params().replace(" ", "");
        String[] paramNames = paramsWithCommas.split(",");
        if (paramNames.length == 1 && paramNames[0].length() == 0) {
            paramNames = new String[]{};
        }
        if (paramNames.length != (constructorParamCount = this.fields.length + numberOfVersionParams)) {
            throw new IllegalArgumentException(this.clazz.getName() + " constructor does not have the right number of parameters");
        }
        Integer versionParamIndex = null;
        HashSet<String> paramNamesSeen = new HashSet<String>();
        for (int i = 0; i < paramNames.length; ++i) {
            String paramName = paramNames[i];
            if (paramNamesSeen.contains(paramName)) {
                throw new B2JsonException(this.clazz.getName() + " constructor parameter '" + paramName + "' listed twice");
            }
            paramNamesSeen.add(paramName);
            if (paramName.isEmpty()) {
                throw new B2JsonException(this.clazz.getName() + " constructor parameter name must not be empty");
            }
            if (paramName.equals(versionParamOrEmpty)) {
                versionParamIndex = i;
                continue;
            }
            FieldInfo fieldInfo = this.fieldMap.get(paramName);
            if (fieldInfo == null) {
                throw new B2JsonException(this.clazz.getName() + " param name is not a field: " + paramName);
            }
            fieldInfo.setConstructorArgIndex(i);
        }
        this.versionParamIndexOrNull = versionParamIndex;
        this.constructorParamCount = constructorParamCount;
        String discardsWithCommas = constructor2.discards().replace(" ", "");
        if (discardsWithCommas.isEmpty()) {
            this.fieldsToDiscard = null;
        } else {
            String[] discardNames = discardsWithCommas.split(",");
            this.fieldsToDiscard = B2Collections.unmodifiableSet(discardNames);
            for (String name : this.fieldsToDiscard) {
                FieldInfo fieldInfo = this.fieldMap.get(name);
                if (fieldInfo == null || fieldInfo.requirement == FieldInfo.FieldRequirement.IGNORED) continue;
                throw new B2JsonException(this.clazz.getSimpleName() + "'s field '" + name + "' cannot be discarded: it's " + (Object)((Object)fieldInfo.requirement) + ".  only non-existent or IGNORED fields can be discarded.");
            }
        }
    }

    private boolean omitNull(Field field) throws B2JsonException {
        B2Json.optional optionalAnnotation = field.getAnnotation(B2Json.optional.class);
        if (optionalAnnotation != null) {
            boolean omitNull = optionalAnnotation.omitNull();
            if (omitNull && field.getType().isPrimitive()) {
                String message = String.format("Field %s.%s declared with 'omitNull = true' but is a primitive type", this.clazz.getSimpleName(), field.getName());
                throw new B2JsonException(message);
            }
            return omitNull;
        }
        return false;
    }

    @Override
    protected void checkDefaultValues() throws B2JsonException {
        for (FieldInfo field : this.fieldMap.values()) {
            if (field.defaultValueJsonOrNull == null) continue;
            try {
                field.handler.deserialize(new B2JsonReader(new StringReader(field.defaultValueJsonOrNull)), B2JsonOptions.DEFAULT);
            }
            catch (B2JsonException | IOException e) {
                throw new B2JsonException("error in default value for " + this.clazz.getSimpleName() + "." + field.getName() + ": " + e.getMessage());
            }
        }
    }

    private String getDefaultValueJsonOrNull(Field field) {
        B2Json.optionalWithDefault optional2 = field.getAnnotation(B2Json.optionalWithDefault.class);
        if (optional2 == null) {
            return null;
        }
        return optional2.defaultValue();
    }

    private VersionRange getVersionRange(Field field) throws B2JsonException {
        B2Json.firstVersion firstVersion2 = field.getAnnotation(B2Json.firstVersion.class);
        B2Json.versionRange versionRange2 = field.getAnnotation(B2Json.versionRange.class);
        if (firstVersion2 != null && versionRange2 != null) {
            throw new B2JsonException("must not specify both 'firstVersion' and 'versionRange' in " + this.clazz);
        }
        if (firstVersion2 != null) {
            return VersionRange.allVersionsFrom(firstVersion2.firstVersion());
        }
        if (versionRange2 != null) {
            if (versionRange2.lastVersion() < versionRange2.firstVersion()) {
                throw new B2JsonException("last version " + versionRange2.lastVersion() + " is before first version " + versionRange2.firstVersion() + " in " + this.clazz);
            }
            return VersionRange.range(versionRange2.firstVersion(), versionRange2.lastVersion());
        }
        return VersionRange.ALL_VERSIONS;
    }

    @Override
    public Type getHandledType() {
        return this.typeResolver.getType();
    }

    @Override
    public void serialize(T obj, B2JsonOptions options, B2JsonWriter out) throws IOException, B2JsonException {
        B2Preconditions.checkState(this.isInitialized());
        this.throwIfBadDefaultValue();
        try {
            int version = options.getVersion();
            boolean typeFieldDone = false;
            out.startObject();
            if (this.fields != null) {
                for (FieldInfo fieldInfo : this.fields) {
                    if (this.unionTypeFieldName != null && !typeFieldDone && this.unionTypeFieldName.compareTo(fieldInfo.getName()) < 0) {
                        out.writeObjectFieldNameAndColon(this.unionTypeFieldName);
                        out.writeString(this.unionTypeFieldValue);
                        typeFieldDone = true;
                    }
                    if (!fieldInfo.isInVersion(version)) continue;
                    Object value = fieldInfo.field.get(obj);
                    if (fieldInfo.omitNull && value == null) continue;
                    out.writeObjectFieldNameAndColon(fieldInfo.getName());
                    if (fieldInfo.getIsSensitive() && options.getRedactSensitive()) {
                        out.writeString("***REDACTED***");
                        continue;
                    }
                    if (fieldInfo.isRequiredAndInVersion(version) && value == null) {
                        throw new B2JsonException("required field " + fieldInfo.getName() + " cannot be null");
                    }
                    B2JsonUtil.serializeMaybeNull(fieldInfo.handler, value, out, options);
                }
            }
            if (this.unionTypeFieldName != null && !typeFieldDone) {
                out.writeObjectFieldNameAndColon(this.unionTypeFieldName);
                out.writeString(this.unionTypeFieldValue);
            }
            out.finishObject();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public T deserializeUrlParam(String urlValue) throws B2JsonException {
        throw new B2JsonException("objects not supported in URL parameter");
    }

    @Override
    public T deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        B2Preconditions.checkState(this.isInitialized());
        this.throwIfBadDefaultValue();
        if (this.fields == null) {
            throw new B2JsonException("B2JsonObjectHandler.deserializes called with null fields");
        }
        int version = options.getVersion();
        Object[] constructorArgs = new Object[this.constructorParamCount];
        long foundFieldBits = 0L;
        if (in == null) {
            throw new B2JsonException("B2JsonObjectHandler.deserialize called with null B2JsonReader");
        }
        if (in.startObjectAndCheckForContents()) {
            do {
                String fieldName;
                FieldInfo fieldInfo;
                if ((fieldInfo = this.fieldMap.get(fieldName = in.readObjectFieldNameAndColon())) == null) {
                    if (!(options.getExtraFieldOption() != B2JsonOptions.ExtraFieldOption.ERROR || this.fieldsToDiscard != null && this.fieldsToDiscard.contains(fieldName))) {
                        throw new B2JsonException("unknown field in " + this.clazz.getName() + ": " + fieldName);
                    }
                    in.skipValue();
                    continue;
                }
                if ((foundFieldBits & fieldInfo.bit) != 0L) {
                    throw new B2JsonException("duplicate field: " + fieldInfo.getName());
                }
                Object value = B2JsonUtil.deserializeMaybeNull(fieldInfo.handler, in, options);
                if (fieldInfo.isRequiredAndInVersion(version) && value == null) {
                    throw new B2JsonException("required field " + fieldInfo.getName() + " cannot be null");
                }
                constructorArgs[fieldInfo.constructorArgIndex] = value;
                foundFieldBits |= fieldInfo.bit;
            } while (in.objectHasMoreFields());
        }
        in.finishObject();
        if (this.versionParamIndexOrNull != null) {
            constructorArgs[this.versionParamIndexOrNull.intValue()] = version;
        }
        return this.deserializeFromConstructorArgs(constructorArgs, version);
    }

    public T deserializeFromFieldNameToValueMap(Map<String, Object> fieldNameToValue, B2JsonOptions options) throws B2JsonException {
        B2Preconditions.checkState(this.isInitialized());
        int version = options.getVersion();
        Object[] constructorArgs = new Object[this.fields.length];
        long foundFieldBits = 0L;
        if (fieldNameToValue == null) {
            throw new B2JsonException("B2JsonObjectHandler.deserializeFromFieldNameToValueMap called with null fieldNameToValue");
        }
        for (Map.Entry<String, Object> entry : fieldNameToValue.entrySet()) {
            String fieldName = entry.getKey();
            FieldInfo fieldInfo = this.fieldMap.get(fieldName);
            if (fieldInfo == null) {
                if (options.getExtraFieldOption() != B2JsonOptions.ExtraFieldOption.ERROR || this.fieldsToDiscard != null && this.fieldsToDiscard.contains(fieldName)) continue;
                throw new B2JsonException("unknown field in " + this.clazz.getName() + ": " + fieldName);
            }
            Object value = entry.getValue();
            if (fieldInfo.isRequiredAndInVersion(version) && value == null) {
                throw new B2JsonException("required field " + fieldInfo.getName() + " cannot be null");
            }
            constructorArgs[fieldInfo.constructorArgIndex] = value;
            foundFieldBits |= fieldInfo.bit;
        }
        return this.deserializeFromConstructorArgs(constructorArgs, version);
    }

    public T deserializeFromUrlParameterMap(Map<String, String> parameterMap, B2JsonOptions options) throws B2JsonException {
        B2Preconditions.checkState(this.isInitialized());
        int version = options.getVersion();
        Object[] constructorArgs = new Object[this.fields.length];
        long foundFieldBits = 0L;
        if (parameterMap == null) {
            throw new B2JsonException("B2JsonObjectHandler.deserializeFromUrlParameterMape called with null parameterMap");
        }
        for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
            String fieldName = entry.getKey();
            String strOfValue = entry.getValue();
            FieldInfo fieldInfo = this.fieldMap.get(fieldName);
            if (fieldInfo == null) {
                if (options.getExtraFieldOption() != B2JsonOptions.ExtraFieldOption.ERROR || this.fieldsToDiscard != null && this.fieldsToDiscard.contains(fieldName)) continue;
                throw new B2JsonException("unknown field in " + this.clazz.getName() + ": " + fieldName);
            }
            Object value = fieldInfo.handler.deserializeUrlParam(strOfValue);
            if (fieldInfo.isRequiredAndInVersion(version) && value == null) {
                throw new B2JsonException("required field " + fieldInfo.getName() + " cannot be null");
            }
            constructorArgs[fieldInfo.constructorArgIndex] = value;
            foundFieldBits |= fieldInfo.bit;
        }
        return this.deserializeFromConstructorArgs(constructorArgs, version);
    }

    private T deserializeFromConstructorArgs(Object[] constructorArgs, int version) throws B2JsonException {
        B2Preconditions.checkState(this.isInitialized());
        if (this.fields == null) {
            throw new B2JsonException("B2JsonObjectHandler.deserializeFromConstructorArgs called with null fields");
        }
        for (FieldInfo fieldInfo : this.fields) {
            int index = fieldInfo.constructorArgIndex;
            if (constructorArgs[index] == null) {
                if (fieldInfo.isRequiredAndInVersion(version)) {
                    throw new B2JsonException("required field " + fieldInfo.getName() + " is missing");
                }
                if (fieldInfo.defaultValueJsonOrNull != null) {
                    try {
                        constructorArgs[index] = fieldInfo.handler.deserialize(new B2JsonReader(new StringReader(fieldInfo.defaultValueJsonOrNull)), B2JsonOptions.DEFAULT);
                        continue;
                    }
                    catch (IOException e) {
                        throw new B2JsonException(e.getMessage());
                    }
                }
                constructorArgs[index] = fieldInfo.handler.defaultValueForOptional();
                continue;
            }
            if (fieldInfo.isInVersion(version)) continue;
            throw new B2JsonException("field " + fieldInfo.getName() + " is not in version " + version);
        }
        try {
            return this.constructor.newInstance(constructorArgs);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new B2JsonException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof IllegalArgumentException) {
                throw new B2JsonBadValueException(targetException.getMessage());
            }
            throw new B2JsonException(targetException.getMessage(), targetException);
        }
    }

    @Override
    public T defaultValueForOptional() {
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return false;
    }
}

