/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonNonUrlTypeHandler;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonUtil;
import com.backblaze.b2.json.B2JsonWriter;
import com.backblaze.b2.json.B2TypeResolver;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class B2JsonObjectArrayHandler<T>
extends B2JsonNonUrlTypeHandler<T> {
    private final B2JsonTypeHandler<Object> itemHandler;
    private final Class<T> arrayClazz;
    private final Class eltClazz;

    public B2JsonObjectArrayHandler(Class<T> arrayClazz, Class eltClazz, B2JsonTypeHandler itemHandler) {
        this.arrayClazz = arrayClazz;
        this.eltClazz = eltClazz;
        this.itemHandler = itemHandler;
    }

    @Override
    public Type getHandledType() {
        return new B2TypeResolver.ResolvedParameterizedType(this.arrayClazz, new Type[]{this.eltClazz});
    }

    @Override
    public void serialize(T array, B2JsonOptions options, B2JsonWriter out) throws IOException, B2JsonException {
        out.startArray();
        int nElts = Array.getLength(array);
        for (int i = 0; i < nElts; ++i) {
            out.startArrayValue();
            B2JsonUtil.serializeMaybeNull(this.itemHandler, Array.get(array, i), out, options);
        }
        out.finishArray();
    }

    @Override
    public T deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        ArrayList<Object> result = new ArrayList<Object>();
        if (in.startArrayAndCheckForContents()) {
            do {
                result.add(B2JsonUtil.deserializeMaybeNull(this.itemHandler, in, options));
            } while (in.arrayHasMoreValues());
        }
        in.finishArray();
        int nElts = result.size();
        Object array = Array.newInstance(this.eltClazz, nElts);
        int i = 0;
        for (Object e : result) {
            Array.set(array, i, e);
            ++i;
        }
        return (T)array;
    }

    @Override
    public T defaultValueForOptional() {
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return false;
    }
}

