/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.webApiHttpClient;

import com.backblaze.b2.client.contentHandlers.B2ContentSink;
import com.backblaze.b2.client.contentSources.B2Headers;
import com.backblaze.b2.client.contentSources.B2HeadersImpl;
import com.backblaze.b2.client.exceptions.B2ConnectFailedException;
import com.backblaze.b2.client.exceptions.B2ConnectionBrokenException;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.exceptions.B2LocalException;
import com.backblaze.b2.client.exceptions.B2NetworkException;
import com.backblaze.b2.client.exceptions.B2NetworkTimeoutException;
import com.backblaze.b2.client.structures.B2ErrorStructure;
import com.backblaze.b2.client.webApiClients.B2WebApiClient;
import com.backblaze.b2.client.webApiHttpClient.HttpClientFactory;
import com.backblaze.b2.client.webApiHttpClient.HttpClientFactoryImpl;
import com.backblaze.b2.json.B2Json;
import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.util.B2IoUtils;
import com.backblaze.b2.util.B2Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

public class B2WebApiHttpClientImpl
implements B2WebApiClient {
    private static final String UTF8 = "UTF-8";
    private final B2Json bzJson = B2Json.get();
    private final HttpClientFactory clientFactory;

    private B2WebApiHttpClientImpl(HttpClientFactory clientFactory) {
        this.clientFactory = clientFactory != null ? clientFactory : HttpClientFactoryImpl.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <ResponseType> ResponseType postJsonReturnJson(String url, B2Headers headersOrNull, Object request, Class<ResponseType> responseClass) throws B2Exception {
        String responseString = this.postJsonAndReturnString(url, headersOrNull, request);
        try {
            return this.bzJson.fromJson(responseString, responseClass, B2JsonOptions.DEFAULT_AND_ALLOW_EXTRA_FIELDS);
        }
        catch (B2JsonException e) {
            throw new B2LocalException("parsing_failed", "can't convert response from json: " + e.getMessage(), e);
        }
    }

    @Override
    public <ResponseType> ResponseType postDataReturnJson(String url, B2Headers headersOrNull, InputStream inputStream, long contentLength, Class<ResponseType> responseClass) throws B2Exception {
        try {
            InputStreamEntity requestEntity = new InputStreamEntity(inputStream, contentLength);
            String responseJson = this.postAndReturnString(url, headersOrNull, requestEntity);
            return B2Json.get().fromJson(responseJson, responseClass, B2JsonOptions.DEFAULT_AND_ALLOW_EXTRA_FIELDS);
        }
        catch (B2JsonException e) {
            throw new B2LocalException("parsing_failed", "can't convert response from json: " + e.getMessage(), e);
        }
    }

    @Override
    public void getContent(String url, B2Headers headersOrNull, B2ContentSink handler) throws B2Exception {
        block16: {
            HttpGet get = new HttpGet(url);
            if (headersOrNull != null) {
                get.setHeaders(this.makeHeaders(headersOrNull));
            }
            try (CloseableHttpResponse response = this.clientFactory.create().execute(get);){
                int statusCode = response.getStatusLine().getStatusCode();
                HttpEntity responseEntity = response.getEntity();
                if (200 <= statusCode && statusCode < 300) {
                    InputStream content = responseEntity.getContent();
                    handler.readContent(this.makeHeaders(response.getAllHeaders()), content);
                    content.read();
                    break block16;
                }
                String responseText = EntityUtils.toString(responseEntity, UTF8);
                throw this.extractExceptionFromErrorResponse(response, responseText);
            }
            catch (IOException e) {
                throw this.translateToB2Exception(e, url);
            }
        }
    }

    @Override
    public B2Headers head(String url, B2Headers headersOrNull) throws B2Exception {
        int statusCode;
        CloseableHttpResponse response;
        block6: {
            response = null;
            HttpHead head = new HttpHead(url);
            if (headersOrNull != null) {
                head.setHeaders(this.makeHeaders(headersOrNull));
            }
            if ((statusCode = (response = this.clientFactory.create().execute(head)).getStatusLine().getStatusCode()) != 200) break block6;
            B2HeadersImpl.Builder builder = B2HeadersImpl.builder();
            Arrays.stream(response.getAllHeaders()).forEach(header -> builder.set(header.getName(), header.getValue()));
            B2HeadersImpl b2HeadersImpl = builder.build();
            B2IoUtils.closeQuietly(response);
            return b2HeadersImpl;
        }
        try {
            try {
                throw B2Exception.create(null, statusCode, null, "");
            }
            catch (IOException e) {
                throw this.translateToB2Exception(e, url);
            }
        }
        catch (Throwable throwable) {
            B2IoUtils.closeQuietly(response);
            throw throwable;
        }
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }

    private B2Headers makeHeaders(Header[] allHeaders) {
        B2HeadersImpl.Builder builder = B2HeadersImpl.builder();
        for (Header header : allHeaders) {
            builder.set(header.getName(), header.getValue());
        }
        return builder.build();
    }

    private String postJsonAndReturnString(String url, B2Headers headersOrNull, Object request) throws B2Exception {
        ByteArrayEntity requestEntity = B2WebApiHttpClientImpl.parseToByteArrayEntityUsingBzJson(request);
        return this.postAndReturnString(url, headersOrNull, requestEntity);
    }

    private String postAndReturnString(String url, B2Headers headersOrNull, HttpEntity requestEntity) throws B2Exception {
        String responseText;
        CloseableHttpResponse response;
        block7: {
            response = null;
            HttpPost post = new HttpPost(url);
            if (headersOrNull != null) {
                post.setHeaders(this.makeHeaders(headersOrNull));
            }
            if (requestEntity != null) {
                post.setEntity(requestEntity);
            }
            response = this.clientFactory.create().execute(post);
            HttpEntity responseEntity = response.getEntity();
            responseText = EntityUtils.toString(responseEntity, UTF8);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) break block7;
            String string = responseText;
            B2IoUtils.closeQuietly(response);
            return string;
        }
        try {
            try {
                throw this.extractExceptionFromErrorResponse(response, responseText);
            }
            catch (IOException e) {
                throw this.translateToB2Exception(e, url);
            }
        }
        catch (Throwable throwable) {
            B2IoUtils.closeQuietly(response);
            throw throwable;
        }
    }

    private B2Exception translateToB2Exception(IOException e, String url) {
        if (e instanceof ConnectException) {
            return new B2ConnectFailedException("connect_failed", null, "failed to connect for " + url, e);
        }
        if (e instanceof UnknownHostException) {
            return new B2ConnectFailedException("unknown_host", null, "unknown host for " + url, e);
        }
        if (e instanceof ConnectionPoolTimeoutException) {
            return new B2ConnectFailedException("connect_timed_out", null, "connect timed out for " + url, e);
        }
        if (e instanceof ConnectTimeoutException) {
            return new B2ConnectFailedException("connection_pool_timed_out", null, "connection pool timed out for " + url, e);
        }
        if (e instanceof SocketTimeoutException) {
            return new B2NetworkTimeoutException("socket_timeout", null, "socket timed out talking to " + url, e);
        }
        if (e instanceof SocketException) {
            return new B2NetworkException("socket_exception", null, "socket exception talking to " + url, e);
        }
        if (e instanceof NoHttpResponseException) {
            return new B2ConnectionBrokenException("no_http_response", null, "didn't get an http response from " + url, e);
        }
        return new B2NetworkException("io_exception", null, e + " talking to " + url, e);
    }

    private B2Exception extractExceptionFromErrorResponse(CloseableHttpResponse response, String responseText) {
        int statusCode = response.getStatusLine().getStatusCode();
        try {
            B2ErrorStructure err = B2Json.get().fromJson(responseText, B2ErrorStructure.class);
            return B2Exception.create(err.code, err.status, this.getRetryAfterSecondsOrNull(response), err.message);
        }
        catch (Throwable t) {
            return new B2Exception("unknown", statusCode, this.getRetryAfterSecondsOrNull(response), responseText);
        }
    }

    private Integer getRetryAfterSecondsOrNull(CloseableHttpResponse response) {
        for (Header header : response.getHeaders("Retry-After")) {
            try {
                return Integer.parseInt(header.getValue(), 10);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return null;
    }

    private Header[] makeHeaders(B2Headers headersOrNull) {
        if (headersOrNull == null) {
            return null;
        }
        int headerCount = headersOrNull.getNames().size();
        Header[] vHeaders = new Header[headerCount];
        int iHeader = 0;
        for (String name : headersOrNull.getNames()) {
            vHeaders[iHeader] = new BasicHeader(name, headersOrNull.getValueOrNull(name));
            ++iHeader;
        }
        return vHeaders;
    }

    private static ByteArrayEntity parseToByteArrayEntityUsingBzJson(Object request) throws B2Exception {
        B2Preconditions.checkArgument(request != null);
        try {
            B2Json bzJson = B2Json.get();
            String requestJson = bzJson.toJson(request);
            byte[] requestBytes = B2WebApiHttpClientImpl.getUtf8Bytes(requestJson);
            return new ByteArrayEntity(requestBytes);
        }
        catch (B2JsonException e) {
            throw new B2LocalException("parsing_failed", "B2Json.toJson(" + request.getClass() + ") failed: " + e.getMessage(), e);
        }
    }

    private static byte[] getUtf8Bytes(String str) throws B2Exception {
        try {
            return str.getBytes(UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("No UTF-8 charset", e);
        }
    }

    public static class Builder {
        private HttpClientFactory httpClientFactory;

        public Builder setHttpClientFactory(HttpClientFactory httpClientFactory) {
            this.httpClientFactory = httpClientFactory;
            return this;
        }

        public B2WebApiHttpClientImpl build() {
            return new B2WebApiHttpClientImpl(this.httpClientFactory);
        }
    }
}

