/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.client.contentSources.B2ContentSource;
import com.backblaze.b2.client.structures.B2UploadListener;
import java.util.Map;
import java.util.TreeMap;

public class B2UploadFileRequest {
    private final String bucketId;
    private final String fileName;
    private final String contentType;
    private final B2ContentSource contentSource;
    private final Map<String, String> fileInfo;
    private final B2UploadListener listener;

    private B2UploadFileRequest(String bucketId, String fileName, String contentType, Map<String, String> fileInfo, B2ContentSource contentSource, B2UploadListener listener) {
        this.bucketId = bucketId;
        this.fileName = fileName;
        this.contentType = contentType;
        this.fileInfo = fileInfo;
        this.contentSource = contentSource;
        this.listener = listener != null ? listener : B2UploadListener.noopListener();
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public B2ContentSource getContentSource() {
        return this.contentSource;
    }

    public Map<String, String> getFileInfo() {
        return this.fileInfo;
    }

    public B2UploadListener getListener() {
        return this.listener;
    }

    public static Builder builder(String bucketId, String fileName, String contentType, B2ContentSource source) {
        return new Builder(bucketId, fileName, contentType, source);
    }

    public static class Builder {
        private String bucketId;
        private String fileName;
        private String contentType;
        private B2ContentSource source;
        private Map<String, String> info;
        private B2UploadListener listener;

        Builder(String bucketId, String fileName, String contentType, B2ContentSource source) {
            this.bucketId = bucketId;
            this.fileName = fileName;
            this.contentType = contentType;
            this.source = source;
            this.info = new TreeMap<String, String>();
        }

        public Builder setCustomField(String name, String value) {
            this.info.put(name, value);
            return this;
        }

        public Builder setCustomFields(Map<String, String> fileInfo) {
            if (fileInfo != null) {
                this.info.putAll(fileInfo);
            }
            return this;
        }

        public Builder setListener(B2UploadListener listener) {
            this.listener = listener;
            return this;
        }

        public B2UploadFileRequest build() {
            return new B2UploadFileRequest(this.bucketId, this.fileName, this.contentType, this.info, this.source, this.listener);
        }
    }
}

