/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.json.B2Json;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class B2CorsRule {
    @B2Json.required
    private final String corsRuleName;
    @B2Json.required
    private final List<String> allowedOrigins;
    @B2Json.required
    private final Set<String> allowedOperations;
    @B2Json.optional
    private final List<String> allowedHeaders;
    @B2Json.optional
    private final List<String> exposeHeaders;
    @B2Json.required
    private final int maxAgeSeconds;

    @B2Json.constructor(params="corsRuleName,allowedOrigins,allowedOperations,allowedHeaders,exposeHeaders,maxAgeSeconds")
    private B2CorsRule(String corsRuleName, List<String> allowedOrigins, Set<String> allowedOperations, List<String> allowedHeaders, List<String> exposeHeaders, int maxAgeSeconds) {
        this.corsRuleName = corsRuleName;
        this.allowedOrigins = allowedOrigins;
        this.allowedOperations = allowedOperations;
        this.allowedHeaders = allowedHeaders;
        this.exposeHeaders = exposeHeaders;
        this.maxAgeSeconds = maxAgeSeconds;
    }

    public String getCorsRuleName() {
        return this.corsRuleName;
    }

    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public Set<String> getAllowedOperations() {
        return this.allowedOperations;
    }

    public List<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public List<String> getExposeHeaders() {
        return this.exposeHeaders;
    }

    public int getMaxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public static Builder builder(String corsRuleName, List<String> allowedOrigins, Set<String> allowedOperations, int maxAgeSeconds) {
        return new Builder(corsRuleName, allowedOrigins, allowedOperations, maxAgeSeconds);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2CorsRule corsRule = (B2CorsRule)o;
        return this.corsRuleName.equals(corsRule.corsRuleName) && this.maxAgeSeconds == corsRule.maxAgeSeconds && Objects.equals(this.allowedOrigins, corsRule.allowedOrigins) && Objects.equals(this.allowedOperations, corsRule.allowedOperations) && Objects.equals(this.getAllowedHeaders(), corsRule.getAllowedHeaders()) && Objects.equals(this.getExposeHeaders(), corsRule.getExposeHeaders());
    }

    public int hashCode() {
        return Objects.hash(this.corsRuleName, this.allowedOrigins, this.allowedOperations, this.allowedHeaders, this.exposeHeaders, this.maxAgeSeconds);
    }

    public String toString() {
        return "CorsRule{corsRuleName=" + this.corsRuleName + ", allowedOrigin=" + this.allowedOrigins + ", allowedOperations=" + this.allowedOperations + ", allowedHeaders=" + this.allowedHeaders + ", exposeHeaders=" + this.exposeHeaders + ", maxAgeSeconds=" + this.maxAgeSeconds + '}';
    }

    public static class Builder {
        private String corsRuleName;
        private List<String> allowedOrigins;
        private Set<String> allowedOperations;
        private List<String> allowedHeaders;
        private List<String> exposeHeaders;
        private int maxAgeSeconds;

        Builder(String corsRuleName, List<String> allowedOrigins, Set<String> allowedOperations, int maxAgeSeconds) {
            this.corsRuleName = corsRuleName;
            this.allowedOrigins = allowedOrigins;
            this.allowedOperations = allowedOperations;
            this.allowedHeaders = null;
            this.exposeHeaders = null;
            this.maxAgeSeconds = maxAgeSeconds;
        }

        public Builder setAllowedHeaders(List<String> allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
            return this;
        }

        public Builder setExposeHeaders(List<String> exposeHeaders) {
            this.exposeHeaders = exposeHeaders;
            return this;
        }

        public B2CorsRule build() {
            return new B2CorsRule(this.corsRuleName, this.allowedOrigins, this.allowedOperations, this.allowedHeaders, this.exposeHeaders, this.maxAgeSeconds);
        }
    }
}

