/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.contentHandlers;

import com.backblaze.b2.client.contentHandlers.B2ContentSink;
import com.backblaze.b2.client.contentSources.B2Headers;
import com.backblaze.b2.client.exceptions.B2ConnectionBrokenException;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.exceptions.B2LocalException;
import com.backblaze.b2.util.B2IoUtils;
import com.backblaze.b2.util.B2Preconditions;
import com.backblaze.b2.util.B2Sha1;
import com.backblaze.b2.util.B2Sha1InputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class B2ContentWriter
implements B2ContentSink {
    private static final int EOF = -1;
    private static final int DEFAULT_COPY_BUFFER_SIZE = 4096;
    private final boolean verifySha1ByRereadingFromDestination;
    private B2Headers headers;

    B2ContentWriter(boolean verifySha1ByRereadingFromDestination) {
        this.verifySha1ByRereadingFromDestination = verifySha1ByRereadingFromDestination;
    }

    boolean getVerifySha1ByRereadingFromDestination() {
        return this.verifySha1ByRereadingFromDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readContent(B2Headers responseHeaders, InputStream rawIn) throws B2Exception {
        this.headers = responseHeaders;
        String expectedSha1OrNull = B2ContentWriter.getSha1ToCheckOrNull(this.headers);
        InputStream in = expectedSha1OrNull != null ? new B2Sha1InputStream(rawIn) : rawIn;
        OutputStream out = null;
        try {
            out = this.createDestinationOutputStreamOrThrow();
            B2ContentWriter.copy(in, out);
            this.closeOrThrow(out);
            this.maybeCheckSha1("from network", expectedSha1OrNull, in);
            this.maybeVerifySha1FromDestination(expectedSha1OrNull);
        }
        finally {
            B2IoUtils.closeQuietly(out);
        }
    }

    private void maybeCheckSha1(String when, String expectedSha1OrNull, InputStream in) throws B2LocalException {
        if (expectedSha1OrNull == null) {
            return;
        }
        B2Preconditions.checkArgument(in instanceof B2Sha1InputStream);
        String actualSha1 = ((B2Sha1InputStream)in).hexDigest();
        if (!B2Sha1.equalHexSha1s(expectedSha1OrNull, actualSha1)) {
            throw new B2LocalException("mismatch", "sha1 mismatch " + when + ".  expected " + expectedSha1OrNull + ", but got " + actualSha1);
        }
    }

    private void maybeVerifySha1FromDestination(String expectedSha1OrNull) throws B2Exception {
        if (expectedSha1OrNull == null) {
            return;
        }
        if (!this.verifySha1ByRereadingFromDestination) {
            return;
        }
        try (InputStream fromDest = this.createDestinationInputStreamOrThrow();
             B2Sha1InputStream sha1er = new B2Sha1InputStream(fromDest);){
            B2IoUtils.readToEnd(sha1er);
            this.maybeCheckSha1("from destination", expectedSha1OrNull, sha1er);
        }
        catch (IOException e) {
            throw new B2LocalException("write_failed", "failed to verify the sha1: " + e.getMessage(), e);
        }
    }

    static String getSha1ToCheckOrNull(B2Headers headers) {
        if (headers.hasContentRange()) {
            return null;
        }
        String sha1 = headers.getContentSha1EvenIfUnverifiedOrNull();
        if (sha1 != null && !sha1.equals("none")) {
            return sha1;
        }
        String largeSha1 = headers.getLargeFileSha1OrNull();
        if (largeSha1 != null) {
            return largeSha1;
        }
        return null;
    }

    private OutputStream createDestinationOutputStreamOrThrow() throws B2Exception {
        try {
            return this.createDestinationOutputStream();
        }
        catch (IOException e) {
            throw new B2LocalException("write_failed", "couldn't open destination output stream to write it: " + e.getMessage(), e);
        }
    }

    private void closeOrThrow(Closeable closeable) throws B2Exception {
        try {
            closeable.close();
        }
        catch (IOException e) {
            throw new B2LocalException("write_failed", "couldn't close destination output stream: " + e.getMessage(), e);
        }
    }

    private InputStream createDestinationInputStreamOrThrow() throws B2Exception {
        try {
            return this.createDestinationInputStream();
        }
        catch (IOException e) {
            throw new B2LocalException("write_failed", "couldn't open destination input stream to check it: " + e.getMessage(), e);
        }
    }

    protected abstract OutputStream createDestinationOutputStream() throws IOException;

    protected abstract InputStream createDestinationInputStream() throws IOException;

    public B2Headers getHeadersOrNull() {
        return this.headers;
    }

    private static void copy(InputStream in, OutputStream out) throws B2Exception {
        B2ContentWriter.copy(in, out, new byte[4096]);
    }

    private static void copy(InputStream input, OutputStream output, byte[] buffer) throws B2Exception {
        while (true) {
            int nRead;
            try {
                nRead = input.read(buffer);
                if (nRead == -1) {
                    break;
                }
            }
            catch (IOException e) {
                throw new B2ConnectionBrokenException("read_failed", null, "read failed: " + e.getMessage(), e);
            }
            try {
                output.write(buffer, 0, nRead);
            }
            catch (IOException e) {
                throw new B2LocalException("write_failed", "write failed: " + e.getMessage(), e);
            }
        }
    }
}

