/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.contentHandlers;

import com.backblaze.b2.client.contentHandlers.B2ContentWriter;
import com.backblaze.b2.client.contentSources.B2Headers;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.exceptions.B2LocalException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class B2ContentMemoryWriter
extends B2ContentWriter {
    private static final long MAX_LEN = Integer.MAX_VALUE;
    private ByteArrayOutputStream byteStream = null;

    private B2ContentMemoryWriter(boolean verifySha1ByRereadingFromDestination) {
        super(verifySha1ByRereadingFromDestination);
    }

    @Override
    public void readContent(B2Headers responseHeaders, InputStream rawIn) throws B2Exception {
        long len = responseHeaders.getContentLength();
        if (len >= Integer.MAX_VALUE) {
            throw new B2LocalException("too_big", "contentLength is too big for this B2ContentMemoryWriter.  (" + len + " > " + Integer.MAX_VALUE + ")");
        }
        super.readContent(responseHeaders, rawIn);
    }

    @Override
    protected OutputStream createDestinationOutputStream() throws IOException {
        this.byteStream = new ByteArrayOutputStream();
        return this.byteStream;
    }

    @Override
    protected InputStream createDestinationInputStream() throws IOException {
        return new ByteArrayInputStream(this.getBytes());
    }

    public byte[] getBytes() {
        if (this.byteStream == null) {
            return new byte[0];
        }
        return this.byteStream.toByteArray();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static B2ContentMemoryWriter build() {
        return B2ContentMemoryWriter.builder().build();
    }

    public static class Builder {
        private boolean verifySha1ByRereadingFromDestination = true;

        public B2ContentMemoryWriter build() {
            return new B2ContentMemoryWriter(this.verifySha1ByRereadingFromDestination);
        }

        public Builder setVerifySha1ByRereadingFromDestination(boolean verifySha1ByRereadingFromDestination) {
            this.verifySha1ByRereadingFromDestination = verifySha1ByRereadingFromDestination;
            return this;
        }
    }
}

