/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2AccountAuthorizationCache;
import com.backblaze.b2.client.B2StorageClientWebifier;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.structures.B2GetUploadPartUrlRequest;
import com.backblaze.b2.client.structures.B2UploadPartUrlResponse;
import java.util.ArrayDeque;
import java.util.Deque;

class B2UploadPartUrlCache {
    private final B2StorageClientWebifier webifier;
    private final B2AccountAuthorizationCache accountAuthCache;
    private final String largeFileId;
    private final Deque<B2UploadPartUrlResponse> responses = new ArrayDeque<B2UploadPartUrlResponse>();

    B2UploadPartUrlCache(B2StorageClientWebifier webifier, B2AccountAuthorizationCache accountAuthCache, String largeFileId) {
        this.webifier = webifier;
        this.accountAuthCache = accountAuthCache;
        this.largeFileId = largeFileId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    B2UploadPartUrlResponse get(boolean isRetry) throws B2Exception {
        if (!isRetry) {
            B2UploadPartUrlCache b2UploadPartUrlCache = this;
            synchronized (b2UploadPartUrlCache) {
                B2UploadPartUrlResponse response = this.responses.pollFirst();
                if (response != null) {
                    return response;
                }
            }
        }
        B2GetUploadPartUrlRequest request = B2GetUploadPartUrlRequest.builder(this.largeFileId).build();
        return this.webifier.getUploadPartUrl(this.accountAuthCache.get(), request);
    }

    synchronized void unget(B2UploadPartUrlResponse response) {
        this.responses.offerLast(response);
    }
}

